/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import org.exist.collections.Collection;
import org.exist.dom.DocumentImpl;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.numbering.NodeId;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.storage.lock.LockedDocumentMap;
import org.exist.util.LockException;
import org.exist.util.hashtable.Int2ObjectHashMap;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentSet
extends Int2ObjectHashMap
implements NodeList {
    public static final DocumentSet EMPTY_DOCUMENT_SET = new DocumentSet(9);
    private ArrayList list = null;
    private TreeSet collections = new TreeSet();

    public DocumentSet() {
        super(29, 1.75);
    }

    public DocumentSet(int initialSize) {
        super(initialSize, 1.75);
    }

    public void clear() {
        super.clear();
        this.collections = new TreeSet();
        this.list = null;
    }

    public void add(DocumentImpl doc) {
        this.add(doc, true);
    }

    public void add(DocumentImpl doc, boolean checkDuplicates) {
        int docId = doc.getDocId();
        if (checkDuplicates && this.containsKey(docId)) {
            return;
        }
        this.put(docId, doc);
        if (this.list != null) {
            this.list.add(doc);
        }
        if (doc.getCollection() != null && !this.collections.contains(doc.getCollection())) {
            this.collections.add(doc.getCollection());
        }
    }

    public void add(Node node) {
        if (!(node instanceof DocumentImpl)) {
            throw new RuntimeException("wrong implementation");
        }
        this.add((DocumentImpl)node);
    }

    public void addAll(NodeList other) {
        for (int i = 0; i < other.getLength(); ++i) {
            this.add(other.item(i));
        }
    }

    public void addAll(DBBroker broker, Collection collection, String[] paths, boolean checkPermissions) {
        for (int i = 0; i < paths.length; ++i) {
            DocumentImpl doc = collection.getDocumentNoLock(paths[i]);
            if (doc == null || broker != null && checkPermissions && !doc.getPermissions().validate(broker.getUser(), 4)) continue;
            doc.setBroker(broker);
            this.put(doc.getDocId(), doc);
        }
    }

    public void addAll(DBBroker broker, Collection collection, String[] paths, LockedDocumentMap lockMap, int lockType) throws LockException {
        for (int i = 0; i < paths.length; ++i) {
            DocumentImpl doc = collection.getDocumentNoLock(paths[i]);
            if (doc == null || !doc.getPermissions().validate(broker.getUser(), 2)) continue;
            doc.setBroker(broker);
            Lock lock = doc.getUpdateLock();
            lock.acquire(1);
            this.put(doc.getDocId(), doc);
            lockMap.add(doc);
        }
    }

    public void addCollection(Collection collection) {
        this.collections.add(collection);
    }

    public Iterator iterator() {
        return this.valueIterator();
    }

    public Iterator getCollectionIterator() {
        return this.collections.iterator();
    }

    public int getLength() {
        return this.size();
    }

    public int getCollectionCount() {
        return this.collections.size();
    }

    public Node item(int pos) {
        if (this.list == null) {
            this.list = new ArrayList();
            Iterator i = this.valueIterator();
            while (i.hasNext()) {
                this.list.add(i.next());
            }
        }
        return (Node)this.list.get(pos);
    }

    public DocumentImpl getDoc(int docId) {
        return (DocumentImpl)this.get(docId);
    }

    public XmldbURI[] getNames() {
        Object[] result = new XmldbURI[this.size()];
        int j = 0;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            DocumentImpl d = (DocumentImpl)i.next();
            result[j] = d.getFileURI();
            ++j;
        }
        Arrays.sort(result);
        return result;
    }

    public DocumentSet intersection(DocumentSet other) {
        DocumentImpl d;
        DocumentSet r = new DocumentSet();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            d = (DocumentImpl)i.next();
            if (!other.containsKey(d.getDocId())) continue;
            r.add(d);
        }
        i = other.iterator();
        while (i.hasNext()) {
            d = (DocumentImpl)i.next();
            if (!this.containsKey(d.getDocId()) || r.containsKey(d.getDocId())) continue;
            r.add(d);
        }
        return r;
    }

    public DocumentSet union(DocumentSet other) {
        DocumentSet result = new DocumentSet();
        result.addAll(other);
        Iterator i = this.iterator();
        while (i.hasNext()) {
            DocumentImpl d = (DocumentImpl)i.next();
            if (result.containsKey(d.getDocId())) continue;
            result.add(d);
        }
        return result;
    }

    public boolean contains(DocumentSet other) {
        if (other.size() > this.size()) {
            return false;
        }
        Iterator i = other.iterator();
        while (i.hasNext()) {
            DocumentImpl d = (DocumentImpl)i.next();
            if (this.containsKey(d.getDocId())) continue;
            return false;
        }
        return true;
    }

    public boolean contains(int id) {
        return this.containsKey(id);
    }

    public NodeSet toNodeSet() {
        ExtArrayNodeSet result = new ExtArrayNodeSet(this.getLength());
        Iterator i = this.iterator();
        while (i.hasNext()) {
            DocumentImpl doc = (DocumentImpl)i.next();
            if (doc.getResourceType() != 0) continue;
            result.add(new NodeProxy(doc, NodeId.DOCUMENT_NODE));
        }
        return result;
    }

    public int getMinDocId() {
        int min = -1;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            DocumentImpl d = (DocumentImpl)i.next();
            if (min == -1) {
                min = d.getDocId();
                continue;
            }
            if (d.getDocId() >= min) continue;
            min = d.getDocId();
        }
        return min;
    }

    public int getMaxDocId() {
        int max = -1;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            DocumentImpl d = (DocumentImpl)i.next();
            if (d.getDocId() <= max) continue;
            max = d.getDocId();
        }
        return max;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        DocumentSet o = (DocumentSet)other;
        if (this.size() != o.size()) {
            return false;
        }
        return this.hasEqualKeys(o);
    }

    public void lock(boolean exclusive, boolean checkExisting) throws LockException {
        for (int idx = 0; idx < this.tabSize; ++idx) {
            if (this.values[idx] == null || this.values[idx] == REMOVED) continue;
            DocumentImpl d = (DocumentImpl)this.values[idx];
            Lock dlock = d.getUpdateLock();
            if (exclusive) {
                dlock.acquire(1);
                continue;
            }
            dlock.acquire(0);
        }
    }

    public void unlock(boolean exclusive) {
        Thread thread = Thread.currentThread();
        for (int idx = 0; idx < this.tabSize; ++idx) {
            if (this.values[idx] == null || this.values[idx] == REMOVED) continue;
            DocumentImpl d = (DocumentImpl)this.values[idx];
            Lock dlock = d.getUpdateLock();
            if (exclusive) {
                dlock.release(1);
                continue;
            }
            if (!dlock.isLockedForRead(thread)) continue;
            dlock.release(0);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < this.getLength(); ++i) {
            result.append(this.item(i));
            result.append(", ");
        }
        return result.toString();
    }
}

