/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.io.UnsupportedEncodingException;
import org.exist.dom.DocumentImpl;
import org.exist.dom.StoredNode;
import org.exist.numbering.NodeId;
import org.exist.util.ByteConversion;
import org.exist.util.pool.NodePool;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class ProcessingInstructionImpl
extends StoredNode
implements ProcessingInstruction {
    public static final int LENGTH_TARGET_DATA = 4;
    protected String target = null;
    protected String data = null;

    public ProcessingInstructionImpl() {
        super((short)7);
    }

    public ProcessingInstructionImpl(NodeId nodeId, String target, String data) {
        super((short)7, nodeId);
        this.target = target;
        this.data = data;
    }

    public ProcessingInstructionImpl(String target, String data) {
        this(null, target, data);
    }

    public void clear() {
        super.clear();
        this.target = null;
        this.data = null;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getNodeName() {
        return this.target;
    }

    public String getLocalName() {
        return this.target;
    }

    public String getNamespaceURI() {
        return "";
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getBaseURI() {
        String baseURI = "";
        StoredNode parent = null;
        Node test = this.getParentNode();
        if (!(test instanceof DocumentImpl)) {
            parent = (StoredNode)test;
        }
        while (parent != null && parent.getBaseURI() != null) {
            baseURI = "".equals(baseURI) ? parent.getBaseURI() : parent.getBaseURI() + "/" + baseURI;
            test = parent.getParentNode();
            if (test instanceof DocumentImpl) {
                return baseURI;
            }
            parent = (StoredNode)test;
        }
        if ("".equals(baseURI)) {
            baseURI = this.getDocument().getBaseURI();
        }
        return baseURI;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<?");
        buf.append(this.target);
        buf.append(" ");
        buf.append(this.data);
        buf.append(" ?>");
        return buf.toString();
    }

    public byte[] serialize() {
        byte[] dd;
        byte[] td;
        try {
            td = this.target.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            LOG.warn((Object)uee);
            td = this.target.getBytes();
        }
        try {
            dd = this.data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            LOG.warn((Object)uee);
            dd = this.data.getBytes();
        }
        int nodeIdLen = this.nodeId.size();
        byte[] d = new byte[td.length + dd.length + nodeIdLen + 7];
        int pos = 0;
        d[pos] = 64;
        ByteConversion.shortToByte((short)this.nodeId.units(), d, ++pos);
        this.nodeId.serialize(d, pos += 2);
        ByteConversion.intToByte(td.length, d, pos += nodeIdLen);
        System.arraycopy(td, 0, d, pos += 4, td.length);
        System.arraycopy(dd, 0, d, pos += td.length, dd.length);
        return d;
    }

    public static StoredNode deserialize(byte[] data, int start, int len, DocumentImpl doc, boolean pooled) {
        String cdata;
        String target;
        int pos = start;
        short dlnLen = ByteConversion.byteToShort(data, ++pos);
        NodeId dln = doc.getBroker().getBrokerPool().getNodeFactory().createFromData(dlnLen, data, pos += 2);
        int nodeIdLen = dln.size();
        int l = ByteConversion.byteToInt(data, pos += nodeIdLen);
        pos += 4;
        try {
            target = new String(data, pos, l, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            LOG.warn((Object)uee);
            target = new String(data, pos, l);
        }
        pos += l;
        try {
            cdata = new String(data, pos, len - (pos - start), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            LOG.warn((Object)uee);
            cdata = new String(data, pos, len - (pos - start));
        }
        ProcessingInstructionImpl pi = pooled ? (ProcessingInstructionImpl)NodePool.getInstance().borrowNode((short)7) : new ProcessingInstructionImpl();
        pi.setTarget(target);
        pi.data = cdata;
        pi.setNodeId(dln);
        return pi;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public int getChildCount() {
        return 0;
    }

    public Node getFirstChild() {
        return null;
    }
}

