/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import org.exist.dom.CharacterDataImpl;
import org.exist.dom.DocumentImpl;
import org.exist.dom.StoredNode;
import org.exist.numbering.NodeId;
import org.exist.util.ByteArrayPool;
import org.exist.util.ByteConversion;
import org.exist.util.UTF8;
import org.exist.util.pool.NodePool;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public class TextImpl
extends CharacterDataImpl
implements Text {
    public TextImpl() {
        super((short)3);
    }

    public TextImpl(String data) {
        super((short)3, data);
    }

    public TextImpl(NodeId nodeId, String data) {
        super((short)3, nodeId, data);
    }

    public String getLocalName() {
        return "";
    }

    public String getNamespaceURI() {
        return "";
    }

    public byte[] serialize() {
        int nodeIdLen = this.nodeId.size();
        byte[] data = ByteArrayPool.getByteArray(1 + nodeIdLen + 2 + this.cdata.UTF8Size());
        int pos = 0;
        data[pos] = 0;
        ByteConversion.shortToByte((short)this.nodeId.units(), data, ++pos);
        this.nodeId.serialize(data, pos += 2);
        this.cdata.UTF8Encode(data, pos += nodeIdLen);
        return data;
    }

    public static StoredNode deserialize(byte[] data, int start, int len, DocumentImpl doc, boolean pooled) {
        TextImpl text = pooled ? (TextImpl)NodePool.getInstance().borrowNode((short)3) : new TextImpl();
        int pos = start;
        short dlnLen = ByteConversion.byteToShort(data, ++pos);
        NodeId dln = doc.getBroker().getBrokerPool().getNodeFactory().createFromData(dlnLen, data, pos += 2);
        text.setNodeId(dln);
        int nodeIdLen = dln.size();
        text.cdata = UTF8.decode(data, pos += nodeIdLen, len - (1 + nodeIdLen + 2));
        return text;
    }

    public void appendData(String arg) throws DOMException {
        super.appendData(arg);
    }

    public void appendData(char[] data, int start, int howmany) throws DOMException {
        super.appendData(data, start, howmany);
    }

    public void deleteData(int offset, int count) throws DOMException {
        super.deleteData(offset, count);
    }

    public int getLength() {
        return super.getLength();
    }

    public String getNodeValue() {
        return super.getNodeValue();
    }

    public void insertData(int offset, String arg) throws DOMException {
        super.insertData(offset, arg);
    }

    public void replaceData(int offset, int count, String arg) throws DOMException {
        super.replaceData(offset, count, arg);
    }

    public void setNodeValue(String value) throws DOMException {
        super.setNodeValue(value);
    }

    public Text splitText(int offset) throws DOMException {
        return null;
    }

    public String substringData(int offset, int count) throws DOMException {
        return super.substringData(offset, count);
    }

    public String toString(boolean top) {
        if (top) {
            StringBuffer result = new StringBuffer();
            result.append("<exist:text ");
            result.append("xmlns:exist=\"http://exist.sourceforge.net/NS/exist\" ");
            result.append("exist:id=\"");
            result.append(this.getNodeId());
            result.append("\" exist:source=\"");
            result.append(((DocumentImpl)this.getOwnerDocument()).getFileURI());
            result.append("\">");
            result.append(this.getData());
            result.append("</exist:text>");
            return result.toString();
        }
        return this.toString();
    }

    public String toString() {
        return super.toString();
    }

    public int getChildCount() {
        return 0;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public Node getFirstChild() {
        return null;
    }

    public boolean isElementContentWhitespace() {
        return false;
    }

    public String getWholeText() {
        return null;
    }

    public Text replaceWholeText(String content) throws DOMException {
        return null;
    }

    public String getBaseURI() {
        return null;
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        return 0;
    }

    public String getTextContent() throws DOMException {
        return null;
    }

    public void setTextContent(String textContent) throws DOMException {
    }

    public boolean isSameNode(Node other) {
        return false;
    }

    public String lookupPrefix(String namespaceURI) {
        return null;
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        return false;
    }

    public String lookupNamespaceURI(String prefix) {
        return null;
    }

    public boolean isEqualNode(Node arg) {
        return false;
    }

    public Object getFeature(String feature, String version) {
        return null;
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return null;
    }

    public Object getUserData(String key) {
        return null;
    }
}

