/*
 * Decompiled with CFR 0.152.
 */
package org.exist.fulltext;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.Match;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSetIterator;
import org.exist.dom.QName;
import org.exist.fulltext.FTIndex;
import org.exist.indexing.AbstractMatchListener;
import org.exist.numbering.NodeId;
import org.exist.stax.EmbeddedXMLStreamReader;
import org.exist.util.FastQSort;
import org.exist.util.serializer.AttrList;
import org.exist.xquery.value.Sequence;
import org.xml.sax.SAXException;

public class FTMatchListener
extends AbstractMatchListener {
    private static final Logger LOG = Logger.getLogger((Class)FTMatchListener.class);
    private Match match;
    private Stack offsetStack = null;

    public FTMatchListener() {
    }

    public FTMatchListener(NodeProxy proxy) {
        this.reset(proxy);
    }

    public boolean hasMatches(NodeProxy proxy) {
        for (Match nextMatch = proxy.getMatches(); nextMatch != null; nextMatch = nextMatch.getNextMatch()) {
            if (nextMatch.getIndexId() != FTIndex.ID) continue;
            return true;
        }
        return false;
    }

    public void reset(NodeProxy proxy) {
        this.match = proxy.getMatches();
        this.setNextInChain(null);
        Sequence ancestors = null;
        for (Match nextMatch = this.match; nextMatch != null; nextMatch = nextMatch.getNextMatch()) {
            if (!proxy.getNodeId().isDescendantOf(nextMatch.getNodeId())) continue;
            if (ancestors == null) {
                ancestors = new ExtArrayNodeSet();
            }
            ancestors.add(new NodeProxy(proxy.getDocument(), nextMatch.getNodeId()));
        }
        if (ancestors != null && !ancestors.isEmpty()) {
            NodeSetIterator i = ancestors.iterator();
            while (i.hasNext()) {
                NodeProxy p = (NodeProxy)i.next();
                int startOffset = 0;
                try {
                    EmbeddedXMLStreamReader reader = proxy.getDocument().getBroker().getXMLStreamReader(p, false);
                    while (reader.hasNext()) {
                        int ev = reader.next();
                        NodeId nodeId = (NodeId)reader.getProperty("node-id");
                        if (!nodeId.equals(proxy.getNodeId())) {
                            if (ev != 4) continue;
                            startOffset += reader.getText().length();
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    LOG.warn((Object)("Problem found while serializing XML: " + e.getMessage()), (Throwable)e);
                }
                catch (XMLStreamException e) {
                    LOG.warn((Object)("Problem found while serializing XML: " + e.getMessage()), (Throwable)e);
                }
                if (this.offsetStack == null) {
                    this.offsetStack = new Stack();
                }
                this.offsetStack.push(new NodeOffset(p.getNodeId(), startOffset));
            }
        }
    }

    public void startElement(QName qname, AttrList attribs) throws SAXException {
        for (Match nextMatch = this.match; nextMatch != null; nextMatch = nextMatch.getNextMatch()) {
            if (!nextMatch.getNodeId().equals(this.getCurrentNode().getNodeId())) continue;
            if (this.offsetStack == null) {
                this.offsetStack = new Stack();
            }
            this.offsetStack.push(new NodeOffset(nextMatch.getNodeId()));
            break;
        }
        super.startElement(qname, attribs);
    }

    public void endElement(QName qname) throws SAXException {
        for (Match nextMatch = this.match; nextMatch != null; nextMatch = nextMatch.getNextMatch()) {
            if (!nextMatch.getNodeId().equals(this.getCurrentNode().getNodeId())) continue;
            this.offsetStack.pop();
            break;
        }
        super.endElement(qname);
    }

    public void characters(CharSequence seq) throws SAXException {
        ArrayList<Match.Offset> offsets = null;
        if (this.offsetStack != null) {
            for (int i = 0; i < this.offsetStack.size(); ++i) {
                NodeOffset no = (NodeOffset)this.offsetStack.get(i);
                int end = no.offset + seq.length();
                for (Match next = this.match; next != null; next = next.getNextMatch()) {
                    if (next.getIndexId() != FTIndex.ID || !next.getNodeId().equals(no.nodeId)) continue;
                    int freq = next.getFrequency();
                    for (int j = 0; j < freq; ++j) {
                        Match.Offset offset = next.getOffset(j);
                        if (offset.getOffset() >= end || offset.getOffset() + offset.getLength() <= no.offset) continue;
                        if (offsets == null) {
                            offsets = new ArrayList(4);
                        }
                        int start = offset.getOffset() - no.offset;
                        int len = offset.getLength();
                        if (start < 0) {
                            len -= Math.abs(start);
                            start = 0;
                        }
                        if (start + len > seq.length()) {
                            len = seq.length() - start;
                        }
                        offsets.add(new Match.Offset(start, len));
                    }
                }
                no.offset = end;
            }
        }
        for (Match next = this.match; next != null; next = next.getNextMatch()) {
            if (next.getIndexId() != FTIndex.ID || !next.getNodeId().equals(this.getCurrentNode().getNodeId())) continue;
            if (offsets == null) {
                offsets = new ArrayList<Match.Offset>();
            }
            int freq = next.getFrequency();
            for (int i = 0; i < freq; ++i) {
                offsets.add(next.getOffset(i));
            }
        }
        if (offsets != null) {
            FastQSort.sort(offsets, 0, offsets.size() - 1);
            String s = ((Object)seq).toString();
            int pos = 0;
            for (int i = 0; i < offsets.size(); ++i) {
                Match.Offset offset = (Match.Offset)offsets.get(i);
                if (offset.getOffset() > pos) {
                    super.characters(s.substring(pos, pos + (offset.getOffset() - pos)));
                }
                super.startElement(MATCH_ELEMENT, null);
                super.characters(s.substring(offset.getOffset(), offset.getOffset() + offset.getLength()));
                super.endElement(MATCH_ELEMENT);
                pos = offset.getOffset() + offset.getLength();
            }
            if (pos < s.length()) {
                super.characters(s.substring(pos));
            }
        } else {
            super.characters(seq);
        }
    }

    private class NodeOffset {
        NodeId nodeId;
        int offset = 0;

        public NodeOffset(NodeId nodeId) {
            this.nodeId = nodeId;
        }

        public NodeOffset(NodeId nodeId, int offset) {
            this.nodeId = nodeId;
            this.offset = offset;
        }
    }
}

