/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentMetadata;
import org.exist.dom.DocumentSet;
import org.exist.http.BadRequestException;
import org.exist.http.Descriptor;
import org.exist.http.NotFoundException;
import org.exist.http.servlets.HttpRequestWrapper;
import org.exist.http.servlets.HttpResponseWrapper;
import org.exist.security.Permission;
import org.exist.security.PermissionDeniedException;
import org.exist.security.xacml.AccessContext;
import org.exist.source.DBSource;
import org.exist.source.StringSource;
import org.exist.storage.DBBroker;
import org.exist.storage.XQueryPool;
import org.exist.storage.serializers.Serializer;
import org.exist.storage.txn.TransactionException;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xupdate.Modification;
import org.exist.xupdate.XUpdateProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;

public class RESTServer {
    protected static final Logger LOG = Logger.getLogger((Class)RESTServer.class);
    protected static final Properties defaultProperties = new Properties();
    protected static final Properties defaultOutputKeysProperties;
    private static final String QUERY_ERROR_HEAD = "<html><head><title>Query Error</title><style type=\"text/css\">.errmsg {  border: 1px solid black;  padding: 15px;  margin-left: 20px;  margin-right: 20px;}h1 { color: #C0C0C0; }.path {  padding-bottom: 10px;}.high {   color: #666699;   font-weight: bold;}</style></head><body><h1>XQuery Error</h1>";
    private String formEncoding;
    private String containerEncoding;
    private boolean useDynamicContentType;

    public RESTServer(String formEncoding, String containerEncoding, boolean useDynamicContentType) {
        this.formEncoding = formEncoding;
        this.containerEncoding = containerEncoding;
        this.useDynamicContentType = useDynamicContentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(DBBroker broker, HttpServletRequest request, HttpServletResponse response, String path) throws BadRequestException, PermissionDeniedException, NotFoundException, IOException {
        String stylesheet;
        String option;
        String p_start;
        String p_howmany;
        if (request.getCharacterEncoding() == null) {
            request.setCharacterEncoding(this.formEncoding);
        }
        int howmany = 10;
        int start = 1;
        boolean wrap = true;
        boolean source = false;
        Properties outputProperties = new Properties(defaultOutputKeysProperties);
        String query = request.getParameter("_xpath");
        if (query == null) {
            query = request.getParameter("_query");
        }
        if ((p_howmany = request.getParameter("_howmany")) != null) {
            try {
                howmany = Integer.parseInt(p_howmany);
            }
            catch (NumberFormatException nfe) {
                throw new BadRequestException("Parameter _howmany should be an int");
            }
        }
        if ((p_start = request.getParameter("_start")) != null) {
            try {
                start = Integer.parseInt(p_start);
            }
            catch (NumberFormatException nfe) {
                throw new BadRequestException("Parameter _start should be an int");
            }
        }
        if ((option = request.getParameter("_wrap")) != null) {
            wrap = option.equals("yes");
        }
        if ((option = request.getParameter("_indent")) != null) {
            outputProperties.setProperty("indent", option);
        }
        if ((option = request.getParameter("_source")) != null) {
            source = option.equals("yes");
        }
        if ((stylesheet = request.getParameter("_xsl")) != null) {
            if (stylesheet.equals("no")) {
                outputProperties.setProperty("process-xsl-pi", "no");
                outputProperties.remove("stylesheet");
                stylesheet = null;
            } else {
                outputProperties.setProperty("stylesheet", stylesheet);
            }
        } else {
            outputProperties.setProperty("process-xsl-pi", "yes");
        }
        LOG.debug((Object)("stylesheet = " + stylesheet));
        LOG.debug((Object)("query = " + query));
        String encoding = request.getParameter("_encoding");
        if (encoding != null) {
            outputProperties.setProperty("encoding", encoding);
        } else {
            encoding = "UTF-8";
        }
        String mimeType = outputProperties.getProperty("media-type");
        DocumentImpl resource = null;
        XmldbURI pathUri = XmldbURI.create(path);
        try {
            resource = broker.getXMLResource(pathUri, 0);
            if (resource != null && resource.getResourceType() == 1 && MimeType.XQUERY_TYPE.getName().equals(resource.getMetadata().getMimeType())) {
                Descriptor descriptor = Descriptor.getDescriptorSingleton();
                if (source && descriptor != null) {
                    if (descriptor.allowSourceXQuery(path)) {
                        this.writeResourceAs(resource, broker, stylesheet, encoding, MimeType.TEXT_TYPE.getName(), outputProperties, response);
                        return;
                    }
                    response.sendError(403, "Permission to view XQuery source for: " + path + " denied. Must be explicitly defined in descriptor.xml");
                    return;
                }
                try {
                    String result = this.executeXQuery(broker, resource, request, response, outputProperties);
                    encoding = outputProperties.getProperty("encoding");
                    mimeType = outputProperties.getProperty("media-type");
                    if (response.isCommitted()) return;
                    this.writeResponse(response, result, mimeType, encoding);
                    return;
                }
                catch (XPathException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)e.getMessage(), (Throwable)e);
                    }
                    response.setStatus(400);
                    if (MimeType.XML_TYPE.getName().equals(mimeType)) {
                        this.writeResponse(response, this.formatXPathException(query, path, e), mimeType, encoding);
                        return;
                    }
                    this.writeResponse(response, this.formatXPathExceptionHtml(query, path, e), MimeType.HTML_TYPE.getName(), encoding);
                    return;
                }
            }
            if (query != null) {
                try {
                    String result = this.search(broker, query, path, howmany, start, outputProperties, wrap, request, response);
                    encoding = outputProperties.getProperty("encoding");
                    mimeType = outputProperties.getProperty("media-type");
                    if (response.isCommitted()) return;
                    this.writeResponse(response, result, mimeType, encoding);
                    return;
                }
                catch (XPathException e) {
                    response.setStatus(400);
                    if (MimeType.XML_TYPE.getName().equals(mimeType)) {
                        this.writeResponse(response, this.formatXPathException(query, path, e), mimeType, encoding);
                        return;
                    }
                    this.writeResponse(response, this.formatXPathExceptionHtml(query, path, e), MimeType.HTML_TYPE.getName(), encoding);
                    return;
                }
            }
            if (resource == null) {
                Collection collection = broker.getCollection(pathUri);
                if (collection == null) throw new NotFoundException("Document " + path + " not found");
                if (!collection.getPermissions().validate(broker.getUser(), 4)) {
                    throw new PermissionDeniedException("Not allowed to read collection");
                }
                this.writeResponse(response, this.printCollection(broker, collection), MimeType.XML_TYPE.getName(), encoding);
                return;
            }
            this.writeResourceAs(resource, broker, stylesheet, encoding, null, outputProperties, response);
            return;
        }
        finally {
            if (resource != null) {
                resource.getUpdateLock().release(0);
            }
        }
    }

    private void writeResourceAs(DocumentImpl resource, DBBroker broker, String stylesheet, String encoding, String asMimeType, Properties outputProperties, HttpServletResponse response) throws BadRequestException, PermissionDeniedException, IOException {
        if (!resource.getPermissions().validate(broker.getUser(), 4)) {
            throw new PermissionDeniedException("Not allowed to read resource");
        }
        if (resource.getResourceType() == 1) {
            if (asMimeType != null) {
                response.setContentType(asMimeType);
            } else {
                response.setContentType(resource.getMetadata().getMimeType());
            }
            ServletOutputStream os = response.getOutputStream();
            broker.readBinaryResource((BinaryDocument)resource, (OutputStream)os);
            os.flush();
        } else {
            Serializer serializer = broker.getSerializer();
            serializer.reset();
            try {
                if (stylesheet != null) {
                    serializer.setStylesheet(resource, stylesheet);
                }
                serializer.setProperties(outputProperties);
                serializer.prepareStylesheets(resource);
                if (asMimeType != null) {
                    response.setContentType(asMimeType + "; charset=" + encoding);
                } else if (serializer.isStylesheetApplied() || serializer.hasXSLPi(resource) != null) {
                    asMimeType = serializer.getStylesheetProperty("media-type");
                    if (!this.useDynamicContentType || asMimeType == null) {
                        asMimeType = MimeType.HTML_TYPE.getName();
                    }
                    LOG.debug((Object)("media-type: " + asMimeType));
                    response.setContentType(asMimeType + "; charset=" + encoding);
                } else {
                    asMimeType = resource.getMetadata().getMimeType();
                    response.setContentType(asMimeType + "; charset=" + encoding);
                }
                if (asMimeType.equals(MimeType.HTML_TYPE.getName())) {
                    serializer.setProperty("method", "xhtml");
                    serializer.setProperty("media-type", "text/html");
                    serializer.setProperty("ident", "yes");
                    serializer.setProperty("omit-xml-declaration", "no");
                }
                ServletOutputStream is = response.getOutputStream();
                OutputStreamWriter w = new OutputStreamWriter((OutputStream)is, encoding);
                serializer.serialize(resource, w);
                ((Writer)w).flush();
                ((Writer)w).close();
            }
            catch (SAXException saxe) {
                LOG.warn((Object)saxe);
                throw new BadRequestException("Error while serializing XML: " + saxe.getMessage());
            }
            catch (TransformerConfigurationException e) {
                LOG.warn((Object)e);
                throw new BadRequestException(e.getMessageAndLocation());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHead(DBBroker broker, HttpServletRequest request, HttpServletResponse response, String path) throws BadRequestException, PermissionDeniedException, NotFoundException, IOException {
        DocumentImpl resource = null;
        XmldbURI pathUri = XmldbURI.create(path);
        try {
            resource = broker.getXMLResource(pathUri, 0);
            if (resource == null) {
                throw new NotFoundException("Resource " + pathUri + " not found");
            }
            if (!resource.getPermissions().validate(broker.getUser(), 4)) {
                throw new PermissionDeniedException("Permission to read resource " + path + " denied");
            }
            DocumentMetadata metadata = resource.getMetadata();
            response.setContentType(metadata.getMimeType());
            response.setContentLength(resource.getContentLength());
            response.addDateHeader("Last-Modified", metadata.getLastModified());
            response.addDateHeader("Created", metadata.getCreated());
        }
        finally {
            if (resource != null) {
                resource.getUpdateLock().release(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(DBBroker broker, HttpServletRequest request, HttpServletResponse response, String path) throws BadRequestException, PermissionDeniedException, IOException {
        block43: {
            XmldbURI pathUri;
            Properties outputProperties;
            block42: {
                if (request.getCharacterEncoding() == null) {
                    request.setCharacterEncoding(this.formEncoding);
                }
                outputProperties = new Properties(defaultOutputKeysProperties);
                pathUri = XmldbURI.create(path);
                DocumentImpl resource = null;
                String encoding = outputProperties.getProperty("encoding");
                String mimeType = outputProperties.getProperty("media-type");
                try {
                    resource = broker.getXMLResource(pathUri, 0);
                    if (resource == null || resource.getResourceType() != 1 || !MimeType.XQUERY_TYPE.getName().equals(resource.getMetadata().getMimeType())) break block42;
                    try {
                        String result = this.executeXQuery(broker, resource, request, response, outputProperties);
                        encoding = outputProperties.getProperty("encoding");
                        mimeType = outputProperties.getProperty("media-type");
                        this.writeResponse(response, result, mimeType, encoding);
                    }
                    catch (XPathException e) {
                        response.setStatus(400);
                        if (MimeType.XML_TYPE.getName().equals(mimeType)) {
                            this.writeResponse(response, this.formatXPathException(null, path, e), mimeType, encoding);
                        }
                        this.writeResponse(response, this.formatXPathExceptionHtml(null, path, e), MimeType.HTML_TYPE.getName(), encoding);
                    }
                    return;
                }
                finally {
                    if (resource != null) {
                        resource.getUpdateLock().release(0);
                    }
                }
            }
            int howmany = 10;
            int start = 1;
            boolean enclose = true;
            String mime = MimeType.XML_TYPE.getName();
            String query = null;
            TransactionManager transact = broker.getBrokerPool().getTransactionManager();
            Txn transaction = transact.beginTransaction();
            try {
                DocumentBuilder docBuilder;
                String content = this.getRequestContent(request);
                InputSource src = new InputSource(new StringReader(content));
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                docFactory.setNamespaceAware(true);
                try {
                    docBuilder = docFactory.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    LOG.warn((Object)e);
                    transact.abort(transaction);
                    throw new BadRequestException(e.getMessage());
                }
                Document doc = docBuilder.parse(src);
                Element root = doc.getDocumentElement();
                String rootNS = root.getNamespaceURI();
                if (rootNS != null && rootNS.equals("http://exist.sourceforge.net/NS/exist")) {
                    if (root.getLocalName().equals("query")) {
                        String option = root.getAttribute("start");
                        if (option != null) {
                            try {
                                start = Integer.parseInt(option);
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                        }
                        if ((option = root.getAttribute("max")) != null) {
                            try {
                                howmany = Integer.parseInt(option);
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                        }
                        if ((option = root.getAttribute("enclose")) != null && option.equals("no")) {
                            enclose = false;
                        }
                        option = root.getAttribute("mime");
                        mime = MimeType.XML_TYPE.getName();
                        if (option != null && !option.equals("")) {
                            mime = option;
                        }
                        NodeList children = root.getChildNodes();
                        for (int i = 0; i < children.getLength(); ++i) {
                            Node child = children.item(i);
                            if (child.getNodeType() != 1 || !child.getNamespaceURI().equals("http://exist.sourceforge.net/NS/exist")) continue;
                            if (child.getLocalName().equals("text")) {
                                StringBuffer buf = new StringBuffer();
                                for (Node next = child.getFirstChild(); next != null; next = next.getNextSibling()) {
                                    if (next.getNodeType() != 3 && next.getNodeType() != 4) continue;
                                    buf.append(next.getNodeValue());
                                }
                                query = buf.toString();
                                continue;
                            }
                            if (!child.getLocalName().equals("properties")) continue;
                            for (Node node = child.getFirstChild(); node != null; node = node.getNextSibling()) {
                                if (node.getNodeType() != 1 || !node.getNamespaceURI().equals("http://exist.sourceforge.net/NS/exist") || !node.getLocalName().equals("property")) continue;
                                Element property = (Element)node;
                                String key = property.getAttribute("name");
                                String value = property.getAttribute("value");
                                LOG.debug((Object)(key + " = " + value));
                                if (key == null || value == null) continue;
                                outputProperties.setProperty(key, value);
                            }
                        }
                    }
                    if (query != null) {
                        String result = "";
                        try {
                            result = this.search(broker, query, path, howmany, start, outputProperties, enclose, request, response);
                        }
                        catch (Exception e) {
                            response.setStatus(202);
                            result = e.getMessage();
                        }
                        this.writeResponse(response, result, mime, outputProperties.getProperty("encoding"));
                        break block43;
                    }
                    transact.abort(transaction);
                    throw new BadRequestException("No query specified");
                }
                if (rootNS != null && rootNS.equals("http://www.xmldb.org/xupdate")) {
                    LOG.debug((Object)("Got xupdate request: " + content));
                    DocumentSet docs = new DocumentSet();
                    Collection collection = broker.getCollection(pathUri);
                    if (collection != null) {
                        collection.allDocs(broker, docs, true, true);
                    } else {
                        DocumentImpl xupdateDoc = (DocumentImpl)broker.getXMLResource(pathUri);
                        if (xupdateDoc != null) {
                            if (!xupdateDoc.getPermissions().validate(broker.getUser(), 4)) {
                                transact.abort(transaction);
                                throw new PermissionDeniedException("Not allowed to read collection");
                            }
                            docs.add(xupdateDoc);
                        } else {
                            broker.getAllXMLResources(docs);
                        }
                    }
                    XUpdateProcessor processor = new XUpdateProcessor(broker, docs, AccessContext.REST);
                    Modification[] modifications = processor.parse(new InputSource(new StringReader(content)));
                    long mods = 0L;
                    for (int i = 0; i < modifications.length; ++i) {
                        mods += modifications[i].process(transaction);
                        broker.flush();
                    }
                    transact.commit(transaction);
                    this.writeResponse(response, "<?xml version='1.0'?>\n<exist:modifications xmlns:exist='http://exist.sourceforge.net/NS/exist' count='" + mods + "'>" + mods + "modifications processed.</exist:modifications>", MimeType.XML_TYPE.getName(), "UTF-8");
                    break block43;
                }
                transact.abort(transaction);
                throw new BadRequestException("Unknown XML root element: " + root.getNodeName());
            }
            catch (SAXException e) {
                transact.abort(transaction);
                Exception cause = e;
                if (e.getException() != null) {
                    cause = e.getException();
                }
                LOG.debug((Object)("SAX exception while parsing request: " + cause.getMessage()), (Throwable)cause);
                throw new BadRequestException("SAX exception while parsing request: " + cause.getMessage());
            }
            catch (ParserConfigurationException e) {
                transact.abort(transaction);
                throw new BadRequestException("Parser exception while parsing request: " + e.getMessage());
            }
            catch (XPathException e) {
                transact.abort(transaction);
                throw new BadRequestException("Query exception while parsing request: " + e.getMessage());
            }
            catch (IOException e) {
                transact.abort(transaction);
                throw new BadRequestException("IO exception while parsing request: " + e.getMessage());
            }
            catch (EXistException e) {
                transact.abort(transaction);
                throw new BadRequestException(e.getMessage());
            }
            catch (LockException e) {
                transact.abort(transaction);
                throw new PermissionDeniedException(e.getMessage());
            }
        }
    }

    private InputSource createInputSource(String charset, URI location) throws IOException {
        if (charset == null) {
            return new InputSource(location.toASCIIString());
        }
        InputSource source = new InputSource(new InputStreamReader(location.toURL().openStream(), charset));
        source.setSystemId(location.toASCIIString());
        return source;
    }

    public void doPut(DBBroker broker, File tempFile, XmldbURI path, HttpServletRequest request, HttpServletResponse response) throws BadRequestException, PermissionDeniedException, IOException {
        if (tempFile == null) {
            throw new BadRequestException("No request content found for PUT");
        }
        TransactionManager transact = broker.getBrokerPool().getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            MimeType mime;
            XmldbURI docUri = path.lastSegment();
            XmldbURI collUri = path.removeLastSegment();
            if (docUri == null || collUri == null) {
                transact.abort(transaction);
                throw new BadRequestException("Bad path: " + path);
            }
            Collection collection = broker.getCollection(collUri);
            if (collection == null) {
                LOG.debug((Object)("creating collection " + collUri));
                collection = broker.getOrCreateCollection(transaction, collUri);
                broker.saveCollection(transaction, collection);
            }
            String contentType = request.getContentType();
            String charset = null;
            if (contentType != null) {
                String param;
                int equals;
                int semicolon = contentType.indexOf(59);
                if (semicolon > 0 && (equals = (contentType = contentType.substring(0, semicolon).trim()).indexOf(61, semicolon)) > 0 && (param = contentType.substring(semicolon + 1, equals).trim()).compareToIgnoreCase("charset=") == 0) {
                    charset = param.substring(equals + 1).trim();
                }
                mime = MimeTable.getInstance().getContentType(contentType);
            } else {
                mime = MimeTable.getInstance().getContentTypeFor(docUri);
                if (mime != null) {
                    contentType = mime.getName();
                }
            }
            if (mime == null) {
                mime = MimeType.BINARY_TYPE;
            }
            if (mime.isXMLType()) {
                URI url = tempFile.toURI();
                IndexInfo info = collection.validateXMLResource(transaction, broker, docUri, this.createInputSource(charset, url));
                info.getDocument().getMetadata().setMimeType(contentType);
                collection.store(transaction, broker, info, this.createInputSource(charset, url), false);
                response.setStatus(201);
            } else {
                FileInputStream is = new FileInputStream(tempFile);
                collection.addBinaryResource(transaction, broker, docUri, is, contentType, (int)tempFile.length());
                is.close();
                response.setStatus(201);
            }
            transact.commit(transaction);
        }
        catch (SAXParseException e) {
            transact.abort(transaction);
            throw new BadRequestException("Parsing exception at " + e.getLineNumber() + "/" + e.getColumnNumber() + ": " + e.toString());
        }
        catch (SAXException e) {
            transact.abort(transaction);
            Exception o = e.getException();
            if (o == null) {
                o = e;
            }
            throw new BadRequestException("Parsing exception: " + o.getMessage());
        }
        catch (EXistException e) {
            transact.abort(transaction);
            throw new BadRequestException("Internal error: " + e.getMessage());
        }
        catch (TriggerException e) {
            transact.abort(transaction);
            throw new PermissionDeniedException(e.getMessage());
        }
        catch (LockException e) {
            transact.abort(transaction);
            throw new PermissionDeniedException(e.getMessage());
        }
    }

    public void doDelete(DBBroker broker, XmldbURI path, HttpServletResponse response) throws PermissionDeniedException, NotFoundException, IOException {
        TransactionManager transact = broker.getBrokerPool().getTransactionManager();
        Txn txn = transact.beginTransaction();
        try {
            Collection collection = broker.getCollection(path);
            if (collection != null) {
                LOG.debug((Object)("removing collection " + path));
                broker.removeCollection(txn, collection);
                response.setStatus(200);
            } else {
                DocumentImpl doc = (DocumentImpl)broker.getXMLResource(path);
                if (doc == null) {
                    transact.abort(txn);
                    throw new NotFoundException("No document or collection found for path: " + path);
                }
                LOG.debug((Object)("removing document " + path));
                if (doc.getResourceType() == 1) {
                    doc.getCollection().removeBinaryResource(txn, broker, path.lastSegment());
                } else {
                    doc.getCollection().removeXMLResource(txn, broker, path.lastSegment());
                }
                response.setStatus(200);
            }
            transact.commit(txn);
        }
        catch (TriggerException e) {
            transact.abort(txn);
            throw new PermissionDeniedException("Trigger failed: " + e.getMessage());
        }
        catch (LockException e) {
            transact.abort(txn);
            throw new PermissionDeniedException("Could not acquire lock: " + e.getMessage());
        }
        catch (TransactionException e) {
            transact.abort(txn);
            LOG.warn((Object)("Transaction aborted: " + e.getMessage()), (Throwable)e);
        }
    }

    private String getRequestContent(HttpServletRequest request) throws IOException, UnsupportedEncodingException {
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        ServletInputStream is = request.getInputStream();
        InputStreamReader reader = new InputStreamReader((InputStream)is, encoding);
        StringWriter content = new StringWriter();
        char[] ch = new char[4096];
        int len = 0;
        while ((len = reader.read(ch)) > -1) {
            content.write(ch, 0, len);
        }
        String xml = content.toString();
        return xml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String search(DBBroker broker, String query, String path, int howmany, int start, Properties outputProperties, boolean wrap, HttpServletRequest request, HttpServletResponse response) throws BadRequestException, PermissionDeniedException, XPathException {
        XmldbURI pathUri = XmldbURI.create(path);
        StringSource source = new StringSource(query);
        XQuery xquery = broker.getXQueryService();
        XQueryPool pool = xquery.getXQueryPool();
        CompiledXQuery compiled = pool.borrowCompiledXQuery(broker, source);
        XQueryContext context = compiled == null ? xquery.newContext(AccessContext.REST) : compiled.getContext();
        context.setStaticallyKnownDocuments(new XmldbURI[]{pathUri});
        context.setBaseURI(new AnyURIValue(pathUri.toString()));
        this.declareVariables(context, request, response);
        if (compiled == null) {
            compiled = xquery.compile(context, source);
        }
        context.checkOptions(outputProperties);
        try {
            long startTime = System.currentTimeMillis();
            Sequence resultSequence = xquery.execute(compiled, null);
            long queryTime = System.currentTimeMillis() - startTime;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found " + resultSequence.getItemCount() + " in " + queryTime + "ms."));
            }
            String string = this.printResults(broker, resultSequence, howmany, start, queryTime, outputProperties, wrap);
            pool.returnCompiledXQuery(source, compiled);
            return string;
        }
        catch (Throwable throwable) {
            try {
                pool.returnCompiledXQuery(source, compiled);
                throw throwable;
            }
            catch (IOException e) {
                throw new BadRequestException(e.getMessage(), e);
            }
        }
    }

    private void declareVariables(XQueryContext context, HttpServletRequest request, HttpServletResponse response) throws XPathException {
        HttpRequestWrapper reqw = new HttpRequestWrapper(request, this.formEncoding, this.containerEncoding);
        HttpResponseWrapper respw = new HttpResponseWrapper(response);
        context.declareVariable("request:request", reqw);
        context.declareVariable("response:response", respw);
        context.declareVariable("session:session", reqw.getSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeXQuery(DBBroker broker, DocumentImpl resource, HttpServletRequest request, HttpServletResponse response, Properties outputProperties) throws XPathException, BadRequestException {
        XQueryContext context;
        DBSource source = new DBSource(broker, (BinaryDocument)resource, true);
        XQuery xquery = broker.getXQueryService();
        XQueryPool pool = xquery.getXQueryPool();
        CompiledXQuery compiled = pool.borrowCompiledXQuery(broker, source);
        if (compiled == null) {
            response.setHeader("X-XQuery-Cached", "false");
            context = xquery.newContext(AccessContext.REST);
        } else {
            response.setHeader("X-XQuery-Cached", "true");
            context = compiled.getContext();
        }
        context.setModuleLoadPath(XmldbURI.EMBEDDED_SERVER_URI.append(resource.getCollection().getURI()).toString());
        context.setStaticallyKnownDocuments(new XmldbURI[]{resource.getCollection().getURI()});
        this.declareVariables(context, request, response);
        if (compiled == null) {
            try {
                compiled = xquery.compile(context, source);
            }
            catch (IOException e) {
                throw new BadRequestException("Failed to read query from " + resource.getURI(), e);
            }
        }
        context.checkOptions(outputProperties);
        try {
            Sequence result = xquery.execute(compiled, null);
            String string = this.printResults(broker, result, -1, 1, 0L, outputProperties, false);
            return string;
        }
        finally {
            pool.returnCompiledXQuery(source, compiled);
        }
    }

    private String formatXPathExceptionHtml(String query, String path, XPathException e) {
        StringWriter writer = new StringWriter();
        writer.write(QUERY_ERROR_HEAD);
        writer.write("<p class=\"path\"><span class=\"high\">Path</span>: ");
        writer.write("<a href=\"");
        writer.write(path);
        writer.write("\">");
        writer.write(path);
        writer.write("</a></p>");
        writer.write("<p class=\"errmsg\">");
        writer.write(e.getMessage());
        writer.write("</p>");
        if (query != null) {
            writer.write("<p><span class=\"high\">Query</span>:</p><pre>");
            writer.write(query);
            writer.write("</pre>");
        }
        writer.write("</body></html>");
        return writer.toString();
    }

    private String formatXPathException(String query, String path, XPathException e) {
        StringWriter writer = new StringWriter();
        writer.write("<?xml version=\"1.0\" ?>");
        writer.write("<exception><path>");
        writer.write(path);
        writer.write("</path>");
        writer.write("<message>");
        writer.write(e.getMessage());
        writer.write("</message>");
        if (query != null) {
            writer.write("<query>");
            writer.write(query);
            writer.write("</query>");
        }
        writer.write("</exception>");
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String printCollection(DBBroker broker, Collection collection) {
        SAXSerializer serializer = null;
        StringWriter writer = new StringWriter();
        try {
            serializer = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
            serializer.setOutput(writer, defaultProperties);
            AttributesImpl attrs = new AttributesImpl();
            serializer.startDocument();
            serializer.startPrefixMapping("exist", "http://exist.sourceforge.net/NS/exist");
            serializer.startElement("http://exist.sourceforge.net/NS/exist", "result", "exist:result", attrs);
            attrs.addAttribute("", "name", "name", "CDATA", collection.getURI().toString());
            try {
                DateTimeValue dtCreated = new DateTimeValue(new Date(collection.getCreationTime()));
                attrs.addAttribute("", "created", "created", "CDATA", dtCreated.getStringValue());
            }
            catch (XPathException e) {
                attrs.addAttribute("", "created", "created", "CDATA", String.valueOf(collection.getCreationTime()));
            }
            this.printPermissions(attrs, collection.getPermissions());
            serializer.startElement("http://exist.sourceforge.net/NS/exist", "collection", "exist:collection", attrs);
            Iterator i = collection.collectionIterator();
            while (i.hasNext()) {
                XmldbURI child = (XmldbURI)i.next();
                Collection childCollection = broker.getCollection(collection.getURI().append(child));
                if (childCollection == null || !childCollection.getPermissions().validate(broker.getUser(), 4)) continue;
                attrs.clear();
                attrs.addAttribute("", "name", "name", "CDATA", child.toString());
                try {
                    DateTimeValue dtCreated = new DateTimeValue(new Date(childCollection.getCreationTime()));
                    attrs.addAttribute("", "created", "created", "CDATA", dtCreated.getStringValue());
                }
                catch (XPathException e) {
                    attrs.addAttribute("", "created", "created", "CDATA", String.valueOf(childCollection.getCreationTime()));
                }
                this.printPermissions(attrs, childCollection.getPermissions());
                serializer.startElement("http://exist.sourceforge.net/NS/exist", "collection", "exist:collection", attrs);
                serializer.endElement("http://exist.sourceforge.net/NS/exist", "collection", "exist:collection");
            }
            i = collection.iterator(broker);
            while (i.hasNext()) {
                DocumentImpl doc = (DocumentImpl)i.next();
                if (!doc.getPermissions().validate(broker.getUser(), 4)) continue;
                XmldbURI resource = doc.getFileURI();
                DocumentMetadata metadata = doc.getMetadata();
                attrs.clear();
                attrs.addAttribute("", "name", "name", "CDATA", resource.toString());
                try {
                    DateTimeValue dtCreated = new DateTimeValue(new Date(metadata.getCreated()));
                    attrs.addAttribute("", "created", "created", "CDATA", dtCreated.getStringValue());
                }
                catch (XPathException e) {
                    attrs.addAttribute("", "created", "created", "CDATA", String.valueOf(metadata.getCreated()));
                }
                try {
                    DateTimeValue dtLastModified = new DateTimeValue(new Date(metadata.getLastModified()));
                    attrs.addAttribute("", "last-mofified", "last-modified", "CDATA", dtLastModified.getStringValue());
                }
                catch (XPathException e) {
                    attrs.addAttribute("", "last-modified", "last-modified", "CDATA", String.valueOf(metadata.getLastModified()));
                }
                this.printPermissions(attrs, doc.getPermissions());
                serializer.startElement("http://exist.sourceforge.net/NS/exist", "resource", "exist:resource", attrs);
                serializer.endElement("http://exist.sourceforge.net/NS/exist", "resource", "exist:resource");
            }
            serializer.endElement("http://exist.sourceforge.net/NS/exist", "collection", "exist:collection");
            serializer.endElement("http://exist.sourceforge.net/NS/exist", "result", "exist:result");
            serializer.endDocument();
            SerializerPool.getInstance().returnObject(serializer);
        }
        catch (SAXException e) {
            try {
                LOG.warn((Object)("Error while serializing collection contents: " + e.getMessage()), (Throwable)e);
                SerializerPool.getInstance().returnObject(serializer);
            }
            catch (Throwable throwable) {
                SerializerPool.getInstance().returnObject(serializer);
                throw throwable;
            }
        }
        return writer.toString();
    }

    protected void printPermissions(AttributesImpl attrs, Permission perm) {
        attrs.addAttribute("", "owner", "owner", "CDATA", perm.getOwner());
        attrs.addAttribute("", "group", "group", "CDATA", perm.getOwnerGroup());
        attrs.addAttribute("", "permissions", "permissions", "CDATA", ((Object)perm).toString());
    }

    protected String printResults(DBBroker broker, Sequence results, int howmany, int start, long queryTime, Properties outputProperties, boolean wrap) throws BadRequestException {
        if (!results.isEmpty()) {
            int rlen = results.getItemCount();
            if (start < 1 || start > rlen) {
                throw new BadRequestException("Start parameter out of range");
            }
            if (howmany + start > rlen || howmany <= 0) {
                howmany = rlen - start + 1;
            }
        } else {
            howmany = 0;
        }
        Serializer serializer = broker.getSerializer();
        serializer.reset();
        outputProperties.setProperty("sax-document-events", "false");
        SAXSerializer sax = null;
        try {
            StringWriter writer = new StringWriter();
            sax = (SAXSerializer)SerializerPool.getInstance().borrowObject(SAXSerializer.class);
            sax.setOutput(writer, outputProperties);
            serializer.setProperties(outputProperties);
            serializer.setSAXHandlers(sax, sax);
            serializer.toSAX(results, start, howmany, wrap);
            SerializerPool.getInstance().returnObject(sax);
            return writer.toString();
        }
        catch (SAXException e) {
            LOG.warn((Object)e);
            throw new BadRequestException("Error while serializing xml: " + e.toString(), e);
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
            throw new BadRequestException("Error while serializing xml: " + e.toString(), e);
        }
    }

    private void writeResponse(HttpServletResponse response, String data, String contentType, String encoding) throws IOException {
        if (contentType != null && !response.isCommitted()) {
            int semicolon = contentType.indexOf(59);
            if (semicolon != -1) {
                contentType = contentType.substring(0, semicolon);
            }
            response.setContentType(contentType + "; charset=" + encoding);
        }
        ServletOutputStream is = response.getOutputStream();
        is.write(data.getBytes(encoding));
    }

    static {
        defaultProperties.setProperty("indent", "yes");
        defaultProperties.setProperty("encoding", "UTF-8");
        defaultProperties.setProperty("media-type", MimeType.XML_TYPE.getName());
        defaultProperties.setProperty("expand-xincludes", "yes");
        defaultProperties.setProperty("highlight-matches", "elements");
        defaultProperties.setProperty("process-xsl-pi", "yes");
        defaultOutputKeysProperties = new Properties();
        defaultOutputKeysProperties.setProperty("indent", "yes");
        defaultOutputKeysProperties.setProperty("encoding", "UTF-8");
        defaultOutputKeysProperties.setProperty("media-type", MimeType.XML_TYPE.getName());
    }
}

