/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http;

import java.io.DataOutputStream;
import java.io.IOException;
import org.exist.util.MimeType;

public class Response {
    private static final String stdHeaders = "Allow: POST GET PUT DELETE\nServer: eXist\nCache-control: no-cache\n";
    private int code = 200;
    private String statusDesc = null;
    private String content = null;
    private byte[] binaryContent = null;
    private String encoding = "UTF-8";
    private String contentType = MimeType.XML_TYPE.getName();

    public Response() {
    }

    public Response(int code, String message) {
        this.code = code;
        this.statusDesc = message;
    }

    public Response(String content) {
        this.content = content;
    }

    public void setResponseCode(int code) {
        this.code = code;
    }

    public int getResponseCode() {
        return this.code;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setDescription(String description) {
        this.statusDesc = description;
    }

    public String getDescription() {
        return this.statusDesc;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setContent(byte[] content) {
        this.binaryContent = content;
    }

    public byte[] getContent() throws IOException {
        return this.content == null ? (this.binaryContent != null ? this.binaryContent : null) : this.content.getBytes(this.encoding);
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void write(DataOutputStream os) throws IOException {
        byte[] contentData = this.content == null ? (this.binaryContent != null ? this.binaryContent : null) : this.content.getBytes(this.encoding);
        StringBuffer buf = new StringBuffer();
        buf.append("HTTP/1.0 ");
        buf.append(Integer.toString(this.code));
        if (this.statusDesc != null) {
            buf.append(' ');
            buf.append(this.statusDesc);
        } else {
            buf.append(" OK");
        }
        buf.append('\n');
        buf.append(stdHeaders);
        buf.append("Content-Type: ");
        buf.append(this.contentType);
        buf.append("\nContent-Length: ");
        buf.append(contentData == null ? 0 : contentData.length);
        buf.append("\n\n");
        os.writeBytes(buf.toString());
        if (contentData != null) {
            os.write(contentData, 0, contentData.length);
        }
        os.flush();
        os.close();
    }
}

