/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.exist.dom.BinaryDocument;
import org.exist.dom.QName;
import org.exist.http.BadRequestException;
import org.exist.http.NotFoundException;
import org.exist.http.servlets.HttpRequestWrapper;
import org.exist.http.servlets.HttpResponseWrapper;
import org.exist.memtree.DocumentBuilderReceiver;
import org.exist.memtree.DocumentImpl;
import org.exist.memtree.MemTreeBuilder;
import org.exist.memtree.SAXAdapter;
import org.exist.security.PermissionDeniedException;
import org.exist.security.xacml.AccessContext;
import org.exist.source.Source;
import org.exist.source.StringSource;
import org.exist.storage.DBBroker;
import org.exist.storage.XQueryPool;
import org.exist.storage.serializers.Serializer;
import org.exist.storage.serializers.WSDLFilter;
import org.exist.util.MimeType;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Module;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SOAPServer {
    private String formEncoding;
    private String containerEncoding;
    private static final String ENCODING = "UTF-8";
    private static final String SEPERATOR = System.getProperty("line.separator");
    private static final String XSLT_WEBSERVICE_WSDL = "/db/system/webservice/wsdl.xslt";
    private static final String XSLT_WEBSERVICE_HUMAN_DESCRIPTION = "/db/system/webservice/human.description.xslt";
    private static final String XSLT_WEBSERVICE_FUNCTION_DESCRIPTION = "/db/system/webservice/function.description.xslt";
    private static final String XSLT_WEBSERVICE_SOAP_RESPONSE = "/db/system/webservice/soap.response.xslt";
    public static final String WEBSERVICE_MODULE_EXTENSION = ".xqws";
    private HashMap XQWSDescriptionsCache = new HashMap();
    private static final String QUERY_ERROR_HEAD = "<html><head><title>Query Error</title><style type=\"text/css\">.errmsg {  border: 1px solid black;  padding: 15px;  margin-left: 20px;  margin-right: 20px;}h1 { color: #C0C0C0; }.path {  padding-bottom: 10px;}.high {   color: #666699;   font-weight: bold;}</style></head><body><h1>XQuery Error</h1>";

    public SOAPServer(String formEncoding, String containerEncoding) {
        this.formEncoding = formEncoding;
        this.containerEncoding = containerEncoding;
    }

    private CompiledXQuery compileXQuery(DBBroker broker, Source xqSource, XmldbURI[] staticallyKnownDocuments, XmldbURI xqwsCollectionUri, HttpServletRequest request, HttpServletResponse response) throws XPathException {
        XQuery xquery = broker.getXQueryService();
        XQueryPool pool = xquery.getXQueryPool();
        CompiledXQuery compiled = pool.borrowCompiledXQuery(broker, xqSource);
        XQueryContext context = compiled == null ? xquery.newContext(AccessContext.REST) : compiled.getContext();
        this.declareVariables(context, request, response);
        context.setModuleLoadPath(XmldbURI.EMBEDDED_SERVER_URI.append(xqwsCollectionUri).toString());
        context.setStaticallyKnownDocuments(staticallyKnownDocuments);
        if (compiled == null) {
            try {
                compiled = xquery.compile(context, xqSource);
            }
            catch (IOException e) {
                throw new XPathException("Failed to compile query: " + xqSource.toString(), e);
            }
        }
        pool.returnCompiledXQuery(xqSource, compiled);
        return compiled;
    }

    private CompiledXQuery XQueryExecuteXQWSFunction(DBBroker broker, Node xqwsSOAPFunction, XQWSDescription xqwsDescription, HttpServletRequest request, HttpServletResponse response) throws XPathException {
        StringBuffer query = new StringBuffer();
        query.append("xquery version \"1.0\";" + SEPERATOR);
        query.append(SEPERATOR);
        query.append("import module namespace " + xqwsDescription.getNamespace().getLocalName() + "=\"" + xqwsDescription.getNamespace().getNamespaceURI() + "\" at \"" + xqwsDescription.getFileURI().toString() + "\";" + SEPERATOR);
        query.append(SEPERATOR);
        String functionName = xqwsSOAPFunction.getLocalName();
        if (functionName == null) {
            functionName = xqwsSOAPFunction.getNodeName();
        }
        query.append(xqwsDescription.getNamespace().getLocalName() + ":" + functionName + "(");
        NodeList xqwsSOAPFunctionParams = xqwsSOAPFunction.getChildNodes();
        Node nInternalFunction = xqwsDescription.getFunction(functionName);
        NodeList nlInternalFunctionParams = xqwsDescription.getFunctionParameters(nInternalFunction);
        int j = 0;
        for (int i = 0; i < xqwsSOAPFunctionParams.getLength(); ++i) {
            Node nSOAPFunctionParam = xqwsSOAPFunctionParams.item(i);
            if (nSOAPFunctionParam.getNodeType() != 1) continue;
            query.append(this.writeXQueryFunctionParameter(xqwsDescription.getFunctionParameterType(nlInternalFunctionParams.item(j)), xqwsDescription.getFunctionParameterCardinality(nlInternalFunctionParams.item(j)), nSOAPFunctionParam));
            query.append(",");
            ++j;
        }
        if (query.charAt(query.length() - 1) == ',') {
            query.deleteCharAt(query.length() - 1);
        }
        query.append(")");
        return this.compileXQuery(broker, new StringSource(query.toString()), new XmldbURI[]{xqwsDescription.getCollectionURI()}, xqwsDescription.getCollectionURI(), request, response);
    }

    private void processParameterValue(StringBuffer param, Node nParamSeqItem, String prefix, String postfix, int isAtomic) throws XPathException {
        boolean justOnce = false;
        StringBuffer whiteContent = new StringBuffer();
        try {
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            tr.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter sw = new StringWriter();
            StreamResult result = new StreamResult(sw);
            StringBuffer psw = sw.getBuffer();
            block6: for (Node n = nParamSeqItem.getFirstChild(); n != null; n = n.getNextSibling()) {
                switch (n.getNodeType()) {
                    case 1: {
                        if (isAtomic > 0) {
                            throw new Exception("Content of " + nParamSeqItem.getNodeName() + " must be an atomic value");
                        }
                        isAtomic = -1;
                        if (justOnce) {
                            throw new Exception(nParamSeqItem.getNodeName() + " must have ONLY ONE element child");
                        }
                        DOMSource source = new DOMSource(n);
                        tr.transform(source, result);
                        justOnce = true;
                        continue block6;
                    }
                    case 3: 
                    case 4: {
                        boolean isNotWhite;
                        String nodeValue = n.getNodeValue();
                        boolean bl = isNotWhite = !nodeValue.matches("[ \n\r\t]+");
                        if (isAtomic >= 0) {
                            if (isNotWhite || isAtomic > 0) {
                                if (isAtomic == 0) {
                                    isAtomic = 1;
                                }
                                psw.append(nodeValue);
                                continue block6;
                            }
                            if (isAtomic != 0) continue block6;
                            whiteContent.append(nodeValue);
                            continue block6;
                        }
                        if (!isNotWhite) continue block6;
                        throw new Exception(nParamSeqItem.getNodeName() + " has mixed content, but it must have only one element child");
                    }
                }
            }
            if (isAtomic >= 0) {
                param.append(prefix);
            }
            if (isAtomic == 0) {
                param.append(whiteContent);
            } else {
                param.append(psw);
            }
            if (isAtomic >= 0) {
                param.append(postfix);
            }
        }
        catch (Exception e) {
            throw new XPathException(e.getMessage());
        }
    }

    private StringBuffer writeXQueryFunctionParameter(String paramType, int paramCardinality, Node nSOAPParam) throws XPathException {
        int isAtomic;
        String prefix;
        String postfix = prefix = new String();
        int type = Type.getType(paramType);
        int n = Type.subTypeOf(type, 20) ? 1 : (isAtomic = Type.subTypeOf(type, -1) ? -1 : 0);
        if (isAtomic >= 0) {
            if (isAtomic > 0 && type != 22) {
                String typeName = Type.getTypeName(type);
                if (typeName != null) {
                    prefix = typeName + "(\"";
                    postfix = "\")";
                }
            } else {
                postfix = prefix = "\"";
            }
        }
        StringBuffer param = new StringBuffer();
        if (paramCardinality >= 4) {
            param.append("(");
            NodeList nlParamSequenceItems = nSOAPParam.getChildNodes();
            for (int i = 0; i < nlParamSequenceItems.getLength(); ++i) {
                Node nParamSeqItem = nlParamSequenceItems.item(i);
                if (nParamSeqItem.getNodeType() != 1) continue;
                this.processParameterValue(param, nParamSeqItem, prefix, postfix, isAtomic);
                param.append(",");
            }
            if (param.charAt(param.length() - 1) == ',') {
                param.deleteCharAt(param.length() - 1);
            }
            param.append(")");
        } else {
            this.processParameterValue(param, nSOAPParam, prefix, postfix, isAtomic);
        }
        return param;
    }

    private XQWSDescription getXQWSDescription(DBBroker broker, String path, HttpServletRequest request) throws PermissionDeniedException, XPathException, SAXException, NotFoundException {
        XQWSDescription description;
        if (this.XQWSDescriptionsCache.containsKey(path)) {
            description = (XQWSDescription)this.XQWSDescriptionsCache.get(path);
            if (!description.isValid()) {
                description.refresh(request);
            }
        } else {
            description = new XQWSDescription(broker, path, request);
        }
        this.XQWSDescriptionsCache.put(path, description);
        return description;
    }

    public void doGet(DBBroker broker, HttpServletRequest request, HttpServletResponse response, String path) throws BadRequestException, PermissionDeniedException, NotFoundException, IOException {
        if (request.getCharacterEncoding() == null) {
            request.setCharacterEncoding(this.formEncoding);
        }
        try {
            XQWSDescription description = this.getXQWSDescription(broker, path, request);
            byte[] result = null;
            if (request.getParameter("WSDL") != null || request.getParameter("wsdl") != null) {
                result = description.getWSDL();
                response.setContentType(MimeType.XML_TYPE.getName());
            } else if (request.getParameter("WSDLRPC") != null || request.getParameter("wsdlrpc") != null) {
                result = description.getWSDL(false);
                response.setContentType(MimeType.XML_TYPE.getName());
            } else {
                result = request.getParameter("function") != null ? description.getFunctionDescription(request.getParameter("function")) : description.getHumanDescription();
            }
            ServletOutputStream os = response.getOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream((OutputStream)os);
            bos.write(result);
            bos.close();
            os.close();
        }
        catch (XPathException xpe) {
            response.setStatus(400);
            this.writeResponse(response, this.formatXPathException(null, path, xpe), "text/html", ENCODING);
        }
        catch (SAXException saxe) {
            response.setStatus(400);
            this.writeResponse(response, this.formatXPathException(null, path, new XPathException(null, "SAX exception while transforming node: " + saxe.getMessage(), saxe)), "text/html", ENCODING);
        }
        catch (TransformerConfigurationException tce) {
            response.setStatus(400);
            this.writeResponse(response, this.formatXPathException(null, path, new XPathException(null, "SAX exception while transforming node: " + tce.getMessage(), tce)), "text/html", ENCODING);
        }
    }

    public void doPost(DBBroker broker, HttpServletRequest request, HttpServletResponse response, String path) throws BadRequestException, PermissionDeniedException, NotFoundException, IOException {
        boolean isRpcEncoded;
        String funcNamespace;
        ServletInputStream is = request.getInputStream();
        byte[] buf = new byte[request.getContentLength()];
        int bytes = 0;
        int offset = 0;
        int max = 4096;
        while ((bytes = is.read(buf, offset, max)) != -1) {
            offset += bytes;
        }
        Document soapRequest = null;
        try {
            soapRequest = this.BuildXMLDocument(buf);
        }
        catch (Exception e) {
            response.setStatus(400);
            this.writeResponse(response, this.formatXPathException(null, path, new XPathException(null, "Unable to construct an XML document from the SOAP Request, probably an invalid request: " + e.getMessage(), e)), "text/html", ENCODING);
            return;
        }
        NodeList nlBody = soapRequest.getDocumentElement().getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
        Node nSOAPBody = nlBody.item(0);
        NodeList nlBodyChildren = nSOAPBody.getChildNodes();
        Node nSOAPFunction = null;
        for (int i = 0; i < nlBodyChildren.getLength(); ++i) {
            Node bodyChild = nlBodyChildren.item(i);
            if (bodyChild.getNodeType() != 1) continue;
            nSOAPFunction = bodyChild;
            break;
        }
        if ((funcNamespace = nSOAPFunction.getNamespaceURI()) != null) {
            if (!funcNamespace.equals(request.getRequestURL().toString())) {
                response.setStatus(400);
                this.writeResponse(response, "SOAP Function call has invalid namespace, got: " + funcNamespace + " but expected: " + request.getRequestURL().toString(), "text/html", ENCODING);
                return;
            }
        } else {
            response.setStatus(400);
            this.writeResponse(response, "SOAP Function call has no namespace, expected: " + request.getRequestURL().toString(), "text/html", ENCODING);
            return;
        }
        String encodingStyle = ((Element)nSOAPFunction).getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle");
        boolean bl = isRpcEncoded = encodingStyle != null && encodingStyle.equals("http://schemas.xmlsoap.org/soap/encoding/");
        if (!isRpcEncoded) {
            NodeList nlSOAPFunction = nSOAPFunction.getChildNodes();
            for (int i = 0; i < nlSOAPFunction.getLength(); ++i) {
                Node functionChild = nlSOAPFunction.item(i);
                if (functionChild.getNodeType() != 1 || !((Element)functionChild).hasAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type")) continue;
                isRpcEncoded = true;
                break;
            }
        }
        try {
            XQWSDescription description = this.getXQWSDescription(broker, path, request);
            CompiledXQuery xqCallXQWS = this.XQueryExecuteXQWSFunction(broker, nSOAPFunction, description, request, response);
            XQuery xqueryService = broker.getXQueryService();
            Sequence xqwsResult = xqueryService.execute(xqCallXQWS, null);
            String funcName = nSOAPFunction.getLocalName();
            if (funcName == null) {
                funcName = nSOAPFunction.getNodeName();
            }
            byte[] result = description.getSOAPResponse(funcName, xqwsResult, request, isRpcEncoded);
            response.setContentType(MimeType.XML_TYPE.getName());
            ServletOutputStream os = response.getOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream((OutputStream)os);
            bos.write(result);
            bos.close();
            os.close();
        }
        catch (XPathException xpe) {
            response.setStatus(400);
            this.writeResponse(response, this.formatXPathException(null, path, xpe), "text/html", ENCODING);
        }
        catch (SAXException saxe) {
            response.setStatus(400);
            this.writeResponse(response, this.formatXPathException(null, path, new XPathException(null, "SAX exception while transforming node: " + saxe.getMessage(), saxe)), "text/html", ENCODING);
        }
        catch (TransformerConfigurationException tce) {
            response.setStatus(400);
            this.writeResponse(response, this.formatXPathException(null, path, new XPathException(null, "SAX exception while transforming node: " + tce.getMessage(), tce)), "text/html", ENCODING);
        }
    }

    private Document BuildXMLDocument(byte[] buf) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        InputSource src = new InputSource(new ByteArrayInputStream(buf));
        SAXParser parser = factory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        SAXAdapter adapter = new SAXAdapter();
        reader.setContentHandler(adapter);
        reader.setContentHandler(adapter);
        reader.parse(src);
        return adapter.getDocument();
    }

    private void declareVariables(XQueryContext context, HttpServletRequest request, HttpServletResponse response) throws XPathException {
        if (request != null) {
            HttpRequestWrapper reqw = new HttpRequestWrapper(request, this.formEncoding, this.containerEncoding);
            context.declareVariable("request:request", reqw);
            context.declareVariable("session:session", reqw.getSession());
        }
        if (response != null) {
            HttpResponseWrapper respw = new HttpResponseWrapper(response);
            context.declareVariable("response:response", respw);
        }
    }

    private String formatXPathException(String query, String path, XPathException e) {
        StringWriter writer = new StringWriter();
        writer.write(QUERY_ERROR_HEAD);
        writer.write("<p class=\"path\"><span class=\"high\">Path</span>: ");
        writer.write("<a href=\"");
        writer.write(path);
        writer.write("\">");
        writer.write(path);
        writer.write("</a></p>");
        writer.write("<p class=\"errmsg\">");
        writer.write(e.getMessage());
        writer.write("</p>");
        if (query != null) {
            writer.write("<p><span class=\"high\">Query</span>:</p><pre>");
            writer.write(query);
            writer.write("</pre>");
        }
        writer.write("</body></html>");
        return writer.toString();
    }

    private void writeResponse(HttpServletResponse response, String data, String contentType, String encoding) throws IOException {
        if (contentType != null && !response.isCommitted()) {
            int semicolon = contentType.indexOf(59);
            if (semicolon != -1) {
                contentType = contentType.substring(0, semicolon);
            }
            response.setContentType(contentType + "; charset=" + encoding);
        }
        ServletOutputStream is = response.getOutputStream();
        is.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes());
        is.write(data.getBytes(encoding));
    }

    private class XQWSDescription {
        private DBBroker broker = null;
        private String HttpServletRequestURL = null;
        private String XQWSPath = null;
        private XmldbURI xqwsFileURI = null;
        private XmldbURI xqwsCollectionURI = null;
        private QName xqwsNamespace = null;
        private long lastModifiedXQWS = 0L;
        private Module modXQWS = null;
        private DocumentImpl docXQWSDescription = null;
        private long lastModifiedWSDL = 0L;
        private byte[][] descriptionWSDL = new byte[][]{null, null};
        private long lastModifiedHuman = 0L;
        private byte[] descriptionHuman = null;
        private long lastModifiedFunction = 0L;
        private HashMap descriptionFunction = new HashMap();

        public XQWSDescription(DBBroker broker, String XQWSPath, HttpServletRequest request) throws XPathException, SAXException, PermissionDeniedException, NotFoundException {
            this.broker = broker;
            this.HttpServletRequestURL = request.getRequestURL().toString();
            this.XQWSPath = XQWSPath;
            this.createInternalDescription(request);
        }

        public XmldbURI getFileURI() {
            return this.xqwsFileURI;
        }

        public XmldbURI getCollectionURI() {
            return this.xqwsCollectionURI;
        }

        public QName getNamespace() {
            return this.xqwsNamespace;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isValid() {
            org.exist.dom.DocumentImpl docXQWS = null;
            try {
                docXQWS = this.getXQWS(this.broker, this.XQWSPath);
                boolean bl = docXQWS.getMetadata().getLastModified() == this.lastModifiedXQWS;
                return bl;
            }
            catch (PermissionDeniedException e) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (docXQWS != null) {
                    docXQWS.getUpdateLock().release(0);
                }
            }
        }

        public void refresh(HttpServletRequest request) throws XPathException, SAXException, PermissionDeniedException, NotFoundException {
            this.createInternalDescription(request);
        }

        public byte[] getWSDL() throws PermissionDeniedException, TransformerConfigurationException, SAXException {
            return this.getWSDL(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getWSDL(boolean isDocumentLiteral) throws PermissionDeniedException, TransformerConfigurationException, SAXException {
            org.exist.dom.DocumentImpl docStyleSheet = null;
            int wsdlIndex = isDocumentLiteral ? 0 : 1;
            try {
                docStyleSheet = this.broker.getXMLResource(XmldbURI.create(SOAPServer.XSLT_WEBSERVICE_WSDL), 0);
                if (docStyleSheet.getMetadata().getLastModified() != this.lastModifiedWSDL || this.descriptionWSDL[wsdlIndex] == null) {
                    Properties params = new Properties();
                    params.put("isDocumentLiteral", isDocumentLiteral ? "true" : "false");
                    this.descriptionWSDL[wsdlIndex] = this.Transform(this.docXQWSDescription, docStyleSheet, params);
                    this.lastModifiedWSDL = docStyleSheet.getMetadata().getLastModified();
                }
                byte[] byArray = this.descriptionWSDL[wsdlIndex];
                return byArray;
            }
            finally {
                if (docStyleSheet != null) {
                    docStyleSheet.getUpdateLock().release(0);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getHumanDescription() throws PermissionDeniedException, TransformerConfigurationException, SAXException {
            org.exist.dom.DocumentImpl docStyleSheet = null;
            try {
                docStyleSheet = this.broker.getXMLResource(XmldbURI.create(SOAPServer.XSLT_WEBSERVICE_HUMAN_DESCRIPTION), 0);
                if (docStyleSheet.getMetadata().getLastModified() != this.lastModifiedHuman || this.descriptionHuman == null) {
                    this.descriptionHuman = this.Transform(this.docXQWSDescription, docStyleSheet, null);
                    this.lastModifiedHuman = docStyleSheet.getMetadata().getLastModified();
                }
                byte[] byArray = this.descriptionHuman;
                return byArray;
            }
            finally {
                if (docStyleSheet != null) {
                    docStyleSheet.getUpdateLock().release(0);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getFunctionDescription(String functionName) throws PermissionDeniedException, TransformerConfigurationException, SAXException {
            org.exist.dom.DocumentImpl docStyleSheet = null;
            try {
                docStyleSheet = this.broker.getXMLResource(XmldbURI.create(SOAPServer.XSLT_WEBSERVICE_FUNCTION_DESCRIPTION), 0);
                if (docStyleSheet.getMetadata().getLastModified() != this.lastModifiedFunction) {
                    this.descriptionFunction.clear();
                    this.lastModifiedFunction = docStyleSheet.getMetadata().getLastModified();
                }
                if (!this.descriptionFunction.containsKey(functionName)) {
                    Properties params = new Properties();
                    params.put("function", functionName);
                    this.descriptionFunction.put(functionName, this.Transform(this.docXQWSDescription, docStyleSheet, params));
                }
                byte[] byArray = (byte[])this.descriptionFunction.get(functionName);
                return byArray;
            }
            finally {
                if (docStyleSheet != null) {
                    docStyleSheet.getUpdateLock().release(0);
                }
            }
        }

        public Node getFunction(String functionName) {
            NodeList nlFunctions = this.docXQWSDescription.getElementsByTagName("function");
            for (int i = 0; i < nlFunctions.getLength(); ++i) {
                Node nFunction = nlFunctions.item(i);
                NodeList nlFunctionChildren = nFunction.getChildNodes();
                for (int j = 0; j < nlFunctionChildren.getLength(); ++j) {
                    Node nFunctionChild = nlFunctionChildren.item(j);
                    if (nFunctionChild.getNodeType() != 1 || !nFunctionChild.getNodeName().equals("name") || !nFunctionChild.getFirstChild().getNodeValue().equals(functionName)) continue;
                    return nFunction;
                }
            }
            return null;
        }

        public NodeList getFunctionParameters(String functionName) {
            Node internalFunction = this.getFunction(functionName);
            if (internalFunction != null) {
                return this.getFunctionParameters(internalFunction);
            }
            return null;
        }

        public NodeList getFunctionParameters(Node internalFunction) {
            NodeList nlChildren = internalFunction.getChildNodes();
            for (int i = 0; i < nlChildren.getLength(); ++i) {
                Node child = nlChildren.item(i);
                if (!child.getNodeName().equals("parameters")) continue;
                return child.getChildNodes();
            }
            return null;
        }

        public String getFunctionParameterName(Node internalFunctionParameter) {
            NodeList nlParamArgs = internalFunctionParameter.getChildNodes();
            for (int i = 0; i < nlParamArgs.getLength(); ++i) {
                Node nArg = nlParamArgs.item(i);
                if (nArg.getNodeType() != 1 || !nArg.getNodeName().equals("name")) continue;
                return nArg.getFirstChild().getNodeValue();
            }
            return null;
        }

        public String getFunctionParameterType(Node internalFunctionParameter) {
            NodeList nlParamArgs = internalFunctionParameter.getChildNodes();
            for (int i = 0; i < nlParamArgs.getLength(); ++i) {
                Node nArg = nlParamArgs.item(i);
                if (nArg.getNodeType() != 1 || !nArg.getNodeName().equals("type")) continue;
                return nArg.getFirstChild().getNodeValue();
            }
            return null;
        }

        public int getFunctionParameterCardinality(Node internalFunctionParameter) {
            NodeList nlParamArgs = internalFunctionParameter.getChildNodes();
            for (int i = 0; i < nlParamArgs.getLength(); ++i) {
                Node nArg = nlParamArgs.item(i);
                if (nArg.getNodeType() != 1 || !nArg.getNodeName().equals("cardinality")) continue;
                return Integer.valueOf(nArg.getFirstChild().getNodeValue());
            }
            return 2;
        }

        public byte[] getSOAPResponse(String functionName, Sequence functionResult, HttpServletRequest request, boolean isRpcEncoded) throws XPathException, PermissionDeniedException, TransformerConfigurationException, SAXException {
            org.exist.dom.DocumentImpl docStyleSheet = this.broker.getXMLResource(XmldbURI.create(SOAPServer.XSLT_WEBSERVICE_SOAP_RESPONSE), 0);
            DocumentImpl docResult = this.describeWebService(this.modXQWS, this.xqwsFileURI, request, this.XQWSPath, functionName, functionResult);
            Properties params = new Properties();
            params.put("isDocumentLiteral", isRpcEncoded ? "false" : "true");
            return this.Transform(docResult, docStyleSheet, params);
        }

        private void createInternalDescription(HttpServletRequest request) throws XPathException, SAXException, PermissionDeniedException, NotFoundException {
            BinaryDocument docXQWS = this.getXQWS(this.broker, this.XQWSPath);
            if (docXQWS == null) {
                throw new NotFoundException("Resource " + request.getRequestURL().toString() + " not found");
            }
            this.xqwsFileURI = docXQWS.getFileURI();
            this.xqwsCollectionURI = docXQWS.getCollection().getURI();
            byte[] xqwsData = this.getXQWSData(this.broker, docXQWS);
            this.lastModifiedXQWS = docXQWS.getMetadata().getLastModified();
            this.xqwsNamespace = this.getXQWSNamespace(xqwsData);
            CompiledXQuery compiled = this.XQueryIncludeXQWS(this.broker, docXQWS.getFileURI(), this.xqwsNamespace, docXQWS.getCollection().getURI());
            this.modXQWS = compiled.getContext().getModule(this.xqwsNamespace.getNamespaceURI());
            this.docXQWSDescription = this.describeWebService(this.modXQWS, this.xqwsFileURI, request, this.XQWSPath, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BinaryDocument getXQWS(DBBroker broker, String path) throws PermissionDeniedException {
            org.exist.dom.DocumentImpl docXQWS = null;
            try {
                XmldbURI pathUri = XmldbURI.create(path);
                org.exist.dom.DocumentImpl documentImpl = docXQWS = (BinaryDocument)broker.getXMLResource(pathUri, 0);
                return documentImpl;
            }
            finally {
                if (docXQWS != null) {
                    docXQWS.getUpdateLock().release(0);
                }
            }
        }

        private byte[] getXQWSData(DBBroker broker, BinaryDocument docXQWS) {
            byte[] data = broker.getBinaryResource(docXQWS);
            return data;
        }

        private QName getXQWSNamespace(byte[] xqwsData) {
            StringBuffer sbNamespace = new StringBuffer();
            ByteArrayInputStream bis = new ByteArrayInputStream(xqwsData);
            while (bis.available() > 0) {
                char c = (char)bis.read();
                sbNamespace.append(c);
                if (c != SEPERATOR.charAt(SEPERATOR.length() - 1)) continue;
                if (sbNamespace.toString().startsWith("module namespace")) break;
                sbNamespace.delete(0, sbNamespace.length());
            }
            String namespaceName = sbNamespace.substring("module namespace".length(), sbNamespace.indexOf("=")).trim();
            String namespaceURL = sbNamespace.substring(sbNamespace.indexOf("\"") + 1, sbNamespace.lastIndexOf("\""));
            return new QName(namespaceName, namespaceURL);
        }

        private CompiledXQuery XQueryIncludeXQWS(DBBroker broker, XmldbURI xqwsFileUri, QName xqwsNamespace, XmldbURI xqwsCollectionUri) throws XPathException {
            String query = "xquery version \"1.0\";" + SEPERATOR;
            query = query + SEPERATOR;
            query = query + "import module namespace " + xqwsNamespace.getLocalName() + "=\"" + xqwsNamespace.getNamespaceURI() + "\" at \"" + xqwsFileUri.toString() + "\";" + SEPERATOR;
            query = query + SEPERATOR;
            query = query + "()";
            return SOAPServer.this.compileXQuery(broker, new StringSource(query), new XmldbURI[]{xqwsCollectionUri}, xqwsCollectionUri, null, null);
        }

        private DocumentImpl describeWebService(Module modXQWS, XmldbURI xqwsFileUri, HttpServletRequest request, String path, String functionName, Sequence functionResult) throws XPathException, SAXException {
            FunctionSignature[] xqwsFunctions = modXQWS.listFunctions();
            MemTreeBuilder builderWebserviceDoc = new MemTreeBuilder(this.broker.getXQueryService().newContext(AccessContext.REST));
            builderWebserviceDoc.startDocument();
            builderWebserviceDoc.startElement(new QName("webservice", null, null), null);
            builderWebserviceDoc.startElement(new QName("name", null, null), null);
            builderWebserviceDoc.characters(xqwsFileUri.toString().substring(0, xqwsFileUri.toString().indexOf(SOAPServer.WEBSERVICE_MODULE_EXTENSION)));
            builderWebserviceDoc.endElement();
            builderWebserviceDoc.startElement(new QName("description", null, null), null);
            builderWebserviceDoc.characters(modXQWS.getDescription());
            builderWebserviceDoc.endElement();
            builderWebserviceDoc.startElement(new QName("host", null, null), null);
            builderWebserviceDoc.characters(request.getServerName() + ":" + request.getServerPort());
            builderWebserviceDoc.endElement();
            builderWebserviceDoc.startElement(new QName("path", null, null), null);
            builderWebserviceDoc.characters(path);
            builderWebserviceDoc.endElement();
            builderWebserviceDoc.startElement(new QName("URL", null, null), null);
            builderWebserviceDoc.characters(request.getRequestURL());
            builderWebserviceDoc.endElement();
            builderWebserviceDoc.startElement(new QName("functions", null, null), null);
            for (int f = 0; f < xqwsFunctions.length; ++f) {
                if (functionName == null) {
                    this.describeWebServiceFunction(xqwsFunctions[f], builderWebserviceDoc, null);
                    continue;
                }
                if (!xqwsFunctions[f].getName().getLocalName().equals(functionName)) continue;
                this.describeWebServiceFunction(xqwsFunctions[f], builderWebserviceDoc, functionResult);
                break;
            }
            builderWebserviceDoc.endElement();
            builderWebserviceDoc.endElement();
            builderWebserviceDoc.endDocument();
            return builderWebserviceDoc.getDocument();
        }

        private void describeWebServiceFunction(FunctionSignature signature, MemTreeBuilder builderFunction, Sequence functionResult) throws XPathException, SAXException {
            builderFunction.startElement(new QName("function", null, null), null);
            builderFunction.startElement(new QName("name", null, null), null);
            builderFunction.characters(signature.getName().getLocalName());
            builderFunction.endElement();
            if (signature.getDescription() != null) {
                builderFunction.startElement(new QName("description", null, null), null);
                builderFunction.characters(signature.getDescription());
                builderFunction.endElement();
            }
            SequenceType[] xqwsArguments = signature.getArgumentTypes();
            builderFunction.startElement(new QName("parameters", null, null), null);
            for (int a = 0; a < xqwsArguments.length; ++a) {
                builderFunction.startElement(new QName("parameter", null, null), null);
                builderFunction.startElement(new QName("name", null, null), null);
                builderFunction.endElement();
                builderFunction.startElement(new QName("type", null, null), null);
                builderFunction.characters(Type.getTypeName(xqwsArguments[a].getPrimaryType()));
                builderFunction.endElement();
                builderFunction.startElement(new QName("cardinality", null, null), null);
                builderFunction.characters(Integer.toString(xqwsArguments[a].getCardinality()));
                builderFunction.endElement();
                builderFunction.endElement();
            }
            builderFunction.endElement();
            builderFunction.startElement(new QName("return", null, null), null);
            builderFunction.startElement(new QName("type", null, null), null);
            builderFunction.characters(Type.getTypeName(signature.getReturnType().getPrimaryType()));
            builderFunction.endElement();
            int iReturnCardinality = signature.getReturnType().getCardinality();
            builderFunction.startElement(new QName("cardinality", null, null), null);
            builderFunction.characters(Integer.toString(iReturnCardinality));
            builderFunction.endElement();
            if (functionResult != null) {
                builderFunction.startElement(new QName("result", null, null), null);
                DocumentBuilderReceiver receiver = new DocumentBuilderReceiver(builderFunction);
                if (iReturnCardinality >= 4) {
                    builderFunction.startElement(new QName("sequence", null, null), null);
                    for (int i = 0; i < functionResult.getItemCount(); ++i) {
                        builderFunction.startElement(new QName("value", null, null), null);
                        functionResult.itemAt(i).copyTo(this.broker, receiver);
                        builderFunction.endElement();
                    }
                    builderFunction.endElement();
                } else {
                    builderFunction.startElement(new QName("value", null, null), null);
                    functionResult.itemAt(0).copyTo(this.broker, receiver);
                    builderFunction.endElement();
                }
                builderFunction.endElement();
            }
            builderFunction.endElement();
            builderFunction.endElement();
        }

        private byte[] Transform(DocumentImpl srcDoc, org.exist.dom.DocumentImpl docStyleSheet, Properties parameters) throws TransformerConfigurationException, SAXException {
            SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            TemplatesHandler templatesHandler = factory.newTemplatesHandler();
            templatesHandler.startDocument();
            Serializer serializer = this.broker.getSerializer();
            serializer.reset();
            WSDLFilter wsdlfilter = new WSDLFilter(templatesHandler, this.HttpServletRequestURL);
            serializer.setSAXHandlers(wsdlfilter, null);
            serializer.toSAX(docStyleSheet);
            templatesHandler.endDocument();
            TransformerHandler handler = factory.newTransformerHandler(templatesHandler.getTemplates());
            if (parameters != null) {
                Transformer transformer = handler.getTransformer();
                Enumeration<Object> parameterKeys = parameters.keys();
                while (parameterKeys.hasMoreElements()) {
                    String paramName = (String)parameterKeys.nextElement();
                    Object paramValue = parameters.get(paramName);
                    transformer.setParameter(paramName, paramValue);
                }
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(os);
            handler.setResult(result);
            handler.startDocument();
            srcDoc.toSAX(this.broker, handler, null);
            handler.endDocument();
            return os.toByteArray();
        }
    }
}

