/*
 * Decompiled with CFR 0.152.
 */
package org.exist.http.webdav.methods;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentMetadata;
import org.exist.http.webdav.methods.AbstractWebDAVMethod;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.xmldb.XmldbURI;

public class Head
extends AbstractWebDAVMethod {
    public Head(BrokerPool pool) {
        super(pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(User user, HttpServletRequest request, HttpServletResponse response, XmldbURI path) throws ServletException, IOException {
        DBBroker broker = null;
        Collection collection = null;
        DocumentImpl resource = null;
        try {
            broker = this.pool.get(user);
            collection = broker.openCollection(path, 0);
            if (collection != null) {
                response.setContentLength(0);
                response.addDateHeader("Last-Modified", collection.getCreationTime());
                return;
            }
            resource = broker.getXMLResource(path, 0);
            if (resource == null) {
                response.sendError(404, "Resource not found");
                return;
            }
            if (!resource.getPermissions().validate(user, 4)) {
                response.sendError(403, "Not allowed to read resource");
                return;
            }
            DocumentMetadata metadata = resource.getMetadata();
            response.setContentType(metadata.getMimeType());
            response.setContentLength(resource.getContentLength());
            response.addDateHeader("Last-Modified", metadata.getLastModified());
        }
        catch (EXistException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        catch (PermissionDeniedException e) {
            response.sendError(403, "Not allowed to read resource");
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            if (resource != null) {
                resource.getUpdateLock().release(0);
            }
            this.pool.release(broker);
        }
    }
}

