/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.exist.backup.RawDataBackup;
import org.exist.indexing.AbstractIndex;
import org.exist.indexing.Index;
import org.exist.indexing.IndexWorker;
import org.exist.indexing.RawBackupSupport;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.btree.DBException;
import org.exist.util.Configuration;
import org.exist.util.DatabaseConfigurationException;

public class IndexManager {
    private static final Logger LOG = Logger.getLogger((Class)IndexManager.class);
    public static final String CONFIGURATION_ELEMENT_NAME = "modules";
    public static final String CONFIGURATION_MODULE_ELEMENT_NAME = "module";
    public static final String INDEXER_MODULES_CLASS_ATTRIBUTE = "class";
    public static final String INDEXER_MODULES_ID_ATTRIBUTE = "id";
    public static final String PROPERTY_INDEXER_MODULES = "indexer.modules";
    private BrokerPool pool;
    private Map indexers = new HashMap();

    public IndexManager(BrokerPool pool, Configuration config) throws DatabaseConfigurationException {
        this.pool = pool;
        Configuration.IndexModuleConfig[] modConf = (Configuration.IndexModuleConfig[])config.getProperty(PROPERTY_INDEXER_MODULES);
        String dataDir = (String)config.getProperty("db-connection.data-dir");
        if (modConf != null) {
            for (int i = 0; i < modConf.length; ++i) {
                String className = modConf[i].getClassName();
                try {
                    Class<?> clazz = Class.forName(className);
                    if (!(class$org$exist$indexing$AbstractIndex == null ? IndexManager.class$("org.exist.indexing.AbstractIndex") : class$org$exist$indexing$AbstractIndex).isAssignableFrom(clazz)) {
                        throw new DatabaseConfigurationException("Class " + className + " does not implement " + AbstractIndex.class.getName());
                    }
                    AbstractIndex index = (AbstractIndex)clazz.newInstance();
                    index.configure(pool, dataDir, modConf[i].getConfig());
                    index.open();
                    this.indexers.put(modConf[i].getId(), index);
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info((Object)("Registered index " + className + " as " + modConf[i].getId()));
                    continue;
                }
                catch (ClassNotFoundException e) {
                    LOG.warn((Object)("Class " + className + " not found. Cannot configure index."), (Throwable)e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    LOG.warn((Object)("Exception while configuring index " + className + ": " + e.getMessage()), (Throwable)e);
                    continue;
                }
                catch (InstantiationException e) {
                    LOG.warn((Object)("Exception while configuring index " + className + ": " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    public BrokerPool getBrokerPool() {
        return this.pool;
    }

    protected Iterator iterator() {
        return this.indexers.values().iterator();
    }

    public synchronized Index getIndexById(String indexId) {
        Iterator i = this.iterator();
        if (i.hasNext()) {
            Index indexer = (Index)i.next();
            if (indexId.equals(indexer.getIndexId())) {
                // empty if block
            }
            return indexer;
        }
        return null;
    }

    public synchronized Index getIndexByName(String indexName) {
        return (Index)this.indexers.get(indexName);
    }

    protected synchronized IndexWorker[] getWorkers(DBBroker broker) {
        IndexWorker[] workers = new IndexWorker[this.indexers.size()];
        int j = 0;
        Iterator i = this.indexers.values().iterator();
        while (i.hasNext()) {
            Index index = (Index)i.next();
            workers[j] = index.getWorker(broker);
            ++j;
        }
        return workers;
    }

    public void shutdown() throws DBException {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Index index = (Index)i.next();
            index.close();
        }
    }

    public void sync() throws DBException {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Index index = (Index)i.next();
            index.sync();
        }
    }

    public void removeIndexes() throws DBException {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Index index = (Index)i.next();
            index.remove();
        }
    }

    public void reopenIndexes() throws DatabaseConfigurationException {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Index index = (Index)i.next();
            index.open();
        }
    }

    public void backupToArchive(RawDataBackup backup) throws IOException {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Index index = (Index)i.next();
            if (!(index instanceof RawBackupSupport)) continue;
            ((RawBackupSupport)((Object)index)).backupToArchive(backup);
        }
    }
}

