/*
 * Decompiled with CFR 0.152.
 */
package org.exist.indexing;

import java.util.Iterator;
import org.exist.dom.AttrImpl;
import org.exist.dom.ElementImpl;
import org.exist.dom.StoredNode;
import org.exist.dom.TextImpl;
import org.exist.indexing.StreamListener;
import org.exist.storage.NodePath;
import org.exist.storage.txn.Txn;

public class IndexUtils {
    public static void scanNode(Txn transaction, StoredNode node, StreamListener listener) {
        Iterator iterator = node.getDocument().getBroker().getNodeIterator(node);
        iterator.next();
        NodePath path = node.getPath();
        IndexUtils.scanNode(transaction, iterator, node, listener, path);
    }

    private static void scanNode(Txn transaction, Iterator iterator, StoredNode node, StreamListener listener, NodePath currentPath) {
        switch (node.getNodeType()) {
            case 1: {
                if (listener != null) {
                    listener.startElement(transaction, (ElementImpl)node, currentPath);
                }
                if (node.hasChildNodes()) {
                    int childCount = node.getChildCount();
                    for (int i = 0; i < childCount; ++i) {
                        StoredNode child = (StoredNode)iterator.next();
                        if (child.getNodeType() == 1) {
                            currentPath.addComponent(child.getQName());
                        }
                        IndexUtils.scanNode(transaction, iterator, child, listener, currentPath);
                        if (child.getNodeType() != 1) continue;
                        currentPath.removeLastComponent();
                    }
                }
                if (listener == null) break;
                listener.endElement(transaction, (ElementImpl)node, currentPath);
                break;
            }
            case 3: {
                if (listener == null) break;
                listener.characters(transaction, (TextImpl)node, currentPath);
                break;
            }
            case 2: {
                if (listener == null) break;
                listener.attribute(transaction, (AttrImpl)node, currentPath);
            }
        }
    }
}

