/*
 * Decompiled with CFR 0.152.
 */
package org.exist.protocolhandler.embedded;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.protocolhandler.embedded.EmbeddedUser;
import org.exist.protocolhandler.xmldb.XmldbURL;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.io.ExistIOException;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.xmldb.XmldbURI;
import org.xml.sax.InputSource;

public class EmbeddedUpload {
    private static final Logger LOG = Logger.getLogger((Class)EmbeddedUpload.class);

    public void stream(XmldbURL xmldbURL, InputStream is) throws IOException {
        this.stream(xmldbURL, is, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stream(XmldbURL xmldbURL, InputStream is, User user) throws IOException {
        File tmp = null;
        try {
            tmp = File.createTempFile("EMBEDDED", "tmp");
            FileOutputStream fos = new FileOutputStream(tmp);
            try {
                int len;
                byte[] buf = new byte[1024];
                while ((len = is.read(buf)) > 0) {
                    fos.write(buf, 0, len);
                }
            }
            finally {
                fos.close();
            }
            this.stream(xmldbURL, tmp, user);
        }
        catch (IOException ex) {
            LOG.error((Object)ex);
            throw ex;
        }
        finally {
            if (tmp != null) {
                tmp.delete();
            }
        }
    }

    public void stream(XmldbURL xmldbURL, File tmp) throws IOException {
        this.stream(xmldbURL, tmp, null);
    }

    public void stream(XmldbURL xmldbURL, File tmp, User user) throws IOException {
        LOG.debug((Object)"Begin document upload");
        Collection collection = null;
        BrokerPool pool = null;
        DBBroker broker = null;
        TransactionManager transact = null;
        Txn txn = null;
        boolean collectionLocked = true;
        try {
            pool = BrokerPool.getInstance();
            if (user == null) {
                if (xmldbURL.hasUserInfo()) {
                    user = EmbeddedUser.authenticate(xmldbURL, pool);
                    if (user == null) {
                        LOG.debug((Object)("Unauthorized user " + xmldbURL.getUsername()));
                        throw new ExistIOException("Unauthorized user " + xmldbURL.getUsername());
                    }
                } else {
                    user = EmbeddedUser.getUserGuest(pool);
                }
            }
            broker = pool.get(user);
            transact = pool.getTransactionManager();
            txn = transact.beginTransaction();
            XmldbURI collectionUri = XmldbURI.create(xmldbURL.getCollection());
            XmldbURI documentUri = XmldbURI.create(xmldbURL.getDocumentName());
            collection = broker.openCollection(collectionUri, 0);
            if (collection == null) {
                transact.abort(txn);
                throw new ExistIOException("Resource " + collectionUri.toString() + " is not a collection.");
            }
            if (collection.hasChildCollection(documentUri)) {
                transact.abort(txn);
                throw new ExistIOException("Resource " + documentUri.toString() + " is a collection.");
            }
            MimeType mime = MimeTable.getInstance().getContentTypeFor(documentUri);
            String contentType = null;
            if (mime != null) {
                contentType = mime.getName();
            } else {
                mime = MimeType.BINARY_TYPE;
            }
            if (mime.isXMLType()) {
                LOG.debug((Object)"storing XML resource");
                InputSource inputsource = new InputSource(tmp.toURI().toASCIIString());
                IndexInfo info = collection.validateXMLResource(txn, broker, documentUri, inputsource);
                DocumentImpl doc = info.getDocument();
                doc.getMetadata().setMimeType(contentType);
                collection.release(0);
                collectionLocked = false;
                collection.store(txn, broker, info, inputsource, false);
                LOG.debug((Object)"done");
            } else {
                LOG.debug((Object)"storing Binary resource");
                FileInputStream is = new FileInputStream(tmp);
                BinaryDocument doc = collection.addBinaryResource(txn, broker, documentUri, is, contentType, (int)tmp.length());
                ((InputStream)is).close();
                LOG.debug((Object)"done");
            }
            LOG.debug((Object)"commit");
            transact.commit(txn);
        }
        catch (IOException ex) {
            try {
                transact.abort(txn);
            }
            catch (Exception abex) {
                LOG.debug((Object)abex);
            }
            LOG.debug((Object)ex);
            throw ex;
        }
        catch (Exception ex) {
            try {
                transact.abort(txn);
            }
            catch (Exception abex) {
                LOG.debug((Object)abex);
            }
            LOG.debug((Object)ex);
            throw new ExistIOException(ex.getMessage(), ex);
        }
        finally {
            LOG.debug((Object)"Done.");
            if (collectionLocked && collection != null) {
                collection.release(0);
            }
            pool.release(broker);
        }
    }
}

