/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security.xacml;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.MatchResult;
import com.sun.xacml.ParsingException;
import com.sun.xacml.finder.PolicyFinder;
import com.sun.xacml.finder.PolicyFinderModule;
import com.sun.xacml.finder.PolicyFinderResult;
import java.net.URI;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.security.XMLSecurityManager;
import org.exist.security.xacml.ExistPDP;
import org.exist.security.xacml.XACMLUtil;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;

public class ExistPolicyModule
extends PolicyFinderModule {
    private static final Logger LOG = Logger.getLogger((Class)ExistPolicyModule.class);
    private ExistPDP pdp;

    private ExistPolicyModule() {
    }

    public ExistPolicyModule(ExistPDP pdp) {
        if (pdp == null) {
            throw new NullPointerException("BrokerPool cannot be null");
        }
        this.pdp = pdp;
    }

    public boolean isRequestSupported() {
        return true;
    }

    public boolean isIdReferenceSupported() {
        return true;
    }

    public void init(PolicyFinder finder) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyFinderResult findPolicy(EvaluationCtx context) {
        BrokerPool pool = this.pdp.getBrokerPool();
        DBBroker broker = null;
        try {
            broker = pool.get(XMLSecurityManager.SYSTEM_USER);
            PolicyFinderResult policyFinderResult = this.findPolicy(broker, context);
            return policyFinderResult;
        }
        catch (EXistException ee) {
            PolicyFinderResult policyFinderResult = XACMLUtil.errorResult("Error while finding policy: " + ee.getMessage(), ee);
            return policyFinderResult;
        }
        finally {
            pool.release(broker);
        }
    }

    private PolicyFinderResult findPolicy(DBBroker broker, EvaluationCtx context) {
        DocumentSet mainPolicyDocs = XACMLUtil.getPolicyDocuments(broker, false);
        if (mainPolicyDocs == null) {
            return new PolicyFinderResult();
        }
        AbstractPolicy matchedPolicy = null;
        try {
            XACMLUtil util = this.pdp.getUtil();
            Iterator it = mainPolicyDocs.iterator();
            while (it.hasNext()) {
                AbstractPolicy policy = util.getPolicyDocument((DocumentImpl)it.next());
                MatchResult match = policy.match(context);
                int result = match.getResult();
                if (result == 2) {
                    return new PolicyFinderResult(match.getStatus());
                }
                if (result != 0) continue;
                if (matchedPolicy == null) {
                    matchedPolicy = policy;
                    continue;
                }
                return XACMLUtil.errorResult("Matched multiple policies for reqest", null);
            }
        }
        catch (ParsingException pe) {
            return XACMLUtil.errorResult("Error retrieving policies: " + pe.getMessage(), pe);
        }
        if (matchedPolicy == null) {
            return new PolicyFinderResult();
        }
        return new PolicyFinderResult(matchedPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyFinderResult findPolicy(URI idReference, int type) {
        BrokerPool pool = this.pdp.getBrokerPool();
        DBBroker broker = null;
        try {
            broker = pool.get(XMLSecurityManager.SYSTEM_USER);
            AbstractPolicy policy = this.pdp.getUtil().findPolicy(broker, idReference, type);
            PolicyFinderResult policyFinderResult = policy == null ? new PolicyFinderResult() : new PolicyFinderResult(policy);
            return policyFinderResult;
        }
        catch (Exception e) {
            PolicyFinderResult policyFinderResult = XACMLUtil.errorResult("Error resolving id '" + idReference.toString() + "': " + e.getMessage(), e);
            return policyFinderResult;
        }
        finally {
            pool.release(broker);
        }
    }
}

