/*
 * Decompiled with CFR 0.152.
 */
package org.exist.security.xacml;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.Policy;
import com.sun.xacml.PolicySet;
import com.sun.xacml.PolicyTreeElement;
import com.sun.xacml.ProcessingException;
import com.sun.xacml.Target;
import com.sun.xacml.cond.Apply;
import com.sun.xacml.ctx.Status;
import com.sun.xacml.finder.PolicyFinder;
import com.sun.xacml.finder.PolicyFinderResult;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.dom.StoredNode;
import org.exist.numbering.NodeId;
import org.exist.security.PermissionDeniedException;
import org.exist.security.XMLSecurityManager;
import org.exist.security.xacml.ExistPDP;
import org.exist.security.xacml.ExistPolicyModule;
import org.exist.security.xacml.XACMLConstants;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeValueIndex;
import org.exist.storage.UpdateListener;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AnyURIValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XACMLUtil
implements UpdateListener {
    private static final Logger LOG = Logger.getLogger((Class)ExistPolicyModule.class);
    private static final Map POLICY_CACHE = Collections.synchronizedMap(new HashMap(8));
    private static final XmldbURI[] samplePolicyDocs = new XmldbURI[]{XmldbURI.create("policies/main_modules_policy.xml"), XmldbURI.create("policies/builtin_policy.xml"), XmldbURI.create("policies/external_modules_policy.xml"), XmldbURI.create("policies/reflection_policy.xml")};
    private ExistPDP pdp;

    private XACMLUtil() {
    }

    XACMLUtil(ExistPDP pdp) {
        if (pdp == null) {
            throw new NullPointerException("ExistPDP cannot be null");
        }
        this.pdp = pdp;
        pdp.getBrokerPool().getNotificationService().subscribe(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializePolicyCollection() {
        DBBroker broker = null;
        try {
            broker = this.pdp.getBrokerPool().get(XMLSecurityManager.SYSTEM_USER);
            this.initializePolicyCollection(broker);
        }
        catch (EXistException ee) {
            LOG.error((Object)"Could not get broker pool to initialize policy collection", (Throwable)ee);
        }
        finally {
            this.pdp.getBrokerPool().release(broker);
        }
    }

    private void initializePolicyCollection(DBBroker broker) {
        Boolean loadDefaults;
        Collection policyCollection = XACMLUtil.getPolicyCollection(broker);
        if (policyCollection == null) {
            return;
        }
        if (policyCollection.getDocumentCount() == 0 && ((loadDefaults = (Boolean)broker.getConfiguration().getProperty("xacml.load.defaults")) == null || loadDefaults.booleanValue())) {
            XACMLUtil.storeDefaultPolicies(broker);
        }
    }

    public void documentUpdated(DocumentImpl document, int event) {
        if (XACMLUtil.inPolicyCollection(document) && (event == 2 || event == 1)) {
            POLICY_CACHE.remove(document.getURI());
        }
    }

    public void nodeMoved(NodeId oldNodeId, StoredNode newNode) {
    }

    public void unsubscribe() {
    }

    public static boolean inPolicyCollection(DocumentImpl document) {
        return "/db/system/policies".equals(document.getCollection().getURI());
    }

    public void close() {
        this.pdp.getBrokerPool().getNotificationService().unsubscribe(this);
    }

    public AbstractPolicy findPolicy(DBBroker broker, URI idReference, int type) throws ParsingException, ProcessingException, XPathException {
        QName idAttributeQName = XACMLUtil.getIdAttributeQName(type);
        if (idAttributeQName == null) {
            throw new NullPointerException("Invalid reference type: " + type);
        }
        DocumentImpl policyDoc = this.getPolicyDocument(broker, idAttributeQName, idReference);
        if (policyDoc == null) {
            return null;
        }
        return this.getPolicyDocument(policyDoc);
    }

    public static DocumentSet getPolicyDocuments(DBBroker broker, boolean recursive) {
        Collection policyCollection = XACMLUtil.getPolicyCollection(broker);
        if (policyCollection == null) {
            return null;
        }
        int documentCount = policyCollection.getDocumentCount();
        if (documentCount == 0) {
            return null;
        }
        DocumentSet documentSet = new DocumentSet(documentCount);
        return policyCollection.allDocs(broker, documentSet, recursive, false);
    }

    public static Collection getPolicyCollection(DBBroker broker) {
        Collection policyCollection = broker.getCollection(XACMLConstants.POLICY_COLLECTION_URI);
        if (policyCollection == null) {
            TransactionManager transact = broker.getBrokerPool().getTransactionManager();
            Txn txn = transact.beginTransaction();
            try {
                policyCollection = broker.getOrCreateCollection(txn, XACMLConstants.POLICY_COLLECTION_URI);
                broker.saveCollection(txn, policyCollection);
                transact.commit(txn);
            }
            catch (IOException e) {
                transact.abort(txn);
                LOG.error((Object)"Error creating policy collection", (Throwable)e);
                return null;
            }
            catch (EXistException e) {
                transact.abort(txn);
                LOG.error((Object)"Error creating policy collection", (Throwable)e);
                return null;
            }
            catch (PermissionDeniedException e) {
                transact.abort(txn);
                LOG.error((Object)"Error creating policy collection", (Throwable)e);
                return null;
            }
        }
        return policyCollection;
    }

    public DocumentImpl getPolicyDocument(DBBroker broker, QName attributeQName, URI attributeValue) throws ProcessingException, XPathException {
        int documentCount;
        DocumentSet documentSet = this.getPolicyDocuments(broker, attributeQName, attributeValue);
        int n = documentCount = documentSet == null ? 0 : documentSet.getLength();
        if (documentCount == 0) {
            LOG.warn((Object)("Could not find " + attributeQName.getLocalName() + " '" + attributeValue + "'"), null);
            return null;
        }
        if (documentCount > 1) {
            throw new ProcessingException("Too many applicable policies for " + attributeQName.getLocalName() + " '" + attributeValue + "'");
        }
        return (DocumentImpl)documentSet.iterator().next();
    }

    public DocumentSet getPolicyDocuments(DBBroker broker, QName attributeQName, URI attributeValue) throws ProcessingException, XPathException {
        if (attributeQName == null) {
            return null;
        }
        if (attributeValue == null) {
            return null;
        }
        AnyURIValue comparison = new AnyURIValue(attributeValue);
        DocumentSet documentSet = XACMLUtil.getPolicyDocuments(broker, true);
        NodeSet nodeSet = documentSet.toNodeSet();
        NativeValueIndex valueIndex = broker.getValueIndex();
        NodeSet results = valueIndex.find(4, documentSet, null, 0, attributeQName, comparison);
        return results == null ? null : results.getDocumentSet();
    }

    public static QName getIdAttributeQName(int type) {
        if (type == 0) {
            return new QName("PolicyId", "urn:oasis:names:tc:xacml:1.0:policy");
        }
        if (type == 1) {
            return new QName("PolicySetId", "urn:oasis:names:tc:xacml:1.0:policy");
        }
        return null;
    }

    public static PolicyFinderResult errorResult(String message, Throwable t) {
        LOG.warn((Object)message, t);
        return new PolicyFinderResult(new Status(Collections.singletonList("urn:oasis:names:tc:xacml:1.0:status:processing-error"), message));
    }

    public AbstractPolicy getPolicyDocument(DocumentImpl policyDoc) throws ParsingException {
        String name = policyDoc.getURI().toString();
        AbstractPolicy policy = (AbstractPolicy)POLICY_CACHE.get(name);
        if (policy == null) {
            policy = this.parsePolicyDocument(policyDoc);
            POLICY_CACHE.put(name, policy);
        }
        return policy;
    }

    public AbstractPolicy parsePolicyDocument(Document policyDoc) throws ParsingException {
        Element root = policyDoc.getDocumentElement();
        String name = root.getTagName();
        if (name.equals("PolicySet")) {
            return PolicySet.getInstance((Node)root, (PolicyFinder)this.pdp.getPDPConfig().getPolicyFinder());
        }
        if (name.equals("Policy")) {
            return Policy.getInstance((Node)root);
        }
        throw new ParsingException("The root element of the policy document must be 'PolicySetId' or 'PolicySetId', was: '" + name + "'");
    }

    public static void XMLEscape(StringBuffer buffer) {
        if (buffer == null) {
            return;
        }
        int i = 0;
        while (i < buffer.length()) {
            char c = buffer.charAt(i);
            String escape = XACMLUtil.getEscape(c);
            if (escape == null) {
                ++i;
                continue;
            }
            buffer.replace(i, i + 1, escape);
            i += escape.length();
        }
    }

    public static String getEscape(char c) {
        switch (c) {
            case '&': {
                return "&amp;";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return "&apos;";
            }
        }
        return null;
    }

    public static String XMLEscape(String in) {
        if (in == null) {
            return null;
        }
        StringBuffer temp = new StringBuffer(in);
        XACMLUtil.XMLEscape(temp);
        return temp.toString();
    }

    public static String serialize(PolicyTreeElement element, boolean indent) {
        if (element == null) {
            return "";
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (indent) {
            element.encode((OutputStream)out, new Indenter());
        } else {
            element.encode((OutputStream)out);
        }
        return out.toString();
    }

    public static String serialize(Target target, boolean indent) {
        if (target == null) {
            return "";
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (indent) {
            target.encode((OutputStream)out, new Indenter());
        } else {
            target.encode((OutputStream)out);
        }
        return out.toString();
    }

    public static String serialize(Apply apply, boolean indent) {
        if (apply == null) {
            return "";
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (indent) {
            apply.encode((OutputStream)out, new Indenter());
        } else {
            apply.encode((OutputStream)out);
        }
        return out.toString();
    }

    public static void storeDefaultPolicies(DBBroker broker) {
        LOG.debug((Object)"Storing default XACML policies");
        for (int i = 0; i < samplePolicyDocs.length; ++i) {
            XmldbURI docPath = samplePolicyDocs[i];
            try {
                XACMLUtil.storePolicy(broker, docPath);
                continue;
            }
            catch (IOException ioe) {
                LOG.warn((Object)("IO Error storing default policy '" + docPath + "'"), (Throwable)ioe);
                continue;
            }
            catch (EXistException ee) {
                LOG.warn((Object)("IO Error storing default policy '" + docPath + "'"), (Throwable)ee);
            }
        }
    }

    public static void storePolicy(DBBroker broker, XmldbURI docPath) throws EXistException, IOException {
        XmldbURI docName = docPath.lastSegment();
        URL url = XACMLUtil.class.getResource(docPath.toString());
        if (url == null) {
            return;
        }
        String content = XACMLUtil.toString(url.openStream());
        if (content == null) {
            return;
        }
        Collection collection = XACMLUtil.getPolicyCollection(broker);
        if (collection == null) {
            return;
        }
        TransactionManager transact = broker.getBrokerPool().getTransactionManager();
        Txn txn = transact.beginTransaction();
        try {
            IndexInfo info = collection.validateXMLResource(txn, broker, docName, content);
            collection.store(txn, broker, info, content, false);
            transact.commit(txn);
        }
        catch (Exception e) {
            transact.abort(txn);
            if (e instanceof EXistException) {
                throw (EXistException)e;
            }
            throw new EXistException("Error storing policy '" + docPath + "'", e);
        }
    }

    public static String toString(InputStream in) throws IOException {
        int read;
        if (in == null) {
            return null;
        }
        InputStreamReader reader = new InputStreamReader(in);
        char[] buffer = new char[100];
        CharArrayWriter writer = new CharArrayWriter(1000);
        while ((read = reader.read(buffer)) > -1) {
            writer.write(buffer, 0, read);
        }
        return writer.toString();
    }

    public void debug() {
    }
}

