/*
 * Decompiled with CFR 0.152.
 */
package org.exist.source;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.source.AbstractSource;
import org.exist.source.Source;
import org.exist.storage.DBBroker;
import org.exist.xmldb.XmldbURI;

public class DBSource
extends AbstractSource {
    private BinaryDocument doc;
    private XmldbURI key;
    private long lastModified;
    private String encoding = "UTF-8";
    private boolean checkEncoding;
    private DBBroker broker;

    public DBSource(DBBroker broker, BinaryDocument doc, boolean checkXQEncoding) {
        this.broker = broker;
        this.doc = doc;
        this.key = doc.getURI();
        this.lastModified = doc.getMetadata().getLastModified();
        this.checkEncoding = checkXQEncoding;
    }

    public Object getKey() {
        return this.key;
    }

    public XmldbURI getDocumentPath() {
        return this.key;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int isValid(DBBroker broker) {
        DocumentImpl doc = null;
        try {
            doc = broker.getXMLResource(this.key, 0);
            if (doc == null) {
                int n = -1;
                return n;
            }
            if (doc.getMetadata().getLastModified() > this.lastModified) {
                int n = -1;
                return n;
            }
            int n = 1;
            return n;
        }
        catch (PermissionDeniedException e) {
            int n = -1;
            return n;
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(0);
            }
        }
    }

    public int isValid(Source other) {
        if (!(other instanceof DBSource)) {
            return -1;
        }
        DBSource source = (DBSource)other;
        if (source.getLastModified() > this.lastModified) {
            return -1;
        }
        return 1;
    }

    public Reader getReader() throws IOException {
        byte[] data = this.broker.getBinaryResource(this.doc);
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        this.checkEncoding(is);
        is.reset();
        return new InputStreamReader((InputStream)is, this.encoding);
    }

    public String getContent() throws IOException {
        byte[] data = this.broker.getBinaryResource(this.doc);
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        this.checkEncoding(is);
        return new String(data, this.encoding);
    }

    private void checkEncoding(InputStream is) throws IOException {
        String checkedEnc;
        if (this.checkEncoding && (checkedEnc = DBSource.guessXQueryEncoding(is)) != null) {
            this.encoding = checkedEnc;
        }
    }
}

