/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import javax.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.backup.RawDataBackup;
import org.exist.collections.Collection;
import org.exist.dom.BinaryDocument;
import org.exist.dom.DocumentSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.StoredNode;
import org.exist.dom.SymbolTable;
import org.exist.indexing.IndexController;
import org.exist.indexing.StreamListener;
import org.exist.memtree.DocumentImpl;
import org.exist.numbering.NodeId;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.stax.EmbeddedXMLStreamReader;
import org.exist.storage.BrokerPool;
import org.exist.storage.ContentLoadingObserver;
import org.exist.storage.ElementIndex;
import org.exist.storage.IndexSpec;
import org.exist.storage.NativeValueIndex;
import org.exist.storage.NodePath;
import org.exist.storage.TextSearchEngine;
import org.exist.storage.serializers.Serializer;
import org.exist.storage.txn.Txn;
import org.exist.util.Configuration;
import org.exist.util.LockException;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.XQuery;
import org.w3c.dom.Document;

public abstract class DBBroker
extends Observable {
    public static final int MATCH_EXACT = 0;
    public static final int MATCH_REGEXP = 1;
    public static final int MATCH_WILDCARDS = 2;
    public static final String ROOT_COLLECTION_NAME = "db";
    public static final String ROOT_COLLECTION = "/db";
    public static final String SYSTEM_COLLECTION_NAME = "system";
    public static final String SYSTEM_COLLECTION = "/db/system";
    public static final String TEMP_COLLECTION_NAME = "temp";
    public static final String TEMP_COLLECTION = "/db/system/temp";
    public static final String CONFIGURATION_ELEMENT_NAME = "xupdate";
    public static final String XUPDATE_FRAGMENTATION_FACTOR_ATTRIBUTE = "allowed-fragmentation";
    public static final String PROPERTY_XUPDATE_FRAGMENTATION_FACTOR = "xupdate.fragmentation";
    public static final String XUPDATE_CONSISTENCY_CHECKS_ATTRIBUTE = "enable-consistency-checks";
    public static final String PROPERTY_XUPDATE_CONSISTENCY_CHECKS = "xupdate.consistency-checks";
    protected static final Logger LOG = Logger.getLogger((Class)DBBroker.class);
    protected boolean caseSensitive = true;
    protected Configuration config;
    protected BrokerPool pool;
    protected User user = null;
    protected XQuery xqueryService;
    private int referenceCount = 0;
    protected String id;
    protected IndexController indexController;
    public HashMap customProperties = new HashMap();
    protected List contentLoadingObservers = new ArrayList();

    public DBBroker(BrokerPool pool, Configuration config) throws EXistException {
        this.config = config;
        Boolean temp = (Boolean)config.getProperty("indexer.case-sensitive");
        if (temp != null) {
            this.caseSensitive = temp;
        }
        this.customProperties.put(PROPERTY_XUPDATE_FRAGMENTATION_FACTOR, new Integer(config.getInteger(PROPERTY_XUPDATE_FRAGMENTATION_FACTOR)));
        temp = (Boolean)config.getProperty(PROPERTY_XUPDATE_CONSISTENCY_CHECKS);
        if (temp != null) {
            this.customProperties.put(PROPERTY_XUPDATE_CONSISTENCY_CHECKS, new Boolean(temp));
        }
        this.pool = pool;
        this.xqueryService = new XQuery(this);
        this.initIndexModules();
    }

    public void initIndexModules() {
        this.indexController = new IndexController(this);
    }

    public void setUser(User user) {
        this.user = user;
    }

    public User getUser() {
        return this.user;
    }

    public IndexController getIndexController() {
        return this.indexController;
    }

    public abstract SymbolTable getSymbols();

    public XQuery getXQueryService() {
        return this.xqueryService;
    }

    public abstract ElementIndex getElementIndex();

    public void flush() {
    }

    public void clearContentLoadingObservers() {
        this.contentLoadingObservers.clear();
    }

    public void addContentLoadingObserver(ContentLoadingObserver observer) {
        if (!this.contentLoadingObservers.contains(observer)) {
            this.contentLoadingObservers.add(observer);
        }
    }

    public void removeContentLoadingObserver(ContentLoadingObserver observer) {
        if (this.contentLoadingObservers.contains(observer)) {
            this.contentLoadingObservers.remove(observer);
        }
    }

    public abstract DocumentSet getAllXMLResources(DocumentSet var1);

    public abstract Collection getCollection(XmldbURI var1);

    public abstract Collection openCollection(XmldbURI var1, int var2);

    public abstract Collection getOrCreateCollection(Txn var1, XmldbURI var2) throws PermissionDeniedException, IOException;

    public Configuration getConfiguration() {
        return this.config;
    }

    public Iterator getNodeIterator(StoredNode node) {
        throw new RuntimeException("not implemented for this storage backend");
    }

    public abstract Document getXMLResource(XmldbURI var1) throws PermissionDeniedException;

    public abstract org.exist.dom.DocumentImpl getXMLResource(XmldbURI var1, int var2) throws PermissionDeniedException;

    public abstract int getNextResourceId(Txn var1, Collection var2);

    public String getNodeValue(StoredNode node, boolean addWhitespace) {
        throw new RuntimeException("not implemented for this storage backend");
    }

    public abstract Serializer getSerializer();

    public abstract TextSearchEngine getTextEngine();

    public abstract NativeValueIndex getValueIndex();

    public abstract Serializer newSerializer();

    public abstract StoredNode objectWith(Document var1, NodeId var2);

    public abstract StoredNode objectWith(NodeProxy var1);

    public abstract boolean removeCollection(Txn var1, Collection var2) throws PermissionDeniedException, IOException;

    public void removeXMLResource(Txn transaction, org.exist.dom.DocumentImpl document) throws PermissionDeniedException {
        this.removeXMLResource(transaction, document, true);
    }

    public abstract void removeXMLResource(Txn var1, org.exist.dom.DocumentImpl var2, boolean var3) throws PermissionDeniedException;

    public abstract void reindexCollection(XmldbURI var1) throws PermissionDeniedException;

    public abstract void repair() throws PermissionDeniedException;

    public abstract void saveCollection(Txn var1, Collection var2) throws PermissionDeniedException, IOException;

    public void closeDocument() {
    }

    public void shutdown() {
    }

    public abstract void storeNode(Txn var1, StoredNode var2, NodePath var3, IndexSpec var4, boolean var5);

    public void storeNode(Txn transaction, StoredNode node, NodePath currentPath, IndexSpec indexSpec) {
        this.storeNode(transaction, node, currentPath, indexSpec, true);
    }

    public void endElement(StoredNode node, NodePath currentPath, String content) {
        this.endElement(node, currentPath, content, false);
    }

    public abstract void endElement(StoredNode var1, NodePath var2, String var3, boolean var4);

    public abstract void storeXMLResource(Txn var1, org.exist.dom.DocumentImpl var2);

    public abstract void storeBinaryResource(Txn var1, BinaryDocument var2, byte[] var3);

    public abstract void storeBinaryResource(Txn var1, BinaryDocument var2, InputStream var3);

    public abstract void getCollectionResources(Collection var1);

    public abstract byte[] getBinaryResource(BinaryDocument var1);

    public abstract void readBinaryResource(BinaryDocument var1, OutputStream var2);

    public abstract void getResourceMetadata(org.exist.dom.DocumentImpl var1);

    public abstract void removeBinaryResource(Txn var1, BinaryDocument var2) throws PermissionDeniedException;

    public abstract void moveCollection(Txn var1, Collection var2, Collection var3, XmldbURI var4) throws PermissionDeniedException, LockException, IOException;

    public abstract void moveXMLResource(Txn var1, org.exist.dom.DocumentImpl var2, Collection var3, XmldbURI var4) throws PermissionDeniedException, LockException, IOException;

    public abstract void copyCollection(Txn var1, Collection var2, Collection var3, XmldbURI var4) throws PermissionDeniedException, LockException, IOException;

    public abstract void copyXMLResource(Txn var1, org.exist.dom.DocumentImpl var2, Collection var3, XmldbURI var4) throws PermissionDeniedException, LockException;

    public abstract void defragXMLResource(Txn var1, org.exist.dom.DocumentImpl var2);

    public abstract void checkXMLResourceTree(org.exist.dom.DocumentImpl var1);

    public abstract void checkXMLResourceConsistency(org.exist.dom.DocumentImpl var1) throws EXistException;

    public abstract void sync(int var1);

    public abstract void updateNode(Txn var1, StoredNode var2, boolean var3);

    public boolean isReadOnly() {
        return false;
    }

    public BrokerPool getBrokerPool() {
        return this.pool;
    }

    public abstract void insertNodeAfter(Txn var1, StoredNode var2, StoredNode var3);

    public abstract void indexNode(Txn var1, StoredNode var2, NodePath var3);

    public void indexNode(Txn transaction, StoredNode node) {
        this.indexNode(transaction, node, null);
    }

    public abstract void removeNode(Txn var1, StoredNode var2, NodePath var3, String var4);

    public abstract void removeAllNodes(Txn var1, StoredNode var2, NodePath var3, StreamListener var4);

    public abstract void endRemove(Txn var1);

    public abstract org.exist.dom.DocumentImpl storeTempResource(DocumentImpl var1) throws EXistException, PermissionDeniedException, LockException;

    public abstract void cleanUpTempResources();

    public abstract void cleanUpTempResources(boolean var1);

    public abstract void checkAvailableMemory();

    public abstract DocumentSet getXMLResourcesByDoctype(String var1, DocumentSet var2);

    public int getReferenceCount() {
        return this.referenceCount;
    }

    public void incReferenceCount() {
        ++this.referenceCount;
    }

    public void decReferenceCount() {
        --this.referenceCount;
    }

    public abstract int getPageSize();

    public abstract IndexSpec getIndexConfiguration();

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }

    public abstract EmbeddedXMLStreamReader getXMLStreamReader(StoredNode var1, boolean var2) throws IOException, XMLStreamException;

    public abstract EmbeddedXMLStreamReader getXMLStreamReader(NodeProxy var1, boolean var2) throws IOException, XMLStreamException;

    public abstract void backupToArchive(RawDataBackup var1) throws IOException;
}

