/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.backup.RawDataBackup;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeBroker;
import org.exist.storage.SystemTask;
import org.exist.util.Configuration;

public class DataBackup
implements SystemTask {
    private static final Logger LOG = Logger.getLogger((Class)DataBackup.class);
    private static final SimpleDateFormat creationDateFormat = new SimpleDateFormat("yyMMdd-HHmmss", Locale.US);
    private String dest;

    public DataBackup() {
    }

    public DataBackup(String destination) {
        this.dest = destination;
    }

    public void configure(Configuration config, Properties properties) throws EXistException {
        this.dest = properties.getProperty("output-dir", "backup");
        File f = new File(this.dest);
        if (!f.isAbsolute()) {
            this.dest = (String)config.getProperty("db-connection.data-dir") + File.separatorChar + this.dest;
            f = new File(this.dest);
        }
        if (!(!f.exists() || f.canWrite() && f.isDirectory())) {
            throw new EXistException("Cannot write backup files to " + f.getAbsolutePath() + ". It should be a writable directory.");
        }
        f.mkdirs();
        this.dest = f.getAbsolutePath();
        LOG.debug((Object)("Setting backup data directory: " + this.dest));
    }

    public void execute(DBBroker broker) throws EXistException {
        if (!(broker instanceof NativeBroker)) {
            throw new EXistException("DataBackup system task can only be used with the native storage backend");
        }
        NativeBroker nbroker = (NativeBroker)broker;
        LOG.debug((Object)"Backing up data files ...");
        String creationDate = creationDateFormat.format(new Date());
        String outFilename = this.dest + File.separatorChar + creationDate + ".zip";
        LOG.debug((Object)("Archiving data files into: " + outFilename));
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outFilename));
            Callback cb = new Callback(out);
            broker.backupToArchive(cb);
            out.close();
        }
        catch (IOException e) {
            LOG.warn((Object)("An IO error occurred while backing up data files: " + e.getMessage()), (Throwable)e);
        }
    }

    private class Callback
    implements RawDataBackup {
        private ZipOutputStream zout;

        private Callback(ZipOutputStream out) {
            this.zout = out;
        }

        public OutputStream newEntry(String name) throws IOException {
            this.zout.putNextEntry(new ZipEntry(name));
            return this.zout;
        }

        public void closeEntry() throws IOException {
            this.zout.closeEntry();
        }
    }
}

