/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import org.exist.numbering.NodeId;
import org.exist.util.FastQSort;

public class OccurrenceList {
    private NodeId[] nodes = new NodeId[4];
    private int[] offsets = new int[4];
    private int position = 0;

    public void add(NodeId id, int offset) {
        this.ensureCapacity(this.position);
        this.nodes[this.position] = id;
        this.offsets[this.position++] = offset;
    }

    public NodeId getNode(int pos) {
        return this.nodes[pos];
    }

    public int getOffset(int pos) {
        return this.offsets[pos];
    }

    public int getSize() {
        return this.position;
    }

    public int getTermCount() {
        int count = 1;
        for (int i = 1; i < this.position; ++i) {
            if (this.nodes[i].equals(this.nodes[i - 1])) continue;
            ++count;
        }
        return count;
    }

    public int getOccurrences(int start) {
        int count = 1;
        for (int i = start + 1; i < this.position && this.nodes[i].equals(this.nodes[start]); ++i) {
            ++count;
        }
        return count;
    }

    public boolean contains(NodeId id) {
        for (int i = 0; i < this.position; ++i) {
            if (!this.nodes[i].equals(id)) continue;
            return true;
        }
        return false;
    }

    private void ensureCapacity(int count) {
        if (count == this.nodes.length) {
            NodeId[] nn = new NodeId[count * 2];
            int[] no = new int[nn.length];
            System.arraycopy(this.nodes, 0, nn, 0, count);
            System.arraycopy(this.offsets, 0, no, 0, count);
            this.nodes = nn;
            this.offsets = no;
        }
    }

    public void sort() {
        FastQSort.sort(this.nodes, 0, this.position - 1, this.offsets);
    }
}

