/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Observable;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.dom.StoredNode;
import org.exist.dom.TextImpl;
import org.exist.fulltext.ElementContent;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.FulltextIndexSpec;
import org.exist.storage.TermMatcher;
import org.exist.storage.analysis.SimpleTokenizer;
import org.exist.storage.analysis.Tokenizer;
import org.exist.storage.btree.DBException;
import org.exist.util.Configuration;
import org.exist.util.Occurrences;
import org.exist.util.PorterStemmer;
import org.exist.xquery.TerminatedException;
import org.exist.xquery.XQueryContext;

public abstract class TextSearchEngine
extends Observable {
    protected static final Logger LOG = Logger.getLogger((Class)TextSearchEngine.class);
    protected TreeSet stoplist = new TreeSet();
    protected DBBroker broker = null;
    protected Tokenizer tokenizer;
    protected Configuration config;
    protected boolean indexNumbers = false;
    protected boolean stem = false;
    protected boolean termFreq = true;
    protected PorterStemmer stemmer = null;
    protected int trackMatches = 1;
    public static final String INDEX_NUMBERS_ATTRIBUTE = "parseNumbers";
    public static final String STEM_ATTRIBUTE = "stemming";
    public static final String STORE_TERM_FREQUENCY_ATTRIBUTE = "track-term-freq";
    public static final String TOKENIZER_ATTRIBUTE = "tokenizer";
    public static final String CONFIGURATION_STOPWORDS_ELEMENT_NAME = "stopwords";
    public static final String STOPWORD_FILE_ATTRIBUTE = "file";
    public static final String PROPERTY_INDEX_NUMBERS = "indexer.indexNumbers";
    public static final String PROPERTY_STEM = "indexer.stem";
    public static final String PROPERTY_STORE_TERM_FREQUENCY = "indexer.store-term-freq";
    public static final String PROPERTY_TOKENIZER = "indexer.tokenizer";
    public static final String PROPERTY_STOPWORD_FILE = "stopwords";

    public TextSearchEngine(DBBroker broker, Configuration conf) {
        String tokenizerClass;
        String track;
        Boolean termFrequencies;
        Boolean stemming;
        this.broker = broker;
        this.config = conf;
        Boolean num = (Boolean)this.config.getProperty(PROPERTY_INDEX_NUMBERS);
        if (num != null) {
            this.indexNumbers = num;
        }
        if ((stemming = (Boolean)this.config.getProperty(PROPERTY_STEM)) != null) {
            this.stem = stemming;
        }
        if ((termFrequencies = (Boolean)this.config.getProperty(PROPERTY_STORE_TERM_FREQUENCY)) != null) {
            this.termFreq = termFrequencies;
        }
        if ((track = (String)this.config.getProperty("serialization.match-tagging-elements")) != null) {
            int n = this.trackMatches = track.equalsIgnoreCase("yes") ? 1 : 0;
        }
        if ((track = (String)this.config.getProperty("serialization.match-tagging-attributes")) != null && track.equalsIgnoreCase("yes")) {
            this.trackMatches |= 2;
        }
        if ((tokenizerClass = (String)this.config.getProperty(PROPERTY_TOKENIZER)) != null) {
            try {
                Class<?> tokClass = Class.forName(tokenizerClass);
                this.tokenizer = (Tokenizer)tokClass.newInstance();
                LOG.debug((Object)("using tokenizer: " + tokenizerClass));
            }
            catch (ClassNotFoundException e) {
                LOG.debug((Object)e);
            }
            catch (InstantiationException e) {
                LOG.debug((Object)e);
            }
            catch (IllegalAccessException e) {
                LOG.debug((Object)e);
            }
        }
        if (this.tokenizer == null) {
            LOG.debug((Object)"using simple tokenizer");
            this.tokenizer = new SimpleTokenizer();
        }
        if (this.stem) {
            this.stemmer = new PorterStemmer();
        }
        this.tokenizer.setStemming(this.stem);
        String stopword = (String)this.config.getProperty("stopwords");
        if (stopword != null) {
            try {
                FileReader in = new FileReader(stopword);
                StreamTokenizer tok = new StreamTokenizer(in);
                int next = tok.nextToken();
                while (next != -1) {
                    if (next != -3) continue;
                    this.stoplist.add(tok.sval);
                    next = tok.nextToken();
                }
            }
            catch (FileNotFoundException e) {
                LOG.debug((Object)e);
            }
            catch (IOException e) {
                LOG.debug((Object)e);
            }
        }
    }

    public Tokenizer getTokenizer() {
        return this.tokenizer;
    }

    public abstract void storeText(TextImpl var1, int var2, FulltextIndexSpec var3, boolean var4);

    public abstract void storeText(StoredNode var1, ElementContent var2, int var3, FulltextIndexSpec var4, boolean var5);

    public abstract void flush();

    public abstract boolean close() throws DBException;

    public int getTrackMatches() {
        return this.trackMatches;
    }

    public void setTrackMatches(int flags) {
        this.trackMatches = flags;
    }

    public NodeSet getNodesContaining(XQueryContext context, DocumentSet docs, NodeSet contextSet, int axis, QName qname, String expr, int type) throws TerminatedException {
        return this.getNodesContaining(context, docs, contextSet, axis, qname, expr, type, true);
    }

    public abstract NodeSet getNodesContaining(XQueryContext var1, DocumentSet var2, NodeSet var3, int var4, QName var5, String var6, int var7, boolean var8) throws TerminatedException;

    public abstract NodeSet getNodes(XQueryContext var1, DocumentSet var2, NodeSet var3, int var4, QName var5, TermMatcher var6, CharSequence var7) throws TerminatedException;

    public abstract Occurrences[] scanIndexTerms(DocumentSet var1, NodeSet var2, String var3, String var4) throws PermissionDeniedException;

    public abstract Occurrences[] scanIndexTerms(DocumentSet var1, NodeSet var2, QName[] var3, String var4, String var5) throws PermissionDeniedException;

    public abstract String[] getIndexTerms(DocumentSet var1, TermMatcher var2);

    public abstract void dropIndex(Collection var1);

    public abstract void dropIndex(DocumentImpl var1);
}

