/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.btree;

import java.util.Arrays;
import org.exist.storage.btree.Value;

public class IndexQuery {
    public static final int ANY = 0;
    public static final int EQ = 1;
    public static final int NEQ = -1;
    public static final int GT = 2;
    public static final int LEQ = -2;
    public static final int LT = 3;
    public static final int GEQ = -3;
    public static final int BW = 4;
    public static final int NBW = -4;
    public static final int BWX = 5;
    public static final int NBWX = -5;
    public static final int IN = 6;
    public static final int NIN = -6;
    public static final int TRUNC_RIGHT = 7;
    public static final int TRUNC_LEFT = 8;
    public static final int REGEXP = 9;
    protected int op;
    protected Value[] vals;

    public IndexQuery() {
        this.op = 0;
    }

    public IndexQuery(int op, Value[] vals) {
        this.op = op;
        this.vals = vals;
    }

    public IndexQuery(Value[] vals) {
        this(6, vals);
    }

    public IndexQuery(int op, Value val1) {
        this.op = op;
        this.vals = new Value[]{val1};
    }

    public IndexQuery(Value val1) {
        this(1, val1);
    }

    public IndexQuery(int op, Value val1, Value val2) {
        this.op = op;
        this.vals = new Value[]{val1, val2};
    }

    public IndexQuery(Value val1, Value val2) {
        this(6, val1, val2);
    }

    public IndexQuery(int op, String val1) {
        this(op, new Value(val1));
    }

    public IndexQuery(String val1) {
        this(new Value(val1));
    }

    public IndexQuery(int op, String val1, String val2) {
        this(op, new Value(val1), new Value(val2));
    }

    public IndexQuery(String val1, String val2) {
        this(new Value(val1), new Value(val2));
    }

    public int getOperator() {
        return this.op;
    }

    public final Value getValue(int index) {
        return this.vals[index];
    }

    public Value[] getValues() {
        return this.vals;
    }

    public final int getLength() {
        return this.vals.length;
    }

    public boolean testValue(Value value) {
        switch (this.op) {
            case 0: {
                return true;
            }
            case 1: {
                return value.equals(this.vals[0]);
            }
            case -1: {
                return !value.equals(this.vals[0]);
            }
            case 2: {
                return value.compareTo(this.vals[0]) > 0;
            }
            case -2: {
                return value.compareTo(this.vals[0]) <= 0;
            }
            case 3: {
                return value.compareTo(this.vals[0]) < 0;
            }
            case -3: {
                return value.compareTo(this.vals[0]) >= 0;
            }
            case 4: {
                return value.compareTo(this.vals[0]) >= 0 && value.compareTo(this.vals[1]) <= 0;
            }
            case -4: {
                return value.compareTo(this.vals[0]) <= 0 || value.compareTo(this.vals[1]) >= 0;
            }
            case 5: {
                return value.compareTo(this.vals[0]) > 0 && value.compareTo(this.vals[1]) < 0;
            }
            case -5: {
                return value.compareTo(this.vals[0]) < 0 || value.compareTo(this.vals[1]) > 0;
            }
            case -6: 
            case 6: {
                return Arrays.binarySearch(this.vals, value) >= 0 ? this.op == 6 : this.op == -6;
            }
            case 7: {
                return value.startsWith(this.vals[0]);
            }
            case 8: {
                return value.endsWith(this.vals[0]);
            }
        }
        return false;
    }

    public final boolean testValue(String value) {
        return this.testValue(new Value(value));
    }
}

