/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.btree;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.exist.storage.btree.DBException;
import org.exist.storage.btree.Value;
import org.exist.util.ByteConversion;

public abstract class Paged {
    public static int LENGTH_VERSION_ID = 2;
    public static int LENGTH_HEADER_SIZE = 2;
    public static int LENGTH_PAGE_COUNT = 8;
    public static int LENGTH_PAGE_SIZE = 4;
    public static int LENGTH_TOTAL_COUNT = 8;
    public static int LENGTH_FIRST_FREE_PAGE = 8;
    public static int LENGTH_LAST_FREE_PAGE = 8;
    public static int LENGTH_PAGE_HEADER_SIZE = 1;
    public static int LENGTH_MAX_KEY_SIZE = 2;
    public static int LENGTH_RECORD_COUNT = 8;
    public static int OFFSET_VERSION_ID = 0;
    public static int OFFSET_HEADER_SIZE = OFFSET_VERSION_ID + LENGTH_VERSION_ID;
    public static int OFFSET_PAGE_SIZE = OFFSET_HEADER_SIZE + LENGTH_HEADER_SIZE;
    public static int OFFSET_PAGE_COUNT = OFFSET_PAGE_SIZE + LENGTH_PAGE_SIZE;
    public static int OFFSET_TOTAL_COUNT = OFFSET_PAGE_COUNT + LENGTH_PAGE_COUNT;
    public static int OFFSET_FIRST_FREE_PAGE = OFFSET_TOTAL_COUNT + LENGTH_TOTAL_COUNT;
    public static int OFFSET_LAST_FREE_PAGE = OFFSET_FIRST_FREE_PAGE + LENGTH_FIRST_FREE_PAGE;
    public static int OFFSET_PAGE_HEADER_SIZE = OFFSET_LAST_FREE_PAGE + LENGTH_LAST_FREE_PAGE;
    public static int OFFSET_MAX_KEY_SIZE = OFFSET_PAGE_HEADER_SIZE + LENGTH_PAGE_HEADER_SIZE;
    public static int OFFSET_RECORD_COUNT = OFFSET_MAX_KEY_SIZE + LENGTH_MAX_KEY_SIZE;
    public static int OFFSET_REMAINDER = OFFSET_RECORD_COUNT + LENGTH_RECORD_COUNT;
    protected static final Logger LOG = Logger.getLogger((Class)Paged.class);
    protected static final byte DELETED = 127;
    protected static final byte OVERFLOW = 126;
    protected static final byte UNUSED = 0;
    protected static int PAGE_SIZE = 4096;
    private RandomAccessFile raf;
    private File file;
    private FileHeader fileHeader = this.createFileHeader();
    private boolean readOnly = false;
    private boolean fileIsNew = false;
    private byte[] tempPageData = new byte[FileHeader.access$000(this.fileHeader)];
    private byte[] tempHeaderData = new byte[FileHeader.access$100(this.fileHeader)];
    private static String[] hex = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    public Paged() {
    }

    public Paged(File file) throws DBException {
        this();
        this.setFile(file);
    }

    public abstract short getFileVersion();

    public static final void setPageSize(int pageSize) {
        PAGE_SIZE = pageSize;
    }

    public static final int getPageSize() {
        return PAGE_SIZE;
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean close() throws DBException {
        try {
            this.raf.close();
        }
        catch (IOException e) {
            throw new DBException("an error occurred while closing database file: " + e.getMessage());
        }
        return true;
    }

    public boolean create() throws DBException {
        try {
            this.fileHeader.write();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DBException(0, "Error creating " + this.file.getName());
        }
    }

    public abstract FileHeader createFileHeader();

    public abstract FileHeader createFileHeader(boolean var1) throws IOException;

    public abstract FileHeader createFileHeader(long var1);

    public abstract FileHeader createFileHeader(long var1, int var3);

    public abstract PageHeader createPageHeader();

    public boolean exists() {
        return !this.fileIsNew;
    }

    public boolean flush() throws DBException {
        boolean flushed = false;
        try {
            if (this.fileHeader.isDirty() && !this.readOnly) {
                this.fileHeader.write();
                flushed = true;
            }
        }
        catch (IOException ioe) {
            LOG.warn((Object)"report me");
        }
        return flushed;
    }

    public void backupToStream(OutputStream os) throws IOException {
        int len;
        this.raf.seek(0L);
        byte[] buf = new byte[1024];
        while ((len = this.raf.read(buf)) > 0) {
            os.write(buf, 0, len);
        }
    }

    public final File getFile() {
        return this.file;
    }

    public FileHeader getFileHeader() {
        return this.fileHeader;
    }

    public void closeAndRemove() {
        try {
            this.raf.close();
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to close data file: " + this.file.getAbsolutePath()));
        }
        this.file.delete();
    }

    protected final Page getFreePage() throws IOException {
        return this.getFreePage(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Page getFreePage(boolean reuseDeleted) throws IOException {
        Page p = null;
        FileHeader fileHeader = this.fileHeader;
        synchronized (fileHeader) {
            long pageNum = this.fileHeader.firstFreePage;
            if (reuseDeleted && pageNum != -1L) {
                p = new Page(pageNum);
                p.read();
                this.fileHeader.firstFreePage = p.header.nextPage;
                if (this.fileHeader.firstFreePage == -1L) {
                    this.fileHeader.setLastFreePage(-1L);
                }
            } else {
                pageNum = this.fileHeader.totalCount;
                if (pageNum == Integer.MAX_VALUE) {
                    throw new IOException("page limit reached: " + pageNum);
                }
                this.fileHeader.setTotalCount(pageNum + 1L);
                p = new Page(pageNum);
                p.read();
            }
        }
        p.header.setNextPage(-1L);
        p.header.setStatus((byte)0);
        this.fileHeader.setDirty(true);
        this.fileHeader.write();
        return p;
    }

    protected final Page getPage(long pageNum) throws IOException {
        return new Page(pageNum);
    }

    public boolean isOpened() {
        return true;
    }

    public boolean open(short expectedVersion) throws DBException {
        try {
            if (this.exists()) {
                this.fileHeader.read();
                if (this.fileHeader.getVersion() != expectedVersion) {
                    throw new DBException("Database file " + this.getFile().getName() + " has a storage format incompatible with this " + "version of eXist. Please do a backup/restore of your data first.");
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new DBException(0, "Error opening " + this.file.getName() + ": " + e.getMessage());
        }
    }

    public void printFreeSpaceList() throws IOException {
        long pageNum = this.fileHeader.firstFreePage;
        System.out.println("first free page: " + pageNum);
        System.out.println("free pages for " + this.getFile().getName());
        while (pageNum != -1L) {
            Page next = this.getPage(pageNum);
            next.read();
            System.out.print(pageNum + ";");
            pageNum = next.header.nextPage;
        }
        System.out.println();
    }

    private boolean isRemovedPage(long pageNum) throws IOException {
        long nextNum = this.fileHeader.firstFreePage;
        while (nextNum != -1L) {
            if (nextNum == pageNum) {
                LOG.error((Object)("Page " + pageNum + " has already been removed"));
                Thread.dumpStack();
                return true;
            }
            Page next = this.getPage(nextNum);
            next.read();
            nextNum = next.header.nextPage;
        }
        return false;
    }

    protected final void setFile(File file) throws DBException {
        block6: {
            this.file = file;
            this.fileIsNew = !file.exists();
            try {
                if (!file.exists() || file.canWrite()) {
                    try {
                        this.raf = new RandomAccessFile(file, "rw");
                        FileChannel channel = this.raf.getChannel();
                        FileLock lock = channel.tryLock();
                        if (lock == null) {
                            this.readOnly = true;
                        }
                        break block6;
                    }
                    catch (NonWritableChannelException e) {
                        this.readOnly = true;
                        this.raf = new RandomAccessFile(file, "r");
                        LOG.warn((Object)e);
                    }
                    break block6;
                }
                this.readOnly = true;
                this.raf = new RandomAccessFile(file, "r");
            }
            catch (IOException e) {
                LOG.warn((Object)("An exception occured while opening database file " + file.getAbsolutePath() + ": " + e.getMessage()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlinkPages(Page page) throws IOException {
        if (page != null) {
            page.header.setStatus((byte)0);
            page.header.lsn = -1L;
            FileHeader fileHeader = this.fileHeader;
            synchronized (fileHeader) {
                if (this.fileHeader.firstFreePage == -1L) {
                    this.fileHeader.setFirstFreePage(page.pageNum);
                    page.header.setNextPage(-1L);
                } else {
                    long first = this.fileHeader.firstFreePage;
                    this.fileHeader.setFirstFreePage(page.pageNum);
                    page.header.setNextPage(first);
                }
                page.remove();
                this.fileHeader.setDirty(true);
            }
        }
    }

    protected final void unlinkPages(long pageNum) throws IOException {
        this.unlinkPages(this.getPage(pageNum));
    }

    protected void reuseDeleted(Page page) throws IOException {
        if (page != null && this.fileHeader.getFirstFreePage() != -1L) {
            long next = this.fileHeader.getFirstFreePage();
            if (next == page.pageNum) {
                this.fileHeader.setFirstFreePage(page.header.getNextPage());
                this.fileHeader.write();
                return;
            }
            Page p = this.getPage(next);
            p.read();
            next = p.header.getNextPage();
            while (next != -1L) {
                if (next == page.pageNum) {
                    p.header.setNextPage(page.header.getNextPage());
                    p.header.setDirty(true);
                    p.write(null);
                    return;
                }
                p = this.getPage(next);
                p.read();
                next = p.header.getNextPage();
            }
        }
    }

    protected final void writeValue(Page page, Value value) throws IOException {
        byte[] data = value.getData();
        this.writeValue(page, data);
    }

    protected final void writeValue(Page page, byte[] data) throws IOException {
        PageHeader hdr = page.getPageHeader();
        hdr.dataLen = this.fileHeader.workSize;
        if (data.length != hdr.dataLen) {
            if (hdr.dataLen != Paged.getPageSize() - 64) {
                LOG.warn((Object)"ouch");
            }
            hdr.dataLen = data.length;
        }
        page.write(data);
    }

    protected final void writeValue(long page, Value value) throws IOException {
        this.writeValue(this.getPage(page), value);
    }

    public static String hexDump(byte[] data) {
        StringBuffer buf = new StringBuffer();
        buf.append("\r\n");
        int columns = 0;
        int i = 0;
        while (i < data.length) {
            Paged.byteToHex(buf, data[i]);
            if (columns == 16) {
                buf.append("\r\n");
                columns = 0;
            } else {
                buf.append(' ');
            }
            ++i;
            ++columns;
        }
        return buf.toString();
    }

    private static void byteToHex(StringBuffer buf, byte b) {
        int n = b;
        if (n < 0) {
            n = 256 + n;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        buf.append(hex[d1]);
        buf.append(hex[d2]);
    }

    public static abstract class PageHeader {
        public static int LENGTH_PAGE_STATUS = 1;
        public static int LENGTH_PAGE_DATA_LENGTH = 4;
        public static int LENGTH_PAGE_NEXT_PAGE = 8;
        public static int LENGTH_PAGE_LSN = 8;
        private int dataLen = 0;
        private boolean dirty = false;
        private long nextPage = -1L;
        private byte status = 0;
        private long lsn = -1L;

        public PageHeader() {
        }

        public PageHeader(byte[] data, int offset) throws IOException {
            this.read(data, offset);
        }

        public final int getDataLen() {
            return this.dataLen;
        }

        public final long getNextPage() {
            return this.nextPage;
        }

        public final byte getStatus() {
            return this.status;
        }

        public final boolean isDirty() {
            return this.dirty;
        }

        public final long getLsn() {
            return this.lsn;
        }

        public final void setLsn(long lsn) {
            this.lsn = lsn;
        }

        public int read(byte[] data, int offset) throws IOException {
            this.status = data[offset];
            this.dataLen = ByteConversion.byteToInt(data, offset += LENGTH_PAGE_STATUS);
            this.nextPage = ByteConversion.byteToLong(data, offset += LENGTH_PAGE_DATA_LENGTH);
            this.lsn = ByteConversion.byteToLong(data, offset += LENGTH_PAGE_NEXT_PAGE);
            return offset += LENGTH_PAGE_LSN;
        }

        public int write(byte[] data, int offset) throws IOException {
            data[offset] = this.status;
            ByteConversion.intToByte(this.dataLen, data, offset += LENGTH_PAGE_STATUS);
            ByteConversion.longToByte(this.nextPage, data, offset += LENGTH_PAGE_DATA_LENGTH);
            ByteConversion.longToByte(this.lsn, data, offset += LENGTH_PAGE_NEXT_PAGE);
            this.dirty = false;
            return offset += LENGTH_PAGE_LSN;
        }

        public final void setDataLen(int dataLen) {
            this.dataLen = dataLen;
            this.dirty = true;
        }

        public final void setDirty(boolean dirty) {
            this.dirty = dirty;
        }

        public final void setNextPage(long nextPage) {
            this.nextPage = nextPage;
            this.dirty = true;
        }

        public final void setStatus(byte status) {
            this.status = status;
            this.dirty = true;
        }
    }

    public final class Page
    implements Comparable {
        public static final long NO_PAGE = -1L;
        private PageHeader header;
        private long offset;
        private long pageNum;
        private int refCount = 0;

        public Page() {
            this.header = Paged.this.createPageHeader();
        }

        public Page(long pageNum) throws IOException {
            this();
            if (pageNum == -1L) {
                throw new IOException("Illegal page num: " + pageNum);
            }
            this.setPageNum(pageNum);
        }

        public void decRefCount() {
            --this.refCount;
        }

        public long getOffset() {
            return this.offset;
        }

        public PageHeader getPageHeader() {
            return this.header;
        }

        public String getPageInfo() {
            return "page: " + this.pageNum + "; file = " + Paged.this.getFile().getName() + "; address = " + Long.toHexString(this.offset) + "; page header = " + Paged.this.fileHeader.getPageHeaderSize() + "; data start = " + Long.toHexString(this.offset + (long)Paged.this.fileHeader.getPageHeaderSize());
        }

        public long getPageNum() {
            return this.pageNum;
        }

        public int getRefCount() {
            return this.refCount;
        }

        public int getDataPos() {
            return Paged.this.fileHeader.pageHeaderSize;
        }

        public void incRefCount() {
            ++this.refCount;
        }

        public byte[] read() throws IOException {
            try {
                if (Paged.this.raf.getFilePointer() != this.offset) {
                    Paged.this.raf.seek(this.offset);
                }
                Arrays.fill(Paged.this.tempHeaderData, (byte)0);
                Paged.this.raf.read(Paged.this.tempHeaderData);
                this.header.read(Paged.this.tempHeaderData, 0);
                byte[] workData = new byte[this.header.dataLen];
                Paged.this.raf.read(workData);
                return workData;
            }
            catch (Exception e) {
                LOG.warn((Object)("error while reading page: " + this.getPageInfo()), (Throwable)e);
                throw new IOException(e.getMessage());
            }
        }

        public void setPageNum(long pageNum) {
            this.pageNum = pageNum;
            this.offset = (long)Paged.this.fileHeader.headerSize + pageNum * (long)Paged.this.fileHeader.pageSize;
        }

        public void remove() throws IOException {
            this.write(null);
        }

        private final void write(byte[] data) throws IOException {
            if (data == null) {
                Arrays.fill(Paged.this.tempPageData, (byte)0);
                this.header.setLsn(-1L);
            }
            this.header.write(Paged.this.tempPageData, 0);
            this.header.dirty = false;
            if (data != null) {
                if (data.length > Paged.this.fileHeader.workSize) {
                    throw new IOException("page: " + this.getPageInfo() + ": data length too large: " + data.length);
                }
                System.arraycopy(data, 0, Paged.this.tempPageData, Paged.this.fileHeader.pageHeaderSize, data.length);
            }
            if (Paged.this.raf.getFilePointer() != this.offset) {
                Paged.this.raf.seek(this.offset);
            }
            Paged.this.raf.write(Paged.this.tempPageData);
        }

        public boolean equals(Object obj) {
            return ((Page)obj).pageNum == this.pageNum;
        }

        public int compareTo(Object o) {
            Page other = (Page)o;
            if (this.pageNum == other.pageNum) {
                return 0;
            }
            if (this.pageNum > other.pageNum) {
                return 1;
            }
            return -1;
        }

        public void dumpPage() throws IOException {
            if (Paged.this.raf.getFilePointer() != this.offset) {
                Paged.this.raf.seek(this.offset);
            }
            byte[] data = new byte[Paged.this.fileHeader.pageSize];
            Paged.this.raf.read(data);
            LOG.debug((Object)("Contents of page " + this.pageNum + ": " + Paged.hexDump(data)));
        }
    }

    public abstract class FileHeader {
        private short versionId;
        private boolean dirty = false;
        private long firstFreePage = -1L;
        private short headerSize;
        private long lastFreePage = -1L;
        private short maxKeySize = (short)256;
        private long pageCount;
        private byte pageHeaderSize = (byte)64;
        private int pageSize;
        private long recordCount;
        private long totalCount;
        private int workSize;
        private byte[] buf;

        public FileHeader() {
            this(1024L, PAGE_SIZE);
        }

        public FileHeader(long pageCount) {
            this(pageCount, 4096);
        }

        public FileHeader(long pageCount, int pageSize) {
            this(pageCount, pageSize, 4);
        }

        public FileHeader(long pageCount, int pageSize, byte blockSize) {
            this.pageSize = pageSize;
            this.pageCount = pageCount;
            this.totalCount = pageCount;
            this.headerSize = (short)pageSize;
            this.versionId = Paged.this.getFileVersion();
            this.buf = new byte[this.headerSize];
            this.calculateWorkSize();
        }

        public FileHeader(boolean read) throws IOException {
            if (read) {
                this.read();
            }
        }

        private void calculateWorkSize() {
            this.workSize = this.pageSize - this.pageHeaderSize;
        }

        public final synchronized void decRecordCount() {
            --this.recordCount;
            this.dirty = true;
        }

        public final long getFirstFreePage() {
            return this.firstFreePage;
        }

        public final short getHeaderSize() {
            return this.headerSize;
        }

        public final long getLastFreePage() {
            return this.lastFreePage;
        }

        public final short getMaxKeySize() {
            return this.maxKeySize;
        }

        public final long getPageCount() {
            return this.pageCount;
        }

        public final byte getPageHeaderSize() {
            return this.pageHeaderSize;
        }

        public final int getPageSize() {
            return this.pageSize;
        }

        public final long getRecordCount() {
            return this.recordCount;
        }

        public final long getTotalCount() {
            return this.totalCount;
        }

        public final int getWorkSize() {
            return this.workSize;
        }

        public final short getVersion() {
            return this.versionId;
        }

        public final synchronized void incRecordCount() {
            ++this.recordCount;
            this.dirty = true;
        }

        public final boolean isDirty() {
            return this.dirty;
        }

        public final synchronized void read() throws IOException {
            Paged.this.raf.seek(0L);
            Paged.this.raf.read(this.buf);
            this.read(this.buf);
            this.calculateWorkSize();
            this.dirty = false;
        }

        public int read(byte[] buf) throws IOException {
            this.versionId = ByteConversion.byteToShort(buf, OFFSET_VERSION_ID);
            this.headerSize = ByteConversion.byteToShort(buf, OFFSET_HEADER_SIZE);
            this.pageSize = ByteConversion.byteToInt(buf, OFFSET_PAGE_SIZE);
            this.pageCount = ByteConversion.byteToLong(buf, OFFSET_PAGE_COUNT);
            this.totalCount = ByteConversion.byteToLong(buf, OFFSET_TOTAL_COUNT);
            this.firstFreePage = ByteConversion.byteToLong(buf, OFFSET_FIRST_FREE_PAGE);
            this.lastFreePage = ByteConversion.byteToLong(buf, OFFSET_LAST_FREE_PAGE);
            this.pageHeaderSize = buf[OFFSET_PAGE_HEADER_SIZE];
            this.maxKeySize = ByteConversion.byteToShort(buf, OFFSET_MAX_KEY_SIZE);
            this.recordCount = ByteConversion.byteToLong(buf, OFFSET_RECORD_COUNT);
            return OFFSET_REMAINDER;
        }

        public int write(byte[] buf) throws IOException {
            ByteConversion.shortToByte(this.versionId, buf, OFFSET_VERSION_ID);
            ByteConversion.shortToByte(this.headerSize, buf, OFFSET_HEADER_SIZE);
            ByteConversion.intToByte(this.pageSize, buf, OFFSET_PAGE_SIZE);
            ByteConversion.longToByte(this.pageCount, buf, OFFSET_PAGE_COUNT);
            ByteConversion.longToByte(this.totalCount, buf, OFFSET_TOTAL_COUNT);
            ByteConversion.longToByte(this.firstFreePage, buf, OFFSET_FIRST_FREE_PAGE);
            ByteConversion.longToByte(this.lastFreePage, buf, OFFSET_LAST_FREE_PAGE);
            buf[Paged.OFFSET_PAGE_HEADER_SIZE] = this.pageHeaderSize;
            ByteConversion.shortToByte(this.maxKeySize, buf, OFFSET_MAX_KEY_SIZE);
            ByteConversion.longToByte(this.recordCount, buf, OFFSET_RECORD_COUNT);
            return OFFSET_REMAINDER;
        }

        public final void setDirty(boolean dirty) {
            this.dirty = dirty;
        }

        public final void setFirstFreePage(long firstFreePage) {
            this.firstFreePage = firstFreePage;
            this.dirty = true;
        }

        public final void setHeaderSize(short headerSize) {
            this.headerSize = headerSize;
            this.dirty = true;
        }

        public final void setLastFreePage(long lastFreePage) {
            this.lastFreePage = lastFreePage;
            this.dirty = true;
        }

        public final void setMaxKeySize(short maxKeySize) {
            this.maxKeySize = maxKeySize;
            this.dirty = true;
        }

        public final void setPageCount(long pageCount) {
            this.pageCount = pageCount;
            this.dirty = true;
        }

        public final void setPageHeaderSize(byte pageHeaderSize) {
            this.pageHeaderSize = pageHeaderSize;
            this.calculateWorkSize();
            this.dirty = true;
        }

        public final void setPageSize(int pageSize) {
            this.pageSize = pageSize;
            this.calculateWorkSize();
            this.dirty = true;
        }

        public final void setRecordCount(long recordCount) {
            this.recordCount = recordCount;
            this.dirty = true;
        }

        public final void setTotalCount(long totalCount) {
            this.totalCount = totalCount;
            this.dirty = true;
        }

        public final synchronized void write() throws IOException {
            Paged.this.raf.seek(0L);
            this.write(this.buf);
            Paged.this.raf.write(this.buf);
            this.dirty = false;
        }
    }
}

