/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.btree;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.btree.BTAbstractLoggable;
import org.exist.storage.btree.Value;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class UpdatePageLoggable
extends BTAbstractLoggable {
    protected Value prefix = Value.EMPTY_VALUE;
    protected Value[] values;
    protected long[] pointers;
    protected long pageNum;
    protected int nValues;
    protected int nPointers;

    public UpdatePageLoggable(Txn transaction, byte fileId, long pageNum, Value prefix, Value[] values, int nValues, long[] pointers, int nPointers) {
        super((byte)34, fileId, transaction);
        this.pageNum = pageNum;
        this.prefix = prefix;
        this.values = values;
        this.nValues = nValues;
        this.pointers = pointers;
        this.nPointers = nPointers;
    }

    public UpdatePageLoggable(DBBroker broker, long transactionId) {
        super((byte)34, broker, transactionId);
    }

    public void write(ByteBuffer out) {
        int i;
        super.write(out);
        out.putLong(this.pageNum);
        short pfxLen = (short)this.prefix.getLength();
        out.putShort(pfxLen);
        if (pfxLen > 0) {
            out.put(this.prefix.data(), this.prefix.start(), pfxLen);
        }
        out.putShort((short)this.nValues);
        for (i = 0; i < this.nValues; ++i) {
            short len = (short)this.values[i].getLength();
            out.putShort(len);
            if (len <= 0) continue;
            out.put(this.values[i].data(), this.values[i].start(), len);
        }
        out.putShort((short)this.nPointers);
        for (i = 0; i < this.nPointers; ++i) {
            out.putLong(this.pointers[i]);
        }
    }

    public void read(ByteBuffer in) {
        int i;
        super.read(in);
        this.pageNum = in.getLong();
        short pfxLen = in.getShort();
        if (pfxLen > 0) {
            byte[] pdata = new byte[pfxLen];
            in.get(pdata);
            this.prefix = new Value(pdata);
        }
        this.nValues = in.getShort();
        this.values = new Value[this.nValues];
        for (i = 0; i < this.nValues; ++i) {
            short dataLen = in.getShort();
            byte[] data = new byte[dataLen];
            if (dataLen > 0) {
                in.get(data);
            }
            this.values[i] = new Value(data);
        }
        this.nPointers = in.getShort();
        this.pointers = new long[this.nPointers];
        for (i = 0; i < this.nPointers; ++i) {
            this.pointers[i] = in.getLong();
        }
    }

    public int getLogSize() {
        int len = super.getLogSize() + 14 + this.nPointers * 8 + this.prefix.getLength();
        for (int i = 0; i < this.nValues; ++i) {
            len += this.values[i].getLength() + 2;
        }
        return len;
    }

    public void redo() throws LogException {
        this.getStorage().redoUpdatePage(this);
    }

    public String dump() {
        return super.dump() + " - updated page " + this.pageNum;
    }
}

