/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.dom;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeBroker;
import org.exist.storage.dom.DOMFile;
import org.exist.storage.journal.AbstractLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class CreatePageLoggable
extends AbstractLoggable {
    protected long prevPage;
    protected long newPage;
    protected long nextPage;
    protected short nextTID;
    private DOMFile domDb = null;

    public CreatePageLoggable(Txn transaction, long prevPage, long newPage, long nextPage) {
        this(transaction, prevPage, newPage, nextPage, -1);
    }

    public CreatePageLoggable(Txn transaction, long prevPage, long newPage, long nextPage, short nextTID) {
        super((byte)16, transaction.getId());
        this.prevPage = prevPage;
        this.newPage = newPage;
        this.nextPage = nextPage;
        this.nextTID = nextTID;
    }

    public CreatePageLoggable(DBBroker broker, long transactId) {
        super((byte)16, transactId);
        this.domDb = ((NativeBroker)broker).getDOMFile();
    }

    public void write(ByteBuffer out) {
        out.putInt((int)this.prevPage);
        out.putInt((int)this.newPage);
        out.putInt((int)this.nextPage);
        out.putShort(this.nextTID);
    }

    public void read(ByteBuffer in) {
        this.prevPage = in.getInt();
        this.newPage = in.getInt();
        this.nextPage = in.getInt();
        this.nextTID = in.getShort();
    }

    public int getLogSize() {
        return 14;
    }

    public void redo() throws LogException {
        this.domDb.redoCreatePage(this);
    }

    public void undo() throws LogException {
        this.domDb.undoCreatePage(this);
    }

    public String dump() {
        return super.dump() + " - new page created: " + this.newPage + "; prev. page: " + this.prevPage + "; next page: " + this.nextPage;
    }
}

