/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.dom;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import org.exist.dom.DocumentImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.StoredNode;
import org.exist.numbering.DLNBase;
import org.exist.numbering.NodeId;
import org.exist.stax.EmbeddedXMLStreamReader;
import org.exist.storage.BrokerPool;
import org.exist.storage.BufferStats;
import org.exist.storage.NativeBroker;
import org.exist.storage.Signatures;
import org.exist.storage.StorageAddress;
import org.exist.storage.btree.BTree;
import org.exist.storage.btree.BTreeCallback;
import org.exist.storage.btree.BTreeException;
import org.exist.storage.btree.DBException;
import org.exist.storage.btree.IndexQuery;
import org.exist.storage.btree.Paged;
import org.exist.storage.btree.Value;
import org.exist.storage.cache.Cache;
import org.exist.storage.cache.Cacheable;
import org.exist.storage.cache.LRUCache;
import org.exist.storage.dom.AddLinkLoggable;
import org.exist.storage.dom.AddMovedValueLoggable;
import org.exist.storage.dom.AddValueLoggable;
import org.exist.storage.dom.CreatePageLoggable;
import org.exist.storage.dom.InsertValueLoggable;
import org.exist.storage.dom.ItemId;
import org.exist.storage.dom.RecordPos;
import org.exist.storage.dom.RemoveEmptyPageLoggable;
import org.exist.storage.dom.RemoveOverflowLoggable;
import org.exist.storage.dom.RemovePageLoggable;
import org.exist.storage.dom.RemoveValueLoggable;
import org.exist.storage.dom.SplitPageLoggable;
import org.exist.storage.dom.UpdateHeaderLoggable;
import org.exist.storage.dom.UpdateLinkLoggable;
import org.exist.storage.dom.UpdateValueLoggable;
import org.exist.storage.dom.WriteOverflowPageLoggable;
import org.exist.storage.journal.AbstractLoggable;
import org.exist.storage.journal.LogEntryTypes;
import org.exist.storage.journal.Loggable;
import org.exist.storage.lock.Lock;
import org.exist.storage.lock.ReentrantReadWriteLock;
import org.exist.storage.txn.TransactionException;
import org.exist.storage.txn.Txn;
import org.exist.util.ByteConversion;
import org.exist.util.Configuration;
import org.exist.util.Lockable;
import org.exist.util.ReadOnlyException;
import org.exist.util.hashtable.Object2LongIdentityHashMap;
import org.exist.util.sanity.SanityCheck;
import org.exist.xquery.TerminatedException;

public class DOMFile
extends BTree
implements Lockable {
    public static final String FILE_NAME = "dom.dbx";
    public static final String FILE_KEY_IN_CONFIG = "db-connection.dom";
    public static final int LENGTH_TID = 2;
    public static final int LENGTH_DATA_LENGTH = 2;
    public static final int LENGTH_LINK = 8;
    public static final int LENGTH_ORIGINAL_LOCATION = 8;
    public static final int LENGTH_FORWARD_LOCATION = 8;
    public static final int LENGTH_OVERFLOW_LOCATION = 8;
    public static final byte LOG_CREATE_PAGE = 16;
    public static final byte LOG_ADD_VALUE = 17;
    public static final byte LOG_REMOVE_VALUE = 18;
    public static final byte LOG_REMOVE_EMPTY_PAGE = 19;
    public static final byte LOG_UPDATE_VALUE = 20;
    public static final byte LOG_REMOVE_PAGE = 21;
    public static final byte LOG_WRITE_OVERFLOW = 22;
    public static final byte LOG_REMOVE_OVERFLOW = 23;
    public static final byte LOG_INSERT_RECORD = 24;
    public static final byte LOG_SPLIT_PAGE = 25;
    public static final byte LOG_ADD_LINK = 26;
    public static final byte LOG_ADD_MOVED_REC = 27;
    public static final byte LOG_UPDATE_HEADER = 28;
    public static final byte LOG_UPDATE_LINK = 29;
    public static final short FILE_FORMAT_VERSION_ID = 7;
    public static final byte LOB = 21;
    public static final byte RECORD = 20;
    public static final short OVERFLOW = 0;
    public static final long DATA_SYNC_PERIOD = 4200L;
    private final Cache dataCache;
    private BTree.BTreeFileHeader fileHeader;
    private Object owner = null;
    private Lock lock = null;
    private final Object2LongIdentityHashMap pages = new Object2LongIdentityHashMap(64);
    private DocumentImpl currentDocument = null;
    private final AddValueLoggable addValueLog = new AddValueLoggable();

    public DOMFile(BrokerPool pool, byte id, String dataDir, Configuration config) throws DBException {
        super(pool, id, true, pool.getCacheManager(), 0.01);
        this.lock = new ReentrantReadWriteLock(DOMFile.getFileName());
        this.fileHeader = (BTree.BTreeFileHeader)this.getFileHeader();
        this.fileHeader.setPageCount(0L);
        this.fileHeader.setTotalCount(0L);
        this.dataCache = new LRUCache(256, 0.0, 1.0, "DATA");
        this.dataCache.setFileName(DOMFile.getFileName());
        this.cacheManager.registerCache(this.dataCache);
        File file = new File(dataDir + File.separatorChar + DOMFile.getFileName());
        this.setFile(file);
        if (this.exists()) {
            this.open();
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Creating data file: " + file.getName()));
            }
            this.create();
        }
        config.setProperty(DOMFile.getConfigKeyForFile(), this);
    }

    public static String getFileName() {
        return FILE_NAME;
    }

    public static String getConfigKeyForFile() {
        return FILE_KEY_IN_CONFIG;
    }

    protected final Cache getPageBuffer() {
        return this.dataCache;
    }

    public short getFileVersion() {
        return 7;
    }

    public void setCurrentDocument(DocumentImpl doc) {
        this.currentDocument = doc;
    }

    public long add(Txn transact, byte[] value) throws ReadOnlyException {
        if (!this.lock.isLockedForWrite()) {
            LOG.warn((Object)"the file doesn't own a write lock");
        }
        if (value == null || value.length == 0) {
            return -1L;
        }
        if (value.length + 2 + 2 > this.fileHeader.getWorkSize()) {
            LOG.debug((Object)"Creating overflow page");
            OverflowDOMPage overflow = new OverflowDOMPage(transact);
            overflow.write(transact, value);
            byte[] pnum = ByteConversion.longToByte(overflow.getPageNum());
            return this.add(transact, pnum, true);
        }
        return this.add(transact, value, false);
    }

    private long add(Txn transaction, byte[] value, boolean overflowPage) throws ReadOnlyException {
        if (!this.lock.isLockedForWrite()) {
            LOG.warn((Object)"the file doesn't own a write lock");
        }
        int vlen = value.length;
        DOMPage page = this.getCurrentPage(transaction);
        if (page == null || page.len + 2 + 2 + vlen > page.data.length) {
            AbstractLoggable loggable;
            DOMPage newPage = new DOMPage();
            DOMFilePageHeader ph = page.getPageHeader();
            if (page != null) {
                if (this.isTransactional && transaction != null) {
                    loggable = new UpdateHeaderLoggable(transaction, ph.getPrevDataPage(), page.getPageNum(), newPage.getPageNum(), ph.getPrevDataPage(), ph.getNextDataPage());
                    this.writeToLog(loggable, page.page);
                }
                ph.setNextDataPage(newPage.getPageNum());
                newPage.getPageHeader().setPrevDataPage(page.getPageNum());
                page.setDirty(true);
                this.dataCache.add(page);
            }
            if (this.isTransactional && transaction != null) {
                loggable = new CreatePageLoggable(transaction, page == null ? -1L : page.getPageNum(), newPage.getPageNum(), -1L);
                this.writeToLog(loggable, newPage.page);
            }
            page = newPage;
            this.setCurrentPage(newPage);
        }
        DOMFilePageHeader ph = page.getPageHeader();
        short tid = ph.getNextTID();
        if (this.isTransactional && transaction != null) {
            this.addValueLog.clear(transaction, page.getPageNum(), tid, value);
            this.writeToLog(this.addValueLog, page.page);
        }
        ByteConversion.shortToByte(tid, page.data, page.len);
        page.len += 2;
        ByteConversion.shortToByte(overflowPage ? (short)0 : (short)vlen, page.data, page.len);
        page.len += 2;
        System.arraycopy(value, 0, page.data, page.len, vlen);
        page.len += vlen;
        ph.incRecordCount();
        ph.setDataLength(page.len);
        page.setDirty(true);
        this.dataCache.add(page, 2);
        return StorageAddress.createPointer((int)page.getPageNum(), tid);
    }

    private void writeToLog(Loggable loggable, Paged.Page page) {
        try {
            this.logManager.writeToLog(loggable);
            page.getPageHeader().setLsn(loggable.getLsn());
        }
        catch (TransactionException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public long addBinary(Txn transaction, DocumentImpl doc, byte[] value) {
        if (!this.lock.isLockedForWrite()) {
            LOG.warn((Object)"the file doesn't own a write lock");
        }
        OverflowDOMPage overflow = new OverflowDOMPage(transaction);
        int pagesCount = overflow.write(transaction, value);
        doc.getMetadata().setPageCount(pagesCount);
        return overflow.getPageNum();
    }

    public long addBinary(Txn transaction, DocumentImpl doc, InputStream is) {
        if (!this.lock.isLockedForWrite()) {
            LOG.warn((Object)"the file doesn't own a write lock");
        }
        OverflowDOMPage overflow = new OverflowDOMPage(transaction);
        int pagesCount = overflow.write(transaction, is);
        doc.getMetadata().setPageCount(pagesCount);
        return overflow.getPageNum();
    }

    public byte[] getBinary(long pageNum) {
        if (!this.lock.hasLock()) {
            LOG.warn((Object)"the file doesn't own a lock");
        }
        return this.getOverflowValue(pageNum);
    }

    public void readBinary(long pageNum, OutputStream os) {
        if (!this.lock.hasLock()) {
            LOG.warn((Object)"the file doesn't own a lock");
        }
        try {
            OverflowDOMPage overflow = new OverflowDOMPage(pageNum);
            overflow.streamTo(os);
        }
        catch (IOException e) {
            LOG.warn((Object)"io error while loading overflow value", (Throwable)e);
        }
    }

    public long insertAfter(Txn transaction, DocumentImpl doc, Value key, byte[] value) {
        if (!this.lock.isLockedForWrite()) {
            LOG.warn((Object)"the file doesn't own a write lock");
        }
        try {
            long p = this.findValue(key);
            if (p == -1L) {
                LOG.warn((Object)"couldn't find value");
                return -1L;
            }
            return this.insertAfter(transaction, doc, p, value);
        }
        catch (BTreeException e) {
            LOG.warn((Object)"key not found", (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn((Object)"IO error", (Throwable)e);
        }
        return -1L;
    }

    public long insertAfter(Txn transaction, DocumentImpl doc, long address, byte[] value) {
        DOMFilePageHeader nph;
        RecordPos rec;
        if (!this.lock.isLockedForWrite()) {
            LOG.warn((Object)"the file doesn't own a write lock");
        }
        boolean isOverflow = false;
        if (4 + value.length > this.fileHeader.getWorkSize()) {
            OverflowDOMPage overflow = new OverflowDOMPage(transaction);
            LOG.debug((Object)("creating overflow page: " + overflow.getPageNum()));
            overflow.write(transaction, value);
            value = ByteConversion.longToByte(overflow.getPageNum());
            isOverflow = true;
        }
        if ((rec = this.findRecord(address)) == null) {
            SanityCheck.TRACE("page not found");
            return -1L;
        }
        short vlen = ByteConversion.byteToShort(rec.getPage().data, rec.offset);
        rec.offset += 2;
        if (ItemId.isRelocated(rec.getTID())) {
            rec.offset += 8;
        }
        rec.offset = vlen == 0 ? (rec.offset += 8) : (rec.offset += vlen);
        int dlen = rec.getPage().getPageHeader().getDataLength();
        if (rec.offset < dlen) {
            if (dlen + 2 + 2 + value.length <= this.fileHeader.getWorkSize() && rec.getPage().getPageHeader().hasRoom()) {
                int end = rec.offset + 2 + 2 + value.length;
                System.arraycopy(rec.getPage().data, rec.offset, rec.getPage().data, end, dlen - rec.offset);
                rec.getPage().len = dlen + 2 + 2 + value.length;
                rec.getPage().getPageHeader().setDataLength(rec.getPage().len);
            } else {
                rec = this.splitDataPage(transaction, doc, rec);
                if (rec.offset + 2 + 2 + value.length > this.fileHeader.getWorkSize() || !rec.getPage().getPageHeader().hasRoom()) {
                    AbstractLoggable loggable;
                    DOMPage newPage = new DOMPage();
                    nph = newPage.getPageHeader();
                    LOG.debug((Object)("creating additional page: " + newPage.getPageNum() + "; prev = " + rec.getPage().getPageNum() + "; next = " + rec.getPage().getPageHeader().getNextDataPage()));
                    if (this.isTransactional && transaction != null) {
                        loggable = new CreatePageLoggable(transaction, rec.getPage().getPageNum(), newPage.getPageNum(), rec.getPage().getPageHeader().getNextDataPage());
                        this.writeToLog(loggable, newPage.page);
                    }
                    nph.setNextDataPage(rec.getPage().getPageHeader().getNextDataPage());
                    nph.setPrevDataPage(rec.getPage().getPageNum());
                    if (this.isTransactional && transaction != null) {
                        loggable = new UpdateHeaderLoggable(transaction, rec.getPage().getPageHeader().getPrevDataPage(), rec.getPage().getPageNum(), newPage.getPageNum(), rec.getPage().getPageHeader().getPrevDataPage(), rec.getPage().getPageHeader().getNextDataPage());
                        this.writeToLog(loggable, rec.getPage().page);
                    }
                    rec.getPage().getPageHeader().setNextDataPage(newPage.getPageNum());
                    if (nph.getNextDataPage() != -1L) {
                        DOMPage nextPage = this.getCurrentPage(nph.getNextDataPage());
                        DOMFilePageHeader nextph = nextPage.getPageHeader();
                        if (this.isTransactional && transaction != null) {
                            UpdateHeaderLoggable loggable2 = new UpdateHeaderLoggable(transaction, newPage.getPageNum(), nextPage.getPageNum(), nextph.getNextDataPage(), nextph.getPrevDataPage(), nextph.getNextDataPage());
                            this.writeToLog(loggable2, nextPage.page);
                        }
                        nextph.setPrevDataPage(newPage.getPageNum());
                        nextPage.setDirty(true);
                        this.dataCache.add(nextPage);
                    }
                    rec.getPage().setDirty(true);
                    this.dataCache.add(rec.getPage());
                    rec.setPage(newPage);
                    rec.offset = 0;
                    rec.getPage().len = 4 + value.length;
                    rec.getPage().getPageHeader().setDataLength(rec.getPage().len);
                } else {
                    rec.getPage().len = rec.offset + 2 + 2 + value.length;
                    rec.getPage().getPageHeader().setDataLength(rec.getPage().len);
                }
            }
        } else if (dlen + 2 + 2 + value.length > this.fileHeader.getWorkSize() || !rec.getPage().getPageHeader().hasRoom()) {
            DOMPage newPage = new DOMPage();
            nph = newPage.getPageHeader();
            LOG.debug((Object)("creating new page: " + newPage.getPageNum()));
            if (this.isTransactional && transaction != null) {
                CreatePageLoggable loggable = new CreatePageLoggable(transaction, rec.getPage().getPageNum(), newPage.getPageNum(), rec.getPage().getPageHeader().getNextDataPage());
                this.writeToLog(loggable, newPage.page);
            }
            long nextPageNr = rec.getPage().getPageHeader().getNextDataPage();
            nph.setNextDataPage(nextPageNr);
            nph.setPrevDataPage(rec.getPage().getPageNum());
            if (this.isTransactional && transaction != null) {
                DOMFilePageHeader ph = rec.getPage().getPageHeader();
                UpdateHeaderLoggable loggable = new UpdateHeaderLoggable(transaction, ph.getPrevDataPage(), rec.getPage().getPageNum(), newPage.getPageNum(), ph.getPrevDataPage(), ph.getNextDataPage());
                this.writeToLog(loggable, rec.getPage().page);
            }
            rec.getPage().getPageHeader().setNextDataPage(newPage.getPageNum());
            if (-1L != nextPageNr) {
                DOMPage nextPage = this.getCurrentPage(nextPageNr);
                DOMFilePageHeader nextph = nextPage.getPageHeader();
                if (this.isTransactional && transaction != null) {
                    UpdateHeaderLoggable loggable = new UpdateHeaderLoggable(transaction, newPage.getPageNum(), nextPage.getPageNum(), nextph.getNextDataPage(), nextph.getPrevDataPage(), nextph.getNextDataPage());
                    this.writeToLog(loggable, nextPage.page);
                }
                nextph.setPrevDataPage(newPage.getPageNum());
                nextPage.setDirty(true);
                this.dataCache.add(nextPage);
            }
            rec.getPage().setDirty(true);
            this.dataCache.add(rec.getPage());
            rec.setPage(newPage);
            rec.offset = 0;
            rec.getPage().len = 4 + value.length;
            rec.getPage().getPageHeader().setDataLength(rec.getPage().len);
        } else {
            rec.getPage().len = dlen + 2 + 2 + value.length;
            rec.getPage().getPageHeader().setDataLength(rec.getPage().len);
        }
        short tid = rec.getPage().getPageHeader().getNextTID();
        if (this.isTransactional && transaction != null) {
            InsertValueLoggable loggable = new InsertValueLoggable(transaction, rec.getPage().getPageNum(), isOverflow, tid, value, rec.offset);
            this.writeToLog(loggable, rec.getPage().page);
        }
        ByteConversion.shortToByte(tid, rec.getPage().data, rec.offset);
        rec.offset += 2;
        ByteConversion.shortToByte(isOverflow ? (short)0 : (short)value.length, rec.getPage().data, rec.offset);
        rec.offset += 2;
        System.arraycopy(value, 0, rec.getPage().data, rec.offset, value.length);
        rec.offset += value.length;
        rec.getPage().getPageHeader().incRecordCount();
        if (doc != null && rec.getPage().getPageHeader().getCurrentTID() >= 12286) {
            doc.triggerDefrag();
        }
        rec.getPage().setDirty(true);
        this.dataCache.add(rec.getPage());
        return StorageAddress.createPointer((int)rec.getPage().getPageNum(), tid);
    }

    private RecordPos splitDataPage(Txn transaction, DocumentImpl doc, RecordPos rec) {
        if (this.currentDocument != null) {
            this.currentDocument.getMetadata().incSplitCount();
        }
        boolean requireSplit = false;
        for (int pos = rec.offset; pos < rec.getPage().len; pos += 8) {
            short tid = ByteConversion.byteToShort(rec.getPage().data, pos);
            pos += 2;
            if (ItemId.isLink(tid)) continue;
            requireSplit = true;
            break;
        }
        if (!requireSplit) {
            LOG.debug((Object)("page " + rec.getPage().getPageNum() + ": no split required. Next :" + rec.getPage().getPageHeader().getNextDataPage() + " Previous :" + rec.getPage().getPageHeader().getPrevDataPage()));
            rec.offset = rec.getPage().len;
            return rec;
        }
        DOMFilePageHeader ph = rec.getPage().getPageHeader();
        int oldDataLen = ph.getDataLength();
        byte[] oldData = rec.getPage().data;
        if (this.isTransactional && transaction != null) {
            SplitPageLoggable loggable = new SplitPageLoggable(transaction, rec.getPage().getPageNum(), rec.offset, oldData, oldDataLen);
            this.writeToLog(loggable, rec.getPage().page);
        }
        rec.getPage().data = new byte[this.fileHeader.getWorkSize()];
        System.arraycopy(oldData, 0, rec.getPage().data, 0, rec.offset);
        rec.getPage().len = rec.offset;
        ph.setDataLength(rec.getPage().len);
        rec.getPage().setDirty(true);
        DOMPage firstSplitPage = new DOMPage();
        if (this.isTransactional && transaction != null) {
            CreatePageLoggable loggable = new CreatePageLoggable(transaction, rec.getPage().getPageNum(), firstSplitPage.getPageNum(), -1L, ph.getCurrentTID());
            this.writeToLog(loggable, firstSplitPage.page);
        }
        DOMPage nextSplitPage = firstSplitPage;
        nextSplitPage.getPageHeader().setNextTID(ph.getCurrentTID());
        short splitRecordCount = 0;
        LOG.debug((Object)("splitting " + rec.getPage().getPageNum() + " at " + rec.offset + ": new: " + nextSplitPage.getPageNum() + "; next: " + ph.getNextDataPage()));
        int pos = rec.offset;
        while (pos < oldDataLen) {
            short tid = ByteConversion.byteToShort(oldData, pos);
            pos += 2;
            if (ItemId.isLink(tid)) {
                AbstractLoggable loggable;
                if (rec.getPage().len + 2 + 8 > this.fileHeader.getWorkSize()) {
                    DOMPage newPage = new DOMPage();
                    DOMFilePageHeader newph = newPage.getPageHeader();
                    if (this.isTransactional && transaction != null) {
                        loggable = new CreatePageLoggable(transaction, rec.getPage().getPageNum(), newPage.getPageNum(), ph.getNextDataPage(), ph.getCurrentTID());
                        this.writeToLog(loggable, firstSplitPage.page);
                        loggable = new UpdateHeaderLoggable(transaction, ph.getPrevDataPage(), rec.getPage().getPageNum(), newPage.getPageNum(), ph.getPrevDataPage(), ph.getNextDataPage());
                        this.writeToLog(loggable, nextSplitPage.page);
                    }
                    newph.setNextTID(ph.getCurrentTID());
                    newph.setPrevDataPage(rec.getPage().getPageNum());
                    newph.setNextDataPage(ph.getNextDataPage());
                    LOG.debug((Object)("appending page after split: " + newPage.getPageNum()));
                    ph.setNextDataPage(newPage.getPageNum());
                    ph.setDataLength(rec.getPage().len);
                    ph.setRecordCount(this.countRecordsInPage(rec.getPage()));
                    rec.getPage().cleanUp();
                    rec.getPage().setDirty(true);
                    this.dataCache.add(rec.getPage());
                    rec.setPage(newPage);
                    rec.getPage().len = 0;
                    this.dataCache.add(newPage);
                }
                if (this.isTransactional && transaction != null) {
                    long oldLink = ByteConversion.byteToLong(oldData, pos);
                    loggable = new AddLinkLoggable(transaction, rec.getPage().getPageNum(), ItemId.getId(tid), oldLink);
                    this.writeToLog(loggable, rec.getPage().page);
                }
                ByteConversion.shortToByte(tid, rec.getPage().data, rec.getPage().len);
                rec.getPage().len += 2;
                System.arraycopy(oldData, pos, rec.getPage().data, rec.getPage().len, 8);
                rec.getPage().len += 8;
                pos += 8;
            } else {
                long backLink;
                AbstractLoggable loggable;
                int realLen;
                short vlen = ByteConversion.byteToShort(oldData, pos);
                pos += 2;
                int n = realLen = vlen == 0 ? 8 : (int)vlen;
                if (nextSplitPage.len + 2 + 2 + 8 + realLen > this.fileHeader.getWorkSize()) {
                    DOMPage newPage = new DOMPage();
                    DOMFilePageHeader newph = newPage.getPageHeader();
                    if (this.isTransactional && transaction != null) {
                        loggable = new CreatePageLoggable(transaction, nextSplitPage.getPageNum(), newPage.getPageNum(), -1L, ph.getCurrentTID());
                        this.writeToLog(loggable, firstSplitPage.page);
                        loggable = new UpdateHeaderLoggable(transaction, nextSplitPage.getPageHeader().getPrevDataPage(), nextSplitPage.getPageNum(), newPage.getPageNum(), nextSplitPage.getPageHeader().getPrevDataPage(), nextSplitPage.getPageHeader().getNextDataPage());
                        this.writeToLog(loggable, nextSplitPage.page);
                    }
                    newph.setNextTID(ph.getCurrentTID());
                    newph.setPrevDataPage(nextSplitPage.getPageNum());
                    LOG.debug((Object)("creating new split page: " + newPage.getPageNum()));
                    nextSplitPage.getPageHeader().setNextDataPage(newPage.getPageNum());
                    nextSplitPage.getPageHeader().setDataLength(nextSplitPage.len);
                    nextSplitPage.getPageHeader().setRecordCount(splitRecordCount);
                    nextSplitPage.cleanUp();
                    nextSplitPage.setDirty(true);
                    this.dataCache.add(nextSplitPage);
                    this.dataCache.add(newPage);
                    nextSplitPage = newPage;
                    splitRecordCount = 0;
                }
                if (ItemId.isRelocated(tid)) {
                    backLink = ByteConversion.byteToLong(oldData, pos);
                    pos += 8;
                    RecordPos origRec = this.findRecord(backLink, false);
                    long oldLink = ByteConversion.byteToLong(origRec.getPage().data, origRec.offset);
                    long forwardLink = StorageAddress.createPointer((int)nextSplitPage.getPageNum(), ItemId.getId(tid));
                    if (this.isTransactional && transaction != null) {
                        UpdateLinkLoggable loggable2 = new UpdateLinkLoggable(transaction, origRec.getPage().getPageNum(), origRec.offset, forwardLink, oldLink);
                        this.writeToLog(loggable2, origRec.getPage().page);
                    }
                    ByteConversion.longToByte(forwardLink, origRec.getPage().data, origRec.offset);
                    origRec.getPage().setDirty(true);
                    this.dataCache.add(origRec.getPage());
                } else {
                    backLink = StorageAddress.createPointer((int)rec.getPage().getPageNum(), ItemId.getId(tid));
                }
                if (this.isTransactional && transaction != null) {
                    byte[] logData = new byte[realLen];
                    System.arraycopy(oldData, pos, logData, 0, realLen);
                    AddMovedValueLoggable loggable3 = new AddMovedValueLoggable(transaction, nextSplitPage.getPageNum(), tid, logData, backLink);
                    this.writeToLog(loggable3, nextSplitPage.page);
                }
                ByteConversion.shortToByte(ItemId.setIsRelocated(tid), nextSplitPage.data, nextSplitPage.len);
                nextSplitPage.len += 2;
                ByteConversion.shortToByte(vlen, nextSplitPage.data, nextSplitPage.len);
                nextSplitPage.len += 2;
                ByteConversion.longToByte(backLink, nextSplitPage.data, nextSplitPage.len);
                nextSplitPage.len += 8;
                try {
                    System.arraycopy(oldData, pos, nextSplitPage.data, nextSplitPage.len, realLen);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    SanityCheck.TRACE("pos = " + pos + "; len = " + nextSplitPage.len + "; currentLen = " + realLen + "; tid = " + tid + "; page = " + rec.getPage().getPageNum());
                    throw e;
                }
                nextSplitPage.len += realLen;
                pos += realLen;
                if (!ItemId.isRelocated(tid)) {
                    if (rec.getPage().len + 2 + 8 > this.fileHeader.getWorkSize()) {
                        DOMPage newPage = new DOMPage();
                        DOMFilePageHeader newph = newPage.getPageHeader();
                        if (this.isTransactional && transaction != null) {
                            loggable = new CreatePageLoggable(transaction, rec.getPage().getPageNum(), newPage.getPageNum(), ph.getNextDataPage(), ph.getCurrentTID());
                            this.writeToLog(loggable, firstSplitPage.page);
                            loggable = new UpdateHeaderLoggable(transaction, ph.getPrevDataPage(), rec.getPage().getPageNum(), newPage.getPageNum(), ph.getPrevDataPage(), ph.getNextDataPage());
                            this.writeToLog(loggable, nextSplitPage.page);
                        }
                        newph.setNextTID(ph.getCurrentTID());
                        newph.setPrevDataPage(rec.getPage().getPageNum());
                        newph.setNextDataPage(ph.getNextDataPage());
                        LOG.debug((Object)("creating new page after split: " + newPage.getPageNum()));
                        ph.setNextDataPage(newPage.getPageNum());
                        ph.setDataLength(rec.getPage().len);
                        ph.setRecordCount(this.countRecordsInPage(rec.getPage()));
                        rec.getPage().cleanUp();
                        rec.getPage().setDirty(true);
                        this.dataCache.add(rec.getPage());
                        rec.setPage(newPage);
                        rec.getPage().len = 0;
                        this.dataCache.add(newPage);
                    }
                    long forwardLink = StorageAddress.createPointer((int)nextSplitPage.getPageNum(), ItemId.getId(tid));
                    if (this.isTransactional && transaction != null) {
                        loggable = new AddLinkLoggable(transaction, rec.getPage().getPageNum(), tid, forwardLink);
                        this.writeToLog(loggable, rec.getPage().page);
                    }
                    ByteConversion.shortToByte(ItemId.setIsLink(tid), rec.getPage().data, rec.getPage().len);
                    rec.getPage().len += 2;
                    ByteConversion.longToByte(forwardLink, rec.getPage().data, rec.getPage().len);
                    rec.getPage().len += 8;
                }
            }
            splitRecordCount = (short)(splitRecordCount + 1);
        }
        if (nextSplitPage.len == 0) {
            LOG.warn((Object)("page " + nextSplitPage.getPageNum() + " is empty. Remove it"));
            if (nextSplitPage == firstSplitPage) {
                firstSplitPage = null;
            }
            try {
                this.unlinkPages(nextSplitPage.page);
            }
            catch (IOException e) {
                LOG.warn((Object)("Failed to remove empty split page: " + e.getMessage()), (Throwable)e);
            }
            nextSplitPage.setDirty(true);
            this.dataCache.remove(nextSplitPage);
            nextSplitPage = null;
        } else {
            if (this.isTransactional && transaction != null) {
                UpdateHeaderLoggable loggable = new UpdateHeaderLoggable(transaction, nextSplitPage.getPageHeader().getPrevDataPage(), nextSplitPage.getPageNum(), ph.getNextDataPage(), nextSplitPage.getPageHeader().getPrevDataPage(), nextSplitPage.getPageHeader().getNextDataPage());
                this.writeToLog(loggable, nextSplitPage.page);
            }
            nextSplitPage.getPageHeader().setDataLength(nextSplitPage.len);
            nextSplitPage.getPageHeader().setNextDataPage(ph.getNextDataPage());
            nextSplitPage.getPageHeader().setRecordCount(splitRecordCount);
            nextSplitPage.cleanUp();
            nextSplitPage.setDirty(true);
            this.dataCache.add(nextSplitPage);
            if (this.isTransactional && transaction != null) {
                DOMFilePageHeader ph1 = firstSplitPage.getPageHeader();
                UpdateHeaderLoggable loggable = new UpdateHeaderLoggable(transaction, rec.getPage().getPageNum(), firstSplitPage.getPageNum(), ph1.getNextDataPage(), ph1.getPrevDataPage(), ph1.getNextDataPage());
                this.writeToLog(loggable, nextSplitPage.page);
            }
            firstSplitPage.getPageHeader().setPrevDataPage(rec.getPage().getPageNum());
            if (nextSplitPage != firstSplitPage) {
                firstSplitPage.setDirty(true);
                this.dataCache.add(firstSplitPage);
            }
        }
        long nextPageNr = ph.getNextDataPage();
        if (-1L != nextPageNr) {
            DOMPage nextPage = this.getCurrentPage(nextPageNr);
            if (this.isTransactional && transaction != null) {
                UpdateHeaderLoggable loggable = new UpdateHeaderLoggable(transaction, nextSplitPage.getPageNum(), nextPage.getPageNum(), -1L, nextPage.getPageHeader().getPrevDataPage(), nextPage.getPageHeader().getNextDataPage());
                this.writeToLog(loggable, nextPage.page);
            }
            nextPage.getPageHeader().setPrevDataPage(nextSplitPage.getPageNum());
            nextPage.setDirty(true);
            this.dataCache.add(nextPage);
        }
        rec.setPage(this.getCurrentPage(rec.getPage().getPageNum()));
        if (firstSplitPage != null) {
            if (this.isTransactional && transaction != null) {
                UpdateHeaderLoggable loggable = new UpdateHeaderLoggable(transaction, ph.getPrevDataPage(), rec.getPage().getPageNum(), firstSplitPage.getPageNum(), ph.getPrevDataPage(), ph.getNextDataPage());
                this.writeToLog(loggable, rec.getPage().page);
            }
            ph.setNextDataPage(firstSplitPage.getPageNum());
        }
        ph.setDataLength(rec.getPage().len);
        ph.setRecordCount(this.countRecordsInPage(rec.getPage()));
        rec.getPage().cleanUp();
        rec.offset = rec.getPage().len;
        return rec;
    }

    private short countRecordsInPage(DOMPage page) {
        short count = 0;
        int dlen = page.getPageHeader().getDataLength();
        int pos = 0;
        while (pos < dlen) {
            short tid = ByteConversion.byteToShort(page.data, pos);
            pos += 2;
            if (ItemId.isLink(tid)) {
                pos += 8;
            } else {
                short vlen = ByteConversion.byteToShort(page.data, pos);
                pos += 2;
                pos = ItemId.isRelocated(tid) ? (pos += vlen == 0 ? 16 : 8 + vlen) : (pos += vlen == 0 ? 8 : (int)vlen);
            }
            count = (short)(count + 1);
        }
        return count;
    }

    public String debugPageContents(DOMPage page) {
        StringBuffer buf = new StringBuffer();
        buf.append("Page " + page.getPageNum() + ": ");
        int count = 0;
        int dlen = page.getPageHeader().getDataLength();
        int pos = 0;
        while (pos < dlen) {
            buf.append(pos + "/");
            short tid = ByteConversion.byteToShort(page.data, pos);
            pos += 2;
            buf.append(ItemId.getId(tid));
            if (ItemId.isLink(tid)) {
                buf.append("L");
            } else if (ItemId.isRelocated(tid)) {
                buf.append("R");
            }
            if (ItemId.isLink(tid)) {
                long forwardLink = ByteConversion.byteToLong(page.data, pos);
                buf.append(':').append(forwardLink).append(" ");
                pos += 8;
            } else {
                short vlen = ByteConversion.byteToShort(page.data, pos);
                pos += 2;
                if (vlen < 0) {
                    LOG.warn((Object)("Illegal length: " + vlen));
                    return buf.append("[illegal length : " + vlen + "] ").toString();
                }
                if (ItemId.isRelocated(tid)) {
                    pos += 8;
                } else {
                    buf.append("[");
                    switch (Signatures.getType(page.data[pos])) {
                        case 1: {
                            buf.append("element");
                            int readOffset = pos;
                            int children = ByteConversion.byteToInt(page.data, ++readOffset);
                            short dlnLen = ByteConversion.byteToShort(page.data, readOffset += 4);
                            readOffset += 2;
                            if (this.owner == null) {
                                buf.append("(can't read data, owner is null)");
                            } else {
                                try {
                                    NodeId nodeId = ((NativeBroker)this.owner).getBrokerPool().getNodeFactory().createFromData(dlnLen, page.data, readOffset);
                                    buf.append("(" + nodeId.toString() + ")");
                                    short attributes = ByteConversion.byteToShort(page.data, readOffset += nodeId.size());
                                    buf.append(" children : " + children);
                                    buf.append(" attributes : " + attributes);
                                }
                                catch (Exception e) {
                                    buf.append("(unable to read the node ID at : " + readOffset);
                                    buf.append(" children : " + children);
                                    buf.append(" attributes : unknown");
                                }
                            }
                            buf.append("] ");
                            break;
                        }
                        case 3: 
                        case 4: {
                            if (Signatures.getType(page.data[pos]) == 3) {
                                buf.append("text");
                            } else {
                                buf.append("CDATA");
                            }
                            int readOffset = pos;
                            short dlnLen = ByteConversion.byteToShort(page.data, ++readOffset);
                            readOffset += 2;
                            if (this.owner == null) {
                                buf.append("(can't read data, owner is null)");
                            } else {
                                try {
                                    String value;
                                    NodeId nodeId = ((NativeBroker)this.owner).getBrokerPool().getNodeFactory().createFromData(dlnLen, page.data, readOffset);
                                    buf.append("(" + nodeId.toString() + ")");
                                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                                    os.write(page.data, readOffset += nodeId.size(), vlen - (readOffset - pos));
                                    try {
                                        value = new String(os.toByteArray(), "UTF-8");
                                        if (value.length() > 15) {
                                            value = value.substring(0, 8) + "..." + value.substring(value.length() - 8);
                                        }
                                    }
                                    catch (UnsupportedEncodingException e) {
                                        value = "can't decode value string";
                                    }
                                    buf.append(":'" + value + "'");
                                }
                                catch (Exception e) {
                                    buf.append("(unable to read the node ID at : " + readOffset);
                                }
                            }
                            buf.append("] ");
                            break;
                        }
                        case 2: {
                            buf.append("attribute");
                            int readOffset = pos;
                            byte idSizeType = (byte)(page.data[readOffset] & 3);
                            boolean hasNamespace = (page.data[readOffset] & 0x10) == 16;
                            short dlnLen = ByteConversion.byteToShort(page.data, ++readOffset);
                            readOffset += 2;
                            if (this.owner == null) {
                                buf.append("(can't read data, owner is null)");
                            } else {
                                try {
                                    String value;
                                    NodeId nodeId = ((NativeBroker)this.owner).getBrokerPool().getNodeFactory().createFromData(dlnLen, page.data, readOffset);
                                    readOffset += nodeId.size();
                                    buf.append("(" + nodeId.toString() + ")");
                                    readOffset += Signatures.getLength(idSizeType);
                                    if (hasNamespace) {
                                        short NSId = ByteConversion.byteToShort(page.data, readOffset);
                                        short prefixLen = ByteConversion.byteToShort(page.data, readOffset += 2);
                                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                                        os.write(page.data, readOffset += 2 + prefixLen, vlen - (readOffset - prefixLen));
                                        String prefix = "";
                                        try {
                                            prefix = new String(os.toByteArray(), "UTF-8");
                                        }
                                        catch (UnsupportedEncodingException e) {
                                            LOG.error((Object)"can't decode prefix string");
                                        }
                                        String NsURI = ((NativeBroker)this.owner).getSymbols().getNamespace(NSId);
                                        buf.append(prefix + "{" + NsURI + "}");
                                    }
                                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                                    os.write(page.data, readOffset, vlen - (readOffset - pos));
                                    try {
                                        value = new String(os.toByteArray(), "UTF-8");
                                        if (value.length() > 15) {
                                            value = value.substring(0, 8) + "..." + value.substring(value.length() - 8);
                                        }
                                    }
                                    catch (UnsupportedEncodingException e) {
                                        value = "can't decode value string";
                                    }
                                    buf.append(":'" + value + "'");
                                }
                                catch (Exception e) {
                                    buf.append("(unable to read the node ID at : " + readOffset);
                                }
                            }
                            buf.append("] ");
                            break;
                        }
                        default: {
                            buf.append("Unknown node type !").append("]");
                        }
                    }
                }
                pos += vlen;
            }
            count = (short)(count + 1);
        }
        buf.append("; records in page: " + count + " (header says " + page.getPageHeader().getRecordCount() + ")");
        buf.append("; nextTID: " + page.getPageHeader().getCurrentTID());
        buf.append("; length: " + page.getPageHeader().getDataLength());
        for (int i = page.data.length; i > 0; --i) {
            if (page.data[i - 1] == 0) continue;
            buf.append(" (last non-zero byte: " + i + ")");
            break;
        }
        return buf.toString();
    }

    public boolean close() throws DBException {
        if (!this.isReadOnly()) {
            this.flush();
        }
        super.close();
        return true;
    }

    public void closeAndRemove() {
        if (!this.lock.isLockedForWrite()) {
            LOG.warn((Object)"the file doesn't own a write lock");
        }
        super.closeAndRemove();
        this.cacheManager.deregisterCache(this.dataCache);
    }

    public boolean create() throws DBException {
        return super.create((short)-1);
    }

    public Paged.FileHeader createFileHeader() {
        return new BTree.BTreeFileHeader(1024L, PAGE_SIZE);
    }

    protected void unlinkPages(Paged.Page page) throws IOException {
        super.unlinkPages(page);
    }

    public Paged.PageHeader createPageHeader() {
        return new DOMFilePageHeader();
    }

    public ArrayList findKeys(IndexQuery query) throws IOException, BTreeException {
        if (!this.lock.hasLock()) {
            LOG.warn((Object)"the file doesn't own a lock");
        }
        FindCallback cb = new FindCallback(1);
        try {
            this.query(query, cb);
        }
        catch (TerminatedException e) {
            LOG.warn((Object)"Method terminated");
        }
        return cb.getValues();
    }

    protected long findValue(Object lockObject, NodeProxy node) throws IOException, BTreeException {
        DocumentImpl doc;
        NativeBroker.NodeRef nodeRef;
        long p;
        if (!this.lock.hasLock()) {
            LOG.warn((Object)"the file doesn't own a lock");
        }
        if ((p = this.findValue(nodeRef = new NativeBroker.NodeRef((doc = node.getDocument()).getDocId(), node.getNodeId()))) == -1L) {
            NodeId id = node.getNodeId();
            long parentPointer = -1L;
            do {
                if ((id = id.getParentId()) == NodeId.DOCUMENT_NODE) {
                    SanityCheck.TRACE("Node " + node.getDocument().getDocId() + ":" + node.getNodeId() + " not found.");
                    throw new BTreeException("node " + node.getNodeId() + " not found.");
                }
                NativeBroker.NodeRef parentRef = new NativeBroker.NodeRef(doc.getDocId(), id);
                try {
                    parentPointer = this.findValue(parentRef);
                }
                catch (BTreeException bte) {
                    LOG.info((Object)"report me", (Throwable)bte);
                }
            } while (parentPointer == -1L);
            try {
                NodeProxy parent = new NodeProxy(doc, id, parentPointer);
                EmbeddedXMLStreamReader cursor = doc.getBroker().getXMLStreamReader(parent, true);
                while (cursor.hasNext()) {
                    NodeId nextId;
                    int status = cursor.next();
                    if (status == 2 || !(nextId = (NodeId)cursor.getProperty("node-id")).equals(node.getNodeId())) continue;
                    return cursor.getCurrentPosition();
                }
                LOG.warn((Object)("Node " + node.getNodeId() + " could not be found. Giving up."));
                return -1L;
            }
            catch (XMLStreamException e) {
                SanityCheck.TRACE("Node " + node.getDocument().getDocId() + ":" + node.getNodeId() + " not found.");
                throw new BTreeException("node " + node.getNodeId() + " not found.");
            }
        }
        return p;
    }

    public ArrayList findValues(IndexQuery query) throws IOException, BTreeException {
        if (!this.lock.hasLock()) {
            LOG.warn((Object)"the file doesn't own a lock");
        }
        FindCallback cb = new FindCallback(0);
        try {
            this.query(query, cb);
        }
        catch (TerminatedException e) {
            LOG.warn((Object)"Method terminated");
        }
        return cb.getValues();
    }

    public boolean flush() throws DBException {
        boolean flushed = false;
        if (this.isTransactional) {
            this.logManager.flushToLog(true);
        }
        if (!BrokerPool.FORCE_CORRUPTION) {
            flushed |= super.flush();
            flushed |= this.dataCache.flush();
        }
        return flushed;
    }

    public void printStatistics() {
        super.printStatistics();
        NumberFormat nf = NumberFormat.getPercentInstance();
        NumberFormat nf2 = NumberFormat.getInstance();
        StringBuffer buf = new StringBuffer();
        buf.append(this.getFile().getName()).append(" DATA ");
        buf.append("Buffers occupation : ");
        if (this.dataCache.getBuffers() == 0 && this.dataCache.getUsedBuffers() == 0) {
            buf.append("N/A");
        } else {
            buf.append(nf.format((float)this.dataCache.getUsedBuffers() / (float)this.dataCache.getBuffers()));
        }
        buf.append(" (" + nf2.format(this.dataCache.getUsedBuffers()) + " out of " + nf2.format(this.dataCache.getBuffers()) + ")");
        buf.append(" Cache efficiency : ");
        if (this.dataCache.getHits() == 0 && this.dataCache.getFails() == 0) {
            buf.append("N/A");
        } else {
            buf.append(nf.format((float)this.dataCache.getHits() / (float)(this.dataCache.getFails() + this.dataCache.getHits())));
        }
        LOG.info((Object)buf.toString());
    }

    public BufferStats getDataBufferStats() {
        return new BufferStats(this.dataCache.getBuffers(), this.dataCache.getUsedBuffers(), this.dataCache.getHits(), this.dataCache.getFails());
    }

    public Value get(Value key) {
        if (!this.lock.hasLock()) {
            LOG.warn((Object)"the file doesn't own a lock");
        }
        try {
            long p = this.findValue(key);
            if (p == -1L) {
                LOG.warn((Object)("value not found : " + key));
                return null;
            }
            return this.get(p);
        }
        catch (BTreeException bte) {
            LOG.warn((Object)bte);
            return null;
        }
        catch (IOException ioe) {
            LOG.warn((Object)ioe);
            return null;
        }
    }

    public Value get(NodeProxy node) {
        if (!this.lock.hasLock()) {
            LOG.warn((Object)"the file doesn't own a lock");
        }
        try {
            long p = this.findValue(this.owner, node);
            if (p == -1L) {
                LOG.warn((Object)("node value not found : " + node.getNodeId()));
                return null;
            }
            return this.get(p);
        }
        catch (BTreeException bte) {
            LOG.warn((Object)bte);
            return null;
        }
        catch (IOException ioe) {
            LOG.warn((Object)ioe);
            return null;
        }
    }

    public Value get(long p) {
        Value v;
        RecordPos rec;
        if (!this.lock.hasLock()) {
            LOG.warn((Object)"the file doesn't own a lock");
        }
        if ((rec = this.findRecord(p)) == null) {
            SanityCheck.TRACE("object at " + StorageAddress.toString(p) + " not found.");
            return null;
        }
        short vlen = ByteConversion.byteToShort(rec.getPage().data, rec.offset);
        rec.offset += 2;
        if (ItemId.isRelocated(rec.getTID())) {
            rec.offset += 8;
        }
        if (vlen == 0) {
            long pnum = ByteConversion.byteToLong(rec.getPage().data, rec.offset);
            byte[] data = this.getOverflowValue(pnum);
            v = new Value(data);
        } else {
            v = new Value(rec.getPage().data, rec.offset, vlen);
        }
        v.setAddress(p);
        return v;
    }

    protected byte[] getOverflowValue(long pnum) {
        if (!this.lock.hasLock()) {
            LOG.warn((Object)"the file doesn't own a lock");
        }
        try {
            OverflowDOMPage overflow = new OverflowDOMPage(pnum);
            return overflow.read();
        }
        catch (IOException e) {
            LOG.warn((Object)"io error while loading overflow value", (Throwable)e);
            return null;
        }
    }

    public void removeOverflowValue(Txn transaction, long pnum) {
        if (!this.lock.isLockedForWrite()) {
            LOG.warn((Object)"the file doesn't own a write lock");
        }
        try {
            OverflowDOMPage overflow = new OverflowDOMPage(pnum);
            overflow.delete(transaction);
        }
        catch (IOException e) {
            LOG.warn((Object)"io error while removing overflow value", (Throwable)e);
        }
    }

    private final void setCurrentPage(DOMPage page) {
        long pnum = this.pages.get(this.owner);
        if (pnum == page.page.getPageNum()) {
            return;
        }
        this.pages.put(this.owner, page.page.getPageNum());
    }

    private final DOMPage getCurrentPage(Txn transaction) {
        long pnum = this.pages.get(this.owner);
        if (pnum == -1L) {
            DOMPage page = new DOMPage();
            this.pages.put(this.owner, page.page.getPageNum());
            this.dataCache.add(page);
            if (this.isTransactional && transaction != null) {
                CreatePageLoggable loggable = new CreatePageLoggable(transaction, -1L, page.getPageNum(), -1L);
                this.writeToLog(loggable, page.page);
            }
            return page;
        }
        return this.getCurrentPage(pnum);
    }

    protected final DOMPage getCurrentPage(long p) {
        DOMPage page = (DOMPage)this.dataCache.get(p);
        if (page == null) {
            page = new DOMPage(p);
        }
        return page;
    }

    public void closeDocument() {
        if (!this.lock.hasLock()) {
            LOG.warn((Object)"the file doesn't own a lock");
        }
        this.pages.remove(this.owner);
    }

    public boolean open() throws DBException {
        return super.open((short)7);
    }

    public long put(Txn transaction, Value key, byte[] value) throws ReadOnlyException {
        if (!this.lock.hasLock()) {
            LOG.warn((Object)"the file doesn't own a lock");
        }
        long p = this.add(transaction, value);
        try {
            this.addValue(transaction, key, p);
        }
        catch (IOException ioe) {
            LOG.warn((Object)ioe);
            return -1L;
        }
        catch (BTreeException bte) {
            LOG.warn((Object)bte);
            return -1L;
        }
        return p;
    }

    public void remove(Value key) {
        if (!this.lock.isLockedForWrite()) {
            LOG.warn((Object)"the file doesn't own a write lock");
        }
        this.remove(null, key);
    }

    public void remove(Txn transaction, Value key) {
        if (!this.lock.isLockedForWrite()) {
            LOG.warn((Object)"the file doesn't own a write lock");
        }
        try {
            long p = this.findValue(key);
            if (p == -1L) {
                LOG.warn((Object)("value not found : " + key));
                return;
            }
            this.remove(transaction, key, p);
        }
        catch (BTreeException bte) {
            LOG.warn((Object)bte);
        }
        catch (IOException ioe) {
            LOG.warn((Object)ioe);
        }
    }

    private void removeLink(Txn transaction, long p) {
        AbstractLoggable loggable;
        RecordPos rec = this.findRecord(p, false);
        DOMFilePageHeader ph = rec.getPage().getPageHeader();
        if (this.isTransactional && transaction != null) {
            byte[] data = new byte[8];
            System.arraycopy(rec.getPage().data, rec.offset, data, 0, 8);
            loggable = new RemoveValueLoggable(transaction, rec.getPage().getPageNum(), rec.getTID(), rec.offset - 2, data, false, 0L);
            this.writeToLog(loggable, rec.getPage().page);
        }
        int end = rec.offset + 8;
        System.arraycopy(rec.getPage().data, end, rec.getPage().data, rec.offset - 2, rec.getPage().len - end);
        rec.getPage().len -= 10;
        if (rec.getPage().len < 0) {
            LOG.warn((Object)"page length < 0");
        }
        ph.setDataLength(rec.getPage().len);
        ph.decRecordCount();
        if (rec.getPage().len == 0) {
            if (ph.getRecordCount() > 0) {
                LOG.warn((Object)"empty page seems to have record !");
            }
            if (this.isTransactional && transaction != null) {
                loggable = new RemoveEmptyPageLoggable(transaction, rec.getPage().getPageNum(), ph.getPrevDataPage(), ph.getNextDataPage());
                this.writeToLog(loggable, rec.getPage().page);
            }
            this.removePage(rec.getPage());
            rec.setPage(null);
        } else {
            rec.getPage().setDirty(true);
            this.dataCache.add(rec.getPage());
        }
    }

    public void removeNode(long p) {
        if (!this.lock.isLockedForWrite()) {
            LOG.warn((Object)"the file doesn't own a write lock");
        }
        this.removeNode(null, p);
    }

    public void removeNode(Txn transaction, long p) {
        if (!this.lock.isLockedForWrite()) {
            LOG.warn((Object)"the file doesn't own a write lock");
        }
        RecordPos rec = this.findRecord(p);
        int startOffset = rec.offset - 2;
        DOMFilePageHeader ph = rec.getPage().getPageHeader();
        short vlen = ByteConversion.byteToShort(rec.getPage().data, rec.offset);
        rec.offset += 2;
        short realLen = vlen;
        if (ItemId.isLink(rec.getTID())) {
            throw new RuntimeException("Cannot remove link ...");
        }
        boolean isOverflow = false;
        long backLink = 0L;
        if (ItemId.isRelocated(rec.getTID())) {
            backLink = ByteConversion.byteToLong(rec.getPage().data, rec.offset);
            rec.offset += 8;
            realLen = (short)(realLen + 8);
            this.removeLink(transaction, backLink);
        }
        if (vlen == 0) {
            isOverflow = true;
            long overflowLink = ByteConversion.byteToLong(rec.getPage().data, rec.offset);
            rec.offset += 8;
            try {
                OverflowDOMPage overflow = new OverflowDOMPage(overflowLink);
                overflow.delete(transaction);
            }
            catch (IOException e) {
                LOG.warn((Object)"io error while removing overflow page", (Throwable)e);
            }
            realLen = (short)(realLen + 8);
        }
        if (this.isTransactional && transaction != null) {
            byte[] data = new byte[vlen == 0 ? 8 : (int)vlen];
            System.arraycopy(rec.getPage().data, rec.offset, data, 0, vlen == 0 ? 8 : (int)vlen);
            RemoveValueLoggable loggable = new RemoveValueLoggable(transaction, rec.getPage().getPageNum(), rec.getTID(), startOffset, data, isOverflow, backLink);
            this.writeToLog(loggable, rec.getPage().page);
        }
        int dlen = ph.getDataLength();
        int end = startOffset + 2 + 2 + realLen;
        System.arraycopy(rec.getPage().data, end, rec.getPage().data, startOffset, dlen - end);
        rec.getPage().setDirty(true);
        rec.getPage().len = dlen - (4 + realLen);
        if (rec.getPage().len < 0) {
            LOG.warn((Object)"page length < 0");
        }
        rec.getPage().setDirty(true);
        ph.setDataLength(rec.getPage().len);
        ph.decRecordCount();
        if (rec.getPage().len == 0) {
            LOG.debug((Object)("removing page " + rec.getPage().getPageNum()));
            if (ph.getRecordCount() > 0) {
                LOG.warn((Object)"empty page seems to have record !");
            }
            if (this.isTransactional && transaction != null) {
                RemoveEmptyPageLoggable loggable = new RemoveEmptyPageLoggable(transaction, rec.getPage().getPageNum(), rec.getPage().ph.getPrevDataPage(), rec.getPage().ph.getNextDataPage());
                this.writeToLog(loggable, rec.getPage().page);
            }
            this.removePage(rec.getPage());
            rec.setPage(null);
        } else {
            rec.getPage().setDirty(true);
            this.dataCache.add(rec.getPage());
        }
    }

    public void remove(Value key, long p) {
        this.remove(null, key, p);
    }

    public void remove(Txn transaction, Value key, long p) {
        this.removeNode(transaction, p);
        try {
            this.removeValue(transaction, key);
        }
        catch (BTreeException e) {
            LOG.warn((Object)"btree error while removing node", (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn((Object)"io error while removing node", (Throwable)e);
        }
    }

    private void removePage(DOMPage page) {
        DOMFilePageHeader ph;
        if (!this.lock.isLockedForWrite()) {
            LOG.warn((Object)"the file doesn't own a write lock");
        }
        if ((ph = page.getPageHeader()).getNextDataPage() != -1L) {
            DOMPage next = this.getCurrentPage(ph.getNextDataPage());
            next.getPageHeader().setPrevDataPage(ph.getPrevDataPage());
            next.setDirty(true);
            this.dataCache.add(next);
        }
        if (ph.getPrevDataPage() != -1L) {
            DOMPage prev = this.getCurrentPage(ph.getPrevDataPage());
            prev.getPageHeader().setNextDataPage(ph.getNextDataPage());
            prev.setDirty(true);
            this.dataCache.add(prev);
        }
        try {
            ph.setNextDataPage(-1L);
            ph.setPrevDataPage(-1L);
            ph.setDataLength(0);
            ph.setNextTID((short)-1);
            ph.setRecordCount((short)0);
            this.unlinkPages(page.page);
            page.setDirty(true);
            this.dataCache.remove(page);
        }
        catch (IOException ioe) {
            LOG.warn((Object)ioe);
        }
        if (this.currentDocument != null) {
            this.currentDocument.getMetadata().decPageCount();
        }
    }

    public void removeAll(Txn transaction, long p) {
        long pnum;
        if (!this.lock.isLockedForWrite()) {
            LOG.warn((Object)"the file doesn't own a write lock");
        }
        if (-1L == (pnum = (long)StorageAddress.pageFromPointer(p))) {
            LOG.warn((Object)("tried to remove unknown page. p = " + pnum));
        }
        while (-1L != pnum) {
            DOMPage page = this.getCurrentPage(pnum);
            DOMFilePageHeader ph = page.getPageHeader();
            if (this.isTransactional && transaction != null) {
                RemovePageLoggable loggable = new RemovePageLoggable(transaction, pnum, ph.getPrevDataPage(), ph.getNextDataPage(), page.data, page.len, ph.getCurrentTID(), ph.getRecordCount());
                this.writeToLog(loggable, page.page);
            }
            pnum = ph.getNextDataPage();
            try {
                ph.setNextDataPage(-1L);
                ph.setPrevDataPage(-1L);
                ph.setDataLength(0);
                ph.setNextTID((short)-1);
                ph.setRecordCount((short)0);
                page.len = 0;
                this.unlinkPages(page.page);
                page.setDirty(true);
                this.dataCache.remove(page);
            }
            catch (IOException e) {
                LOG.warn((Object)("Error while removing page: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public String debugPages(DocumentImpl doc, boolean showPageContents) {
        StringBuffer buf = new StringBuffer();
        buf.append("Pages used by ").append(doc.getURI());
        buf.append("; docId ").append(doc.getDocId()).append(':');
        long pnum = StorageAddress.pageFromPointer(((StoredNode)doc.getFirstChild()).getInternalAddress());
        while (-1L != pnum) {
            DOMPage page = this.getCurrentPage(pnum);
            DOMFilePageHeader ph = page.getPageHeader();
            this.dataCache.add(page);
            buf.append(' ').append(pnum);
            pnum = ph.getNextDataPage();
            if (!showPageContents) continue;
            LOG.debug((Object)this.debugPageContents(page));
        }
        return buf.toString();
    }

    public final Lock getLock() {
        return this.lock;
    }

    public final synchronized void setOwnerObject(Object obj) {
        if (obj == null) {
            LOG.warn((Object)"setOwnerObject(null)");
        }
        this.owner = obj;
    }

    public boolean update(Txn transaction, Value key, byte[] value) throws ReadOnlyException {
        try {
            long p = this.findValue(key);
            if (p == -1L) {
                LOG.warn((Object)("node value not found : " + key));
                return false;
            }
            this.update(transaction, p, value);
        }
        catch (BTreeException bte) {
            LOG.warn((Object)bte);
            bte.printStackTrace();
            return false;
        }
        catch (IOException ioe) {
            LOG.warn((Object)ioe);
            return false;
        }
        return true;
    }

    public void update(Txn transaction, long p, byte[] value) throws ReadOnlyException {
        if (!this.lock.isLockedForWrite()) {
            LOG.warn((Object)"the file doesn't own a write lock");
        }
        RecordPos rec = this.findRecord(p);
        short vlen = ByteConversion.byteToShort(rec.getPage().data, rec.offset);
        rec.offset += 2;
        if (ItemId.isRelocated(rec.getTID())) {
            rec.offset += 8;
        }
        if (value.length < vlen) {
            throw new IllegalStateException("shrinked");
        }
        if (value.length > vlen) {
            throw new IllegalStateException("value too long: expected: " + value.length + "; got: " + vlen);
        }
        if (this.isTransactional && transaction != null) {
            if (ItemId.getId(rec.getTID()) < 0) {
                LOG.warn((Object)"tid < 0");
            }
            UpdateValueLoggable loggable = new UpdateValueLoggable(transaction, rec.getPage().getPageNum(), rec.getTID(), value, rec.getPage().data, rec.offset);
            this.writeToLog(loggable, rec.getPage().page);
        }
        System.arraycopy(value, 0, rec.getPage().data, rec.offset, value.length);
        rec.getPage().setDirty(true);
    }

    public String getNodeValue(StoredNode node, boolean addWhitespace) {
        if (!this.lock.hasLock()) {
            LOG.warn((Object)"the file doesn't own a lock");
        }
        try {
            String value;
            long address = node.getInternalAddress();
            RecordPos rec = null;
            if (address != -1L) {
                rec = this.findRecord(address);
            }
            if (rec == null) {
                address = this.findValue(this, new NodeProxy(node));
                if (address == -1L) {
                    LOG.warn((Object)("node value not found : " + node));
                    return null;
                }
                rec = this.findRecord(address);
                SanityCheck.THROW_ASSERT(rec != null, "Node data could not be found!");
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.getNodeValue((DocumentImpl)node.getOwnerDocument(), os, rec, true, addWhitespace);
            byte[] data = os.toByteArray();
            try {
                value = new String(data, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn((Object)"UTF-8 error while reading node value", (Throwable)e);
                value = new String(data);
            }
            return value;
        }
        catch (BTreeException e) {
            LOG.warn((Object)"btree error while reading node value", (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn((Object)"io error while reading node value", (Throwable)e);
        }
        return null;
    }

    private void getNodeValue(DocumentImpl doc, ByteArrayOutputStream os, RecordPos rec, boolean acceptAttributeValue, boolean addWhitespace) {
        int vlen;
        if (!this.lock.hasLock()) {
            LOG.warn((Object)"the file doesn't own a lock");
        }
        boolean foundNext = false;
        do {
            DOMFilePageHeader ph;
            if (rec.offset > (ph = rec.getPage().getPageHeader()).getDataLength()) {
                long nextPage = ph.getNextDataPage();
                if (nextPage == -1L) {
                    SanityCheck.TRACE("bad link to next page! offset: " + rec.offset + "; len: " + ph.getDataLength() + ": " + rec.getPage().page.getPageInfo());
                    return;
                }
                rec.setPage(this.getCurrentPage(nextPage));
                this.dataCache.add(rec.getPage());
                rec.offset = 2;
            }
            short tid = ByteConversion.byteToShort(rec.getPage().data, rec.offset - 2);
            rec.setTID(tid);
            if (ItemId.isLink(rec.getTID())) {
                rec.offset += 10;
                continue;
            }
            foundNext = true;
        } while (!foundNext);
        int realLen = vlen = ByteConversion.byteToShort(rec.getPage().data, rec.offset);
        rec.offset += 2;
        if (ItemId.isRelocated(rec.getTID())) {
            rec.offset += 8;
        }
        byte[] data = rec.getPage().data;
        int readOffset = rec.offset;
        boolean inOverflow = false;
        if (vlen == 0) {
            long op = ByteConversion.byteToLong(data, rec.offset);
            data = this.getOverflowValue(op);
            rec.offset += 10;
            realLen = data.length;
            readOffset = 0;
            inOverflow = true;
        }
        short type = Signatures.getType(data[readOffset]);
        ++readOffset;
        switch (type) {
            case 1: {
                int children = ByteConversion.byteToInt(data, readOffset);
                short dlnLen = ByteConversion.byteToShort(data, readOffset += 4);
                int nodeIdLen = doc.getBroker().getBrokerPool().getNodeFactory().lengthInBytes(dlnLen, data, readOffset += 2);
                short attributes = ByteConversion.byteToShort(data, readOffset += nodeIdLen);
                rec.offset += realLen + 2;
                boolean extraWhitespace = addWhitespace && children - attributes > 1;
                for (int i = 0; i < children; ++i) {
                    this.getNodeValue(doc, os, rec, false, addWhitespace);
                    if (!extraWhitespace) continue;
                    os.write(32);
                }
                return;
            }
            case 3: 
            case 4: {
                short dlnLen = ByteConversion.byteToShort(data, readOffset);
                int nodeIdLen = doc.getBroker().getBrokerPool().getNodeFactory().lengthInBytes(dlnLen, data, readOffset += 2);
                os.write(data, readOffset += nodeIdLen, realLen - (3 + nodeIdLen));
                break;
            }
            case 2: {
                if (!acceptAttributeValue) break;
                int start = readOffset - 1;
                byte idSizeType = (byte)(data[start] & 3);
                boolean hasNamespace = (data[start] & 0x10) == 16;
                short dlnLen = ByteConversion.byteToShort(data, readOffset);
                int nodeIdLen = doc.getBroker().getBrokerPool().getNodeFactory().lengthInBytes(dlnLen, data, readOffset += 2);
                readOffset += nodeIdLen;
                readOffset += Signatures.getLength(idSizeType);
                if (hasNamespace) {
                    short prefixLen = ByteConversion.byteToShort(data, readOffset += 2);
                    readOffset += 2;
                    readOffset += prefixLen;
                }
                os.write(rec.getPage().data, readOffset, realLen - (readOffset - start));
            }
        }
        if (!inOverflow) {
            rec.offset += realLen + 2;
        }
    }

    protected RecordPos findRecord(long p) {
        return this.findRecord(p, true);
    }

    protected RecordPos findRecord(long p, boolean skipLinks) {
        if (!this.lock.hasLock()) {
            LOG.warn((Object)"the file doesn't own a lock");
        }
        long pageNr = StorageAddress.pageFromPointer(p);
        short tid = StorageAddress.tidFromPointer(p);
        while (pageNr != -1L) {
            DOMPage page = this.getCurrentPage(pageNr);
            this.dataCache.add(page);
            RecordPos rec = page.findRecord(tid);
            if (rec == null) {
                pageNr = page.getPageHeader().getNextDataPage();
                if (pageNr != page.getPageNum()) continue;
                SanityCheck.TRACE("circular link to next page on " + pageNr);
                return null;
            }
            if (rec.isLink()) {
                if (!skipLinks) {
                    return rec;
                }
                long forwardLink = ByteConversion.byteToLong(page.data, rec.offset);
                pageNr = StorageAddress.pageFromPointer(forwardLink);
                tid = StorageAddress.tidFromPointer(forwardLink);
                continue;
            }
            return rec;
        }
        return null;
    }

    private boolean requiresRedo(Loggable loggable, DOMPage page) {
        return loggable.getLsn() > page.getPageHeader().getLsn();
    }

    protected void redoCreatePage(CreatePageLoggable loggable) {
        DOMPage newPage = this.getCurrentPage(loggable.newPage);
        DOMFilePageHeader nph = newPage.getPageHeader();
        if (nph.getLsn() == -1L || this.requiresRedo((Loggable)loggable, newPage)) {
            try {
                this.reuseDeleted(newPage.page);
                nph.setStatus((byte)20);
                nph.setDataLength(0);
                nph.setNextTID((short)-1);
                nph.setRecordCount((short)0);
                newPage.len = 0;
                newPage.data = new byte[this.fileHeader.getWorkSize()];
                nph.setPrevDataPage(-1L);
                if (loggable.nextTID != -1) {
                    nph.setNextTID(loggable.nextTID);
                }
                nph.setLsn(loggable.getLsn());
                newPage.setDirty(true);
                if (loggable.nextPage == -1L) {
                    nph.setNextDataPage(-1L);
                } else {
                    nph.setNextDataPage(loggable.nextPage);
                }
                if (loggable.prevPage == -1L) {
                    nph.setPrevDataPage(-1L);
                } else {
                    nph.setPrevDataPage(loggable.prevPage);
                }
            }
            catch (IOException e) {
                LOG.warn((Object)("Failed to redo " + loggable.dump() + ": " + e.getMessage()), (Throwable)e);
            }
        }
        this.dataCache.add(newPage);
    }

    protected void undoCreatePage(CreatePageLoggable loggable) {
        DOMPage page = this.getCurrentPage(loggable.newPage);
        DOMFilePageHeader ph = page.getPageHeader();
        try {
            ph.setNextDataPage(-1L);
            ph.setPrevDataPage(-1L);
            ph.setDataLength(0);
            ph.setNextTID((short)-1);
            ph.setRecordCount((short)0);
            page.len = 0;
            this.unlinkPages(page.page);
            page.setDirty(true);
            this.dataCache.remove(page);
        }
        catch (IOException e) {
            LOG.warn((Object)("Error while removing page: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void redoAddValue(AddValueLoggable loggable) {
        DOMPage page = this.getCurrentPage(loggable.pageNum);
        DOMFilePageHeader ph = page.getPageHeader();
        if (ph.getLsn() != -1L && this.requiresRedo((Loggable)loggable, page)) {
            try {
                ByteConversion.shortToByte(loggable.tid, page.data, page.len);
                page.len += 2;
                short vlen = (short)loggable.value.length;
                ByteConversion.shortToByte(vlen, page.data, page.len);
                page.len += 2;
                System.arraycopy(loggable.value, 0, page.data, page.len, vlen);
                page.len += vlen;
                ph.incRecordCount();
                ph.setDataLength(page.len);
                page.setDirty(true);
                ph.setNextTID(loggable.tid);
                ph.setLsn(loggable.getLsn());
                this.dataCache.add(page, 2);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOG.warn((Object)("page: " + page.getPageNum() + "; len = " + page.len + "; value = " + loggable.value.length));
                throw e;
            }
        }
    }

    protected void undoAddValue(AddValueLoggable loggable) {
        DOMPage page = this.getCurrentPage(loggable.pageNum);
        DOMFilePageHeader ph = page.getPageHeader();
        RecordPos pos = page.findRecord(ItemId.getId(loggable.tid));
        SanityCheck.ASSERT(pos != null, "Record not found!");
        int startOffset = pos.offset - 2;
        short vlen = ByteConversion.byteToShort(page.data, pos.offset);
        int end = startOffset + 2 + 2 + vlen;
        int dlen = ph.getDataLength();
        System.arraycopy(page.data, end, page.data, startOffset, dlen - end);
        page.len = dlen - (4 + vlen);
        if (page.len < 0) {
            LOG.warn((Object)"page length < 0");
        }
        ph.setDataLength(page.len);
        ph.decRecordCount();
        page.setDirty(true);
    }

    protected void redoUpdateValue(UpdateValueLoggable loggable) {
        DOMPage page = this.getCurrentPage(loggable.pageNum);
        DOMFilePageHeader ph = page.getPageHeader();
        if (ph.getLsn() != -1L && this.requiresRedo((Loggable)loggable, page)) {
            RecordPos rec = page.findRecord(ItemId.getId(loggable.tid));
            SanityCheck.THROW_ASSERT(rec != null, "tid " + ItemId.getId(loggable.tid) + " not found on page " + page.getPageNum() + "; contents: " + this.debugPageContents(page));
            ByteConversion.byteToShort(rec.getPage().data, rec.offset);
            rec.offset += 2;
            if (ItemId.isRelocated(rec.getTID())) {
                rec.offset += 8;
            }
            System.arraycopy(loggable.value, 0, rec.getPage().data, rec.offset, loggable.value.length);
            rec.getPage().getPageHeader().setLsn(loggable.getLsn());
            rec.getPage().setDirty(true);
            this.dataCache.add(rec.getPage());
        }
    }

    protected void undoUpdateValue(UpdateValueLoggable loggable) {
        DOMPage page = this.getCurrentPage(loggable.pageNum);
        RecordPos rec = page.findRecord(ItemId.getId(loggable.tid));
        SanityCheck.THROW_ASSERT(rec != null, "tid " + ItemId.getId(loggable.tid) + " not found on page " + page.getPageNum() + "; contents: " + this.debugPageContents(page));
        short vlen = ByteConversion.byteToShort(rec.getPage().data, rec.offset);
        SanityCheck.THROW_ASSERT(vlen == loggable.oldValue.length);
        rec.offset += 2;
        if (ItemId.isRelocated(rec.getTID())) {
            rec.offset += 8;
        }
        System.arraycopy(loggable.oldValue, 0, page.data, rec.offset, loggable.oldValue.length);
        page.getPageHeader().setLsn(loggable.getLsn());
        page.setDirty(true);
        this.dataCache.add(page);
    }

    protected void redoRemoveValue(RemoveValueLoggable loggable) {
        DOMPage page = this.getCurrentPage(loggable.pageNum);
        DOMFilePageHeader ph = page.getPageHeader();
        if (ph.getLsn() != -1L && this.requiresRedo((Loggable)loggable, page)) {
            RecordPos pos = page.findRecord(ItemId.getId(loggable.tid));
            SanityCheck.ASSERT(pos != null, "Record not found: " + ItemId.getId(loggable.tid) + ": " + page.page.getPageInfo() + "\n" + this.debugPageContents(page));
            int startOffset = pos.offset - 2;
            if (ItemId.isLink(loggable.tid)) {
                int end = pos.offset + 8;
                System.arraycopy(page.data, end, page.data, startOffset, page.len - end);
                page.len -= 10;
            } else {
                short l = ByteConversion.byteToShort(page.data, pos.offset);
                if (ItemId.isRelocated(loggable.tid)) {
                    pos.offset += 8;
                    l = (short)(l + 8);
                }
                if (l == 0) {
                    l = (short)(l + 8);
                }
                int end = startOffset + 2 + 2 + l;
                int dlen = ph.getDataLength();
                System.arraycopy(page.data, end, page.data, startOffset, dlen - end);
                page.setDirty(true);
                page.len = dlen - (4 + l);
            }
            if (page.len < 0) {
                LOG.warn((Object)"page length < 0");
            }
            ph.setDataLength(page.len);
            ph.decRecordCount();
            ph.setLsn(loggable.getLsn());
            page.setDirty(true);
            this.dataCache.add(page);
        }
    }

    protected void undoRemoveValue(RemoveValueLoggable loggable) {
        DOMPage page = this.getCurrentPage(loggable.pageNum);
        DOMFilePageHeader ph = page.getPageHeader();
        int offset = loggable.offset;
        short vlen = (short)loggable.oldData.length;
        if (offset < ph.getDataLength()) {
            int required = ItemId.isLink(loggable.tid) ? 10 : 4 + vlen;
            if (ItemId.isRelocated(loggable.tid)) {
                required += 8;
            }
            int end = offset + required;
            try {
                System.arraycopy(page.data, offset, page.data, end, ph.getDataLength() - offset);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOG.warn((Object)e);
                SanityCheck.TRACE("Error while copying data on page " + page.getPageNum() + "; tid: " + ItemId.getId(loggable.tid) + "; required: " + required + "; offset: " + offset + "; end: " + end + "; len: " + (ph.getDataLength() - offset) + "; avail: " + page.data.length + "; work: " + this.fileHeader.getWorkSize());
            }
        }
        ByteConversion.shortToByte(loggable.tid, page.data, offset);
        offset += 2;
        if (ItemId.isLink(loggable.tid)) {
            System.arraycopy(loggable.oldData, 0, page.data, offset, 8);
            page.len += 10;
        } else {
            if (loggable.isOverflow) {
                ByteConversion.shortToByte((short)0, page.data, offset);
            } else {
                ByteConversion.shortToByte(vlen, page.data, offset);
            }
            offset += 2;
            if (ItemId.isRelocated(loggable.tid)) {
                ByteConversion.longToByte(loggable.backLink, page.data, offset);
                offset += 8;
                page.len += 8;
            }
            System.arraycopy(loggable.oldData, 0, page.data, offset, vlen);
            page.len += 4 + vlen;
        }
        ph.incRecordCount();
        ph.setDataLength(page.len);
        page.setDirty(true);
        this.dataCache.add(page, 2);
    }

    protected void redoRemoveEmptyPage(RemoveEmptyPageLoggable loggable) {
        DOMPage page = this.getCurrentPage(loggable.pageNum);
        DOMFilePageHeader ph = page.getPageHeader();
        if (ph.getLsn() != -1L && this.requiresRedo((Loggable)loggable, page)) {
            this.removePage(page);
        }
    }

    protected void undoRemoveEmptyPage(RemoveEmptyPageLoggable loggable) {
        try {
            DOMFilePageHeader oph;
            DOMPage oldPage;
            DOMPage newPage = this.getCurrentPage(loggable.pageNum);
            DOMFilePageHeader nph = newPage.getPageHeader();
            this.reuseDeleted(newPage.page);
            if (loggable.prevPage == -1L) {
                nph.setPrevDataPage(-1L);
            } else {
                oldPage = this.getCurrentPage(loggable.prevPage);
                oph = oldPage.getPageHeader();
                nph.setPrevDataPage(oldPage.getPageNum());
                oph.setNextDataPage(newPage.getPageNum());
                oldPage.setDirty(true);
                this.dataCache.add(oldPage);
            }
            if (loggable.nextPage == -1L) {
                nph.setNextDataPage(-1L);
            } else {
                oldPage = this.getCurrentPage(loggable.nextPage);
                oph = oldPage.getPageHeader();
                oph.setPrevDataPage(newPage.getPageNum());
                nph.setNextDataPage(loggable.nextPage);
                oldPage.setDirty(true);
                this.dataCache.add(oldPage);
            }
            nph.setNextTID((short)-1);
            newPage.setDirty(true);
            this.dataCache.add(newPage);
        }
        catch (IOException e) {
            LOG.warn((Object)("Error during undo: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void redoRemovePage(RemovePageLoggable loggable) {
        DOMPage page = this.getCurrentPage(loggable.pageNum);
        DOMFilePageHeader ph = page.getPageHeader();
        if (ph.getLsn() != -1L && this.requiresRedo((Loggable)loggable, page)) {
            try {
                ph.setNextDataPage(-1L);
                ph.setPrevDataPage(-1L);
                ph.setDataLen(this.fileHeader.getWorkSize());
                ph.setDataLength(0);
                ph.setNextTID((short)-1);
                ph.setRecordCount((short)0);
                page.len = 0;
                this.unlinkPages(page.page);
                page.setDirty(true);
                this.dataCache.remove(page);
            }
            catch (IOException e) {
                LOG.warn((Object)("Error while removing page: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void undoRemovePage(RemovePageLoggable loggable) {
        try {
            DOMPage page = this.getCurrentPage(loggable.pageNum);
            DOMFilePageHeader ph = page.getPageHeader();
            this.reuseDeleted(page.page);
            ph.setStatus((byte)20);
            ph.setNextDataPage(loggable.nextPage);
            ph.setPrevDataPage(loggable.prevPage);
            ph.setNextTID(ItemId.getId(loggable.oldTid));
            ph.setRecordCount(loggable.oldRecCnt);
            ph.setDataLength(loggable.oldLen);
            System.arraycopy(loggable.oldData, 0, page.data, 0, loggable.oldLen);
            page.len = loggable.oldLen;
            page.setDirty(true);
            this.dataCache.add(page);
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to undo " + loggable.dump() + ": " + e.getMessage()), (Throwable)e);
        }
    }

    protected void redoWriteOverflow(WriteOverflowPageLoggable loggable) {
        try {
            Paged.Page page = this.getPage(loggable.pageNum);
            page.read();
            Paged.PageHeader ph = page.getPageHeader();
            this.reuseDeleted(page);
            ph.setStatus((byte)20);
            if (ph.getLsn() != -1L && this.requiresRedo((Loggable)loggable, page)) {
                if (loggable.nextPage == -1L) {
                    ph.setNextPage(-1L);
                } else {
                    ph.setNextPage(loggable.nextPage);
                }
                ph.setLsn(loggable.getLsn());
                this.writeValue(page, loggable.value);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to redo " + loggable.dump() + ": " + e.getMessage()), (Throwable)e);
        }
    }

    protected void undoWriteOverflow(WriteOverflowPageLoggable loggable) {
        try {
            Paged.Page page = this.getPage(loggable.pageNum);
            page.read();
            this.unlinkPages(page);
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to undo " + loggable.dump() + ": " + e.getMessage()), (Throwable)e);
        }
    }

    protected void redoRemoveOverflow(RemoveOverflowLoggable loggable) {
        try {
            Paged.Page page = this.getPage(loggable.pageNum);
            page.read();
            Paged.PageHeader ph = page.getPageHeader();
            if (ph.getLsn() != -1L && this.requiresRedo((Loggable)loggable, page)) {
                this.unlinkPages(page);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to undo " + loggable.dump() + ": " + e.getMessage()), (Throwable)e);
        }
    }

    protected void undoRemoveOverflow(RemoveOverflowLoggable loggable) {
        try {
            Paged.Page page = this.getPage(loggable.pageNum);
            page.read();
            Paged.PageHeader ph = page.getPageHeader();
            this.reuseDeleted(page);
            ph.setStatus((byte)20);
            if (loggable.nextPage == -1L) {
                ph.setNextPage(-1L);
            } else {
                ph.setNextPage(loggable.nextPage);
            }
            this.writeValue(page, loggable.oldData);
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to redo " + loggable.dump() + ": " + e.getMessage()), (Throwable)e);
        }
    }

    protected void redoInsertValue(InsertValueLoggable loggable) {
        DOMPage page = this.getCurrentPage(loggable.pageNum);
        DOMFilePageHeader ph = page.getPageHeader();
        if (ph.getLsn() != -1L && this.requiresRedo((Loggable)loggable, page)) {
            int offset = loggable.offset;
            int dlen = ph.getDataLength();
            if (offset < dlen) {
                int end = offset + 2 + 2 + loggable.value.length;
                try {
                    System.arraycopy(page.data, offset, page.data, end, dlen - offset);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    LOG.warn((Object)e);
                    SanityCheck.TRACE("Error while copying data on page " + page.getPageNum() + "; tid: " + loggable.tid + "; offset: " + offset + "; end: " + end + "; len: " + (dlen - offset));
                }
            }
            ByteConversion.shortToByte(loggable.tid, page.data, offset);
            page.len += 2;
            ByteConversion.shortToByte(loggable.isOverflow() ? (short)0 : (short)loggable.value.length, page.data, offset += 2);
            page.len += 2;
            System.arraycopy(loggable.value, 0, page.data, offset += 2, loggable.value.length);
            offset += loggable.value.length;
            page.len += loggable.value.length;
            ph.incRecordCount();
            ph.setDataLength(page.len);
            ph.setNextTID(ItemId.getId(loggable.tid));
            page.setDirty(true);
            this.dataCache.add(page);
        }
    }

    protected void undoInsertValue(InsertValueLoggable loggable) {
        DOMPage page = this.getCurrentPage(loggable.pageNum);
        DOMFilePageHeader ph = page.getPageHeader();
        if (ItemId.isLink(loggable.tid)) {
            int end = loggable.offset + 8;
            System.arraycopy(page.data, end, page.data, loggable.offset - 2, page.len - end);
            page.len -= 10;
        } else {
            int offset = loggable.offset + 2;
            short l = ByteConversion.byteToShort(page.data, offset);
            if (ItemId.isRelocated(loggable.tid)) {
                l = (short)(l + 8);
            }
            if (l == 0) {
                l = (short)(l + 8);
            }
            int end = loggable.offset + (4 + l);
            int dlen = ph.getDataLength();
            try {
                System.arraycopy(page.data, end, page.data, loggable.offset, dlen - end);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOG.warn((Object)e);
                SanityCheck.TRACE("Error while copying data on page " + page.getPageNum() + "; tid: " + loggable.tid + "; offset: " + loggable.offset + "; end: " + end + "; len: " + (dlen - end) + "; dataLength: " + dlen);
            }
            page.len = dlen - (4 + l);
        }
        if (page.len < 0) {
            LOG.warn((Object)"page length < 0");
        }
        ph.setDataLength(page.len);
        ph.decRecordCount();
        ph.setLsn(loggable.getLsn());
        page.setDirty(true);
        this.dataCache.add(page);
    }

    protected void redoSplitPage(SplitPageLoggable loggable) {
        DOMPage page = this.getCurrentPage(loggable.pageNum);
        DOMFilePageHeader ph = page.getPageHeader();
        if (ph.getLsn() != -1L && this.requiresRedo((Loggable)loggable, page)) {
            byte[] oldData = page.data;
            page.data = new byte[this.fileHeader.getWorkSize()];
            System.arraycopy(oldData, 0, page.data, 0, loggable.splitOffset);
            page.len = loggable.splitOffset;
            if (page.len < 0) {
                LOG.warn((Object)"page length < 0");
            }
            ph.setDataLength(page.len);
            ph.setRecordCount(this.countRecordsInPage(page));
            page.setDirty(true);
            this.dataCache.add(page);
        }
    }

    protected void undoSplitPage(SplitPageLoggable loggable) {
        DOMPage page = this.getCurrentPage(loggable.pageNum);
        DOMFilePageHeader ph = page.getPageHeader();
        page.data = loggable.oldData;
        page.len = loggable.oldLen;
        if (page.len < 0) {
            LOG.warn((Object)"page length < 0");
        }
        ph.setDataLength(page.len);
        ph.setLsn(loggable.getLsn());
        page.setDirty(true);
        this.dataCache.add(page);
    }

    protected void redoAddLink(AddLinkLoggable loggable) {
        DOMPage page = this.getCurrentPage(loggable.pageNum);
        DOMFilePageHeader ph = page.getPageHeader();
        if (ph.getLsn() != -1L && this.requiresRedo((Loggable)loggable, page)) {
            ByteConversion.shortToByte(ItemId.setIsLink(loggable.tid), page.data, page.len);
            page.len += 2;
            ByteConversion.longToByte(loggable.link, page.data, page.len);
            page.len += 8;
            ph.setNextTID(ItemId.getId(loggable.tid));
            ph.setDataLength(page.len);
            ph.setLsn(loggable.getLsn());
            ph.incRecordCount();
            page.setDirty(true);
            this.dataCache.add(page);
        }
    }

    protected void undoAddLink(AddLinkLoggable loggable) {
        DOMPage page = this.getCurrentPage(loggable.pageNum);
        DOMFilePageHeader ph = page.getPageHeader();
        RecordPos rec = page.findRecord(loggable.tid);
        int end = rec.offset + 8;
        System.arraycopy(page.data, end, page.data, rec.offset - 2, page.len - end);
        page.len -= 10;
        if (page.len < 0) {
            LOG.warn((Object)"page length < 0");
        }
        ph.setDataLength(page.len);
        ph.decRecordCount();
        ph.setLsn(loggable.getLsn());
        page.setDirty(true);
        this.dataCache.add(page);
    }

    protected void redoUpdateLink(UpdateLinkLoggable loggable) {
        DOMPage page = this.getCurrentPage(loggable.pageNum);
        DOMFilePageHeader ph = page.getPageHeader();
        if (ph.getLsn() != -1L && this.requiresRedo((Loggable)loggable, page)) {
            ByteConversion.longToByte(loggable.link, page.data, loggable.offset);
            ph.setLsn(loggable.getLsn());
            page.setDirty(true);
            this.dataCache.add(page);
        }
    }

    protected void undoUpdateLink(UpdateLinkLoggable loggable) {
        DOMPage page = this.getCurrentPage(loggable.pageNum);
        DOMFilePageHeader ph = page.getPageHeader();
        ByteConversion.longToByte(loggable.oldLink, page.data, loggable.offset);
        ph.setLsn(loggable.getLsn());
        page.setDirty(true);
        this.dataCache.add(page);
    }

    protected void redoAddMovedValue(AddMovedValueLoggable loggable) {
        DOMPage page = this.getCurrentPage(loggable.pageNum);
        DOMFilePageHeader ph = page.getPageHeader();
        if (ph.getLsn() != -1L && this.requiresRedo((Loggable)loggable, page)) {
            try {
                ByteConversion.shortToByte(ItemId.setIsRelocated(loggable.tid), page.data, page.len);
                page.len += 2;
                short vlen = (short)loggable.value.length;
                ByteConversion.shortToByte(vlen, page.data, page.len);
                page.len += 2;
                ByteConversion.longToByte(loggable.backLink, page.data, page.len);
                page.len += 8;
                System.arraycopy(loggable.value, 0, page.data, page.len, vlen);
                page.len += vlen;
                ph.incRecordCount();
                ph.setDataLength(page.len);
                ph.setNextTID(ItemId.getId(loggable.tid));
                ph.incRecordCount();
                ph.setLsn(loggable.getLsn());
                page.setDirty(true);
                this.dataCache.add(page, 2);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                LOG.warn((Object)("page: " + page.getPageNum() + "; len = " + page.len + "; value = " + loggable.value.length));
                throw e;
            }
        }
    }

    protected void undoAddMovedValue(AddMovedValueLoggable loggable) {
        DOMPage page = this.getCurrentPage(loggable.pageNum);
        DOMFilePageHeader ph = page.getPageHeader();
        RecordPos rec = page.findRecord(ItemId.getId(loggable.tid));
        SanityCheck.ASSERT(rec != null, "Record with tid " + ItemId.getId(loggable.tid) + " not found: " + this.debugPageContents(page));
        short vlen = ByteConversion.byteToShort(page.data, rec.offset);
        int end = rec.offset + 2 + 8 + vlen;
        int dlen = ph.getDataLength();
        try {
            System.arraycopy(page.data, end, page.data, rec.offset - 2, dlen - end);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            LOG.warn((Object)e);
            SanityCheck.TRACE("Error while copying data on page " + page.getPageNum() + "; tid: " + loggable.tid + "; offset: " + (rec.offset - 2) + "; end: " + end + "; len: " + (dlen - end));
        }
        page.len = dlen - (12 + vlen);
        if (page.len < 0) {
            LOG.warn((Object)"page length < 0");
        }
        ph.setDataLength(page.len);
        ph.decRecordCount();
        ph.setLsn(loggable.getLsn());
        page.setDirty(true);
        this.dataCache.add(page);
    }

    protected void redoUpdateHeader(UpdateHeaderLoggable loggable) {
        DOMPage page = this.getCurrentPage(loggable.pageNum);
        DOMFilePageHeader ph = page.getPageHeader();
        if (ph.getLsn() != -1L && this.requiresRedo((Loggable)loggable, page)) {
            if (loggable.nextPage != -1L) {
                ph.setNextDataPage(loggable.nextPage);
            }
            if (loggable.prevPage != -1L) {
                ph.setPrevDataPage(loggable.prevPage);
            }
            ph.setLsn(loggable.getLsn());
            page.setDirty(true);
            this.dataCache.add(page, 2);
        }
    }

    protected void undoUpdateHeader(UpdateHeaderLoggable loggable) {
        DOMPage page = this.getCurrentPage(loggable.pageNum);
        DOMFilePageHeader ph = page.getPageHeader();
        if (loggable.oldPrev != -1L) {
            ph.setPrevDataPage(loggable.oldPrev);
        }
        if (loggable.oldNext != -1L) {
            ph.setNextDataPage(loggable.oldNext);
        }
        ph.setLsn(loggable.getLsn());
        page.setDirty(true);
        this.dataCache.add(page, 2);
    }

    protected void dumpValue(Writer writer, Value key, int status) throws IOException {
        if (status == 2) {
            super.dumpValue(writer, key, status);
            return;
        }
        if (key.getLength() == 0) {
            return;
        }
        writer.write(Integer.toString(ByteConversion.byteToInt(key.data(), key.start())));
        writer.write(58);
        try {
            int bytes = key.getLength() - 4;
            byte[] data = key.data();
            for (int i = 0; i < bytes; ++i) {
                writer.write(DLNBase.toBitString(data[key.start() + 4 + i]));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)e);
            e.printStackTrace();
            System.out.println(e.getMessage() + ": doc: " + Integer.toString(ByteConversion.byteToInt(key.data(), key.start())));
        }
    }

    public final synchronized void addToBuffer(DOMPage page) {
        this.dataCache.add(page);
    }

    static {
        LogEntryTypes.addEntryType((byte)16, CreatePageLoggable.class);
        LogEntryTypes.addEntryType((byte)17, AddValueLoggable.class);
        LogEntryTypes.addEntryType((byte)18, RemoveValueLoggable.class);
        LogEntryTypes.addEntryType((byte)19, RemoveEmptyPageLoggable.class);
        LogEntryTypes.addEntryType((byte)20, UpdateValueLoggable.class);
        LogEntryTypes.addEntryType((byte)21, RemovePageLoggable.class);
        LogEntryTypes.addEntryType((byte)22, WriteOverflowPageLoggable.class);
        LogEntryTypes.addEntryType((byte)23, RemoveOverflowLoggable.class);
        LogEntryTypes.addEntryType((byte)24, InsertValueLoggable.class);
        LogEntryTypes.addEntryType((byte)25, SplitPageLoggable.class);
        LogEntryTypes.addEntryType((byte)26, AddLinkLoggable.class);
        LogEntryTypes.addEntryType((byte)27, AddMovedValueLoggable.class);
        LogEntryTypes.addEntryType((byte)28, UpdateHeaderLoggable.class);
        LogEntryTypes.addEntryType((byte)29, UpdateLinkLoggable.class);
    }

    private final class FindCallback
    implements BTreeCallback {
        public static final int KEYS = 1;
        public static final int VALUES = 0;
        int mode;
        ArrayList values = new ArrayList();

        public FindCallback(int mode) {
            this.mode = mode;
        }

        public ArrayList getValues() {
            return this.values;
        }

        public boolean indexInfo(Value value, long pointer) {
            switch (this.mode) {
                case 0: {
                    RecordPos rec = DOMFile.this.findRecord(pointer);
                    short vlen = ByteConversion.byteToShort(rec.getPage().data, rec.offset);
                    this.values.add(new Value(rec.getPage().data, rec.offset + 2, vlen));
                    return true;
                }
                case 1: {
                    this.values.add(value);
                    return true;
                }
            }
            return false;
        }
    }

    protected final class OverflowDOMPage {
        Paged.Page firstPage = null;

        public OverflowDOMPage(Txn transaction) {
            this.firstPage = this.createNewPage();
            LOG.debug((Object)("Creating overflow page: " + this.firstPage.getPageNum()));
        }

        public OverflowDOMPage(long first) throws IOException {
            this.firstPage = DOMFile.this.getPage(first);
        }

        protected Paged.Page createNewPage() {
            try {
                Paged.Page page = DOMFile.this.getFreePage();
                DOMFilePageHeader ph = (DOMFilePageHeader)page.getPageHeader();
                ph.setStatus((byte)20);
                ph.setDirty(true);
                ph.setNextDataPage(-1L);
                ph.setPrevDataPage(-1L);
                ph.setNextPage(-1L);
                ph.setNextTID((short)-1);
                ph.setDataLength(0);
                ph.setRecordCount((short)0);
                if (DOMFile.this.currentDocument != null) {
                    DOMFile.this.currentDocument.getMetadata().incPageCount();
                }
                return page;
            }
            catch (IOException ioe) {
                LOG.warn((Object)ioe);
                return null;
            }
        }

        public int write(Txn transaction, InputStream is) {
            int pageCount = 0;
            Paged.Page currentPage = this.firstPage;
            try {
                int chunkSize = DOMFile.this.fileHeader.getWorkSize();
                byte[] buf = new byte[chunkSize];
                int len = is.read(buf);
                if (len < 1) {
                    currentPage.setPageNum(-1L);
                    currentPage.getPageHeader().setNextPage(-1L);
                    return -1;
                }
                while (len > -1) {
                    if (len == 0) {
                        LOG.warn((Object)"len == 0");
                    }
                    if (len > 0) {
                        Paged.Page nextPage;
                        Value value = new Value(buf, 0, len);
                        if (len == chunkSize) {
                            nextPage = this.createNewPage();
                            currentPage.getPageHeader().setNextPage(nextPage.getPageNum());
                        } else {
                            nextPage = null;
                            currentPage.getPageHeader().setNextPage(-1L);
                        }
                        if (DOMFile.this.isTransactional && transaction != null) {
                            long nextPageNum = nextPage == null ? -1L : nextPage.getPageNum();
                            WriteOverflowPageLoggable loggable = new WriteOverflowPageLoggable(transaction, currentPage.getPageNum(), nextPageNum, value);
                            DOMFile.this.writeToLog(loggable, currentPage);
                        }
                        DOMFile.this.writeValue(currentPage, value);
                        ++pageCount;
                        currentPage = nextPage;
                    }
                    len = is.read(buf);
                }
            }
            catch (IOException ex) {
                LOG.warn((Object)"io error while writing overflow page", (Throwable)ex);
            }
            return pageCount;
        }

        public int write(Txn transaction, byte[] data) {
            int pageCount = 0;
            try {
                int remaining = data.length;
                Paged.Page currentPage = this.firstPage;
                int pos = 0;
                while (remaining > 0) {
                    Paged.Page nextPage;
                    int chunkSize = remaining > DOMFile.this.fileHeader.getWorkSize() ? DOMFile.this.fileHeader.getWorkSize() : remaining;
                    Value value = new Value(data, pos, chunkSize);
                    if ((remaining -= chunkSize) > 0) {
                        nextPage = this.createNewPage();
                        currentPage.getPageHeader().setNextPage(nextPage.getPageNum());
                    } else {
                        nextPage = null;
                        currentPage.getPageHeader().setNextPage(-1L);
                    }
                    if (DOMFile.this.isTransactional && transaction != null) {
                        WriteOverflowPageLoggable loggable = new WriteOverflowPageLoggable(transaction, currentPage.getPageNum(), remaining > 0 ? nextPage.getPageNum() : -1L, value);
                        DOMFile.this.writeToLog(loggable, currentPage);
                    }
                    DOMFile.this.writeValue(currentPage, value);
                    pos += chunkSize;
                    currentPage = nextPage;
                    ++pageCount;
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"io error while writing overflow page", (Throwable)e);
            }
            return pageCount;
        }

        public byte[] read() {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.streamTo(os);
            return os.toByteArray();
        }

        public void streamTo(OutputStream os) {
            Paged.Page page = this.firstPage;
            int count = 0;
            while (page != null) {
                try {
                    byte[] chunk = page.read();
                    os.write(chunk);
                    long nextPageNumber = page.getPageHeader().getNextPage();
                    page = nextPageNumber == -1L ? null : DOMFile.this.getPage(nextPageNumber);
                }
                catch (IOException e) {
                    LOG.warn((Object)("io error while loading overflow page " + this.firstPage.getPageNum() + "; read: " + count), (Throwable)e);
                    break;
                }
                ++count;
            }
        }

        public void delete(Txn transaction) throws IOException {
            Paged.Page page = this.firstPage;
            while (page != null) {
                LOG.debug((Object)("removing overflow page " + page.getPageNum()));
                long nextPageNumber = page.getPageHeader().getNextPage();
                if (DOMFile.this.isTransactional && transaction != null) {
                    byte[] chunk = page.read();
                    RemoveOverflowLoggable loggable = new RemoveOverflowLoggable(transaction, page.getPageNum(), nextPageNumber, chunk);
                    DOMFile.this.writeToLog(loggable, page);
                }
                DOMFile.this.unlinkPages(page);
                page = nextPageNumber == -1L ? null : DOMFile.this.getPage(nextPageNumber);
            }
        }

        public long getPageNum() {
            return this.firstPage.getPageNum();
        }
    }

    protected final class DOMPage
    implements Cacheable {
        byte[] data;
        int len = 0;
        Paged.Page page;
        DOMFilePageHeader ph;
        int refCount = 0;
        int timestamp = 0;
        boolean saved = true;
        boolean invalidated = false;

        public DOMPage() {
            this.page = this.createNewPage();
            this.ph = (DOMFilePageHeader)this.page.getPageHeader();
            this.data = new byte[DOMFile.this.fileHeader.getWorkSize()];
            this.len = 0;
        }

        public DOMPage(long pos) {
            try {
                this.page = DOMFile.this.getPage(pos);
                this.load(this.page);
            }
            catch (IOException ioe) {
                LOG.warn((Object)ioe);
                ioe.printStackTrace();
            }
        }

        public DOMPage(Paged.Page page) {
            this.page = page;
            this.load(page);
        }

        protected Paged.Page createNewPage() {
            try {
                Paged.Page page = DOMFile.this.getFreePage();
                DOMFilePageHeader ph = (DOMFilePageHeader)page.getPageHeader();
                ph.setStatus((byte)20);
                ph.setDirty(true);
                ph.setNextDataPage(-1L);
                ph.setPrevDataPage(-1L);
                ph.setNextPage(-1L);
                ph.setNextTID((short)-1);
                ph.setDataLength(0);
                ph.setRecordCount((short)0);
                if (DOMFile.this.currentDocument != null) {
                    DOMFile.this.currentDocument.getMetadata().incPageCount();
                }
                return page;
            }
            catch (IOException ioe) {
                LOG.warn((Object)ioe);
                return null;
            }
        }

        public RecordPos findRecord(short targetId) {
            int dlen = this.ph.getDataLength();
            RecordPos rec = null;
            int pos = 0;
            while (pos < dlen) {
                short tid = ByteConversion.byteToShort(this.data, pos);
                pos += 2;
                if (ItemId.matches(tid, targetId)) {
                    if (ItemId.isLink(tid)) {
                        rec = new RecordPos(pos, this, tid, true);
                        break;
                    }
                    rec = new RecordPos(pos, this, tid);
                    break;
                }
                if (ItemId.isLink(tid)) {
                    pos += 8;
                    continue;
                }
                short vlen = ByteConversion.byteToShort(this.data, pos);
                pos += 2;
                if (vlen < 0) {
                    LOG.warn((Object)("page = " + this.page.getPageNum() + "; pos = " + pos + "; vlen = " + vlen + "; tid = " + tid + "; target = " + targetId));
                }
                pos = ItemId.isRelocated(tid) ? (pos += 8 + vlen) : (pos += vlen);
                if (vlen != 0) continue;
                pos += 8;
            }
            return rec;
        }

        public long getKey() {
            return this.page.getPageNum();
        }

        public int getReferenceCount() {
            return this.refCount;
        }

        public int decReferenceCount() {
            return this.refCount > 0 ? (this.refCount = this.refCount - 1) : 0;
        }

        public int incReferenceCount() {
            if (this.refCount < 10000) {
                ++this.refCount;
            }
            return this.refCount;
        }

        public void setReferenceCount(int count) {
            this.refCount = count;
        }

        public void setTimestamp(int timestamp) {
            this.timestamp = timestamp;
        }

        public int getTimestamp() {
            return this.timestamp;
        }

        public DOMFilePageHeader getPageHeader() {
            return this.ph;
        }

        public long getPageNum() {
            return this.page.getPageNum();
        }

        public boolean isDirty() {
            return !this.saved;
        }

        public void setDirty(boolean dirty) {
            this.saved = !dirty;
            this.page.getPageHeader().setDirty(dirty);
        }

        private void load(Paged.Page page) {
            try {
                this.data = page.read();
                this.ph = (DOMFilePageHeader)page.getPageHeader();
                this.len = this.ph.getDataLength();
                if (this.data.length == 0) {
                    this.data = new byte[DOMFile.this.fileHeader.getWorkSize()];
                    this.len = 0;
                    return;
                }
            }
            catch (IOException ioe) {
                LOG.warn((Object)ioe);
                ioe.printStackTrace();
            }
            this.saved = true;
        }

        public void write() {
            if (this.page == null) {
                return;
            }
            try {
                if (!this.ph.isDirty()) {
                    return;
                }
                this.ph.setDataLength(this.len);
                DOMFile.this.writeValue(this.page, this.data);
                this.setDirty(false);
            }
            catch (IOException ioe) {
                LOG.warn((Object)ioe);
            }
        }

        public String dumpPage() {
            return "Contents of page " + this.page.getPageNum() + ": " + Paged.hexDump(this.data);
        }

        public boolean sync(boolean syncJournal) {
            if (this.isDirty()) {
                this.write();
                if (DOMFile.this.isTransactional && syncJournal && DOMFile.this.logManager.lastWrittenLsn() < this.ph.getLsn()) {
                    DOMFile.this.logManager.flushToLog(true);
                }
                return true;
            }
            return false;
        }

        public boolean allowUnload() {
            return true;
        }

        public boolean equals(Object obj) {
            DOMPage other = (DOMPage)obj;
            return this.page.equals(other.page);
        }

        public void invalidate() {
            this.invalidated = true;
        }

        public boolean isInvalidated() {
            return this.invalidated;
        }

        public void cleanUp() {
            int dlen = this.ph.getDataLength();
            short maxTID = 0;
            int recordCount = 0;
            int pos = 0;
            while (pos < dlen) {
                short tid = ByteConversion.byteToShort(this.data, pos);
                pos += 2;
                if (ItemId.getId(tid) > 16382) {
                    LOG.debug((Object)DOMFile.this.debugPageContents(this));
                    throw new RuntimeException("TID overflow in page " + this.getPageNum());
                }
                if (ItemId.getId(tid) > maxTID) {
                    maxTID = ItemId.getId(tid);
                }
                if (ItemId.isLink(tid)) {
                    pos += 8;
                } else {
                    short vlen = ByteConversion.byteToShort(this.data, pos);
                    pos += 2;
                    pos = ItemId.isRelocated(tid) ? (pos += vlen == 0 ? 16 : 8 + vlen) : (pos += vlen == 0 ? 8 : (int)vlen);
                }
                recordCount = (short)(recordCount + 1);
            }
            this.ph.setNextTID(maxTID);
        }
    }

    protected final class DOMFilePageHeader
    extends BTree.BTreePageHeader {
        protected int dataLen;
        protected long nextDataPage;
        protected long prevDataPage;
        protected short tid;
        protected short records;
        public static final short LENGTH_RECORDS_COUNT = 2;
        public static final int LENGTH_DATA_LENGTH = 4;
        public static final long LENGTH_NEXT_PAGE_POINTER = 8L;
        public static final long LENGTH_PREV_PAGE_POINTER = 8L;
        public static final short LENGTH_CURRENT_TID = 2;

        public DOMFilePageHeader() {
            this.dataLen = 0;
            this.nextDataPage = -1L;
            this.prevDataPage = -1L;
            this.tid = (short)-1;
            this.records = 0;
        }

        public DOMFilePageHeader(byte[] data, int offset) throws IOException {
            super(data, offset);
            this.dataLen = 0;
            this.nextDataPage = -1L;
            this.prevDataPage = -1L;
            this.tid = (short)-1;
            this.records = 0;
        }

        public void decRecordCount() {
            this.records = (short)(this.records - 1);
        }

        public short getCurrentTID() {
            return this.tid;
        }

        public short getNextTID() {
            this.tid = (short)(this.tid + 1);
            if (this.tid == 16383) {
                throw new RuntimeException("no spare ids on page");
            }
            return this.tid;
        }

        public boolean hasRoom() {
            return this.tid < 16382;
        }

        public void setNextTID(short tid) {
            if (tid > 16382) {
                throw new RuntimeException("TID overflow! TID = " + tid);
            }
            this.tid = tid;
        }

        public int getDataLength() {
            return this.dataLen;
        }

        public long getNextDataPage() {
            return this.nextDataPage;
        }

        public long getPrevDataPage() {
            return this.prevDataPage;
        }

        public short getRecordCount() {
            return this.records;
        }

        public void incRecordCount() {
            this.records = (short)(this.records + 1);
        }

        public int read(byte[] data, int offset) throws IOException {
            offset = super.read(data, offset);
            this.records = ByteConversion.byteToShort(data, offset);
            this.dataLen = ByteConversion.byteToInt(data, offset += 2);
            this.nextDataPage = ByteConversion.byteToLong(data, offset += 4);
            offset = (int)((long)offset + 8L);
            this.prevDataPage = ByteConversion.byteToLong(data, offset);
            offset = (int)((long)offset + 8L);
            this.tid = ByteConversion.byteToShort(data, offset);
            return offset + 2;
        }

        public int write(byte[] data, int offset) throws IOException {
            offset = super.write(data, offset);
            ByteConversion.shortToByte(this.records, data, offset);
            ByteConversion.intToByte(this.dataLen, data, offset += 2);
            ByteConversion.longToByte(this.nextDataPage, data, offset += 4);
            offset = (int)((long)offset + 8L);
            ByteConversion.longToByte(this.prevDataPage, data, offset);
            offset = (int)((long)offset + 8L);
            ByteConversion.shortToByte(this.tid, data, offset);
            return offset + 2;
        }

        public void setDataLength(int len) {
            if (len > DOMFile.this.fileHeader.getWorkSize()) {
                LOG.warn((Object)"too long !");
            }
            this.dataLen = len;
        }

        public void setNextDataPage(long page) {
            this.nextDataPage = page;
        }

        public void setPrevDataPage(long page) {
            this.prevDataPage = page;
        }

        public void setRecordCount(short recs) {
            this.records = recs;
        }
    }
}

