/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.index;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.index.AbstractBFileLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class OverflowCreateLoggable
extends AbstractBFileLoggable {
    protected long pageNum;

    public OverflowCreateLoggable(byte fileId, Txn transaction, long pageNum) {
        super((byte)54, fileId, transaction);
        this.pageNum = pageNum;
    }

    public OverflowCreateLoggable(DBBroker broker, long transactionId) {
        super(broker, transactionId);
    }

    public void write(ByteBuffer out) {
        super.write(out);
        out.putInt((int)this.pageNum);
    }

    public void read(ByteBuffer in) {
        super.read(in);
        this.pageNum = in.getInt();
    }

    public int getLogSize() {
        return super.getLogSize() + 4;
    }

    public void redo() throws LogException {
        this.getIndexFile().redoCreateOverflow(this);
    }

    public void undo() throws LogException {
        this.getIndexFile().undoCreateOverflow(this);
    }

    public String dump() {
        return super.dump() + " - create new overflow page " + this.pageNum;
    }
}

