/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.index;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.index.AbstractBFileLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class OverflowStoreLoggable
extends AbstractBFileLoggable {
    protected long pageNum;
    protected long prevPage;
    protected byte[] data;
    protected int startOffset;
    protected int size;

    public OverflowStoreLoggable(byte fileId, Txn transaction, long page, long prevPage, byte[] chunk, int startOffset, int chunkSize) {
        super((byte)53, fileId, transaction);
        this.pageNum = page;
        this.data = chunk;
        this.size = chunkSize;
        this.prevPage = prevPage;
        this.startOffset = startOffset;
    }

    public OverflowStoreLoggable(DBBroker broker, long transactionId) {
        super(broker, transactionId);
    }

    public void write(ByteBuffer out) {
        super.write(out);
        out.putInt((int)this.pageNum);
        out.putInt((int)this.prevPage);
        out.putInt(this.size);
        out.put(this.data, this.startOffset, this.size);
    }

    public void read(ByteBuffer in) {
        super.read(in);
        this.pageNum = in.getInt();
        this.prevPage = in.getInt();
        this.size = in.getInt();
        this.data = new byte[this.size];
        in.get(this.data);
    }

    public int getLogSize() {
        return super.getLogSize() + 12 + this.size;
    }

    public void redo() throws LogException {
        this.getIndexFile().redoStoreOverflow(this);
    }

    public String dump() {
        return super.dump() + " - stored overflow page " + this.pageNum;
    }
}

