/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.journal;

import java.io.IOException;
import java.nio.channels.FileChannel;

public class FileSyncThread
extends Thread {
    private FileChannel endOfLog;
    private boolean syncTriggered = false;
    private boolean shutdown = false;
    private Object latch;

    public FileSyncThread(Object latch) {
        this.latch = latch;
    }

    public void setChannel(FileChannel channel) {
        this.endOfLog = channel;
    }

    public synchronized void triggerSync() {
        this.syncTriggered = true;
        this.notifyAll();
    }

    public synchronized void shutdown() {
        this.shutdown = true;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel() {
        Object object = this.latch;
        synchronized (object) {
            try {
                this.endOfLog.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.shutdown) {
            FileSyncThread fileSyncThread = this;
            synchronized (fileSyncThread) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.syncTriggered) {
                    this.sync();
                }
            }
        }
        this.sync();
        this.closeChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync() {
        Object object = this.latch;
        synchronized (object) {
            try {
                this.endOfLog.force(false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.syncTriggered = false;
        }
    }
}

