/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.journal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.log4j.Logger;
import org.exist.storage.DBBroker;
import org.exist.storage.journal.LogEntryTypes;
import org.exist.storage.journal.LogException;
import org.exist.storage.journal.Loggable;
import org.exist.storage.journal.Lsn;

public class JournalReader {
    private static final Logger LOG = Logger.getLogger((Class)JournalReader.class);
    private FileChannel fc;
    private ByteBuffer header = ByteBuffer.allocateDirect(11);
    private ByteBuffer payload = ByteBuffer.allocateDirect(8192);
    private int fileNumber;
    private DBBroker broker;

    public JournalReader(DBBroker broker, File file, int fileNumber) throws LogException {
        this.broker = broker;
        this.fileNumber = fileNumber;
        try {
            FileInputStream is = new FileInputStream(file);
            this.fc = is.getChannel();
        }
        catch (IOException e) {
            throw new LogException("Failed to read log file " + file.getAbsolutePath(), e);
        }
    }

    public Loggable nextEntry() throws LogException {
        try {
            if (this.fc.position() + 13L > this.fc.size()) {
                return null;
            }
            return this.readEntry();
        }
        catch (IOException e) {
            return null;
        }
    }

    public Loggable previousEntry() throws LogException {
        try {
            if (this.fc.position() == 0L) {
                return null;
            }
            this.fc.position(this.fc.position() - 2L);
            this.header.clear().limit(2);
            int bytes = this.fc.read(this.header);
            if (bytes < 2) {
                throw new LogException("Incomplete log entry found!");
            }
            this.header.flip();
            short prevLink = this.header.getShort();
            long prevStart = this.fc.position() - 2L - (long)prevLink;
            this.fc.position(prevStart);
            Loggable loggable = this.readEntry();
            this.fc.position(prevStart);
            return loggable;
        }
        catch (IOException e) {
            throw new LogException("Fatal error while reading journal entry: " + e.getMessage(), e);
        }
    }

    public Loggable lastEntry() throws LogException {
        try {
            this.fc.position(this.fc.size());
            return this.previousEntry();
        }
        catch (IOException e) {
            throw new LogException("Fatal error while reading journal entry: " + e.getMessage(), e);
        }
    }

    private Loggable readEntry() throws LogException {
        try {
            long lsn = Lsn.create(this.fileNumber, (int)this.fc.position() + 1);
            this.header.clear();
            int bytes = this.fc.read(this.header);
            if (bytes <= 0) {
                return null;
            }
            if (bytes < 11) {
                throw new LogException("Incomplete log entry header found: " + bytes);
            }
            this.header.flip();
            byte entryType = this.header.get();
            long transactId = this.header.getLong();
            short size = this.header.getShort();
            if (this.fc.position() + (long)size > this.fc.size()) {
                throw new LogException("Invalid length");
            }
            Loggable loggable = LogEntryTypes.create(entryType, this.broker, transactId);
            if (loggable == null) {
                throw new LogException("Invalid log entry: " + entryType + "; size: " + size + "; id: " + transactId + "; at: " + Lsn.dump(lsn));
            }
            loggable.setLsn(lsn);
            if (size + 2 > this.payload.capacity()) {
                this.payload = ByteBuffer.allocate(size + 2);
            }
            this.payload.clear().limit(size + 2);
            bytes = this.fc.read(this.payload);
            if (bytes < size + 2) {
                throw new LogException("Incomplete log entry found!");
            }
            this.payload.flip();
            loggable.read(this.payload);
            short prevLink = this.payload.getShort();
            if (prevLink != size + 11) {
                LOG.warn((Object)("Bad pointer to previous: prevLink = " + prevLink + "; size = " + size + "; transactId = " + transactId));
                throw new LogException("Bad pointer to previous in entry: " + loggable.dump());
            }
            return loggable;
        }
        catch (Exception e) {
            throw new LogException(e.getMessage(), e);
        }
    }

    public void position(long lsn) throws LogException {
        try {
            this.fc.position((int)Lsn.getOffset(lsn) - 1);
        }
        catch (IOException e) {
            throw new LogException("Fatal error while reading journal: " + e.getMessage(), e);
        }
    }

    public void close() {
        try {
            this.fc.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fc = null;
    }
}

