/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.lock;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.exist.storage.lock.DeadlockDetection;
import org.exist.storage.lock.Lock;
import org.exist.storage.lock.LockInfo;
import org.exist.storage.lock.LockOwner;
import org.exist.storage.lock.WaitingThread;
import org.exist.util.DeadlockException;
import org.exist.util.LockException;

public class MultiReadReentrantLock
implements Lock {
    private static final Logger LOG = Logger.getLogger((Class)MultiReadReentrantLock.class);
    private Object id;
    private int waitingForReadLock = 0;
    private List outstandingReadLocks = new ArrayList(4);
    private Thread writeLockedThread;
    private int outstandingWriteLocks = 0;
    private List waitingForWriteLock = null;

    public MultiReadReentrantLock(Object id) {
        this.id = id;
    }

    public String getId() {
        return this.id.toString();
    }

    public boolean acquire() throws LockException {
        return this.acquire(0);
    }

    public boolean acquire(int mode) throws LockException {
        if (mode == -1) {
            LOG.warn((Object)"acquired with no lock !");
            return true;
        }
        switch (mode) {
            case 1: {
                return this.writeLock();
            }
        }
        return this.readLock();
    }

    public boolean attempt(int mode) {
        throw new RuntimeException("Not implemented");
    }

    private synchronized boolean readLock() throws LockException {
        Thread thisThread = Thread.currentThread();
        if (this.writeLockedThread == thisThread) {
            this.outstandingReadLocks.add(new LockOwner(thisThread));
            return true;
        }
        this.deadlockCheck();
        ++this.waitingForReadLock;
        if (this.writeLockedThread != null) {
            WaitingThread waiter = new WaitingThread(thisThread, this, this, 0);
            DeadlockDetection.addResourceWaiter(thisThread, waiter);
            while (this.writeLockedThread != null) {
                waiter.doWait();
            }
            DeadlockDetection.clearResourceWaiter(thisThread);
        }
        --this.waitingForReadLock;
        this.outstandingReadLocks.add(new LockOwner(thisThread));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeLock() throws LockException {
        WaitingThread waiter;
        Thread thisThread = Thread.currentThread();
        MultiReadReentrantLock multiReadReentrantLock = this;
        synchronized (multiReadReentrantLock) {
            if (this.writeLockedThread == thisThread) {
                ++this.outstandingWriteLocks;
                return true;
            }
            if (this.writeLockedThread == null && this.grantWriteLock()) {
                this.writeLockedThread = thisThread;
                ++this.outstandingWriteLocks;
                return true;
            }
            this.deadlockCheck();
            if (this.waitingForWriteLock == null) {
                this.waitingForWriteLock = new ArrayList(3);
            }
            waiter = new WaitingThread(thisThread, thisThread, this, 1);
            this.addWaitingWrite(waiter);
            DeadlockDetection.addResourceWaiter(thisThread, waiter);
        }
        List deadlockedThreads = null;
        LockException exceptionCaught = null;
        Object object = thisThread;
        synchronized (object) {
            if (thisThread != this.writeLockedThread) {
                while (thisThread != this.writeLockedThread && deadlockedThreads == null) {
                    if (LockOwner.DEBUG) {
                        StringBuffer buf = new StringBuffer("Waiting for write: ");
                        for (int i = 0; i < this.waitingForWriteLock.size(); ++i) {
                            buf.append(' ');
                            buf.append(((WaitingThread)this.waitingForWriteLock.get(i)).getThread().getName());
                        }
                        LOG.debug((Object)buf.toString());
                        this.debugReadLocks("WAIT");
                    }
                    if ((deadlockedThreads = this.checkForDeadlock(thisThread)) != null) continue;
                    try {
                        waiter.doWait();
                    }
                    catch (LockException e) {
                        exceptionCaught = e;
                        break;
                    }
                }
            }
            if (deadlockedThreads == null && exceptionCaught == null) {
                ++this.outstandingWriteLocks;
            }
        }
        object = this;
        synchronized (object) {
            DeadlockDetection.clearResourceWaiter(thisThread);
            this.removeWaitingWrite(waiter);
        }
        if (exceptionCaught != null) {
            throw exceptionCaught;
        }
        if (deadlockedThreads != null) {
            for (int i = 0; i < deadlockedThreads.size(); ++i) {
                WaitingThread wt = (WaitingThread)deadlockedThreads.get(i);
                wt.signalDeadlock();
            }
            throw new DeadlockException();
        }
        return true;
    }

    private void addWaitingWrite(WaitingThread waiter) {
        this.waitingForWriteLock.add(waiter);
    }

    private void removeWaitingWrite(WaitingThread waiter) {
        for (int i = 0; i < this.waitingForWriteLock.size(); ++i) {
            WaitingThread next = (WaitingThread)this.waitingForWriteLock.get(i);
            if (next.getThread() != waiter.getThread()) continue;
            this.waitingForWriteLock.remove(i);
            break;
        }
    }

    public void release() {
        this.release(0);
    }

    public void release(int mode) {
        switch (mode) {
            case -1: {
                break;
            }
            case 1: {
                this.releaseWrite(1);
                break;
            }
            default: {
                this.releaseRead(1);
            }
        }
    }

    public void release(int mode, int count) {
        switch (mode) {
            case 1: {
                this.releaseWrite(count);
                break;
            }
            default: {
                this.releaseRead(count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void releaseWrite(int count) {
        if (Thread.currentThread() == this.writeLockedThread) {
            if (this.outstandingWriteLocks > 0) {
                this.outstandingWriteLocks -= count;
            }
            if (this.outstandingWriteLocks > 0) {
                return;
            }
            if (this.grantWriteLockAfterRead()) {
                WaitingThread waiter = (WaitingThread)this.waitingForWriteLock.get(0);
                this.removeWaitingWrite(waiter);
                DeadlockDetection.clearResourceWaiter(waiter.getThread());
                Thread thread = this.writeLockedThread = waiter.getThread();
                synchronized (thread) {
                    this.writeLockedThread.notify();
                }
            } else {
                this.writeLockedThread = null;
                if (this.waitingForReadLock > 0) {
                    this.notifyAll();
                }
            }
        } else {
            LOG.warn((Object)"Possible lock problem: a thread released a write lock it didn't hold. Either the thread was interrupted or it never acquired the lock.", new Throwable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void releaseRead(int count) {
        if (!this.outstandingReadLocks.isEmpty()) {
            this.removeReadLock(count);
            if (this.writeLockedThread == null && this.grantWriteLockAfterRead()) {
                WaitingThread waiter = (WaitingThread)this.waitingForWriteLock.get(0);
                this.removeWaitingWrite(waiter);
                DeadlockDetection.clearResourceWaiter(waiter.getThread());
                Thread thread = this.writeLockedThread = waiter.getThread();
                synchronized (thread) {
                    this.writeLockedThread.notifyAll();
                }
            }
            return;
        }
        LOG.warn((Object)("Possible lock problem: thread " + Thread.currentThread().getName() + " released a read lock it didn't hold. Either the " + "thread was interrupted or it never acquired the lock. " + "Write lock: " + (this.writeLockedThread != null ? this.writeLockedThread.getName() : "null")), new Throwable());
        if (LockOwner.DEBUG) {
            this.debugReadLocks("ILLEGAL RELEASE");
        }
    }

    public synchronized boolean isLockedForWrite() {
        return this.writeLockedThread != null || this.waitingForWriteLock != null && this.waitingForWriteLock.size() > 0;
    }

    public synchronized boolean hasLock() {
        return !this.outstandingReadLocks.isEmpty() || this.isLockedForWrite();
    }

    public synchronized boolean isLockedForRead(Thread owner) {
        for (int i = this.outstandingReadLocks.size() - 1; i > -1; --i) {
            if (((LockOwner)this.outstandingReadLocks.get(i)).getOwner() != owner) continue;
            return true;
        }
        return false;
    }

    private void removeReadLock(int count) {
        Thread owner = Thread.currentThread();
        for (int i = this.outstandingReadLocks.size() - 1; i > -1 && count > 0; --i) {
            LockOwner current = (LockOwner)this.outstandingReadLocks.get(i);
            if (current.getOwner() != owner) continue;
            this.outstandingReadLocks.remove(i);
            --count;
        }
    }

    private void deadlockCheck() throws DeadlockException {
        int size = this.outstandingReadLocks.size();
        for (int i = 0; i < size; ++i) {
            LockOwner next = (LockOwner)this.outstandingReadLocks.get(i);
            Lock lock = DeadlockDetection.isWaitingFor(next.getOwner());
            if (lock == null) continue;
            lock.wakeUp();
        }
    }

    private List checkForDeadlock(Thread waiter) {
        ArrayList waiters = new ArrayList(10);
        if (DeadlockDetection.wouldDeadlock(waiter, this.writeLockedThread, waiters)) {
            LOG.warn((Object)("Potential deadlock detected on lock " + this.getId() + "; killing threads: " + waiters.size()));
            return waiters.size() > 0 ? waiters : null;
        }
        return null;
    }

    private boolean grantWriteLock() {
        Thread waiter = Thread.currentThread();
        int size = this.outstandingReadLocks.size();
        if (size == 0) {
            return true;
        }
        for (int i = 0; i < size; ++i) {
            LockOwner next = (LockOwner)this.outstandingReadLocks.get(i);
            if (next.getOwner() == waiter || DeadlockDetection.isBlockedBy(waiter, next.getOwner())) continue;
            return false;
        }
        return true;
    }

    private boolean grantWriteLockAfterRead() {
        if (this.waitingForWriteLock != null && this.waitingForWriteLock.size() > 0) {
            int size = this.outstandingReadLocks.size();
            if (size > 0) {
                WaitingThread waiter = (WaitingThread)this.waitingForWriteLock.get(0);
                return this.isCompatible(waiter.getThread());
            }
            return true;
        }
        return false;
    }

    private boolean hasReadLock(Thread owner) {
        for (int i = 0; i < this.outstandingReadLocks.size(); ++i) {
            LockOwner next = (LockOwner)this.outstandingReadLocks.get(i);
            if (next.getOwner() != owner) continue;
            return true;
        }
        return false;
    }

    public Thread getWriteLockedThread() {
        return this.writeLockedThread;
    }

    public boolean hasLock(Thread owner) {
        if (this.writeLockedThread == owner) {
            return true;
        }
        return this.hasReadLock(owner);
    }

    public void wakeUp() {
    }

    private boolean isCompatible(Thread waiting) {
        for (int i = 0; i < this.outstandingReadLocks.size(); ++i) {
            LockOwner next = (LockOwner)this.outstandingReadLocks.get(i);
            if (next.getOwner() == waiting || DeadlockDetection.isBlockedBy(waiting, next.getOwner())) continue;
            return false;
        }
        return true;
    }

    public synchronized LockInfo getLockInfo() {
        LockInfo info;
        String[] readers = new String[]{};
        if (this.outstandingReadLocks != null) {
            readers = new String[this.outstandingReadLocks.size()];
            for (int i = 0; i < this.outstandingReadLocks.size(); ++i) {
                LockOwner owner = (LockOwner)this.outstandingReadLocks.get(i);
                readers[i] = owner.getOwner().getName();
            }
        }
        if (this.writeLockedThread != null) {
            info = new LockInfo("RESOURCE", "WRITE", this.getId(), new String[]{this.writeLockedThread.getName()});
            info.setReadLocks(readers);
        } else {
            info = new LockInfo("RESOURCE", "READ", this.getId(), readers);
        }
        if (this.waitingForWriteLock != null) {
            String[] waitingForWrite = new String[this.waitingForWriteLock.size()];
            for (int i = 0; i < this.waitingForWriteLock.size(); ++i) {
                waitingForWrite[i] = ((WaitingThread)this.waitingForWriteLock.get(i)).getThread().getName();
            }
            info.setWaitingForWrite(waitingForWrite);
        }
        return info;
    }

    private void debugReadLocks(String msg) {
        for (int i = 0; i < this.outstandingReadLocks.size(); ++i) {
            LockOwner owner = (LockOwner)this.outstandingReadLocks.get(i);
            LOG.debug((Object)(msg + ": " + owner.getOwner()), owner.getStack());
        }
    }

    private String listReadLocks() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.outstandingReadLocks.size(); ++i) {
            LockOwner owner = (LockOwner)this.outstandingReadLocks.get(i);
            buf.append(' ');
            buf.append(owner.getOwner().getName());
        }
        return buf.toString();
    }
}

