/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

public class CharArrayPool {
    public static final int POOL_SIZE = 128;
    public static final int MAX = 128;
    public static final ThreadLocal pools_ = new PoolThreadLocal();
    private static int slot_ = 0;

    public static char[] getCharArray(int size) {
        if (128 > size) {
            char[][] pool = (char[][])pools_.get();
            for (int i = 0; i < pool.length; ++i) {
                if (pool[i] == null || pool[i].length != size) continue;
                char[] b = pool[i];
                pool[i] = null;
                return b;
            }
        }
        return new char[size];
    }

    public static void releaseCharArray(char[] b) {
        int s;
        if (b == null || b.length > 128) {
            return;
        }
        char[][] pool = (char[][])pools_.get();
        for (int i = 0; i < pool.length; ++i) {
            if (pool[i] != null) continue;
            pool[i] = b;
            return;
        }
        if ((s = slot_++) < 0) {
            s = -s;
        }
        pool[s % pool.length] = b;
    }

    private static final class PoolThreadLocal
    extends ThreadLocal {
        private PoolThreadLocal() {
        }

        protected Object initialValue() {
            return new char[128][];
        }
    }
}

