/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.exist.dom.NodeProxy;
import org.exist.util.SwapVals;

public final class HeapSort {
    public static void sort(Comparable[] a, int lo, int hi) {
        int i;
        for (i = hi / 2; i >= lo; --i) {
            HeapSort.fixHeap(a, i, hi, a[i]);
        }
        for (i = hi; i > lo; --i) {
            SwapVals.swap(a, lo, i);
            HeapSort.fixHeap(a, lo, i - 1, a[lo]);
        }
    }

    public static void sort(Comparable[] a, int lo, int hi, int[] b) {
        int i;
        for (i = hi / 2; i >= lo; --i) {
            HeapSort.fixHeap(a, b, i, hi, a[i], b != null ? b[i] : 0);
        }
        for (i = hi; i > lo; --i) {
            SwapVals.swap(a, lo, i);
            if (b != null) {
                SwapVals.swap(b, lo, i);
            }
            HeapSort.fixHeap(a, b, lo, i - 1, a[lo], b != null ? b[lo] : 0);
        }
    }

    public static void sort(Object[] a, Comparator c, int lo, int hi) {
        int i;
        for (i = hi / 2; i >= lo; --i) {
            HeapSort.fixHeap(a, c, i, hi, a[i]);
        }
        for (i = hi; i > lo; --i) {
            SwapVals.swap(a, lo, i);
            HeapSort.fixHeap(a, c, lo, i - 1, a[lo]);
        }
    }

    public static void sort(List a, int lo, int hi) {
        int i;
        for (i = hi / 2; i >= lo; --i) {
            HeapSort.fixHeap(a, i, hi, a.get(i));
        }
        for (i = hi; i > lo; --i) {
            SwapVals.swap(a, lo, i);
            HeapSort.fixHeap(a, lo, i - 1, a.get(lo));
        }
    }

    public static void sort(long[] a, int lo, int hi, Object[] b) {
        int i;
        for (i = hi / 2; i >= lo; --i) {
            HeapSort.fixHeap(a, b, i, hi, a[i], b != null ? b[i] : null);
        }
        for (i = hi; i > lo; --i) {
            SwapVals.swap(a, lo, i);
            if (b != null) {
                SwapVals.swap(b, lo, i);
            }
            HeapSort.fixHeap(a, b, lo, i - 1, a[lo], b != null ? b[lo] : null);
        }
    }

    public static void sort(NodeProxy[] a, int lo, int hi) {
        int i;
        for (i = hi / 2; i >= lo; --i) {
            HeapSort.fixHeap(a, i, hi, a[i]);
        }
        for (i = hi; i > lo; --i) {
            SwapVals.swap(a, lo, i);
            HeapSort.fixHeap(a, lo, i - 1, a[lo]);
        }
    }

    public static void sortByNodeId(NodeProxy[] a, int lo, int hi) {
        int i;
        for (i = hi / 2; i >= lo; --i) {
            HeapSort.fixHeapByNodeId(a, i, hi, a[i]);
        }
        for (i = hi; i > lo; --i) {
            SwapVals.swap(a, lo, i);
            HeapSort.fixHeapByNodeId(a, lo, i - 1, a[lo]);
        }
    }

    private static void fixHeap(Comparable[] a, int root, int end, Comparable key) {
        boolean itera;
        do {
            int child;
            if ((child = 2 * root) < end && a[child].compareTo(a[child + 1]) < 0) {
                ++child;
            }
            boolean bl = itera = child <= end && key.compareTo(a[child]) < 0;
            if (itera) {
                a[root] = a[child];
                root = child;
                continue;
            }
            a[root] = key;
        } while (itera);
    }

    private static void fixHeap(Comparable[] a, int[] b, int root, int end, Comparable key, int keyb) {
        boolean itera;
        do {
            int child;
            if ((child = 2 * root) < end && a[child].compareTo(a[child + 1]) < 0) {
                ++child;
            }
            boolean bl = itera = child <= end && key.compareTo(a[child]) < 0;
            if (itera) {
                a[root] = a[child];
                if (b != null) {
                    b[root] = b[child];
                }
                root = child;
                continue;
            }
            a[root] = key;
            if (b == null) continue;
            b[root] = keyb;
        } while (itera);
    }

    private static void fixHeap(Object[] a, Comparator c, int root, int end, Object key) {
        boolean itera;
        do {
            int child;
            if ((child = 2 * root) < end && c.compare(a[child], a[child + 1]) < 0) {
                ++child;
            }
            boolean bl = itera = child <= end && c.compare(key, a[child]) < 0;
            if (itera) {
                a[root] = a[child];
                root = child;
                continue;
            }
            a[root] = key;
        } while (itera);
    }

    private static void fixHeap(List a, int root, int end, Object key) {
        boolean itera;
        do {
            int child;
            if ((child = 2 * root) < end && ((Comparable)a.get(child)).compareTo(a.get(child + 1)) < 0) {
                ++child;
            }
            boolean bl = itera = child <= end && ((Comparable)key).compareTo(a.get(child)) < 0;
            if (itera) {
                a.set(root, a.get(child));
                root = child;
                continue;
            }
            a.set(root, key);
        } while (itera);
    }

    private static void fixHeap(long[] a, Object[] b, int root, int end, long key, Object keyb) {
        boolean itera;
        do {
            int child;
            if ((child = 2 * root) < end && a[child] < a[child + 1]) {
                ++child;
            }
            boolean bl = itera = child <= end && key < a[child];
            if (itera) {
                a[root] = a[child];
                if (b != null) {
                    b[root] = b[child];
                }
                root = child;
                continue;
            }
            a[root] = key;
            if (b == null) continue;
            b[root] = keyb;
        } while (itera);
    }

    private static void fixHeap(NodeProxy[] a, int root, int end, NodeProxy key) {
        boolean itera;
        do {
            int child;
            if ((child = 2 * root) < end && a[child].compareTo(a[child + 1]) < 0) {
                ++child;
            }
            boolean bl = itera = child <= end && key.compareTo(a[child]) < 0;
            if (itera) {
                a[root] = a[child];
                root = child;
                continue;
            }
            a[root] = key;
        } while (itera);
    }

    private static void fixHeapByNodeId(NodeProxy[] a, int root, int end, NodeProxy key) {
        boolean itera;
        do {
            int child;
            if ((child = 2 * root) < end && a[child].compareTo(a[child + 1]) < 0) {
                ++child;
            }
            boolean bl = itera = child <= end && key.compareTo(a[child]) < 0;
            if (itera) {
                a[root] = a[child];
                root = child;
                continue;
            }
            a[root] = key;
        } while (itera);
    }

    public static void main(String[] args) throws Exception {
        ArrayList<String> l = new ArrayList<String>();
        if (args.length == 0) {
            String[] a = new String[]{"Rudi", "Herbert", "Anton", "Berta", "Olga", "Willi", "Heinz"};
            for (int i = 0; i < a.length; ++i) {
                l.add(a[i]);
            }
        } else {
            System.err.println("Ordering file " + args[0] + "\n");
            try {
                String rr;
                BufferedReader is = new BufferedReader(new FileReader(args[0]));
                while ((rr = is.readLine()) != null) {
                    l.add(rr);
                }
                is.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        long a = System.currentTimeMillis();
        HeapSort.sort(l, 0, l.size() - 1);
        long b = System.currentTimeMillis();
        System.err.println("Ellapsed time: " + (b - a) + " size: " + l.size());
        for (int i = 0; i < l.size(); ++i) {
            System.out.println(l.get(i));
        }
    }
}

