/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.exist.util.Configuration;
import org.exist.util.ConfigurationHelper;
import org.exist.util.DatabaseConfigurationException;

public class SingleInstanceConfiguration
extends Configuration {
    private static final Logger LOG = Logger.getLogger((Class)SingleInstanceConfiguration.class);
    protected static String _configFile = null;
    protected static File _existHome = null;

    public SingleInstanceConfiguration() throws DatabaseConfigurationException {
        this("conf.xml", null);
    }

    public SingleInstanceConfiguration(String configFilename) throws DatabaseConfigurationException {
        this(configFilename, null);
    }

    public SingleInstanceConfiguration(String configFilename, String existHomeDirname) throws DatabaseConfigurationException {
        super(configFilename, existHomeDirname);
        _configFile = this.configFilePath;
        _existHome = this.existHome;
    }

    public static String getPath() {
        if (_configFile == null) {
            File f = ConfigurationHelper.lookup("conf.xml");
            return f.getAbsolutePath();
        }
        return _configFile;
    }

    public static boolean isInWarFile() {
        boolean retVal = true;
        if (_existHome == null) {
            ConfigurationHelper.getExistHome();
        }
        if (new File(_existHome, "lib/core").isDirectory()) {
            retVal = false;
        }
        return retVal;
    }

    public static File getWebappHome() {
        File webappFolder = null;
        if (_existHome == null) {
            ConfigurationHelper.getExistHome();
        }
        webappFolder = SingleInstanceConfiguration.isInWarFile() ? new File(_existHome, "..") : new File(_existHome, "webapp");
        try {
            File tmpFolder;
            webappFolder = tmpFolder = webappFolder.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return webappFolder;
    }

    private static boolean containsConfig(File dir, String config) {
        if (dir != null && dir.exists() && dir.isDirectory() && dir.canRead()) {
            File c = new File(dir, config);
            return c.exists() && c.isFile() && c.canRead();
        }
        return false;
    }
}

