/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util;

import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.StackObjectPool;
import org.exist.util.Configuration;
import org.exist.validation.GrammarPool;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;

public class XMLReaderPool
extends StackObjectPool {
    private static final DefaultHandler2 DUMMY_HANDLER = new DefaultHandler2();
    private Configuration config;

    public XMLReaderPool(Configuration config, PoolableObjectFactory factory, int maxIdle, int initIdleCapacity) {
        super(factory, maxIdle, initIdleCapacity);
        this.config = config;
    }

    public synchronized XMLReader borrowXMLReader() {
        try {
            return (XMLReader)this.borrowObject();
        }
        catch (Exception e) {
            throw new IllegalStateException("error while returning XMLReader: " + e.getMessage());
        }
    }

    public synchronized void returnXMLReader(XMLReader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.setContentHandler(DUMMY_HANDLER);
            reader.setErrorHandler(DUMMY_HANDLER);
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", DUMMY_HANDLER);
            GrammarPool grammarPool = (GrammarPool)reader.getProperty("http://apache.org/xml/properties/internal/grammar-pool");
            if (grammarPool != null) {
                grammarPool.clearDTDs();
            }
            this.returnObject(reader);
        }
        catch (Exception e) {
            throw new IllegalStateException("error while returning XMLReader: " + e.getMessage());
        }
    }
}

