/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.hashtable;

import java.util.Iterator;
import org.exist.util.hashtable.AbstractHashtable;

public class Object2ObjectHashMap
extends AbstractHashtable {
    protected Object[] keys;
    protected Object[] values;

    public Object2ObjectHashMap() {
        this.keys = new Object[this.tabSize];
        this.values = new Object[this.tabSize];
    }

    public Object2ObjectHashMap(int iSize) {
        super(iSize);
        this.keys = new Object[this.tabSize];
        this.values = new Object[this.tabSize];
    }

    public void put(Object key, Object value) {
        try {
            this.insert(key, value);
        }
        catch (AbstractHashtable.HashtableOverflowException e) {
            Object[] copyKeys = this.keys;
            Object[] copyValues = this.values;
            this.tabSize = (int)Object2ObjectHashMap.nextPrime(this.tabSize + this.tabSize / 2);
            this.keys = new Object[this.tabSize];
            this.values = new Object[this.tabSize];
            this.items = 0;
            for (int k = 0; k < copyValues.length; ++k) {
                if (copyKeys[k] == null || copyKeys[k] == REMOVED) continue;
                this.put(copyKeys[k], copyValues[k]);
            }
            this.put(key, value);
        }
    }

    public Object get(Object key) {
        int idx = Object2ObjectHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.keys[idx] == null) {
            return null;
        }
        if (this.keys[idx].equals(key)) {
            return this.values[idx];
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == null) {
                return null;
            }
            if (!this.keys[idx].equals(key)) continue;
            return this.values[idx];
        }
        return null;
    }

    public int getIndex(Object key) {
        int idx = Object2ObjectHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.keys[idx] == null) {
            return -1;
        }
        if (this.keys[idx].equals(key)) {
            return idx;
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == null) {
                return -1;
            }
            if (!this.keys[idx].equals(key)) continue;
            return idx;
        }
        return -1;
    }

    public Object remove(Object key) {
        int idx = Object2ObjectHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.keys[idx] == null) {
            return null;
        }
        if (this.keys[idx].equals(key)) {
            this.keys[idx] = REMOVED;
            --this.items;
            Object oldVal = this.values[idx];
            this.values[idx] = null;
            return oldVal;
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == null) {
                return null;
            }
            if (!this.keys[idx].equals(key)) continue;
            this.keys[idx] = REMOVED;
            --this.items;
            Object oldVal = this.values[idx];
            this.values[idx] = null;
            return oldVal;
        }
        return null;
    }

    protected void insert(Object key, Object value) throws AbstractHashtable.HashtableOverflowException {
        if (key == null) {
            throw new IllegalArgumentException("Illegal value: null");
        }
        int idx = Object2ObjectHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        int bucket = -1;
        if (this.keys[idx] == null) {
            this.keys[idx] = key;
            this.values[idx] = value;
            ++this.items;
            return;
        }
        if (this.keys[idx] == REMOVED) {
            bucket = idx;
        } else if (this.keys[idx].equals(key)) {
            this.values[idx] = value;
            return;
        }
        int rehashVal = this.rehash(idx);
        int rehashCnt = 1;
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == REMOVED) {
                bucket = idx;
            } else {
                if (this.keys[idx] == null) {
                    if (bucket > -1) {
                        idx = bucket;
                    }
                    this.keys[idx] = key;
                    this.values[idx] = value;
                    ++this.items;
                    return;
                }
                if (this.keys[idx].equals(key)) {
                    this.values[idx] = value;
                    return;
                }
            }
            ++rehashCnt;
        }
        if (bucket > -1) {
            this.keys[bucket] = key;
            this.values[bucket] = value;
            ++this.items;
            return;
        }
        throw new AbstractHashtable.HashtableOverflowException();
    }

    protected int rehash(int iVal) {
        int retVal = (iVal + iVal / 2) % this.tabSize;
        if (retVal == 0) {
            retVal = 1;
        }
        return retVal;
    }

    protected static final int hash(Object o) {
        return o.hashCode();
    }

    public Iterator iterator() {
        return new Object2ObjectIterator(0);
    }

    public Iterator valueIterator() {
        return new Object2ObjectIterator(1);
    }

    protected class Object2ObjectIterator
    extends AbstractHashtable.HashtableIterator {
        int idx;

        public Object2ObjectIterator(int type) {
            super(type);
            this.idx = 0;
        }

        public boolean hasNext() {
            if (this.idx == Object2ObjectHashMap.this.tabSize) {
                return false;
            }
            while (Object2ObjectHashMap.this.keys[this.idx] == null || Object2ObjectHashMap.this.keys[this.idx] == AbstractHashtable.REMOVED) {
                ++this.idx;
                if (this.idx != Object2ObjectHashMap.this.tabSize) continue;
                return false;
            }
            return true;
        }

        public Object next() {
            if (this.idx == Object2ObjectHashMap.this.tabSize) {
                return null;
            }
            while (Object2ObjectHashMap.this.keys[this.idx] == null || Object2ObjectHashMap.this.keys[this.idx] == AbstractHashtable.REMOVED) {
                ++this.idx;
                if (this.idx != Object2ObjectHashMap.this.tabSize) continue;
                return null;
            }
            if (this.returnType == 1) {
                return Object2ObjectHashMap.this.values[this.idx++];
            }
            return Object2ObjectHashMap.this.keys[this.idx++];
        }
    }
}

