/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.hashtable;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exist.util.hashtable.AbstractHashtable;

public class ObjectHashSet
extends AbstractHashtable {
    protected Object[] keys;

    public ObjectHashSet() {
        this.keys = new Object[this.tabSize];
    }

    public ObjectHashSet(int iSize) {
        super(iSize);
        this.keys = new Object[this.tabSize];
    }

    public void add(Object key) {
        try {
            this.insert(key);
        }
        catch (AbstractHashtable.HashtableOverflowException e) {
            Object[] copyKeys = this.keys;
            this.tabSize = (int)ObjectHashSet.nextPrime(this.tabSize + this.tabSize / 2);
            this.keys = new Object[this.tabSize];
            this.items = 0;
            for (int k = 0; k < copyKeys.length; ++k) {
                if (copyKeys[k] == null || copyKeys[k] == REMOVED) continue;
                this.add(copyKeys[k]);
            }
            this.add(key);
        }
    }

    protected void insert(Object key) throws AbstractHashtable.HashtableOverflowException {
        if (key == null) {
            throw new IllegalArgumentException("Illegal value: null");
        }
        int idx = ObjectHashSet.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        int bucket = -1;
        if (this.keys[idx] == null) {
            this.keys[idx] = key;
            ++this.items;
            return;
        }
        if (this.keys[idx] == REMOVED) {
            bucket = idx;
        } else if (this.keys[idx].equals(key)) {
            return;
        }
        int rehashVal = this.rehash(idx);
        int rehashCnt = 1;
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == REMOVED) {
                bucket = idx;
            } else {
                if (this.keys[idx] == null) {
                    if (bucket > -1) {
                        idx = bucket;
                    }
                    this.keys[idx] = key;
                    ++this.items;
                    return;
                }
                if (this.keys[idx].equals(key)) {
                    return;
                }
            }
            ++rehashCnt;
        }
        if (bucket > -1) {
            this.keys[bucket] = key;
            ++this.items;
            return;
        }
        throw new AbstractHashtable.HashtableOverflowException();
    }

    public boolean contains(Object key) {
        int idx = ObjectHashSet.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.keys[idx] == null) {
            return false;
        }
        if (this.keys[idx].equals(key)) {
            return true;
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == null) {
                return false;
            }
            if (!this.keys[idx].equals(key)) continue;
            return true;
        }
        return false;
    }

    public Object remove(Object key) {
        int idx = ObjectHashSet.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.keys[idx] == null) {
            return null;
        }
        if (this.keys[idx].equals(key)) {
            key = this.keys[idx];
            this.keys[idx] = REMOVED;
            --this.items;
            return key;
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == null) {
                return null;
            }
            if (!this.keys[idx].equals(key)) continue;
            key = this.keys[idx];
            this.keys[idx] = REMOVED;
            --this.items;
            return key;
        }
        return null;
    }

    protected int rehash(int iVal) {
        int retVal = (iVal + iVal / 2) % this.tabSize;
        if (retVal == 0) {
            retVal = 1;
        }
        return retVal;
    }

    protected static final int hash(Object o) {
        return o.hashCode();
    }

    public List keys() {
        ArrayList<Object> list = new ArrayList<Object>(this.items);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[i] == null || this.keys[i] == REMOVED) continue;
            list.add(this.keys[i]);
        }
        return list;
    }

    public Iterator iterator() {
        return new ObjectHashSetIterator();
    }

    public Iterator stableIterator() {
        return new ObjectHashSetStableIterator();
    }

    public Iterator valueIterator() {
        return null;
    }

    protected class ObjectHashSetStableIterator
    implements Iterator {
        int idx = 0;
        Object[] mKeys;

        public ObjectHashSetStableIterator() {
            this.mKeys = new Object[ObjectHashSet.this.tabSize];
            System.arraycopy(ObjectHashSet.this.keys, 0, this.mKeys, 0, ObjectHashSet.this.tabSize);
        }

        public boolean hasNext() {
            if (this.idx == ObjectHashSet.this.tabSize) {
                return false;
            }
            while (this.mKeys[this.idx] == null || this.mKeys[this.idx] == AbstractHashtable.REMOVED) {
                ++this.idx;
                if (this.idx != ObjectHashSet.this.tabSize) continue;
                return false;
            }
            return true;
        }

        public Object next() {
            if (this.idx == ObjectHashSet.this.tabSize) {
                return null;
            }
            while (this.mKeys[this.idx] == null || this.mKeys[this.idx] == AbstractHashtable.REMOVED) {
                ++this.idx;
                if (this.idx != ObjectHashSet.this.tabSize) continue;
                return null;
            }
            return this.mKeys[this.idx++];
        }

        public void remove() {
        }
    }

    protected class ObjectHashSetIterator
    implements Iterator {
        int idx = 0;

        public boolean hasNext() {
            if (this.idx == ObjectHashSet.this.tabSize) {
                return false;
            }
            while (ObjectHashSet.this.keys[this.idx] == null || ObjectHashSet.this.keys[this.idx] == AbstractHashtable.REMOVED) {
                ++this.idx;
                if (this.idx != ObjectHashSet.this.tabSize) continue;
                return false;
            }
            return true;
        }

        public Object next() {
            if (this.idx == ObjectHashSet.this.tabSize) {
                return null;
            }
            while (ObjectHashSet.this.keys[this.idx] == null || ObjectHashSet.this.keys[this.idx] == AbstractHashtable.REMOVED) {
                ++this.idx;
                if (this.idx != ObjectHashSet.this.tabSize) continue;
                return null;
            }
            return ObjectHashSet.this.keys[this.idx++];
        }

        public void remove() {
        }
    }
}

