/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer;

import org.exist.dom.QName;

public class AttrList {
    protected QName[] names = new QName[4];
    protected String[] values = new String[4];
    protected int[] type = new int[4];
    protected int size = 0;

    public void addAttribute(QName name, String value) {
        this.addAttribute(name, value, 0);
    }

    public void addAttribute(QName name, String value, int attrType) {
        this.ensureCapacity();
        this.names[this.size] = name;
        this.values[this.size] = value;
        this.type[this.size] = attrType;
        ++this.size;
    }

    public int getLength() {
        return this.size;
    }

    public QName getQName(int pos) {
        return this.names[pos];
    }

    public String getValue(int pos) {
        return this.values[pos];
    }

    public String getValue(QName name) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.names[i].equalsSimple(name)) continue;
            return this.values[i];
        }
        return null;
    }

    public int getType(int pos) {
        return this.type[pos];
    }

    private void ensureCapacity() {
        if (this.size == this.names.length) {
            int newSize = this.names.length * 3 / 2;
            QName[] tnames = new QName[newSize];
            System.arraycopy(this.names, 0, tnames, 0, this.names.length);
            String[] tvalues = new String[newSize];
            System.arraycopy(this.values, 0, tvalues, 0, this.values.length);
            int[] ttype = new int[newSize];
            System.arraycopy(this.type, 0, ttype, 0, this.type.length);
            this.names = tnames;
            this.values = tvalues;
            this.type = ttype;
        }
    }
}

