/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.serializer;

import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.exist.dom.QName;
import org.exist.dom.StoredNode;
import org.exist.util.XMLString;
import org.exist.util.serializer.AttrList;
import org.exist.util.serializer.IndentingXMLWriter;
import org.exist.util.serializer.Receiver;
import org.exist.util.serializer.TEXTWriter;
import org.exist.util.serializer.XHTMLWriter;
import org.exist.util.serializer.XMLWriter;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class SAXSerializer
implements ContentHandler,
LexicalHandler,
Receiver {
    private static final Properties defaultProperties = new Properties();
    private static final int XML_WRITER = 0;
    private static final int XHTML_WRITER = 1;
    private static final int TEXT_WRITER = 2;
    private XMLWriter[] writers = new XMLWriter[]{new IndentingXMLWriter(), new XHTMLWriter(), new TEXTWriter()};
    protected XMLWriter receiver;
    protected Properties outputProperties = defaultProperties;
    protected NamespaceSupport nsSupport = new NamespaceSupport();
    protected HashMap namespaceDecls = new HashMap();
    protected HashMap optionalNamespaceDecls = new HashMap();

    public SAXSerializer() {
        this.receiver = this.writers[0];
    }

    public SAXSerializer(Writer writer, Properties outputProperties) {
        this.setOutput(writer, outputProperties);
    }

    public void setOutput(Writer writer, Properties properties) {
        this.outputProperties = properties == null ? defaultProperties : properties;
        String method = this.outputProperties.getProperty("method", "xml");
        this.receiver = "xhtml".equalsIgnoreCase(method) ? this.writers[1] : ("text".equalsIgnoreCase(method) ? this.writers[2] : this.writers[0]);
        this.receiver.setWriter(writer);
        this.receiver.setOutputProperties(this.outputProperties);
    }

    public Writer getWriter() {
        return this.receiver.writer;
    }

    public void setReceiver(XMLWriter receiver) {
        this.receiver = receiver;
    }

    public void reset() {
        this.nsSupport.reset();
        this.namespaceDecls.clear();
        this.optionalNamespaceDecls.clear();
        for (int i = 0; i < this.writers.length; ++i) {
            this.writers[i].reset();
        }
    }

    public void setDocumentLocator(Locator arg0) {
    }

    public void startDocument() throws SAXException {
        try {
            this.receiver.startDocument();
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.receiver.endDocument();
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    public void startPrefixMapping(String prefix, String namespaceURI) throws SAXException {
        String ns;
        if (prefix == null) {
            prefix = "";
        }
        if ((ns = this.nsSupport.getURI(prefix)) == null || !ns.equals(namespaceURI)) {
            this.optionalNamespaceDecls.put(prefix, namespaceURI);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.optionalNamespaceDecls.remove(prefix);
    }

    public void startElement(String namespaceURI, String localName, String qname, Attributes attribs) throws SAXException {
        try {
            String uri;
            this.namespaceDecls.clear();
            this.nsSupport.pushContext();
            this.receiver.startElement(qname);
            String prefix = "";
            int p = qname.indexOf(58);
            if (p > 0) {
                prefix = qname.substring(0, p);
            }
            if (namespaceURI == null) {
                namespaceURI = "";
            }
            if (this.nsSupport.getURI(prefix) == null) {
                this.namespaceDecls.put(prefix, namespaceURI);
                this.nsSupport.declarePrefix(prefix, namespaceURI);
            }
            if (attribs != null) {
                for (int i = 0; i < attribs.getLength(); ++i) {
                    String attrName = attribs.getQName(i);
                    if (attrName.equals("xmlns")) {
                        if (this.nsSupport.getURI("") != null) continue;
                        uri = attribs.getValue(i);
                        this.namespaceDecls.put("", uri);
                        this.nsSupport.declarePrefix("", uri);
                        continue;
                    }
                    if (attrName.startsWith("xmlns:")) {
                        prefix = attrName.substring(6);
                        if (this.nsSupport.getURI(prefix) != null) continue;
                        uri = attribs.getValue(i);
                        this.namespaceDecls.put(prefix, uri);
                        this.nsSupport.declarePrefix(prefix, uri);
                        continue;
                    }
                    p = attrName.indexOf(58);
                    if (p <= 0) continue;
                    prefix = attrName.substring(0, p);
                    uri = attribs.getURI(i);
                    if (this.nsSupport.getURI(prefix) != null) continue;
                    this.namespaceDecls.put(prefix, uri);
                    this.nsSupport.declarePrefix(prefix, uri);
                }
            }
            Iterator i = this.optionalNamespaceDecls.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry nsEntry = i.next();
                prefix = (String)nsEntry.getKey();
                uri = (String)nsEntry.getValue();
                this.receiver.namespace(prefix, uri);
                this.nsSupport.declarePrefix(prefix, uri);
            }
            i = this.namespaceDecls.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry nsEntry = i.next();
                prefix = (String)nsEntry.getKey();
                uri = (String)nsEntry.getValue();
                if (this.optionalNamespaceDecls.containsKey(prefix)) continue;
                this.receiver.namespace(prefix, uri);
            }
            if ("".equals(prefix) && !namespaceURI.equals(this.receiver.getDefaultNamespace())) {
                this.receiver.namespace("", namespaceURI);
                this.nsSupport.declarePrefix("", namespaceURI);
            }
            this.optionalNamespaceDecls.clear();
            for (int i2 = 0; i2 < attribs.getLength(); ++i2) {
                if (attribs.getQName(i2).startsWith("xmlns")) continue;
                this.receiver.attribute(attribs.getQName(i2), attribs.getValue(i2));
            }
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    public void startElement(QName qname, AttrList attribs) throws SAXException {
        try {
            String optPrefix;
            String uri;
            this.namespaceDecls.clear();
            this.nsSupport.pushContext();
            this.receiver.startElement(qname);
            String prefix = qname.getPrefix();
            String namespaceURI = qname.getNamespaceURI();
            if (prefix == null) {
                prefix = "";
            }
            if (namespaceURI == null) {
                namespaceURI = "";
            }
            if (this.nsSupport.getURI(prefix) == null) {
                this.namespaceDecls.put(prefix, namespaceURI);
                this.nsSupport.declarePrefix(prefix, namespaceURI);
            }
            if (attribs != null) {
                for (int i = 0; i < attribs.getLength(); ++i) {
                    QName attrQName = attribs.getQName(i);
                    if (attrQName.getLocalName().equals("xmlns")) {
                        if (this.nsSupport.getURI("") != null) continue;
                        uri = attribs.getValue(i);
                        this.namespaceDecls.put("", uri);
                        this.nsSupport.declarePrefix("", uri);
                        continue;
                    }
                    if (attrQName.getPrefix() == null || attrQName.getPrefix().length() <= 0) continue;
                    prefix = attrQName.getPrefix();
                    if (prefix.equals("xmlns:")) {
                        if (this.nsSupport.getURI(prefix) != null) continue;
                        uri = attribs.getValue(i);
                        prefix = attrQName.getLocalName();
                        this.namespaceDecls.put(prefix, uri);
                        this.nsSupport.declarePrefix(prefix, uri);
                        continue;
                    }
                    if (this.nsSupport.getURI(prefix) != null) continue;
                    uri = attrQName.getNamespaceURI();
                    this.namespaceDecls.put(prefix, uri);
                    this.nsSupport.declarePrefix(prefix, uri);
                }
            }
            Iterator i = this.optionalNamespaceDecls.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry nsEntry = i.next();
                optPrefix = (String)nsEntry.getKey();
                uri = (String)nsEntry.getValue();
                this.receiver.namespace(optPrefix, uri);
                this.nsSupport.declarePrefix(optPrefix, uri);
            }
            i = this.namespaceDecls.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry nsEntry = i.next();
                optPrefix = (String)nsEntry.getKey();
                if (optPrefix.equals("xmlns")) continue;
                uri = (String)nsEntry.getValue();
                if (this.optionalNamespaceDecls.containsKey(optPrefix)) continue;
                this.receiver.namespace(optPrefix, uri);
            }
            this.optionalNamespaceDecls.clear();
            if ("".equals(prefix) && !namespaceURI.equals(this.receiver.getDefaultNamespace())) {
                this.receiver.namespace("", namespaceURI);
                this.nsSupport.declarePrefix("", namespaceURI);
            }
            if (attribs != null) {
                for (int i2 = 0; i2 < attribs.getLength(); ++i2) {
                    if (attribs.getQName(i2).getLocalName().startsWith("xmlns")) continue;
                    this.receiver.attribute(attribs.getQName(i2), attribs.getValue(i2));
                }
            }
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    public void endElement(String namespaceURI, String localName, String qname) throws SAXException {
        try {
            this.nsSupport.popContext();
            this.receiver.endElement(qname);
            this.receiver.setDefaultNamespace(this.nsSupport.getURI(""));
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    public void endElement(QName qname) throws SAXException {
        try {
            this.nsSupport.popContext();
            this.receiver.endElement(qname);
            this.receiver.setDefaultNamespace(this.nsSupport.getURI(""));
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    public void attribute(QName qname, String value) throws SAXException {
        if (qname.getPrefix() != null && qname.getPrefix().equals("xmlns") || qname.getLocalName().equals("xmlns")) {
            return;
        }
        try {
            this.receiver.attribute(qname, value);
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        try {
            this.receiver.characters(ch, start, len);
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    public void characters(CharSequence seq) throws SAXException {
        try {
            this.receiver.characters(seq);
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int len) throws SAXException {
        try {
            this.receiver.characters(ch, start, len);
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.receiver.processingInstruction(target, data);
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    public void cdataSection(char[] ch, int start, int len) throws SAXException {
        try {
            this.receiver.cdataSection(ch, start, len);
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    public void skippedEntity(String arg0) throws SAXException {
    }

    public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void documentType(String name, String publicId, String systemId) throws SAXException {
        try {
            this.receiver.documentType(name, publicId, systemId);
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    public void highlightText(CharSequence seq) {
    }

    public void startEntity(String arg0) throws SAXException {
    }

    public void endEntity(String arg0) throws SAXException {
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
        try {
            this.receiver.comment(new XMLString(ch, start, len));
        }
        catch (TransformerException e) {
            throw new SAXException(e.getMessage(), e);
        }
    }

    public void setCurrentNode(StoredNode node) {
    }

    public Document getDocument() {
        return null;
    }

    static {
        defaultProperties.setProperty("encoding", "UTF-8");
        defaultProperties.setProperty("indent", "false");
    }
}

