/*
 * Decompiled with CFR 0.152.
 */
package org.exist.validation;

public class ValidationReportItem {
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int FATAL = 4;
    private int type = -1;
    private int lineNumber = -1;
    private int columnNumber = -1;
    private String publicId = null;
    private String systemId = null;
    private String message = "";
    private int repeat = 1;

    public void setType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public void setLineNumber(int nr) {
        this.lineNumber = nr;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setColumnNumber(int nr) {
        this.columnNumber = nr;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getTypeText() {
        String reportType = "UNKNOWN";
        switch (this.type) {
            case 1: {
                reportType = "Warning";
                break;
            }
            case 2: {
                reportType = "Error";
                break;
            }
            case 4: {
                reportType = "Fatal";
                break;
            }
            default: {
                reportType = "Unknown Error type";
            }
        }
        return reportType;
    }

    public String toString() {
        String reportType = this.getTypeText();
        return reportType + " (" + this.lineNumber + "," + this.columnNumber + ") : " + this.message;
    }

    public void increaseRepeat() {
        ++this.repeat;
    }

    public int getRepeat() {
        return this.repeat;
    }
}

