/*
 * Decompiled with CFR 0.152.
 */
package org.exist.validation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class XmlLibraryChecker {
    private static final ClassVersion[] validParsers = new ClassVersion[]{new ClassVersion("Xerces", "Xerces-J 2.9.1", "org.apache.xerces.impl.Version.getVersion()")};
    private static final ClassVersion[] validTransformers = new ClassVersion[]{new ClassVersion("Xalan", "Xalan Java 2.7.0", "org.apache.xalan.Version.getVersion()"), new ClassVersion("Saxon", "8.9.0.3", "net.sf.saxon.Version.getProductVersion()")};

    public static boolean hasValidParser() {
        return XmlLibraryChecker.hasValidParser(new StringBuffer());
    }

    public static boolean hasValidParser(StringBuffer message) {
        String sep = System.getProperty("line.separator");
        message.append("Looking for a valid Parser..." + sep);
        for (int i = 0; i < validParsers.length; ++i) {
            String actualVersion = validParsers[i].getActualVersion();
            message.append("Checking for " + validParsers[i].getSimpleName());
            if (actualVersion != null) {
                message.append(", found version " + actualVersion);
                if (actualVersion.equals(validParsers[i].getRequiredVersion())) {
                    message.append(sep + "OK!" + sep);
                    return true;
                }
                message.append(" needed version " + validParsers[i].getRequiredVersion() + sep);
                continue;
            }
            message.append(", not found!" + sep);
        }
        message.append("Warning: Failed find a valid Parser!" + sep);
        message.append(sep + "Please add an appropriate Parser to the " + "class-path, e.g. in the 'endorsed' folder of " + "the servlet container or in the 'endorsed' folder " + "of the JRE." + sep);
        return false;
    }

    public static boolean hasValidTransformer() {
        return XmlLibraryChecker.hasValidTransformer(new StringBuffer());
    }

    public static boolean hasValidTransformer(StringBuffer message) {
        String sep = System.getProperty("line.separator");
        message.append("Looking for a valid Transformer..." + sep);
        for (int i = 0; i < validTransformers.length; ++i) {
            String actualVersion = validTransformers[i].getActualVersion();
            message.append("Checking for " + validTransformers[i].getSimpleName());
            if (actualVersion != null) {
                message.append(", found version " + actualVersion);
                if (actualVersion.equals(validTransformers[i].getRequiredVersion())) {
                    message.append(sep + "OK!" + sep);
                    return true;
                }
                message.append(" needed version " + validTransformers[i].getRequiredVersion() + sep);
                continue;
            }
            message.append(", not found!" + sep);
        }
        message.append("Warning: Failed find a valid Transformer!" + sep);
        message.append(sep + "Please add an appropriate Transformer to the " + "class-path, e.g. in the 'endorsed' folder of " + "the servlet container or in the 'endorsed' folder " + "of the JRE." + sep);
        return false;
    }

    private static class ClassVersion {
        private String simpleName;
        private String requiredVersion;
        private String versionFunction;

        ClassVersion(String simpleName, String requiredVersion, String versionFunction) {
            this.simpleName = simpleName;
            this.requiredVersion = requiredVersion;
            this.versionFunction = versionFunction;
        }

        public String getSimpleName() {
            return this.simpleName;
        }

        public String getRequiredVersion() {
            return this.requiredVersion;
        }

        public String getActualVersion() {
            String actualVersion = null;
            String versionClassName = this.versionFunction.substring(0, this.versionFunction.lastIndexOf(46));
            String versionFunctionName = this.versionFunction.substring(this.versionFunction.lastIndexOf(46) + 1, this.versionFunction.lastIndexOf(40));
            try {
                Class<?> versionClass = Class.forName(versionClassName);
                Method getVersionMethod = versionClass.getMethod(versionFunctionName, null);
                actualVersion = (String)getVersionMethod.invoke(versionClass, null);
            }
            catch (ClassNotFoundException cfe) {
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (InvocationTargetException ite) {
            }
            catch (IllegalAccessException iae) {
                // empty catch block
            }
            return actualVersion;
        }
    }
}

