/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Random;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.DocumentImpl;
import org.exist.dom.LockToken;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.security.xacml.AccessContext;
import org.exist.security.xacml.NullAccessContextException;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.validation.service.LocalValidationService;
import org.exist.xmldb.AbstractEXistResource;
import org.exist.xmldb.CollectionImpl;
import org.exist.xmldb.LocalBinaryResource;
import org.exist.xmldb.LocalCollectionManagementService;
import org.exist.xmldb.LocalDatabaseInstanceManager;
import org.exist.xmldb.LocalIndexQueryService;
import org.exist.xmldb.LocalUserManagementService;
import org.exist.xmldb.LocalXMLResource;
import org.exist.xmldb.LocalXPathQueryService;
import org.exist.xmldb.LocalXUpdateQueryService;
import org.exist.xmldb.XmldbURI;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.Service;
import org.xmldb.api.base.XMLDBException;

public class LocalCollection
extends Observable
implements CollectionImpl {
    private static Logger LOG = Logger.getLogger((Class)LocalCollection.class);
    public static final String NORMALIZE_HTML = "normalize-html";
    protected static final Properties defaultProperties = new Properties();
    protected XmldbURI path = null;
    protected BrokerPool brokerPool = null;
    protected Properties properties = new Properties(defaultProperties);
    protected LocalCollection parent = null;
    protected User user = null;
    protected ArrayList observers = new ArrayList(1);
    protected boolean needsSync = false;
    private XMLReader userReader = null;
    private AccessContext accessCtx;

    private LocalCollection() {
    }

    public LocalCollection(User user, BrokerPool brokerPool, XmldbURI collection, AccessContext accessCtx) throws XMLDBException {
        this(user, brokerPool, null, collection, accessCtx);
    }

    public LocalCollection(User user, BrokerPool brokerPool, LocalCollection parent, XmldbURI name, AccessContext accessCtx) throws XMLDBException {
        if (accessCtx == null) {
            throw new NullAccessContextException();
        }
        this.accessCtx = accessCtx;
        if (user == null) {
            user = new User("guest", "guest", "guest");
        }
        this.user = user;
        this.parent = parent;
        this.brokerPool = brokerPool;
        this.path = name;
        if (this.path == null) {
            this.path = XmldbURI.ROOT_COLLECTION_URI;
        }
        this.path = this.path.toCollectionPathURI();
        this.getCollection();
    }

    public AccessContext getAccessContext() {
        return this.accessCtx;
    }

    protected Collection getCollectionWithLock(int lockMode) throws XMLDBException {
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.brokerPool.get(this.user);
            collection = broker.openCollection(this.path, lockMode);
            if (collection == null) {
                throw new XMLDBException(201, "Collection " + this.path + " not found");
            }
            collection.setReader(this.userReader);
        }
        catch (EXistException e) {
            throw new XMLDBException(0, e.getMessage(), (Throwable)e);
        }
        finally {
            this.brokerPool.release(broker);
        }
        return collection;
    }

    protected void saveCollection() throws XMLDBException {
        DBBroker broker = null;
        Collection collection = null;
        TransactionManager transact = this.brokerPool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            broker = this.brokerPool.get(this.user);
            collection = broker.openCollection(this.path, 1);
            if (collection == null) {
                throw new XMLDBException(201, "Collection " + this.path + " not found");
            }
            broker.saveCollection(transaction, collection);
            transact.commit(transaction);
        }
        catch (IOException e) {
            transact.abort(transaction);
            throw new XMLDBException(0, e.getMessage(), (Throwable)e);
        }
        catch (EXistException e) {
            transact.abort(transaction);
            throw new XMLDBException(0, e.getMessage(), (Throwable)e);
        }
        catch (PermissionDeniedException e) {
            transact.abort(transaction);
            throw new XMLDBException(4, e.getMessage(), (Throwable)e);
        }
        finally {
            if (collection != null) {
                collection.release(1);
            }
            this.brokerPool.release(broker);
        }
    }

    protected Collection getCollection() throws XMLDBException {
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(this.user);
            Collection collection = broker.getCollection(this.path);
            if (collection == null) {
                throw new XMLDBException(200, "Collection " + this.path + " not found");
            }
            collection.setReader(this.userReader);
            Collection collection2 = collection;
            return collection2;
        }
        catch (EXistException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    protected boolean checkOwner(Collection collection, User user) throws XMLDBException {
        return user.getName().equals(collection.getPermissions().getOwner());
    }

    protected boolean checkPermissions(Collection collection, int perm) throws XMLDBException {
        return collection.getPermissions().validate(this.user, perm);
    }

    public void close() throws XMLDBException {
        if (this.needsSync) {
            DBBroker broker = null;
            try {
                broker = this.brokerPool.get(this.user);
                broker.sync(1);
            }
            catch (EXistException e) {
                throw new XMLDBException(0, e.getMessage(), (Throwable)e);
            }
            finally {
                this.brokerPool.release(broker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createId() throws XMLDBException {
        Collection collection = this.getCollectionWithLock(0);
        try {
            XmldbURI id;
            boolean ok;
            Random rand = new Random();
            do {
                ok = true;
                id = XmldbURI.create(Integer.toHexString(rand.nextInt()) + ".xml");
                if (collection.hasDocument(id)) {
                    ok = false;
                }
                if (!collection.hasSubcollection(id)) continue;
                ok = false;
            } while (!ok);
            String string = id.toString();
            return string;
        }
        finally {
            collection.getLock().release(0);
        }
    }

    public Resource createResource(String id, String type) throws XMLDBException {
        XmldbURI idURI;
        if (id == null) {
            id = this.createId();
        }
        try {
            idURI = XmldbURI.xmldbUriFor(id);
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
        AbstractEXistResource r = null;
        if (type.equals("XMLResource")) {
            r = new LocalXMLResource(this.user, this.brokerPool, this, idURI);
        } else if (type.equals("BinaryResource")) {
            r = new LocalBinaryResource(this.user, this.brokerPool, this, idURI);
        } else {
            throw new XMLDBException(301, "unknown resource type: " + type);
        }
        ((AbstractEXistResource)r).isNewResource = true;
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.xmldb.api.base.Collection getChildCollection(String name) throws XMLDBException {
        XmldbURI childURI;
        XmldbURI childName = null;
        try {
            childURI = XmldbURI.xmldbUriFor(name);
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
        Collection collection = this.getCollectionWithLock(0);
        try {
            if (!this.checkPermissions(collection, 4)) {
                throw new XMLDBException(4, "You are not allowed to access this collection");
            }
            if (collection.hasChildCollection(childURI)) {
                childName = this.getPathURI().append(childURI);
            }
        }
        finally {
            collection.release(0);
        }
        if (childName != null) {
            return new LocalCollection(this.user, this.brokerPool, this, childName, this.accessCtx);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildCollectionCount() throws XMLDBException {
        Collection collection = this.getCollectionWithLock(0);
        try {
            if (this.checkPermissions(collection, 4)) {
                int n = collection.getChildCollectionCount();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            collection.getLock().release(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() throws XMLDBException {
        Collection collection = this.getCollectionWithLock(0);
        try {
            String string = collection.getURI().toString();
            return string;
        }
        finally {
            collection.release(0);
        }
    }

    public org.xmldb.api.base.Collection getParentCollection() throws XMLDBException {
        if (this.getName().equals("/db")) {
            return null;
        }
        if (this.parent == null) {
            DBBroker broker = null;
            Collection collection = null;
            try {
                broker = this.brokerPool.get(this.user);
                collection = broker.openCollection(this.path, 0);
                if (collection == null) {
                    throw new XMLDBException(201, "Collection " + this.path + " not found");
                }
                this.parent = new LocalCollection(this.user, this.brokerPool, null, collection.getParentURI(), this.accessCtx);
            }
            catch (EXistException e) {
                throw new XMLDBException(0, "error while retrieving parent collection: " + e.getMessage(), (Throwable)e);
            }
            finally {
                if (collection != null) {
                    collection.getLock().release(0);
                }
                this.brokerPool.release(broker);
            }
        }
        return this.parent;
    }

    public String getPath() throws XMLDBException {
        return this.path.toString();
    }

    public XmldbURI getPathURI() {
        return this.path;
    }

    public String getProperty(String property) throws XMLDBException {
        return this.properties.getProperty(property);
    }

    public Resource getResource(String id) throws XMLDBException {
        XmldbURI idURI;
        Collection collection = null;
        DBBroker broker = null;
        try {
            idURI = XmldbURI.xmldbUriFor(id);
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
        try {
            AbstractEXistResource r;
            broker = this.brokerPool.get(this.user);
            collection = broker.openCollection(this.path, 0);
            if (collection == null) {
                throw new XMLDBException(201, "Collection " + this.path + " not found");
            }
            if (!this.checkPermissions(collection, 4)) {
                throw new XMLDBException(4, "not allowed to read collection");
            }
            DocumentImpl document = collection.getDocument(broker, idURI);
            if (document == null) {
                LOG.warn((Object)("Resource " + idURI + " not found"));
                Resource resource = null;
                return resource;
            }
            if (document.getResourceType() == 0) {
                r = new LocalXMLResource(this.user, this.brokerPool, this, idURI);
            } else if (document.getResourceType() == 1) {
                r = new LocalBinaryResource(this.user, this.brokerPool, this, idURI);
            } else {
                throw new XMLDBException(301, "unknown resource type");
            }
            ((AbstractEXistResource)r).setMimeType(document.getMetadata().getMimeType());
            AbstractEXistResource abstractEXistResource = r;
            return abstractEXistResource;
        }
        catch (EXistException e) {
            throw new XMLDBException(0, "error while retrieving resource: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.brokerPool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResourceCount() throws XMLDBException {
        Collection collection = this.getCollectionWithLock(0);
        try {
            if (!this.checkPermissions(collection, 4)) {
                int n = 0;
                return n;
            }
            int n = collection.getDocumentCount();
            return n;
        }
        finally {
            collection.getLock().release(0);
        }
    }

    public Service getService(String name, String version) throws XMLDBException {
        if (name.equals("XPathQueryService")) {
            return new LocalXPathQueryService(this.user, this.brokerPool, this, this.accessCtx);
        }
        if (name.equals("XQueryService")) {
            return new LocalXPathQueryService(this.user, this.brokerPool, this, this.accessCtx);
        }
        if (name.equals("CollectionManagementService") || name.equals("CollectionManager")) {
            return new LocalCollectionManagementService(this.user, this.brokerPool, this, this.accessCtx);
        }
        if (name.equals("UserManagementService")) {
            return new LocalUserManagementService(this.user, this.brokerPool, this);
        }
        if (name.equals("DatabaseInstanceManager")) {
            return new LocalDatabaseInstanceManager(this.user, this.brokerPool);
        }
        if (name.equals("XUpdateQueryService")) {
            return new LocalXUpdateQueryService(this.user, this.brokerPool, this);
        }
        if (name.equals("IndexQueryService")) {
            return new LocalIndexQueryService(this.user, this.brokerPool, this);
        }
        if (name.equals("ValidationService")) {
            return new LocalValidationService(this.user, this.brokerPool, this);
        }
        throw new XMLDBException(100);
    }

    public Service[] getServices() throws XMLDBException {
        Service[] services = new Service[]{new LocalXPathQueryService(this.user, this.brokerPool, this, this.accessCtx), new LocalCollectionManagementService(this.user, this.brokerPool, this, this.accessCtx), new LocalUserManagementService(this.user, this.brokerPool, this), new LocalDatabaseInstanceManager(this.user, this.brokerPool), new LocalXUpdateQueryService(this.user, this.brokerPool, this), new LocalIndexQueryService(this.user, this.brokerPool, this), new LocalValidationService(this.user, this.brokerPool, this)};
        return services;
    }

    public boolean isOpen() throws XMLDBException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listChildCollections() throws XMLDBException {
        Collection collection = this.getCollectionWithLock(0);
        try {
            if (!this.checkPermissions(collection, 4)) {
                String[] stringArray = new String[]{};
                return stringArray;
            }
            String[] collections = new String[collection.getChildCollectionCount()];
            int j = 0;
            Iterator i = collection.collectionIterator();
            while (i.hasNext()) {
                collections[j] = ((XmldbURI)i.next()).toString();
                ++j;
            }
            String[] stringArray = collections;
            return stringArray;
        }
        finally {
            collection.release(0);
        }
    }

    public String[] getChildCollections() throws XMLDBException {
        return this.listChildCollections();
    }

    public String[] listResources() throws XMLDBException {
        Collection collection = null;
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(this.user);
            collection = broker.openCollection(this.path, 0);
            if (collection == null) {
                throw new XMLDBException(201, "Collection " + this.path + " not found");
            }
            if (!this.checkPermissions(collection, 4)) {
                String[] stringArray = new String[]{};
                return stringArray;
            }
            ArrayList<XmldbURI> allresources = new ArrayList<XmldbURI>();
            Iterator i = collection.iterator(broker);
            while (i.hasNext()) {
                DocumentImpl doc = (DocumentImpl)i.next();
                LockToken lock = doc.getMetadata().getLockToken();
                if (lock != null && lock.isNullResource()) continue;
                allresources.add(doc.getFileURI());
            }
            int j = 0;
            String[] resources = new String[allresources.size()];
            Iterator i2 = allresources.iterator();
            while (i2.hasNext()) {
                resources[j] = ((XmldbURI)i2.next()).toString();
                ++j;
            }
            String[] stringArray = resources;
            return stringArray;
        }
        catch (EXistException e) {
            throw new XMLDBException(0, "error while retrieving resource: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            this.brokerPool.release(broker);
        }
    }

    public String[] getResources() throws XMLDBException {
        return this.listResources();
    }

    public void registerService(Service serv) throws XMLDBException {
        throw new XMLDBException(2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeResource(Resource res) throws XMLDBException {
        XmldbURI resURI;
        if (res == null) {
            return;
        }
        try {
            resURI = XmldbURI.xmldbUriFor(res.getId());
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
        Collection collection = null;
        DBBroker broker = null;
        TransactionManager transact = this.brokerPool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("removing " + resURI));
            }
            if ((collection = (broker = this.brokerPool.get(this.user)).openCollection(this.path, 1)) == null) {
                transact.abort(transaction);
                throw new XMLDBException(201, "Collection " + this.path + " not found");
            }
            DocumentImpl doc = collection.getDocument(broker, resURI);
            if (doc == null) {
                transact.abort(transaction);
                throw new XMLDBException(301, "resource " + resURI + " not found");
            }
            if (res.getResourceType().equals("XMLResource")) {
                collection.removeXMLResource(transaction, broker, resURI);
            } else {
                collection.removeBinaryResource(transaction, broker, resURI);
            }
            transact.commit(transaction);
            if (collection != null) {
                collection.getLock().release(1);
            }
            this.brokerPool.release(broker);
        }
        catch (EXistException e) {
            try {
                transact.abort(transaction);
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
                catch (PermissionDeniedException e2) {
                    transact.abort(transaction);
                    throw new XMLDBException(4, e2.getMessage(), (Throwable)e2);
                }
                catch (TriggerException e3) {
                    transact.abort(transaction);
                    throw new XMLDBException(301, e3.getMessage(), (Throwable)e3);
                }
                catch (LockException e4) {
                    transact.abort(transaction);
                    throw new XMLDBException(1, e4.getMessage(), (Throwable)e4);
                }
            }
            catch (Throwable throwable) {
                if (collection != null) {
                    collection.getLock().release(1);
                }
                this.brokerPool.release(broker);
                throw throwable;
            }
        }
        this.needsSync = true;
    }

    public void setProperty(String property, String value) throws XMLDBException {
        this.properties.setProperty(property, value);
    }

    public void storeResource(Resource resource) throws XMLDBException {
        this.storeResource(resource, null, null);
    }

    public void storeResource(Resource resource, Date a, Date b) throws XMLDBException {
        if (resource.getResourceType().equals("XMLResource")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("storing document " + resource.getId()));
            }
            ((LocalXMLResource)resource).datecreated = a;
            ((LocalXMLResource)resource).datemodified = b;
            this.storeXMLResource((LocalXMLResource)resource);
        } else if (resource.getResourceType().equals("BinaryResource")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("storing binary resource " + resource.getId()));
            }
            ((LocalBinaryResource)resource).datecreated = a;
            ((LocalBinaryResource)resource).datemodified = b;
            this.storeBinaryResource((LocalBinaryResource)resource);
        } else {
            throw new XMLDBException(302, "unknown resource type: " + resource.getResourceType());
        }
        ((AbstractEXistResource)resource).isNewResource = false;
        this.needsSync = true;
    }

    private void storeBinaryResource(LocalBinaryResource res) throws XMLDBException {
        XmldbURI resURI;
        try {
            resURI = XmldbURI.xmldbUriFor(res.getId());
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
        Collection collection = null;
        DBBroker broker = null;
        TransactionManager transact = this.brokerPool.getTransactionManager();
        Txn txn = transact.beginTransaction();
        try {
            broker = this.brokerPool.get(this.user);
            collection = broker.openCollection(this.path, 1);
            if (collection == null) {
                transact.abort(txn);
                throw new XMLDBException(201, "Collection " + this.path + " not found");
            }
            collection.addBinaryResource(txn, broker, resURI, (byte[])res.getContent(), res.getMimeType(), res.datecreated, res.datemodified);
            transact.commit(txn);
        }
        catch (Exception e) {
            transact.abort(txn);
            throw new XMLDBException(1, "Exception while storing binary resource: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (collection != null) {
                collection.getLock().release(1);
            }
            this.brokerPool.release(broker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeXMLResource(LocalXMLResource res) throws XMLDBException {
        XmldbURI resURI;
        try {
            resURI = XmldbURI.xmldbUriFor(res.getId());
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
        DBBroker broker = null;
        TransactionManager transact = this.brokerPool.getTransactionManager();
        Txn txn = transact.beginTransaction();
        try {
            broker = this.brokerPool.get(this.user);
            String uri = null;
            if (res.file != null) {
                uri = res.file.toURI().toASCIIString();
            }
            IndexInfo info = null;
            Collection collection = null;
            try {
                collection = broker.openCollection(this.path, 1);
                if (collection == null) {
                    transact.abort(txn);
                    throw new XMLDBException(201, "Collection " + this.path + " not found");
                }
                Iterator i = this.observers.iterator();
                while (i.hasNext()) {
                    Observer observer = (Observer)i.next();
                    collection.addObserver(observer);
                }
                if (uri != null) {
                    this.setupParser(collection, res);
                    info = collection.validateXMLResource(txn, broker, resURI, new InputSource(uri));
                } else {
                    info = res.root != null ? collection.validateXMLResource(txn, broker, resURI, res.root) : collection.validateXMLResource(txn, broker, resURI, res.content);
                }
                info.getDocument().getMetadata().setMimeType(res.getMimeType());
                if (res.datecreated != null) {
                    info.getDocument().getMetadata().setCreated(res.datecreated.getTime());
                }
                if (res.datemodified != null) {
                    info.getDocument().getMetadata().setLastModified(res.datemodified.getTime());
                }
            }
            finally {
                if (collection != null) {
                    collection.release(1);
                }
            }
            if (uri != null) {
                collection.store(txn, broker, info, new InputSource(uri), false);
            } else if (res.root != null) {
                collection.store(txn, broker, info, res.root, false);
            } else {
                collection.store(txn, broker, info, res.content, false);
            }
            transact.commit(txn);
            collection.deleteObservers();
        }
        catch (Exception e) {
            transact.abort(txn);
            LOG.error((Object)e);
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        finally {
            this.brokerPool.release(broker);
        }
    }

    private void setupParser(Collection collection, LocalXMLResource res) throws XMLDBException {
        String normalize = this.properties.getProperty(NORMALIZE_HTML, "no");
        if ((normalize.equalsIgnoreCase("yes") || normalize.equalsIgnoreCase("true")) && (res.getMimeType().equals("text/html") || res.getId().endsWith(".htm") || res.getId().endsWith(".html"))) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Converting HTML to XML using NekoHTML parser.");
                }
                Class<?> clazz = Class.forName("org.cyberneko.html.parsers.SAXParser");
                XMLReader htmlReader = (XMLReader)clazz.newInstance();
                htmlReader.setProperty("http://cyberneko.org/html/properties/names/elems", "match");
                htmlReader.setProperty("http://cyberneko.org/html/properties/names/attrs", "no-change");
                collection.setReader(htmlReader);
            }
            catch (Exception e) {
                LOG.error((Object)("Error while involing NekoHTML parser. (" + e.getMessage() + "). If you want to parse non-wellformed HTML files, put " + "nekohtml.jar into directory 'lib/optional'."), (Throwable)e);
                throw new XMLDBException(1, "NekoHTML parser error", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getCreationTime() throws XMLDBException {
        Collection collection = this.getCollectionWithLock(0);
        try {
            Date date = new Date(collection.getCreationTime());
            return date;
        }
        finally {
            collection.getLock().release(0);
        }
    }

    public void addObserver(Observer o) {
        if (!this.observers.contains(o)) {
            this.observers.add(o);
        }
    }

    public boolean isRemoteCollection() throws XMLDBException {
        return false;
    }

    public void setReader(XMLReader reader) {
        this.userReader = reader;
    }

    public XmldbURI getURI() {
        StringBuffer accessor = new StringBuffer("xmldb:");
        accessor.append("exist");
        accessor.append("://");
        accessor.append("");
        try {
            return XmldbURI.create(accessor.toString(), this.getPath());
        }
        catch (XMLDBException e) {
            return null;
        }
    }

    static {
        defaultProperties.setProperty("encoding", "UTF-8");
        defaultProperties.setProperty("indent", "yes");
        defaultProperties.setProperty("expand-xincludes", "yes");
        defaultProperties.setProperty("process-xsl-pi", "no");
        defaultProperties.setProperty(NORMALIZE_HTML, "no");
    }
}

