/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.security.xacml.AccessContext;
import org.exist.security.xacml.NullAccessContextException;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xmldb.CollectionManagementServiceImpl;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.Document;
import org.xmldb.api.base.XMLDBException;

public class LocalCollectionManagementService
implements CollectionManagementServiceImpl {
    protected BrokerPool brokerPool;
    protected LocalCollection parent = null;
    protected User user;
    protected AccessContext accessCtx;
    private static Logger LOG = Logger.getLogger((Class)LocalCollectionManagementService.class);

    private LocalCollectionManagementService() {
    }

    public LocalCollectionManagementService(User user, BrokerPool pool, LocalCollection parent, AccessContext accessCtx) {
        if (accessCtx == null) {
            throw new NullAccessContextException();
        }
        this.accessCtx = accessCtx;
        if (user == null) {
            throw new NullPointerException("User cannot be null");
        }
        this.parent = parent;
        this.brokerPool = pool;
        this.user = user;
    }

    public org.xmldb.api.base.Collection createCollection(String collName) throws XMLDBException {
        return this.createCollection(collName, (Date)null);
    }

    public org.xmldb.api.base.Collection createCollection(XmldbURI collName) throws XMLDBException {
        return this.createCollection(collName, (Date)null);
    }

    public org.xmldb.api.base.Collection createCollection(String collName, Date created) throws XMLDBException {
        try {
            return this.createCollection(XmldbURI.xmldbUriFor(collName), created);
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    public org.xmldb.api.base.Collection createCollection(XmldbURI collName, Date created) throws XMLDBException {
        if (this.parent != null) {
            collName = this.parent.getPathURI().resolveCollectionPath(collName);
        }
        TransactionManager transact = this.brokerPool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        DBBroker broker = null;
        try {
            broker = this.brokerPool.get(this.user);
            Collection coll = broker.getOrCreateCollection(transaction, collName);
            if (created != null) {
                coll.setCreationTime(created.getTime());
            }
            broker.saveCollection(transaction, coll);
            transact.commit(transaction);
        }
        catch (EXistException e) {
            transact.abort(transaction);
            throw new XMLDBException(1, "failed to create collection " + collName, (Throwable)e);
        }
        catch (IOException e) {
            transact.abort(transaction);
            throw new XMLDBException(1, "failed to create collection " + collName, (Throwable)e);
        }
        catch (PermissionDeniedException e) {
            transact.abort(transaction);
            throw new XMLDBException(4, "not allowed to create collection", (Throwable)e);
        }
        finally {
            this.brokerPool.release(broker);
        }
        return new LocalCollection(this.user, this.brokerPool, this.parent, collName, this.accessCtx);
    }

    public org.xmldb.api.base.Collection createCollection(String path, Document configuration) throws XMLDBException {
        return this.createCollection(path);
    }

    public String getName() throws XMLDBException {
        return "CollectionManagementService";
    }

    public String getProperty(String property) {
        return null;
    }

    public String getVersion() throws XMLDBException {
        return "1.0";
    }

    public void removeCollection(String collName) throws XMLDBException {
        try {
            this.removeCollection(XmldbURI.xmldbUriFor(collName));
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    public void removeCollection(XmldbURI collName) throws XMLDBException {
        if (this.parent != null) {
            collName = this.parent.getPathURI().resolveCollectionPath(collName);
        }
        TransactionManager transact = this.brokerPool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        DBBroker broker = null;
        Collection collection = null;
        try {
            broker = this.brokerPool.get(this.user);
            collection = broker.openCollection(collName, 1);
            if (collection == null) {
                transact.abort(transaction);
                throw new XMLDBException(201, "Collection " + collName + " not found");
            }
            LOG.debug((Object)("removing collection " + collName));
            broker.removeCollection(transaction, collection);
            transact.commit(transaction);
        }
        catch (EXistException e) {
            transact.abort(transaction);
            e.printStackTrace();
            throw new XMLDBException(1, "failed to remove collection " + collName, (Throwable)e);
        }
        catch (IOException e) {
            transact.abort(transaction);
            e.printStackTrace();
            throw new XMLDBException(1, "failed to remove collection " + collName, (Throwable)e);
        }
        catch (PermissionDeniedException e) {
            transact.abort(transaction);
            throw new XMLDBException(4, e.getMessage(), (Throwable)e);
        }
        finally {
            if (collection != null) {
                collection.release(1);
            }
            this.brokerPool.release(broker);
        }
    }

    public void move(String collectionPath, String destinationPath, String newName) throws XMLDBException {
        try {
            this.move(XmldbURI.xmldbUriFor(collectionPath), XmldbURI.xmldbUriFor(destinationPath), XmldbURI.xmldbUriFor(newName));
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    public void move(XmldbURI collectionPath, XmldbURI destinationPath, XmldbURI newName) throws XMLDBException {
        collectionPath = this.parent.getPathURI().resolveCollectionPath(collectionPath);
        destinationPath = destinationPath == null ? collectionPath.removeLastSegment() : this.parent.getPathURI().resolveCollectionPath(destinationPath);
        TransactionManager transact = this.brokerPool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        DBBroker broker = null;
        Collection collection = null;
        Collection destination = null;
        try {
            broker = this.brokerPool.get(this.user);
            collection = broker.openCollection(collectionPath, 1);
            if (collection == null) {
                transact.abort(transaction);
                throw new XMLDBException(200, "Collection " + collectionPath + " not found");
            }
            destination = broker.openCollection(destinationPath, 1);
            if (destination == null) {
                transact.abort(transaction);
                throw new XMLDBException(200, "Collection " + destinationPath + " not found");
            }
            if (newName == null) {
                newName = collectionPath.lastSegment();
            }
            broker.moveCollection(transaction, collection, destination, newName);
            transact.commit(transaction);
        }
        catch (EXistException e) {
            transact.abort(transaction);
            e.printStackTrace();
            throw new XMLDBException(1, "failed to move collection " + collectionPath, (Throwable)e);
        }
        catch (IOException e) {
            transact.abort(transaction);
            e.printStackTrace();
            throw new XMLDBException(1, "failed to move collection " + collectionPath, (Throwable)e);
        }
        catch (PermissionDeniedException e) {
            transact.abort(transaction);
            throw new XMLDBException(4, e.getMessage(), (Throwable)e);
        }
        catch (LockException e) {
            transact.abort(transaction);
            throw new XMLDBException(4, e.getMessage(), (Throwable)e);
        }
        finally {
            if (destination != null) {
                destination.release(1);
            }
            if (collection != null) {
                collection.release(1);
            }
            this.brokerPool.release(broker);
        }
    }

    public void moveResource(String resourcePath, String destinationPath, String newName) throws XMLDBException {
        try {
            this.moveResource(XmldbURI.xmldbUriFor(resourcePath), XmldbURI.xmldbUriFor(destinationPath), XmldbURI.xmldbUriFor(newName));
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    public void moveResource(XmldbURI resourcePath, XmldbURI destinationPath, XmldbURI newName) throws XMLDBException {
        resourcePath = this.parent.getPathURI().resolveCollectionPath(resourcePath);
        destinationPath = destinationPath == null ? resourcePath.removeLastSegment() : this.parent.getPathURI().resolveCollectionPath(destinationPath);
        TransactionManager transact = this.brokerPool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        DBBroker broker = null;
        Collection destination = null;
        Collection source = null;
        try {
            broker = this.brokerPool.get(this.user);
            source = broker.openCollection(resourcePath.removeLastSegment(), 1);
            if (source == null) {
                transact.abort(transaction);
                throw new XMLDBException(201, "Collection " + resourcePath.removeLastSegment() + " not found");
            }
            DocumentImpl doc = source.getDocument(broker, resourcePath.lastSegment());
            if (doc == null) {
                transact.abort(transaction);
                throw new XMLDBException(300, "Resource " + resourcePath + " not found");
            }
            destination = broker.openCollection(destinationPath, 1);
            if (destination == null) {
                transact.abort(transaction);
                throw new XMLDBException(200, "Collection " + destinationPath + " not found");
            }
            if (newName == null) {
                newName = resourcePath.lastSegment();
            }
            broker.moveXMLResource(transaction, doc, destination, newName);
            transact.commit(transaction);
        }
        catch (EXistException e) {
            transact.abort(transaction);
            e.printStackTrace();
            throw new XMLDBException(1, "failed to move resource " + resourcePath, (Throwable)e);
        }
        catch (IOException e) {
            transact.abort(transaction);
            e.printStackTrace();
            throw new XMLDBException(1, "failed to move resource " + resourcePath, (Throwable)e);
        }
        catch (PermissionDeniedException e) {
            transact.abort(transaction);
            throw new XMLDBException(4, e.getMessage(), (Throwable)e);
        }
        catch (LockException e) {
            transact.abort(transaction);
            throw new XMLDBException(4, e.getMessage(), (Throwable)e);
        }
        finally {
            if (source != null) {
                source.release(1);
            }
            if (destination != null) {
                destination.release(1);
            }
            this.brokerPool.release(broker);
        }
    }

    public void copy(String collectionPath, String destinationPath, String newName) throws XMLDBException {
        try {
            this.copy(XmldbURI.xmldbUriFor(collectionPath), XmldbURI.xmldbUriFor(destinationPath), XmldbURI.xmldbUriFor(newName));
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    public void copy(XmldbURI collectionPath, XmldbURI destinationPath, XmldbURI newName) throws XMLDBException {
        collectionPath = this.parent.getPathURI().resolveCollectionPath(collectionPath);
        destinationPath = destinationPath == null ? collectionPath.removeLastSegment() : this.parent.getPathURI().resolveCollectionPath(destinationPath);
        TransactionManager transact = this.brokerPool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        DBBroker broker = null;
        Collection collection = null;
        Collection destination = null;
        try {
            broker = this.brokerPool.get(this.user);
            collection = broker.openCollection(collectionPath, 0);
            if (collection == null) {
                transact.abort(transaction);
                throw new XMLDBException(200, "Collection '" + collectionPath + "' not found");
            }
            destination = broker.openCollection(destinationPath, 1);
            if (destination == null) {
                transact.abort(transaction);
                throw new XMLDBException(200, "Collection '" + destinationPath + "' not found");
            }
            if (newName == null) {
                newName = collectionPath.lastSegment();
            }
            broker.copyCollection(transaction, collection, destination, newName);
            transact.commit(transaction);
        }
        catch (EXistException e) {
            transact.abort(transaction);
            e.printStackTrace();
            throw new XMLDBException(1, "failed to move collection " + collectionPath, (Throwable)e);
        }
        catch (IOException e) {
            transact.abort(transaction);
            e.printStackTrace();
            throw new XMLDBException(1, "failed to move collection " + collectionPath, (Throwable)e);
        }
        catch (PermissionDeniedException e) {
            transact.abort(transaction);
            throw new XMLDBException(4, e.getMessage(), (Throwable)e);
        }
        catch (LockException e) {
            transact.abort(transaction);
            throw new XMLDBException(4, e.getMessage(), (Throwable)e);
        }
        finally {
            if (collection != null) {
                collection.release(0);
            }
            if (destination != null) {
                destination.release(1);
            }
            this.brokerPool.release(broker);
        }
    }

    public void copyResource(String resourcePath, String destinationPath, String newName) throws XMLDBException {
        try {
            this.copyResource(XmldbURI.xmldbUriFor(resourcePath), XmldbURI.xmldbUriFor(destinationPath), XmldbURI.xmldbUriFor(newName));
        }
        catch (URISyntaxException e) {
            throw new XMLDBException(5, (Throwable)e);
        }
    }

    public void copyResource(XmldbURI resourcePath, XmldbURI destinationPath, XmldbURI newName) throws XMLDBException {
        resourcePath = this.parent.getPathURI().resolveCollectionPath(resourcePath);
        destinationPath = destinationPath == null ? resourcePath.removeLastSegment() : this.parent.getPathURI().resolveCollectionPath(destinationPath);
        TransactionManager transact = this.brokerPool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        DBBroker broker = null;
        Collection destination = null;
        Collection source = null;
        try {
            broker = this.brokerPool.get(this.user);
            source = broker.openCollection(resourcePath.removeLastSegment(), 1);
            if (source == null) {
                transact.abort(transaction);
                throw new XMLDBException(201, "Collection " + resourcePath.removeLastSegment() + " not found");
            }
            DocumentImpl doc = source.getDocument(broker, resourcePath.lastSegment());
            if (doc == null) {
                transact.abort(transaction);
                throw new XMLDBException(300, "Resource " + resourcePath + " not found");
            }
            destination = broker.openCollection(destinationPath, 1);
            if (destination == null) {
                transact.abort(transaction);
                throw new XMLDBException(200, "Collection " + destinationPath + " not found");
            }
            if (newName == null) {
                newName = resourcePath.lastSegment();
            }
            broker.copyXMLResource(transaction, doc, destination, newName);
            transact.commit(transaction);
        }
        catch (EXistException e) {
            transact.abort(transaction);
            e.printStackTrace();
            throw new XMLDBException(1, "failed to move resource " + resourcePath, (Throwable)e);
        }
        catch (PermissionDeniedException e) {
            transact.abort(transaction);
            throw new XMLDBException(4, e.getMessage(), (Throwable)e);
        }
        catch (LockException e) {
            transact.abort(transaction);
            throw new XMLDBException(4, e.getMessage(), (Throwable)e);
        }
        finally {
            if (source != null) {
                source.release(1);
            }
            if (destination != null) {
                destination.release(1);
            }
            this.brokerPool.release(broker);
        }
    }

    public void setCollection(org.xmldb.api.base.Collection parent) throws XMLDBException {
        this.parent = (LocalCollection)parent;
    }

    public void setProperty(String property, String value) {
    }
}

