/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Date;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import org.exist.EXistException;
import org.exist.dom.DocumentImpl;
import org.exist.dom.NodeProxy;
import org.exist.dom.XMLUtil;
import org.exist.memtree.AttributeImpl;
import org.exist.memtree.NodeImpl;
import org.exist.numbering.NodeId;
import org.exist.security.Permission;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.serializers.Serializer;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.util.MimeType;
import org.exist.util.serializer.DOMSerializer;
import org.exist.util.serializer.DOMStreamer;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.SerializerPool;
import org.exist.xmldb.AbstractEXistResource;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class LocalXMLResource
extends AbstractEXistResource
implements XMLResource {
    protected NodeProxy proxy = null;
    protected Properties outputProperties = null;
    protected LexicalHandler lexicalHandler = null;
    protected String content = null;
    protected File file = null;
    protected Node root = null;
    protected AtomicValue value = null;
    protected Date datecreated = null;
    protected Date datemodified = null;

    public LocalXMLResource(User user, BrokerPool pool, LocalCollection parent, XmldbURI did) throws XMLDBException {
        super(user, pool, parent, did, MimeType.XML_TYPE.getName());
    }

    public LocalXMLResource(User user, BrokerPool pool, LocalCollection parent, NodeProxy p) throws XMLDBException {
        this(user, pool, parent, p.getDocument().getFileURI());
        this.proxy = p;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getContent() throws XMLDBException {
        String string;
        if (this.content != null) {
            return this.content;
        }
        if (this.root != null && !(this.root instanceof NodeValue)) {
            StringWriter writer = new StringWriter();
            DOMSerializer serializer = new DOMSerializer(writer, this.getProperties());
            try {
                serializer.serialize(this.root);
                this.content = writer.toString();
                return this.content;
            }
            catch (TransformerException e) {
                throw new XMLDBException(301, e.getMessage(), (Throwable)e);
            }
        }
        if (this.value != null) {
            try {
                if (!Type.subTypeOf(this.value.getType(), 22)) return this.value.getStringValue();
                return ((StringValue)this.value).getStringValue(true);
            }
            catch (XPathException e) {
                throw new XMLDBException(301, e.getMessage(), (Throwable)e);
            }
        }
        if (this.file != null) {
            try {
                this.content = XMLUtil.readFile(this.file);
                return this.content;
            }
            catch (IOException e) {
                throw new XMLDBException(1, "error while reading resource contents", (Throwable)e);
            }
        }
        DocumentImpl document = null;
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            Serializer serializer = broker.getSerializer();
            serializer.setUser(this.user);
            serializer.setProperties(this.getProperties());
            if (this.root != null) {
                this.content = serializer.serialize((NodeValue)((Object)this.root));
            } else if (this.proxy != null) {
                this.content = serializer.serialize(this.proxy);
            } else {
                document = this.openDocument(broker, 0);
                if (!document.getPermissions().validate(this.user, 4)) {
                    throw new XMLDBException(4, "permission denied to read resource");
                }
                this.content = serializer.serialize(document);
            }
            string = this.content;
        }
        catch (SAXException saxe) {
            try {
                saxe.printStackTrace();
                throw new XMLDBException(1, saxe.getMessage(), (Throwable)saxe);
                catch (EXistException e) {
                    throw new XMLDBException(1, e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new XMLDBException(1, e.getMessage(), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                this.closeDocument(document, 0);
                this.pool.release(broker);
                throw throwable;
            }
        }
        this.closeDocument(document, 0);
        this.pool.release(broker);
        return string;
    }

    public Node getContentAsDOM() throws XMLDBException {
        DBBroker broker;
        DocumentImpl document;
        block9: {
            if (this.root != null) {
                if (this.root instanceof NodeImpl) {
                    ((NodeImpl)this.root).expand();
                }
                return this.root;
            }
            if (this.value != null) {
                throw new XMLDBException(1, "cannot return an atomic value as DOM node");
            }
            document = null;
            broker = null;
            broker = this.pool.get(this.user);
            document = this.getDocument(broker, 0);
            if (!document.getPermissions().validate(this.user, 4)) {
                throw new XMLDBException(4, "permission denied to read resource");
            }
            if (this.proxy == null) break block9;
            Node node = document.getNode(this.proxy);
            this.parent.getCollection().releaseDocument(document, 0);
            this.pool.release(broker);
            return node;
        }
        try {
            DocumentImpl documentImpl = document;
            this.parent.getCollection().releaseDocument(document, 0);
            this.pool.release(broker);
            return documentImpl;
        }
        catch (EXistException e) {
            try {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.parent.getCollection().releaseDocument(document, 0);
                this.pool.release(broker);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getContentAsSAX(ContentHandler handler) throws XMLDBException {
        block22: {
            DBBroker broker = null;
            if (this.root != null && !(this.root instanceof NodeValue)) {
                try {
                    String option = this.parent.properties.getProperty("sax-document-events", "false");
                    DOMStreamer streamer = (DOMStreamer)SerializerPool.getInstance().borrowObject(DOMStreamer.class);
                    streamer.setContentHandler(handler);
                    streamer.setLexicalHandler(this.lexicalHandler);
                    streamer.serialize(this.root, option.equalsIgnoreCase("true"));
                    SerializerPool.getInstance().returnObject(streamer);
                }
                catch (Exception e) {
                    throw new XMLDBException(301, e.getMessage(), (Throwable)e);
                }
            }
            if (this.value != null) {
                try {
                    broker = this.pool.get(this.user);
                    this.value.toSAX(broker, handler, this.getProperties());
                }
                catch (EXistException e) {
                    throw new XMLDBException(1, e.getMessage(), (Throwable)e);
                }
                catch (SAXException e) {
                    throw new XMLDBException(1, e.getMessage(), (Throwable)e);
                }
                finally {
                    this.pool.release(broker);
                }
            }
            try {
                broker = this.pool.get(this.user);
                Serializer serializer = broker.getSerializer();
                serializer.setUser(this.user);
                serializer.setProperties(this.getProperties());
                serializer.setSAXHandlers(handler, this.lexicalHandler);
                if (this.root != null) {
                    serializer.toSAX((NodeValue)((Object)this.root));
                    break block22;
                }
                if (this.proxy != null) {
                    serializer.toSAX(this.proxy);
                    break block22;
                }
                DocumentImpl document = null;
                try {
                    document = this.openDocument(broker, 0);
                    if (!document.getPermissions().validate(this.user, 4)) {
                        throw new XMLDBException(4, "permission denied to read resource");
                    }
                    serializer.toSAX(document);
                }
                finally {
                    this.closeDocument(document, 0);
                }
            }
            catch (EXistException e) {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
            catch (SAXException e) {
                throw new XMLDBException(1, e.getMessage(), (Throwable)e);
            }
            finally {
                this.pool.release(broker);
            }
        }
    }

    public String getDocumentId() throws XMLDBException {
        return this.docId.toString();
    }

    public String getId() throws XMLDBException {
        return this.docId.toString();
    }

    public Collection getParentCollection() throws XMLDBException {
        if (this.parent == null) {
            throw new XMLDBException(1, "collection parent is null");
        }
        return this.parent;
    }

    public String getResourceType() throws XMLDBException {
        return "XMLResource";
    }

    public Date getCreationTime() throws XMLDBException {
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            DocumentImpl document = this.getDocument(broker, -1);
            if (!document.getPermissions().validate(this.user, 4)) {
                throw new XMLDBException(4, "permission denied to read resource");
            }
            Date date = new Date(document.getMetadata().getCreated());
            return date;
        }
        catch (EXistException e) {
            throw new XMLDBException(0, e.getMessage(), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    public Date getLastModificationTime() throws XMLDBException {
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            DocumentImpl document = this.getDocument(broker, -1);
            if (!document.getPermissions().validate(this.user, 4)) {
                throw new XMLDBException(4, "permission denied to read resource");
            }
            Date date = new Date(document.getMetadata().getLastModified());
            return date;
        }
        catch (EXistException e) {
            throw new XMLDBException(0, e.getMessage(), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    public int getContentLength() throws XMLDBException {
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            DocumentImpl document = this.getDocument(broker, -1);
            if (!document.getPermissions().validate(this.user, 4)) {
                throw new XMLDBException(4, "permission denied to read resource");
            }
            int n = document.getContentLength();
            return n;
        }
        catch (EXistException e) {
            throw new XMLDBException(0, e.getMessage(), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    public void setContent(Object obj) throws XMLDBException {
        this.content = null;
        if (obj instanceof File) {
            this.file = (File)obj;
        } else if (obj instanceof AtomicValue) {
            this.value = (AtomicValue)obj;
        } else {
            this.content = obj.toString();
        }
    }

    public void setContentAsDOM(Node root) throws XMLDBException {
        if (root instanceof AttributeImpl) {
            throw new XMLDBException(3, "SENR0001: can not serialize a standalone attribute");
        }
        this.root = root;
    }

    public ContentHandler setContentAsSAX() throws XMLDBException {
        return new InternalXMLSerializer();
    }

    public boolean getSAXFeature(String arg0) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setSAXFeature(String arg0, boolean arg1) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public Permission getPermissions() throws XMLDBException {
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            DocumentImpl document = this.getDocument(broker, -1);
            Permission permission = document != null ? document.getPermissions() : null;
            return permission;
        }
        catch (EXistException e) {
            throw new XMLDBException(301, e.getMessage(), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.lexicalHandler = handler;
    }

    protected void setProperties(Properties properties) {
        this.outputProperties = properties;
    }

    private Properties getProperties() {
        return this.outputProperties == null ? this.parent.properties : this.outputProperties;
    }

    protected DocumentImpl getDocument(DBBroker broker, int lock) throws XMLDBException {
        DocumentImpl document = null;
        if (lock != -1) {
            try {
                document = this.parent.getCollection().getDocumentWithLock(broker, this.docId, lock);
            }
            catch (LockException e) {
                throw new XMLDBException(4, "Failed to acquire lock on document " + this.docId);
            }
        } else {
            document = this.parent.getCollection().getDocument(broker, this.docId);
        }
        if (document == null) {
            throw new XMLDBException(301);
        }
        return document;
    }

    public NodeProxy getNode() throws XMLDBException {
        if (this.proxy != null) {
            return this.proxy;
        }
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            DocumentImpl document = this.getDocument(broker, -1);
            NodeProxy nodeProxy = new NodeProxy(document, NodeId.DOCUMENT_NODE);
            return nodeProxy;
        }
        catch (EXistException e) {
            throw new XMLDBException(301, e.getMessage(), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    public DocumentType getDocType() throws XMLDBException {
        DBBroker broker = null;
        try {
            broker = this.pool.get(this.user);
            DocumentImpl document = this.getDocument(broker, -1);
            if (!document.getPermissions().validate(this.user, 4)) {
                throw new XMLDBException(4, "permission denied to read resource");
            }
            DocumentType documentType = document.getDoctype();
            return documentType;
        }
        catch (EXistException e) {
            throw new XMLDBException(0, e.getMessage(), (Throwable)e);
        }
        finally {
            this.pool.release(broker);
        }
    }

    public void setDocType(DocumentType doctype) throws XMLDBException {
        DBBroker broker = null;
        DocumentImpl document = null;
        TransactionManager transact = this.pool.getTransactionManager();
        Txn transaction = transact.beginTransaction();
        try {
            broker = this.pool.get(this.user);
            document = this.openDocument(broker, 1);
            if (document == null) {
                throw new EXistException("Resource " + document.getFileURI() + " not found");
            }
            if (!document.getPermissions().validate(this.user, 1)) {
                throw new XMLDBException(4, "User is not allowed to lock resource " + document.getFileURI());
            }
            document.setDocumentType(doctype);
            broker.storeXMLResource(transaction, document);
            transact.commit(transaction);
        }
        catch (EXistException e) {
            try {
                transact.abort(transaction);
                throw new XMLDBException(0, e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeDocument(document, 1);
                this.pool.release(broker);
                throw throwable;
            }
        }
        this.closeDocument(document, 1);
        this.pool.release(broker);
    }

    private class InternalXMLSerializer
    extends SAXSerializer {
        public InternalXMLSerializer() {
            super(new StringWriter(), null);
        }

        public void endDocument() throws SAXException {
            super.endDocument();
            LocalXMLResource.this.content = this.getWriter().toString();
        }
    }
}

