/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpcException;
import org.exist.dom.DocumentTypeImpl;
import org.exist.security.Permission;
import org.exist.util.Compressor;
import org.exist.util.MimeType;
import org.exist.util.serializer.DOMSerializer;
import org.exist.util.serializer.SAXSerializer;
import org.exist.xmldb.EXistResource;
import org.exist.xmldb.RemoteCollection;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.value.StringValue;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

public class RemoteXMLResource
implements XMLResource,
EXistResource {
    private static final Properties emptyProperties = new Properties();
    private XMLReader xmlReader = null;
    protected String id;
    protected XmldbURI path = null;
    private String mimeType = MimeType.XML_TYPE.getName();
    protected int handle = -1;
    protected int pos = -1;
    protected RemoteCollection parent;
    protected String content = null;
    protected File file = null;
    protected Permission permissions = null;
    protected int contentLen = 0;
    protected Properties outputProperties = null;
    protected LexicalHandler lexicalHandler = null;
    protected Date dateCreated = null;
    protected Date dateModified = null;
    private static Logger LOG = Logger.getLogger((String)RemoteXMLResource.class.getName());

    public RemoteXMLResource(RemoteCollection parent, XmldbURI docId, String id) throws XMLDBException {
        this(parent, -1, -1, docId, id);
    }

    public RemoteXMLResource(RemoteCollection parent, int handle, int pos, XmldbURI docId, String id) throws XMLDBException {
        this.handle = handle;
        this.pos = pos;
        this.parent = parent;
        this.id = id;
        this.path = docId.numSegments() > 1 ? docId : parent.getPathURI().append(docId);
    }

    public Date getCreationTime() throws XMLDBException {
        return this.dateCreated;
    }

    public Date getLastModificationTime() throws XMLDBException {
        return this.dateModified;
    }

    public Object getContent() throws XMLDBException {
        Vector<Object> params;
        if (this.content != null) {
            return new StringValue(this.content).getStringValue(true);
        }
        if (this.file != null) {
            return this.file;
        }
        Properties properties = this.parent.getProperties();
        byte[] data = null;
        if (this.id == null) {
            params = new Vector<Object>();
            params.addElement(this.path.toString());
            params.addElement(properties);
            try {
                Hashtable table = (Hashtable)this.parent.getClient().execute("getDocumentData", params);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                int offset = (Integer)table.get("offset");
                data = (byte[])table.get("data");
                os.write(data);
                while (offset > 0) {
                    params.clear();
                    params.addElement(table.get("handle"));
                    params.addElement(new Integer(offset));
                    table = (Hashtable)this.parent.getClient().execute("getNextChunk", params);
                    offset = (Integer)table.get("offset");
                    data = (byte[])table.get("data");
                    os.write(data);
                }
                data = os.toByteArray();
            }
            catch (XmlRpcException xre) {
                throw new XMLDBException(301, xre.getMessage(), (Throwable)xre);
            }
            catch (IOException ioe) {
                throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
            }
        }
        params = new Vector();
        params.addElement(new Integer(this.handle));
        params.addElement(new Integer(this.pos));
        params.addElement(properties);
        try {
            data = (byte[])this.parent.getClient().execute("retrieve", params);
        }
        catch (XmlRpcException xre) {
            throw new XMLDBException(301, xre.getMessage(), (Throwable)xre);
        }
        catch (IOException ioe) {
            throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
        }
        if (properties.getProperty("compress-output", "no").equals("yes")) {
            try {
                data = Compressor.uncompress(data);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            this.content = new String(data, properties.getProperty("encoding", "UTF-8"));
            this.content = new StringValue(this.content).getStringValue(true);
        }
        catch (UnsupportedEncodingException ue) {
            LOG.warn((Object)ue);
            this.content = new String(data);
            this.content = new StringValue(this.content).getStringValue(true);
        }
        return this.content;
    }

    public Node getContentAsDOM() throws XMLDBException {
        if (this.content == null) {
            this.getContent();
        }
        if (this.file != null) {
            this.getData();
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(this.content)));
            return doc;
        }
        catch (SAXException saxe) {
            throw new XMLDBException(1, saxe.getMessage(), (Throwable)saxe);
        }
        catch (ParserConfigurationException pce) {
            throw new XMLDBException(1, pce.getMessage(), (Throwable)pce);
        }
        catch (IOException ioe) {
            throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
        }
    }

    public void getContentAsSAX(ContentHandler handler) throws XMLDBException {
        if (this.content == null) {
            this.getContent();
        }
        if (this.file != null) {
            this.getData();
        }
        XMLReader reader = null;
        if (this.xmlReader == null) {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setNamespaceAware(true);
            saxFactory.setValidating(false);
            try {
                SAXParser sax = saxFactory.newSAXParser();
                reader = sax.getXMLReader();
            }
            catch (ParserConfigurationException pce) {
                throw new XMLDBException(1, pce.getMessage(), (Throwable)pce);
            }
            catch (SAXException saxe) {
                saxe.printStackTrace();
                throw new XMLDBException(1, saxe.getMessage(), (Throwable)saxe);
            }
        } else {
            reader = this.xmlReader;
        }
        try {
            reader.setContentHandler(handler);
            if (this.lexicalHandler != null) {
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", this.lexicalHandler);
            }
            reader.parse(new InputSource(new StringReader(this.content)));
        }
        catch (SAXException saxe) {
            saxe.printStackTrace();
            throw new XMLDBException(1, saxe.getMessage(), (Throwable)saxe);
        }
        catch (IOException ioe) {
            throw new XMLDBException(1, ioe.getMessage(), (Throwable)ioe);
        }
    }

    public String getNodeId() {
        return this.id == null ? "1" : this.id;
    }

    public String getDocumentId() throws XMLDBException {
        return this.path.lastSegment().toString();
    }

    public String getId() throws XMLDBException {
        if (this.id == null || this.id.equals("1")) {
            return this.getDocumentId();
        }
        return this.getDocumentId() + '_' + this.id;
    }

    public Collection getParentCollection() throws XMLDBException {
        return this.parent;
    }

    public String getResourceType() throws XMLDBException {
        return "XMLResource";
    }

    public void setXMLReader(XMLReader xmlReader) {
        this.xmlReader = xmlReader;
    }

    public void setContent(Object value) throws XMLDBException {
        if (value instanceof File) {
            this.file = (File)value;
        } else {
            this.content = value.toString();
        }
    }

    public void setContentAsDOM(Node root) throws XMLDBException {
        StringWriter sout = new StringWriter();
        DOMSerializer xmlout = new DOMSerializer(sout, this.getProperties());
        try {
            switch (root.getNodeType()) {
                case 1: {
                    xmlout.serialize((Element)root);
                    break;
                }
                case 11: {
                    xmlout.serialize((DocumentFragment)root);
                    break;
                }
                case 9: {
                    xmlout.serialize((Document)root);
                    break;
                }
                default: {
                    throw new XMLDBException(1, "invalid node type");
                }
            }
            this.content = sout.toString();
        }
        catch (TransformerException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
    }

    public ContentHandler setContentAsSAX() throws XMLDBException {
        return new InternalXMLSerializer();
    }

    public boolean getSAXFeature(String arg0) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setSAXFeature(String arg0, boolean arg1) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    protected byte[] getData() throws XMLDBException {
        if (this.file != null) {
            if (!this.file.canRead()) {
                throw new XMLDBException(301, "failed to read resource content from file " + this.file.getAbsolutePath());
            }
            try {
                int l;
                byte[] chunk = new byte[512];
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                FileInputStream in = new FileInputStream(this.file);
                do {
                    if ((l = in.read(chunk)) <= 0) continue;
                    out.write(chunk, 0, l);
                } while (l > -1);
                in.close();
                byte[] data = out.toByteArray();
                this.file = null;
                return data;
            }
            catch (IOException e) {
                throw new XMLDBException(301, "failed to read resource content from file " + this.file.getAbsolutePath(), (Throwable)e);
            }
        }
        if (this.content != null) {
            try {
                return this.content.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOG.warn((Object)e);
            }
        }
        return null;
    }

    public void setContentLength(int len) {
        this.contentLen = len;
    }

    public int getContentLength() throws XMLDBException {
        return this.contentLen;
    }

    public void setPermissions(Permission perms) {
        this.permissions = perms;
    }

    public Permission getPermissions() {
        return this.permissions;
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.lexicalHandler = handler;
    }

    protected void setProperties(Properties properties) {
        this.outputProperties = properties;
    }

    private Properties getProperties() {
        return this.outputProperties == null ? this.parent.properties : this.outputProperties;
    }

    public void setMimeType(String mime) {
        this.mimeType = mime;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public DocumentType getDocType() throws XMLDBException {
        DocumentTypeImpl result = null;
        Vector<String> params = new Vector<String>(1);
        Vector request = null;
        params.addElement(this.path.toString());
        try {
            request = (Vector)this.parent.getClient().execute("getDocType", params);
            if (!((String)request.get(0)).equals("")) {
                result = new DocumentTypeImpl((String)request.get(0), (String)request.get(1), (String)request.get(2));
            }
            return result;
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(0, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(0, e.getMessage(), (Throwable)e);
        }
    }

    public void setDocType(DocumentType doctype) throws XMLDBException {
        if (doctype != null) {
            Vector<String> params = new Vector<String>(4);
            params.addElement(this.path.toString());
            params.addElement(doctype.getName());
            params.addElement(doctype.getPublicId() == null ? "" : doctype.getPublicId());
            params.addElement(doctype.getSystemId() == null ? "" : doctype.getSystemId());
            try {
                this.parent.getClient().execute("setDocType", params);
            }
            catch (XmlRpcException e) {
                throw new XMLDBException(0, e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new XMLDBException(0, e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    protected void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    private class InternalXMLSerializer
    extends SAXSerializer {
        StringWriter writer = new StringWriter();

        public InternalXMLSerializer() {
            this.setOutput(this.writer, emptyProperties);
        }

        public void endDocument() throws SAXException {
            super.endDocument();
            RemoteXMLResource.this.content = this.writer.toString();
        }
    }
}

