/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmlrpc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.AuthenticatedXmlRpcHandler;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcException;
import org.exist.EXistException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.util.Configuration;
import org.exist.xmlrpc.RpcAPI;
import org.exist.xmlrpc.RpcServer;

public class AuthenticatedHandler
implements AuthenticatedXmlRpcHandler {
    private static Logger LOG = Logger.getLogger((String)AuthenticatedXmlRpcHandler.class.getName());
    private RpcAPI handler;
    private BrokerPool pool = null;
    private String databaseid = "exist";

    public AuthenticatedHandler(Configuration conf, String id) throws XmlRpcException {
        if (id != null && !"".equals(id)) {
            this.databaseid = id;
        }
        try {
            this.handler = new RpcServer(conf, this.databaseid);
            this.pool = BrokerPool.getInstance(this.databaseid);
        }
        catch (EXistException e) {
            throw new XmlRpcException(0, e.toString());
        }
    }

    public Object execute(String method, Vector v, String user, String password) throws Exception {
        User u;
        if (user == null) {
            user = "guest";
            password = "guest";
        }
        if ((u = this.pool.getSecurityManager().getUser(user)) == null) {
            throw new XmlRpcException(0, "User " + user + " unknown");
        }
        if (!u.validate(password)) {
            if (XmlRpc.debug) {
                LOG.debug((Object)("login denied for user " + user));
            }
            throw new XmlRpcException(0, "Invalid password for user " + user);
        }
        if (XmlRpc.debug) {
            LOG.debug((Object)("user " + user + " logged in"));
            LOG.debug((Object)("calling " + method));
            for (int i = 0; i < v.size(); ++i) {
                LOG.debug((Object)("argument " + i + ": " + v.elementAt(i).toString()));
            }
        }
        return this.execute(u, method, v);
    }

    private Object execute(User user, String methodName, Vector params) throws Exception {
        Class[] argClasses = null;
        Object[] argValues = null;
        if (params != null) {
            argClasses = new Class[params.size() + 1];
            argValues = new Object[params.size() + 1];
            argValues[0] = user;
            argClasses[0] = User.class;
            for (int i = 1; i < params.size() + 1; ++i) {
                argValues[i] = params.elementAt(i - 1);
                argClasses[i] = argValues[i] instanceof Integer ? Integer.TYPE : (argValues[i] instanceof Double ? Double.TYPE : (argValues[i] instanceof Boolean ? Boolean.TYPE : argValues[i].getClass()));
            }
        } else {
            argClasses = new Class[1];
            argValues = new Class[]{user};
            argClasses[0] = User.class;
        }
        Method method = null;
        try {
            method = RpcAPI.class.getMethod(methodName, argClasses);
        }
        catch (NoSuchMethodException nsm_e) {
            throw nsm_e;
        }
        catch (SecurityException s_e) {
            throw s_e;
        }
        if (method.getDeclaringClass() == Object.class) {
            throw new XmlRpcException(0, "Invoker can't call methods defined in java.lang.Object");
        }
        Object returnValue = null;
        try {
            returnValue = method.invoke((Object)this.handler, argValues);
        }
        catch (IllegalAccessException iacc_e) {
            throw iacc_e;
        }
        catch (IllegalArgumentException iarg_e) {
            throw iarg_e;
        }
        catch (InvocationTargetException it_e) {
            Throwable t = AuthenticatedHandler.getCause(it_e);
            if (XmlRpc.debug) {
                t.printStackTrace();
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new Exception(t);
        }
        catch (Exception e) {
            Throwable t = AuthenticatedHandler.getCause(e);
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw e;
        }
        return returnValue;
    }

    private static final Throwable getCause(Throwable e) {
        Throwable t;
        while ((t = e.getCause()) != null) {
            e = t;
        }
        return e;
    }
}

