/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.DocumentImpl;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.numbering.NodeId;
import org.exist.xquery.NodeSelector;

public class AncestorSelector
implements NodeSelector {
    private NodeSet ancestors;
    private NodeSet descendants = null;
    private int contextId;
    private boolean includeSelf;

    public AncestorSelector(NodeSet descendants, int contextId, boolean includeSelf) {
        this.contextId = contextId;
        this.includeSelf = includeSelf;
        if (descendants instanceof ExtArrayNodeSet) {
            this.descendants = descendants;
        } else {
            this.ancestors = descendants.getAncestors(contextId, includeSelf);
        }
    }

    public NodeProxy match(DocumentImpl doc, NodeId nodeId) {
        if (this.descendants == null) {
            return this.ancestors.get(doc, nodeId);
        }
        return ((ExtArrayNodeSet)this.descendants).hasDescendantsInSet(doc, nodeId, this.includeSelf, this.contextId);
    }
}

