/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.DocumentSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Expression;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class AtomicToString
extends AbstractExpression {
    Expression expression;

    public AtomicToString(XQueryContext context, Expression expr) {
        super(context);
        this.expression = expr;
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.expression.analyze(contextInfo);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        Sequence seq = this.expression.eval(contextSequence, contextItem);
        if (seq.isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        ValueSequence result = new ValueSequence();
        SequenceIterator i = seq.iterate();
        while (i.hasNext()) {
            Item next = i.nextItem();
            result.add(new StringValue(next.getStringValue()));
        }
        return result;
    }

    public void dump(ExpressionDumper dumper) {
        dumper.display("xs:string(");
        this.expression.dump(dumper);
        dumper.display(")");
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("xs:string(");
        result.append(this.expression.toString());
        result.append(")");
        return result.toString();
    }

    public int returnsType() {
        return 22;
    }

    public DocumentSet preselect(DocumentSet in_docs) throws XPathException {
        return in_docs;
    }

    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        this.expression.setContextDocSet(contextSet);
    }

    public void resetState() {
        super.resetState();
        this.expression.resetState();
    }
}

