/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.DocumentSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryAST;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.ValueSequence;

public class Atomize
extends AbstractExpression {
    private final Expression expression;

    public Atomize(XQueryContext context, Expression expr) {
        super(context);
        this.expression = expr;
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.expression.analyze(contextInfo);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        Sequence result = Atomize.atomize(this.expression.eval(contextSequence, contextItem));
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public static Sequence atomize(Sequence input) throws XPathException {
        if (input.hasOne()) {
            return input.itemAt(0).atomize();
        }
        ValueSequence result = new ValueSequence();
        SequenceIterator i = input.iterate();
        while (i.hasNext()) {
            Item next = i.nextItem();
            result.add(next.atomize());
        }
        return result;
    }

    public void dump(ExpressionDumper dumper) {
        if (dumper.verbosity() > 1) {
            dumper.display("atomize[");
        }
        this.expression.dump(dumper);
        if (dumper.verbosity() > 1) {
            dumper.display("]");
        }
    }

    public void accept(ExpressionVisitor visitor) {
        this.expression.accept(visitor);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("atomize[");
        result.append(this.expression.toString());
        result.append("]");
        return result.toString();
    }

    public int returnsType() {
        return 20;
    }

    public int getDependencies() {
        return this.expression.getDependencies();
    }

    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        this.expression.setContextDocSet(contextSet);
    }

    public void resetState() {
        super.resetState();
        this.expression.resetState();
    }

    public XQueryAST getASTNode() {
        return this.expression.getASTNode();
    }
}

