/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.DocumentSet;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Atomize;
import org.exist.xquery.Cardinality;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public class CastableExpression
extends AbstractExpression {
    private Expression expression;
    private int requiredCardinality;
    private final int requiredType;

    public CastableExpression(XQueryContext context, Expression expr, int requiredType, int requiredCardinality) {
        super(context);
        this.expression = expr;
        this.requiredType = requiredType;
        this.requiredCardinality = requiredCardinality;
        if (!Type.subTypeOf(this.expression.returnsType(), 20)) {
            this.expression = new Atomize(context, this.expression);
        }
    }

    public int returnsType() {
        return 23;
    }

    public int getCardinality() {
        return 2;
    }

    public int getDependencies() {
        return 3;
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.expression.analyze(contextInfo);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        BooleanValue result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (this.requiredType == 20 || this.requiredType == 28 && this.expression.returnsType() != 28) {
            throw new XPathException(this.getASTNode(), "err:XPST0080: cannot convert to " + Type.getTypeName(this.requiredType));
        }
        if (this.requiredType == 13 || this.expression.returnsType() == 13 || this.requiredType == 14 || this.expression.returnsType() == 14) {
            throw new XPathException(this.getASTNode(), "err:XPST0051: cannot convert to " + Type.getTypeName(this.requiredType));
        }
        if (this.requiredType == 24 && Dependency.dependsOnVar(this.expression)) {
            result = BooleanValue.FALSE;
        } else {
            Sequence seq = this.expression.eval(contextSequence, contextItem);
            if (seq.isEmpty()) {
                result = Cardinality.checkCardinality(this.requiredCardinality, 1) ? BooleanValue.TRUE : BooleanValue.FALSE;
            } else {
                try {
                    seq.itemAt(0).convertTo(this.requiredType);
                    result = Cardinality.checkCardinality(this.requiredCardinality, seq.getCardinality()) ? BooleanValue.TRUE : BooleanValue.FALSE;
                }
                catch (XPathException e) {
                    result = BooleanValue.FALSE;
                }
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public void dump(ExpressionDumper dumper) {
        this.expression.dump(dumper);
        dumper.display(" castable as ");
        dumper.display(Type.getTypeName(this.requiredType));
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.expression.toString());
        result.append(" castable as ");
        result.append(Type.getTypeName(this.requiredType));
        return result.toString();
    }

    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        this.expression.setContextDocSet(contextSet);
    }

    public void resetState() {
        super.resetState();
        this.expression.resetState();
    }
}

