/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.QName;
import org.exist.memtree.MemTreeBuilder;
import org.exist.memtree.NodeImpl;
import org.exist.util.XMLChar;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Atomize;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.NodeConstructor;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;

public class DynamicAttributeConstructor
extends NodeConstructor {
    private Expression qnameExpr;
    private Expression valueExpr;

    public DynamicAttributeConstructor(XQueryContext context) {
        super(context);
    }

    public void setNameExpr(Expression expr) {
        this.qnameExpr = new Atomize(this.context, expr);
    }

    public void setContentExpr(Expression expr) {
        this.valueExpr = new Atomize(this.context, expr);
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.qnameExpr.analyze(contextInfo);
        this.valueExpr.analyze(contextInfo);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        String value;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        this.context.proceed(this, builder);
        Sequence nameSeq = this.qnameExpr.eval(contextSequence, contextItem);
        if (!nameSeq.hasOne()) {
            throw new XPathException(this.getASTNode(), "The name expression should evaluate to a single value");
        }
        QName qn = QName.parse(this.context, nameSeq.getStringValue(), null);
        if (!XMLChar.isValidName(qn.getLocalName())) {
            throw new XPathException("XPTY0004 '" + qn.getLocalName() + "' is not a valid attribute name");
        }
        Sequence valueSeq = this.valueExpr.eval(contextSequence, contextItem);
        if (valueSeq.isEmpty()) {
            value = "";
        } else {
            StringBuffer buf = new StringBuffer();
            SequenceIterator i = valueSeq.iterate();
            while (i.hasNext()) {
                Item next = i.nextItem();
                buf.append(next.getStringValue());
                if (!i.hasNext()) continue;
                buf.append(' ');
            }
            value = buf.toString();
        }
        int nodeNr = builder.addAttribute(qn, value);
        NodeImpl node = builder.getDocument().getAttribute(nodeNr);
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", node);
        }
        return node;
    }

    public void dump(ExpressionDumper dumper) {
        dumper.display("attribute ");
        dumper.display("{");
        this.qnameExpr.dump(dumper);
        dumper.display("} ");
        dumper.display("{");
        dumper.startIndent();
        this.valueExpr.dump(dumper);
        dumper.endIndent();
        dumper.nl().display("}");
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("attribute ");
        result.append("{");
        result.append(this.qnameExpr.toString());
        result.append("} ");
        result.append("{");
        result.append(this.valueExpr.toString());
        result.append("} ");
        return result.toString();
    }

    public void resetState() {
        super.resetState();
        this.qnameExpr.resetState();
        this.valueExpr.resetState();
    }
}

