/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.dom.DocumentSet;
import org.exist.dom.NodeProxy;
import org.exist.xquery.AbstractExpression;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.NameTest;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.w3c.dom.Node;

public class DynamicNameCheck
extends AbstractExpression {
    private final NameTest test;
    private final Expression expression;

    public DynamicNameCheck(XQueryContext context, NameTest test, Expression expression) {
        super(context);
        this.test = test;
        this.expression = expression;
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        Sequence seq = this.expression.eval(contextSequence, contextItem);
        SequenceIterator i = seq.iterate();
        while (i.hasNext()) {
            Item item = i.nextItem();
            int itemType = item.getType();
            if (itemType == -1) {
                itemType = seq.getItemType();
            }
            if (item instanceof NodeProxy && (itemType = (int)((NodeProxy)item).getNodeType()) == -1) {
                itemType = ((NodeProxy)item).getNode().getNodeType();
            }
            if (!Type.subTypeOf(itemType, this.test.getType())) {
                throw new XPathException(this.expression.getASTNode(), "Type error in expression: required type is " + Type.getTypeName(this.test.getType()) + "; got: " + Type.getTypeName(item.getType()) + ": " + item.getStringValue());
            }
            Node node = ((NodeValue)item).getNode();
            if (this.test.matchesName(node)) continue;
            throw new XPathException(this.expression.getASTNode(), "Type error in expression: required node name is " + this.test.getName() + "; got: " + node.getNodeName());
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", seq);
        }
        return seq;
    }

    public int returnsType() {
        return this.test.nodeType;
    }

    public void resetState() {
        super.resetState();
        this.expression.resetState();
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.expression.analyze(contextInfo);
    }

    public void dump(ExpressionDumper dumper) {
        if (dumper.verbosity() > 1) {
            dumper.display("dynamic-name-check");
            dumper.display("[");
            dumper.display(Type.getTypeName(this.test.nodeType));
            dumper.display(", ");
        }
        this.expression.dump(dumper);
        if (dumper.verbosity() > 1) {
            dumper.display("]");
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("dynamic-name-check");
        result.append("[");
        result.append(Type.getTypeName(this.test.nodeType));
        result.append(", ");
        result.append(this.expression.toString());
        result.append("]");
        return result.toString();
    }

    public void setContextDocSet(DocumentSet contextSet) {
        super.setContextDocSet(contextSet);
        this.expression.setContextDocSet(contextSet);
    }

    public void accept(ExpressionVisitor visitor) {
        this.expression.accept(visitor);
    }
}

