/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.exist.dom.QName;
import org.exist.memtree.MemTreeBuilder;
import org.exist.memtree.NodeImpl;
import org.exist.util.XMLChar;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.AttributeConstructor;
import org.exist.xquery.Expression;
import org.exist.xquery.LiteralValue;
import org.exist.xquery.NodeConstructor;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.QNameValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;
import org.xml.sax.helpers.AttributesImpl;

public class ElementConstructor
extends NodeConstructor {
    private Expression qnameExpr;
    private PathExpr content = null;
    private AttributeConstructor[] attributes = null;
    private QName[] namespaceDecls = null;
    protected static final Logger LOG = Logger.getLogger((Class)ElementConstructor.class);

    public ElementConstructor(XQueryContext context) {
        super(context);
    }

    public ElementConstructor(XQueryContext context, String qname) {
        super(context);
        this.qnameExpr = new LiteralValue(context, new StringValue(qname));
    }

    public void setContent(PathExpr path) {
        this.content = path;
    }

    public void setNameExpr(Expression expr) {
        this.qnameExpr = expr;
    }

    public void addAttribute(AttributeConstructor attr) throws XPathException {
        if (attr.isNamespaceDeclaration()) {
            if (attr.getQName().equals("xmlns")) {
                this.addNamespaceDecl("", attr.getLiteralValue());
            } else {
                this.addNamespaceDecl(QName.extractLocalName(attr.getQName()), attr.getLiteralValue());
            }
        } else if (this.attributes == null) {
            this.attributes = new AttributeConstructor[1];
            this.attributes[0] = attr;
        } else {
            AttributeConstructor[] natts = new AttributeConstructor[this.attributes.length + 1];
            System.arraycopy(this.attributes, 0, natts, 0, this.attributes.length);
            natts[this.attributes.length] = attr;
            this.attributes = natts;
        }
    }

    public void addNamespaceDecl(String name, String uri) throws XPathException {
        QName qn = new QName(name, uri, "xmlns");
        if (name.equalsIgnoreCase("xml")) {
            throw new XPathException("XQST0070 : can not redefine '" + qn + "'");
        }
        if (name.equalsIgnoreCase("xmlns")) {
            throw new XPathException("XQST0070 : can not redefine '" + qn + "'");
        }
        if (name.length() != 0 && uri.trim().length() == 0) {
            throw new XPathException("XQST0085 : cannot undeclare a prefix " + name + ".");
        }
        if (this.namespaceDecls == null) {
            this.namespaceDecls = new QName[1];
            this.namespaceDecls[0] = qn;
        } else {
            for (int i = 0; i < this.namespaceDecls.length; ++i) {
                if (!qn.equals(this.namespaceDecls[i])) continue;
                throw new XPathException("XQST0071 : duplicate definition for '" + qn + "'");
            }
            QName[] decls = new QName[this.namespaceDecls.length + 1];
            System.arraycopy(this.namespaceDecls, 0, decls, 0, this.namespaceDecls.length);
            decls[this.namespaceDecls.length] = qn;
            this.namespaceDecls = decls;
        }
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        int i;
        this.context.pushInScopeNamespaces();
        if (this.namespaceDecls != null) {
            for (i = 0; i < this.namespaceDecls.length; ++i) {
                if ("".equals(this.namespaceDecls[i].getNamespaceURI())) {
                    this.context.inScopeNamespaces.remove(this.namespaceDecls[i].getLocalName());
                    continue;
                }
                this.context.declareInScopeNamespace(this.namespaceDecls[i].getLocalName(), this.namespaceDecls[i].getNamespaceURI());
            }
        }
        contextInfo.setParent(this);
        this.qnameExpr.analyze(contextInfo);
        if (this.attributes != null) {
            for (i = 0; i < this.attributes.length; ++i) {
                this.attributes[i].analyze(contextInfo);
            }
        }
        if (this.content != null) {
            this.content.analyze(contextInfo);
        }
        this.context.popInScopeNamespaces();
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        QName qn;
        this.context.pushInScopeNamespaces();
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        if (this.namespaceDecls != null) {
            for (int i = 0; i < this.namespaceDecls.length; ++i) {
                this.context.declareInScopeNamespace(this.namespaceDecls[i].getLocalName(), this.namespaceDecls[i].getNamespaceURI());
            }
        }
        AttributesImpl attrs = new AttributesImpl();
        if (this.attributes != null) {
            AttributeConstructor constructor;
            int i;
            for (i = 0; i < this.attributes.length; ++i) {
                constructor = this.attributes[i];
                if (!constructor.isNamespaceDeclaration()) continue;
                int p = constructor.getQName().indexOf(58);
                if (p == -1) {
                    this.context.declareInScopeNamespace("", constructor.getLiteralValue());
                    continue;
                }
                String prefix = constructor.getQName().substring(p + 1);
                this.context.declareInScopeNamespace(prefix, constructor.getLiteralValue());
            }
            for (i = 0; i < this.attributes.length; ++i) {
                this.context.proceed(this, builder);
                constructor = this.attributes[i];
                Sequence attrValues = constructor.eval(contextSequence, contextItem);
                QName attrQName = QName.parse(this.context, constructor.getQName(), "");
                if (attrs.getIndex(attrQName.getNamespaceURI(), attrQName.getLocalName()) != -1) {
                    throw new XPathException("XQST0040 '" + attrQName.getLocalName() + "' is a duplicate attribute name");
                }
                attrs.addAttribute(attrQName.getNamespaceURI(), attrQName.getLocalName(), attrQName.getStringValue(), "CDATA", attrValues.getStringValue());
            }
        }
        this.context.proceed(this, builder);
        Sequence qnameSeq = this.qnameExpr.eval(contextSequence, contextItem);
        if (!qnameSeq.hasOne()) {
            throw new XPathException("Type error: the node name should evaluate to a single item");
        }
        Item qnitem = qnameSeq.itemAt(0);
        if (qnitem instanceof QNameValue) {
            qn = ((QNameValue)qnitem).getQName();
        } else {
            qn = QName.parse(this.context, qnitem.getStringValue());
            if (qn.getPrefix() == null && this.context.getInScopeNamespace("") != null) {
                qn.setNamespaceURI(this.context.getInScopeNamespace(""));
            }
        }
        if (!XMLChar.isValidName(qn.getLocalName())) {
            throw new XPathException("XPTY0004 '" + qnitem.getStringValue() + "' is not a valid element name");
        }
        int nodeNr = builder.startElement(qn, attrs);
        if (this.namespaceDecls != null) {
            for (int i = 0; i < this.namespaceDecls.length; ++i) {
                builder.namespaceNode(this.namespaceDecls[i]);
            }
        }
        if (this.content != null) {
            this.content.eval(contextSequence, contextItem);
        }
        builder.endElement();
        NodeImpl node = builder.getDocument().getNode(nodeNr);
        this.context.popInScopeNamespaces();
        return node;
    }

    public void dump(ExpressionDumper dumper) {
        dumper.display("element ");
        dumper.display("{");
        this.qnameExpr.dump(dumper);
        dumper.display("} ");
        dumper.display("{");
        dumper.startIndent();
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.length; ++i) {
                if (i > 0) {
                    dumper.nl();
                }
                AttributeConstructor attr = this.attributes[i];
                attr.dump(dumper);
            }
            dumper.endIndent();
            dumper.startIndent();
        }
        if (this.content != null) {
            Iterator i = this.content.steps.iterator();
            while (i.hasNext()) {
                Expression expr = (Expression)i.next();
                expr.dump(dumper);
                if (!i.hasNext()) continue;
                dumper.nl();
            }
            dumper.endIndent().nl();
        }
        dumper.display("} ");
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("element ");
        result.append("{");
        result.append(this.qnameExpr.toString());
        result.append("} ");
        result.append("{");
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.length; ++i) {
                if (i > 0) {
                    result.append(" ");
                }
                AttributeConstructor attr = this.attributes[i];
                result.append(attr.toString());
            }
        }
        if (this.content != null) {
            Iterator i = this.content.steps.iterator();
            while (i.hasNext()) {
                Expression expr = (Expression)i.next();
                result.append(expr.toString());
                if (!i.hasNext()) continue;
                result.append(" ");
            }
        }
        result.append("} ");
        return result.toString();
    }

    public void setPrimaryAxis(int axis) {
        if (this.content != null) {
            this.content.setPrimaryAxis(axis);
        }
    }

    public void resetState() {
        super.resetState();
        this.qnameExpr.resetState();
        if (this.content != null) {
            this.content.resetState();
        }
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.length; ++i) {
                AttributeConstructor next = this.attributes[i];
                next.resetState();
            }
        }
    }
}

